/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.check;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheck;
import cn.smarthse.modules.health.entity.work.check.vo.PhcYearCheckInfo;
import cn.smarthse.modules.health.entity.work.check.vo.StaffCheckCountParam;
import cn.smarthse.modules.health.entity.work.check.vo.StaffCheckCountResult;
import cn.smarthse.modules.health.enums.check.CheckTypeEnum;
import cn.smarthse.modules.health.enums.check.ExamResultEnum;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckDataService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.beans.IntrospectionException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/check/count"})
public class PhcPhysicalCheckCountController
extends ControllerSupport {
    @DubboReference
    IPhcPhysicalCheckService checkService;
    @DubboReference
    IPhcPhysicalCheckDataService phcPhysicalCheckDataService;
    protected String platformLoginUrl;

    @RequiresPermissions(value={"healthCheck.view"})
    @RequestMapping
    public String page_index(@RequestParam(value="page", required=false, defaultValue="1") int pageIndex, HttpSession session, ModelMap m, PhcPhysicalCheck check, Integer endTime) {
        this.logger.info("\u3010\u3011-\u6c47\u603b\u9996\u9875");
        m.put((Object)"checkTypes", (Object)CheckTypeEnum.values());
        m.put((Object)"type", (Object)"check");
        m.put((Object)"checkParam", (Object)check);
        m.put((Object)"isActualize", (Object)this.isActualize);
        m.put((Object)"isSharingSystem", (Object)this.isSharingSystem);
        if (endTime != null) {
            m.put((Object)"endTime", (Object)endTime);
        }
        this.countInfo(m);
        return "work/check/count/check_finish_list";
    }

    @RequiresPermissions(value={"healthCheck.view"})
    @RequestMapping(value={"/confirmationInfo"}, method={RequestMethod.GET})
    public String confirmationInfo(HttpSession session, ModelMap m, Long checkId, Byte confirmationType) {
        m.put((Object)"confirmationType", (Object)confirmationType);
        m.put((Object)"checkId", (Object)checkId);
        return "work/check/count/confirmationList";
    }

    @ResponseBody
    @RequestMapping(value={"confirmationStaffList"}, method={RequestMethod.GET})
    public JqGridData<StaffCheckCountResult> confirmationStaffList(JqGridParam param, Long checkId, Byte confirmationType) {
        PageInfo confirmationStaffList = this.phcPhysicalCheckDataService.getConfirmationStaffList(param, checkId, confirmationType);
        JqGridData data = new JqGridData(confirmationStaffList, param);
        return data;
    }

    @RequiresPermissions(value={"healthCheck.view"})
    @RequestMapping(value={"abnormal"})
    public String abnormal_finish_list(@RequestParam(value="page", required=false, defaultValue="1") int pageIndex, HttpSession session, ModelMap m, PhcPhysicalCheck check) {
        m.put((Object)"type", (Object)"abnormal");
        m.put((Object)"check", (Object)check);
        this.countInfo(m);
        return "work/check/count/abnormal_finish_list";
    }

    @RequiresPermissions(value={"healthCheck.view"})
    @RequestMapping(value={"dieaser"})
    public String dieaser_finish_list(@RequestParam(value="page", required=false, defaultValue="1") int pageIndex, HttpSession session, ModelMap m, PhcPhysicalCheck check) {
        m.put((Object)"type", (Object)"dieaser");
        this.countInfo(m);
        return "work/check/count/diseaser_list";
    }

    @RequiresPermissions(value={"healthCheck.view"})
    @RequestMapping(value={"report"})
    public String report_finish_list(@RequestParam(value="page", required=false, defaultValue="1") int pageIndex, HttpSession session, ModelMap m, PhcPhysicalCheck check) {
        m.put((Object)"type", (Object)"report");
        this.countInfo(m);
        return "work/check/count/report_finish_list";
    }

    @RequiresPermissions(value={"healthCheck.view"})
    @RequestMapping(value={"missing"})
    public String missing_finish_list(@RequestParam(value="page", required=false, defaultValue="1") int pageIndex, HttpSession session, ModelMap m, PhcPhysicalCheck check) {
        m.put((Object)"type", (Object)"missing");
        this.countInfo(m);
        return "work/check/count/missing_finish_list";
    }

    @RequiresPermissions(value={"healthCheck.view"})
    @RequestMapping(value={"suspect/unfinish"})
    public String suspect_dieaser_unfinish_list(@RequestParam(value="page", required=false, defaultValue="1") int pageIndex, Integer checkYear, ModelMap m, Integer endTime) {
        m.put((Object)"type", (Object)"suspect");
        m.put((Object)"checkYear", (Object)checkYear);
        m.put((Object)"isFinish", (Object)false);
        if (endTime != null) {
            m.put((Object)"endTime", (Object)endTime);
        }
        this.countInfo(m);
        return "work/check/count/suspect_dieaser_finish_list";
    }

    @RequiresPermissions(value={"healthCheck.view"})
    @RequestMapping(value={"suspect/finish"})
    public String suspect_dieaser_finish_list(@RequestParam(value="page", required=false, defaultValue="1") int pageIndex, HttpSession session, ModelMap m) {
        m.put((Object)"type", (Object)"suspect");
        m.put((Object)"isFinish", (Object)true);
        this.countInfo(m);
        return "work/check/count/suspect_dieaser_finish_list";
    }

    @RequiresPermissions(value={"healthCheck.view"})
    @RequestMapping(value={"year"})
    public String yearCheckInfo(HttpSession session, ModelMap m, PhcYearCheckInfo params) {
        m.put((Object)"type", (Object)"count");
        this.countInfo(m);
        return "work/check/count/year_check_info";
    }

    private void countInfo(ModelMap m) {
        PhcYearCheckInfo params = new PhcYearCheckInfo();
        params.setCid(UserUtils.getLoginStaffCompanyId());
        params.setYear(Integer.valueOf(DateUtils.getThisYear()));
        UserUtils.startWebDataScope();
        PhcYearCheckInfo checkInfo = this.checkService.countYearCheckInfo(params);
        m.put((Object)"checkInfo", (Object)checkInfo);
        m.put((Object)"isZhouShanCompany", (Object)UserUtils.isZhouShanCompany());
    }

    @RequiresPermissions(value={"healthCheck.view"})
    @RequestMapping(value={"staff"})
    public String staff(HttpSession session, ModelMap m, StaffCheckCountParam params) {
        m.put((Object)"type", (Object)"staff");
        m.put((Object)"checkTypes", (Object)CheckTypeEnum.values());
        m.put((Object)"examResults", (Object)ExamResultEnum.values());
        params.setDefaultYear(DateUtils.getYear());
        if (params.getYear() == null) {
            params.setYear(params.getDefaultYear());
        }
        m.put((Object)"params", (Object)params);
        this.countInfo(m);
        return "work/check/count/staff_check_info";
    }

    @RequiresPermissions(value={"healthCheck.view"})
    @ResponseBody
    @RequestMapping(value={"staff/listData"})
    public JqGridData<StaffCheckCountResult> listData(HttpSession session, JqGridParam gparam, StaffCheckCountParam param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        if (param.getUseDefaultParam() != null && param.getUseDefaultParam().booleanValue()) {
            param.setYear(param.getDefaultYear());
        }
        UserUtils.startWebDataScope();
        PageInfo page = this.checkService.getStaffCheckPage(gparam, param);
        JqGridData data = new JqGridData(page, gparam);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"staff/export"})
    public void exportStaff(HttpServletResponse response, StaffCheckCountParam param) throws Exception {
        this.logger.info("=====================\u5bfc\u51fa\u5e74\u5ea6\u4eba\u5458\u4f53\u68c0\u7ed3\u679c\u6c47\u603b\u5f00\u59cb=========================");
        String templateDirPath = super.getTemplateFilePath();
        String tempDirPath = super.getTempFilePath();
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        UserUtils.startWebDataScope();
        List list = this.checkService.getStaffCheckList(param);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String resultFileName = "\u5e74\u5ea6\u4eba\u5458\u4f53\u68c0\u7ed3\u679c\u6c47\u603b" + dateFormat.format(new Date()) + ".xls";
        String templateFileName = templateDirPath + "staffCheckListTemplate.xls";
        String resultFilePath = tempDirPath + resultFileName;
        this.logger.info("[PHCStaffExport]=====================" + templateFileName + "=========================");
        this.logger.info("[PHCStaffExport]=====================" + resultFilePath + "=========================");
        try {
            this.insertImage2(response, templateFileName, resultFilePath, resultFileName, list);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
        }
        catch (InvalidFormatException e) {
            this.logger.error(e.getMessage());
        }
        this.logger.info("[PHCStaffExport]=====================outputing=========================");
        BufferedOutputStream bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(resultFilePath));
        try {
            int bytesRead;
            this.logger.info("[PHCStaffExportOutputing:]=====================" + bis.toString() + "=========================");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(resultFileName.getBytes("GBK"), "ISO8859_1"));
            response.setContentType("application/octet-stream; charset=GBK");
            response.setHeader("Content-Length", String.valueOf(new File(resultFilePath).length()));
            byte[] buff = new byte[1024];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
            }
            this.logger.info("[PHCStaffExportOutputed:]==============================================");
        }
        catch (Exception e) {
            this.logger.info("[PHCStaffExportOutputingError:]=====================" + e.getMessage() + "=========================");
            this.logger.error(e.getMessage());
        }
        finally {
            if (bos != null) {
                bos.close();
            }
            if (bis != null) {
                bis.close();
            }
        }
        this.logger.info("=====================\u5bfc\u51fa\u5e74\u5ea6\u4eba\u5458\u4f53\u68c0\u7ed3\u679c\u6c47\u603b\u7ed3\u675f=========================");
    }

    private void insertImage2(HttpServletResponse response, String templateFileName, String resultFilePath, String resultFileName, List<StaffCheckCountResult> list) throws IOException, InvalidFormatException, IllegalAccessException, InvocationTargetException, IntrospectionException {
        ServletOutputStream out = null;
        try {
            FileInputStream is = new FileInputStream(templateFileName);
            out = response.getOutputStream();
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(resultFileName.getBytes("GBK"), "ISO8859_1"));
            ExcelWriter excelWriter = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)out).registerConverter((Converter)new Converter<Long>(){

                public Class supportJavaTypeKey() {
                    return Long.class;
                }

                public CellDataTypeEnum supportExcelTypeKey() {
                    return CellDataTypeEnum.STRING;
                }

                public Long convertToJavaData(ReadCellData cellData, ExcelContentProperty excelContentProperty, GlobalConfiguration globalConfiguration) throws Exception {
                    if (StringUtils.isNumeric((CharSequence)cellData.getStringValue())) {
                        return Long.parseLong(cellData.getStringValue());
                    }
                    return null;
                }

                public WriteCellData convertToExcelData(Long o, ExcelContentProperty excelContentProperty, GlobalConfiguration globalConfiguration) throws Exception {
                    if (o != null) {
                        return new WriteCellData(o.toString());
                    }
                    return new WriteCellData("");
                }
            })).withTemplate(templateFileName).build();
            WriteSheet writeSheet = EasyExcel.writerSheet().build();
            excelWriter.fill(list, writeSheet);
            excelWriter.finish();
        }
        catch (FileNotFoundException fe) {
            throw new HealthException("\u7cfb\u7edf\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6587\u4ef6");
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @ResponseBody
    @RequestMapping(value={"test"})
    public Object test(HttpSession session, ModelMap m, PhcYearCheckInfo params) {
        params.setCid(UserUtils.getLoginStaffCompanyId());
        params.setYear(Integer.valueOf(DateUtils.getThisYear()));
        PhcYearCheckInfo checkInfo = this.checkService.countYearCheckInfo(params);
        return checkInfo;
    }

    @RequiresPermissions(value={"healthCheck.view"})
    @RequestMapping(value={"oc"})
    public String oc(@RequestParam(value="page", required=false, defaultValue="1") int pageIndex, HttpSession session, ModelMap m, Integer endTime) {
        m.put((Object)"type", (Object)"oc");
        if (endTime != null) {
            m.put((Object)"endTime", (Object)endTime);
        }
        this.countInfo(m);
        return "work/check/count/oc_list";
    }

    @RequiresPermissions(value={"healthCheck.view"})
    @RequestMapping(value={"recheck"})
    public String recheck(@RequestParam(value="page", required=false, defaultValue="1") int pageIndex, HttpSession session, ModelMap m) {
        m.put((Object)"type", (Object)"recheck");
        this.countInfo(m);
        return "work/check/count/recheck_list";
    }
}

