/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.check;

import cn.smarthse.common.framework.beans.OssClientBean;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.BusinessNoTypeEnum;
import cn.smarthse.common.framework.enums.BusinessTypeEnum;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.excel.ExcelContent;
import cn.smarthse.common.util.excel.ExcelUtil;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheck;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckFile;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckType;
import cn.smarthse.modules.health.entity.work.check.vo.CheckImportErrorData;
import cn.smarthse.modules.health.entity.work.check.vo.HudongSysStaffInfoVo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckParam;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckQuery;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalYearCountQuery;
import cn.smarthse.modules.health.entity.work.planyear.vo.PlanYearExecute;
import cn.smarthse.modules.health.enums.check.CheckTypeEnum;
import cn.smarthse.modules.health.enums.planyear.PlanYearDetailImplState;
import cn.smarthse.modules.health.enums.sys.coreWork.CoreWorkEnum;
import cn.smarthse.modules.health.service.base.IBusinessNoService;
import cn.smarthse.modules.health.service.base.workinfo.IWorkRoleInfoService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckDataService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorWorkService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.SyncBusinessUtil;
import cn.smarthse.web.util.SysFileUtil;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/check"})
public class PhcPhysicalCheckController
extends ControllerSupport {
    @DubboReference
    private IPhcPhysicalCheckService phcPhysicalCheckService;
    @DubboReference
    private IBusinessNoService businessNoService;
    @Autowired
    OssClientBean ossClientBean;
    @DubboReference
    private IWorkRoleInfoService workRoleInfoService;
    @DubboReference
    IHarmfactorWorkService factorService;
    @DubboReference
    IPhcPhysicalCheckDataService phcPhysicalCheckDataService;

    @RequiresPermissions(value={"healthCheck.view"})
    @RequestMapping
    public String page_index(@RequestParam(value="page", required=false, defaultValue="1") int pageIndex, HttpSession session, ModelMap m, PhcPhysicalCheck check) {
        this.logger.info("\u3010\u3011-\u6c47\u603b\u9996\u9875");
        m.put((Object)"checkParam", (Object)check);
        return "work/check/check_list";
    }

    @RequiresPermissions(value={"healthCheck.view"})
    @ResponseBody
    @RequestMapping(value={"listData"})
    public JqGridData<PhcPhysicalCheck> listData(HttpSession session, JqGridParam gparam, PhcPhysicalCheckParam param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        this.setDefaultValue(param);
        UserUtils.startWebDataScope();
        PageInfo list = this.phcPhysicalCheckService.getList(gparam, param);
        JqGridData data = new JqGridData(list, gparam);
        return data;
    }

    @RequiresPermissions(value={"healthCheck.view"})
    @ResponseBody
    @RequestMapping(value={"listReportData"})
    public JqGridData<PhcPhysicalCheck> listReportData(HttpSession session, JqGridParam gparam, PhcPhysicalCheckParam param, Integer endTime1) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        if (endTime1 != null) {
            Date yearFirstDay = DateUtils.getYearFirstDay((int)endTime1);
            param.setEndTime(yearFirstDay);
        }
        param.setCid(cid);
        this.setDefaultValue(param);
        UserUtils.startWebDataScope();
        PageInfo list = this.phcPhysicalCheckService.getReportPage(gparam, param);
        JqGridData data = new JqGridData(list, gparam);
        return data;
    }

    private void setDefaultValue(PhcPhysicalCheckParam param) {
        Boolean isDefault = param.getIsDefault();
        if (isDefault != null && !isDefault.booleanValue()) {
            return;
        }
        if (param.getCheckType() == null && param.getDefaultCheckType() != null) {
            param.setCheckType(param.getDefaultCheckType());
        }
    }

    private void getOthersFlag(ModelMap m) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        List works = this.workRoleInfoService.getWorkRoleInfosByCid(cid);
        m.put((Object)"works", (Object)works);
        Integer factors = this.factorService.countHarmNumByCid(cid);
        m.put((Object)"factors", (Object)factors);
    }

    @RequiresPermissions(value={"healthCheck.view"})
    @RequestMapping(value={"/view"}, method={RequestMethod.GET})
    public String view(PhcPhysicalCheck check, HttpSession session, ModelMap m) {
        check = check.getId() != null ? this.phcPhysicalCheckService.getDetailById(check.getId()) : new PhcPhysicalCheck();
        this.getOthersFlag(m);
        m.put((Object)"data", (Object)check);
        m.put((Object)"checkTypes", (Object)CheckTypeEnum.values());
        if ("true".equals(this.isActualize) && (check.getIsRecheck() != null && check.getIsRecheck().booleanValue() || check.getIsReplenish() != null && check.getIsReplenish().booleanValue())) {
            return "work/check/check_recheck_info";
        }
        return "work/check/check_info";
    }

    @RequiresPermissions(value={"healthCheck.edit"})
    @RequestMapping(value={"/add"}, method={RequestMethod.GET})
    public String add(PhcPhysicalCheck check, HttpSession session, ModelMap m, String defaultCheckTypes, String ownOrgIds) {
        m.put((Object)"ownOrgIds", StringUtils.isEmpty((CharSequence)ownOrgIds) ? UserUtils.getOrgId() : ownOrgIds);
        Long cid = UserUtils.getLoginStaffCompanyId();
        check.setNo(this.businessNoService.getBusinessNo(cid, BusinessNoTypeEnum.HEALTHCHECK.getCode()));
        m.put((Object)"data", (Object)check);
        m.put((Object)"checkTypes", (Object)CheckTypeEnum.values());
        this.getOthersFlag(m);
        this.setCheckTypeByFrom(check);
        this.setCheckTypeByDefaultCheckTypes(check, defaultCheckTypes);
        m.put((Object)"checkTypeEditableFlag", (Object)true);
        return "work/check/check_edit";
    }

    private void setCheckTypeByDefaultCheckTypes(PhcPhysicalCheck check, String defaultCheckTypes) {
        String[] types;
        if (StringUtils.isEmpty((CharSequence)defaultCheckTypes)) {
            return;
        }
        ArrayList<PhcPhysicalCheckType> phcCheckTypes = new ArrayList<PhcPhysicalCheckType>();
        for (String type : types = defaultCheckTypes.split(",")) {
            String typeName = CheckTypeEnum.getName((String)type);
            if (StringUtils.isEmpty((CharSequence)typeName)) continue;
            PhcPhysicalCheckType checkType = new PhcPhysicalCheckType();
            checkType.setCheckType(Byte.valueOf(Byte.parseByte(type)));
            phcCheckTypes.add(checkType);
        }
        check.setCheckTypes(phcCheckTypes);
    }

    private void setCheckTypeByFrom(PhcPhysicalCheck check) {
        ArrayList<PhcPhysicalCheckType> checkTypes = new ArrayList<PhcPhysicalCheckType>();
        if (check.getFromType() == null) {
            return;
        }
        if (check.getFromType().byteValue() == CoreWorkEnum.threeSimultaneityManagement.getValue().byteValue()) {
            PhcPhysicalCheckType checkType = new PhcPhysicalCheckType();
            checkType.setCheckType(Byte.valueOf(Byte.parseByte(CheckTypeEnum.before.getCode())));
            checkTypes.add(checkType);
            check.setCheckTypes(checkTypes);
        } else if (check.getFromType().byteValue() == CoreWorkEnum.accidentManement.getValue().byteValue()) {
            PhcPhysicalCheckType checkType = new PhcPhysicalCheckType();
            checkType.setCheckType(Byte.valueOf(Byte.parseByte(CheckTypeEnum.eme.getCode())));
            checkTypes.add(checkType);
            check.setCheckTypes(checkTypes);
        }
    }

    @RequiresPermissions(value={"healthCheck.edit"})
    @RequestMapping(value={"/edit"}, method={RequestMethod.GET})
    public String edit(PhcPhysicalCheck check, HttpSession session, ModelMap m) {
        m.put((Object)"checkTypeEditableFlag", (Object)true);
        return this.setCheckInfo(check, m, "");
    }

    private String setCheckInfo(PhcPhysicalCheck check, ModelMap m, String pageInfo) {
        check = check.getId() != null ? this.phcPhysicalCheckService.getDetailById(check.getId()) : new PhcPhysicalCheck();
        this.getOthersFlag(m);
        m.put((Object)"data", (Object)check);
        m.put((Object)"checkTypes", (Object)CheckTypeEnum.values());
        if (check.getIsRecheck() != null && check.getIsRecheck().booleanValue() || check.getIsReplenish() != null && check.getIsReplenish().booleanValue()) {
            m.put((Object)"checkTypeEditableFlag", (Object)false);
            return "work/check/check_recheck_edit" + pageInfo;
        }
        return "work/check/check_edit" + pageInfo;
    }

    @RequiresPermissions(value={"healthCheck.edit"})
    @RequestMapping(value={"/editFinished"}, method={RequestMethod.GET})
    public String editFinished(PhcPhysicalCheck check, HttpSession session, ModelMap m) {
        m.put((Object)"checkTypeEditableFlag", (Object)false);
        return this.setCheckInfo(check, m, "_finished");
    }

    @RequiresPermissions(value={"healthCheck.edit"})
    @ResponseBody
    @RequestMapping(value={"/info"}, method={RequestMethod.POST})
    public ResponseData<PhcPhysicalCheck> infoPost(HttpServletRequest request, PhcPhysicalCheck check) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        String[] reportFilesIds = request.getParameterValues("reportFilesIds");
        check.setReportFiles(this.convertFileIds(reportFilesIds));
        if (check.getId() == null && StringUtils.isEmpty((CharSequence)check.getOrgId())) {
            Long orgId = UserUtils.getOrgId();
            if (orgId == null) {
                orgId = 0L;
            }
            check.setOrgId("" + orgId);
        }
        ResponseData data = new ResponseData();
        check = this.phcPhysicalCheckService.insertOrUpdate(check, cid, staffId);
        PlanYearExecute planYearExecute = new PlanYearExecute();
        if (check.getStatus() != null && check.getStatus() == 1) {
            planYearExecute.setImplState(PlanYearDetailImplState.implemented);
        } else {
            planYearExecute.setImplState(PlanYearDetailImplState.progressing);
        }
        planYearExecute.setCid(cid);
        planYearExecute.setBusinessType(BusinessTypeEnum.phcPhysicalCheck.getCode());
        planYearExecute.setBusinessId(check.getId());
        planYearExecute.setImplStartDate(check.getBeginTime());
        planYearExecute.setImplEndDate(check.getEndTime());
        planYearExecute.setImplWorkName(check.getWorkName());
        planYearExecute.setImplManagerId(check.getManager());
        SyncBusinessUtil.executeUpdatePlanYearDetail(planYearExecute);
        data.setResult((Object)check);
        data.setContent("\u64cd\u4f5c\u6210\u529f");
        return data;
    }

    @RequiresPermissions(value={"healthCheck.edit"})
    @ResponseBody
    @RequestMapping(value={"/checkData"}, method={RequestMethod.POST})
    public ResponseData<PhcPhysicalCheck> checkData(HttpServletRequest request, PhcPhysicalCheck check) {
        PhcPhysicalYearCountQuery query = new PhcPhysicalYearCountQuery();
        ResponseData data = new ResponseData();
        if (check.getId() != null) {
            query.setCheckId(check.getId());
            List checkTypes = check.getCheckTypes();
            Boolean ifError = true;
            Object erroMessage = "";
            for (PhcPhysicalCheckType checkType : checkTypes) {
                if (checkType.getCheckType() == null) continue;
                query.setCheckType(checkType.getCheckType());
                Integer number = this.phcPhysicalCheckDataService.selectCountByCheckIdAndType(query);
                if (number == null || checkType.getNeedCheckTotal() == null || number <= checkType.getNeedCheckTotal()) continue;
                ifError = false;
                String erroName = CheckTypeEnum.getName((String)checkType.getCheckType().toString());
                erroMessage = (String)erroMessage + erroName + ",";
            }
            if (!ifError.booleanValue()) {
                data.setContent((String)erroMessage);
                return data;
            }
        }
        data.setContent("\u64cd\u4f5c\u6210\u529f");
        return data;
    }

    @RequiresPermissions(value={"healthCheck.edit"})
    @ResponseBody
    @RequestMapping(value={"/finishedInfo"}, method={RequestMethod.POST})
    public ResponseData<PhcPhysicalCheck> finishedInfo(HttpServletRequest request, PhcPhysicalCheck check) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        String[] reportFilesIds = request.getParameterValues("reportFilesIds");
        check.setReportFiles(this.convertFileIds(reportFilesIds));
        check = this.phcPhysicalCheckService.finishedInfo(check, cid, staffId);
        ResponseData data = new ResponseData();
        data.setResult((Object)check);
        data.setContent("\u64cd\u4f5c\u6210\u529f");
        return data;
    }

    private List<PhcPhysicalCheckFile> convertFileIds(String[] fileIds) {
        ArrayList<PhcPhysicalCheckFile> files = new ArrayList<PhcPhysicalCheckFile>();
        if (fileIds == null || fileIds.length == 0) {
            return files;
        }
        for (String fileId : fileIds) {
            PhcPhysicalCheckFile file = new PhcPhysicalCheckFile();
            file.setFileId(Long.valueOf(Long.parseLong(fileId)));
            files.add(file);
        }
        return files;
    }

    @RequiresPermissions(value={"healthCheck.edit"})
    @ResponseBody
    @RequestMapping(value={"/del/{ids}"}, method={RequestMethod.DELETE})
    public ResponseData<String> ajax_delete(@PathVariable String ids, HttpSession session) {
        this.logger.info("ajax-\u3010\u3011-\u5220\u9664\u8bb0\u5f55:" + ids);
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        this.phcPhysicalCheckService.deleteByIds(ids, staffId, cid);
        List idArray = StringUtils.parseToLongList((String)ids, (String)",");
        if (idArray != null && idArray.size() > 0) {
            for (Long id : idArray) {
                PlanYearExecute planYearExecute = new PlanYearExecute();
                planYearExecute.setImplState(PlanYearDetailImplState.unimplemented);
                planYearExecute.setCid(cid);
                planYearExecute.setBusinessId(id);
                planYearExecute.setBusinessType(BusinessTypeEnum.phcPhysicalCheck.getCode());
                SyncBusinessUtil.executeUpdatePlanYearDetail(planYearExecute);
            }
        }
        ResponseData data = new ResponseData();
        data.setResult((Object)ids);
        data.setContent("\u5220\u9664\u6210\u529f");
        return data;
    }

    @RequiresPermissions(value={"healthCheck.view"})
    @RequestMapping(value={"export"})
    public void export(PhcPhysicalCheckParam data, HttpSession session, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.logger.info("ajax-\u3010\u3011-\u5bfc\u51faExcel");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5\u5df2\u5b8c\u6210\u6e05\u5355" + dateFormat.format(new Date()) + ".xls";
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("GBK"), "ISO8859_1"));
        response.setContentType("application/octet-stream; charset=GBK");
        String[] colums = new String[]{"\u540d\u79f0|workName", "\u8ba1\u5212/\u4f53\u68c0\u65f6\u95f4|checkDate", "\u8d1f\u8d23\u4eba|managerName", "\u804c\u4e1a\u5065\u5eb7\u76d1\u62a4\u79cd\u7c7b|checkTypeNames", "\u72b6\u6001|statusName", "\u5b8c\u6210\u65f6\u95f4|updateDate"};
        data.setCid(UserUtils.getLoginStaffCompanyId());
        data.setMinStatus(Byte.valueOf((byte)1));
        UserUtils.startWebDataScope();
        List list = this.phcPhysicalCheckService.listDetails(data);
        ExportExcel export = new ExportExcel();
        export.simpleExport3("\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5\u5df2\u5b8c\u6210\u6e05\u5355", colums, list, (OutputStream)response.getOutputStream());
    }

    @ResponseBody
    @RequestMapping(value={"/list"})
    public List<PhcPhysicalCheck> list(PhcPhysicalCheckParam data, HttpSession session) throws Exception {
        data.setCid(UserUtils.getLoginStaffCompanyId());
        data.setStatus(Byte.valueOf((byte)1));
        List list = this.phcPhysicalCheckService.listDetails(data);
        return list;
    }

    @ResponseBody
    @RequestMapping(value={"/unreport/list"})
    public List<PhcPhysicalCheck> unreportList(PhcPhysicalCheckParam data, HttpSession session) throws Exception {
        data.setCid(UserUtils.getLoginStaffCompanyId());
        data.setStatus(Byte.valueOf((byte)1));
        List list = this.phcPhysicalCheckService.unreportList(data);
        return list;
    }

    @RequestMapping(value={"/import"}, method={RequestMethod.GET})
    public String uploadDiag(PhcPhysicalCheckParam param, ModelMap m) {
        m.put((Object)"param", (Object)param);
        return "work/check/import";
    }

    @ResponseBody
    @RequestMapping(value={"/import"}, method={RequestMethod.POST})
    public ResponseData<Object> upload(Long fileId, PhcPhysicalCheckQuery param, HttpServletRequest request) {
        ResponseData data = new ResponseData();
        if (fileId == null) {
            return data;
        }
        try {
            SysFileModel file = SysFileUtil.getFileById(fileId);
            if (file == null) {
                data.setResult((Object)"\u4e0a\u4f20\u6587\u4ef6\u4e0d\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
                return data;
            }
            String fileExt = file.getFileExt();
            if (!"xls".equals(fileExt)) {
                data.setResult((Object)"\u4e0a\u4f20\u6587\u4ef6\u4e0d\u6b63\u786e\uff0c\u8bf7\u4e0a\u4f20xls\u6587\u4ef6");
                return data;
            }
            InputStream is = SysFileUtil.getInputStreamFileUrlByfid(file, request);
            if (is == null) {
                data.setResult((Object)"\u4e0a\u4f20\u6587\u4ef6\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
                return data;
            }
            Long cid = UserUtils.getLoginStaffCompanyId();
            Long staffId = UserUtils.getLoginStaffId();
            List<List<String>> contents = this.getImportDatas(is);
            List results = this.phcPhysicalCheckService.importCheckResult(contents, param, cid, staffId);
            data.setResult((Object)results);
        }
        catch (Exception e) {
            e.printStackTrace();
            data.setResult((Object)"\u670d\u52a1\u5668\u7e41\u5fd9\u8bf7\u7a0d\u540e\u518d\u8bd5");
            return data;
        }
        return data;
    }

    private List<List<String>> getImportDatas(InputStream iputstream) {
        List contents = null;
        ExcelUtil util = ExcelUtil.getInstance();
        ArrayList<Integer> cellNum = new ArrayList<Integer>();
        cellNum.add(2);
        cellNum.add(2);
        cellNum.add(4);
        cellNum.add(5);
        cellNum.add(6);
        cellNum.add(6);
        try {
            contents = util.getContent2(iputstream, cellNum, 2);
            return contents;
        }
        catch (Exception e) {
            e.printStackTrace();
            return contents;
        }
    }

    public String downAndReadFile(String filePath, String downloadPath) {
        File savePath = new File(downloadPath);
        if (!savePath.exists()) {
            savePath.mkdir();
        }
        String[] urlname = filePath.split("/");
        int len = urlname.length - 1;
        String uname = urlname[len];
        try {
            File file = new File(downloadPath + File.separator + uname);
            if (file != null && !file.exists()) {
                file.createNewFile();
            }
            FileOutputStream oputstream = new FileOutputStream(file);
            URL url = new URL(filePath);
            HttpURLConnection uc = (HttpURLConnection)url.openConnection();
            uc.setDoInput(true);
            uc.connect();
            InputStream iputstream = uc.getInputStream();
            byte[] buffer = new byte[4096];
            int byteRead = -1;
            while ((byteRead = iputstream.read(buffer)) != -1) {
                ((OutputStream)oputstream).write(buffer, 0, byteRead);
            }
            oputstream.flush();
            iputstream.close();
            ((OutputStream)oputstream).close();
            StringBuffer strb = new StringBuffer();
            FileInputStream fs = new FileInputStream(new File(downloadPath + File.separator + uname));
            InputStreamReader isr = new InputStreamReader((InputStream)fs, "UTF-8");
            BufferedReader br = new BufferedReader(isr);
            String data = "";
            while ((data = br.readLine()) != null) {
                strb.append(data + "\n");
            }
            br.close();
            fs.close();
            isr.close();
            return uname;
        }
        catch (Exception e) {
            System.out.println("\u8bfb\u53d6\u5931\u8d25\uff01");
            e.printStackTrace();
            return null;
        }
    }

    @RequiresPermissions(value={"healthCheck.edit"})
    @ResponseBody
    @RequestMapping(value={"/cancel/{ids}"})
    public ResponseData<String> cancel(@PathVariable String ids, HttpSession session) {
        this.logger.info("ajax-\u3010\u3011-\u5220\u9664\u8bb0\u5f55:" + ids);
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        this.phcPhysicalCheckService.cancelByIds(ids, staffId, cid);
        ResponseData data = new ResponseData();
        data.setResult((Object)ids);
        data.setContent("\u4f5c\u5e9f\u6210\u529f");
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"/importHudongStep1"})
    public ResponseData<String> importHudongStep1(Long fileId, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        SysFileModel file = SysFileUtil.getFileById(fileId);
        if (file == null) {
            responseData.setResult((Object)"\u4e0a\u4f20\u6587\u4ef6\u4e0d\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
            responseData.setState(ResponseStateEnum.fail);
            return responseData;
        }
        String fileExt = file.getFileExt();
        if (!"xls".equals(fileExt)) {
            responseData.setResult((Object)"\u4e0a\u4f20\u6587\u4ef6\u4e0d\u6b63\u786e\uff0c\u8bf7\u4e0a\u4f20xls\u6587\u4ef6");
            responseData.setState(ResponseStateEnum.fail);
            return responseData;
        }
        InputStream is = SysFileUtil.getInputStreamFileUrlByfid(file, request);
        if (is == null) {
            responseData.setResult((Object)"\u4e0a\u4f20\u6587\u4ef6\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
            responseData.setState(ResponseStateEnum.fail);
            return responseData;
        }
        responseData.setState(ResponseStateEnum.success);
        return responseData;
    }

    @ResponseBody
    @RequestMapping(value={"/importHudongStep2"})
    public ResponseData<List<CheckImportErrorData>> importHudongStep2(Long fileId, PhcPhysicalCheckQuery param, HttpServletRequest request) throws Exception {
        ResponseData responseData = new ResponseData();
        Map<String, ArrayList<ArrayList<ExcelContent>>> contentsMap = this.getImportHudongDatas(fileId);
        ArrayList<CheckImportErrorData> errorDataList = new ArrayList<CheckImportErrorData>();
        HashMap excelStaffNameMap = new HashMap();
        for (String sheetName : contentsMap.keySet()) {
            ArrayList<ArrayList<ExcelContent>> sheetContents = contentsMap.get(sheetName);
            if (sheetContents == null || sheetContents.size() <= 0) continue;
            for (ArrayList<Object> arrayList : sheetContents) {
                if (excelStaffNameMap.get(((ExcelContent)arrayList.get(0)).getContent()) == null) {
                    excelStaffNameMap.put(((ExcelContent)arrayList.get(0)).getContent(), new ArrayList());
                }
                ((List)excelStaffNameMap.get(((ExcelContent)arrayList.get(0)).getContent())).add(arrayList);
            }
        }
        for (String staffName : excelStaffNameMap.keySet()) {
            List sameStaffNameList = (List)excelStaffNameMap.get(staffName);
            for (ArrayList<Object> arrayList : sameStaffNameList) {
                CheckImportErrorData errorData = null;
                if (StringUtils.isEmpty((CharSequence)((ExcelContent)arrayList.get(0)).getContent())) {
                    errorData = errorData == null ? new CheckImportErrorData() : errorData;
                    errorData.getErrorReasons().add("\u59d3\u540d\u4e3a\u7a7a");
                }
                if (StringUtils.isEmpty((CharSequence)((ExcelContent)arrayList.get(1)).getContent()) && StringUtils.isEmpty((CharSequence)((ExcelContent)arrayList.get(2)).getContent())) {
                    CheckImportErrorData checkImportErrorData = errorData = errorData == null ? new CheckImportErrorData() : errorData;
                    if (StringUtils.isEmpty((CharSequence)((ExcelContent)arrayList.get(1)).getContent())) {
                        errorData.getErrorReasons().add("\u5de5\u53f7\u4e3a\u7a7a");
                    } else {
                        errorData.getErrorReasons().add("\u8eab\u4efd\u8bc1\u53f7\u4e3a\u7a7a");
                    }
                }
                if (errorData == null) continue;
                errorData.getSheetNames().add(((ExcelContent)arrayList.get(0)).getSheetName());
                errorData.getRowNums().add(((ExcelContent)arrayList.get(0)).getRowNum());
                errorDataList.add(errorData);
            }
        }
        if (errorDataList.size() > 0) {
            responseData.setState(ResponseStateEnum.fail);
            responseData.setResult(errorDataList);
            request.getSession().removeAttribute("errorDataList" + fileId);
            request.getSession().setAttribute("errorDataList" + fileId, errorDataList);
        } else {
            responseData.setState(ResponseStateEnum.success);
            request.getSession().setAttribute("excelStaffNameMap" + fileId, excelStaffNameMap);
        }
        return responseData;
    }

    @RequestMapping(value={"/importHudongStep2Page"})
    public String importHudongStep2Page(ModelMap m, Long fileId, PhcPhysicalCheckQuery param, HttpServletRequest request) {
        List errorDataList = (List)request.getSession().getAttribute("errorDataList" + fileId);
        m.put((Object)"errorDataList", (Object)errorDataList);
        return "work/check/importHudongStep2Page";
    }

    @ResponseBody
    @RequestMapping(value={"/importHudongStep3"})
    public ResponseData<List<CheckImportErrorData>> importHudongStep3(Long fileId, PhcPhysicalCheckQuery param, HttpServletRequest request) throws Exception {
        ResponseData responseData = new ResponseData();
        Map excelStaffNameMap = (Map)request.getSession().getAttribute("excelStaffNameMap" + fileId);
        ArrayList<CheckImportErrorData> errorDataList = new ArrayList<CheckImportErrorData>();
        for (String staffName : excelStaffNameMap.keySet()) {
            List sameStaffNameList = (List)excelStaffNameMap.get(staffName);
            if (sameStaffNameList.size() <= 1) continue;
            CheckImportErrorData errorData = new CheckImportErrorData();
            errorData.setStaffName(staffName);
            HashMap map = new HashMap();
            map.put(staffName, new ArrayList());
            for (ArrayList colContents : sameStaffNameList) {
                errorData.getErrorReasons().add(((ExcelContent)colContents.get(0)).getSheetName() + "\u8868\u4e2d\u7b2c" + ((ExcelContent)colContents.get(0)).getRowNum() + "\u884c");
                errorData.getSheetNames().add(((ExcelContent)colContents.get(0)).getSheetName());
                errorData.getRowNums().add(((ExcelContent)colContents.get(0)).getRowNum());
                if (StringUtils.isNotEmpty((String)((ExcelContent)colContents.get(1)).getContent())) {
                    errorData.getWorkNo().add(((ExcelContent)colContents.get(1)).getContent());
                }
                if (StringUtils.isNotEmpty((String)((ExcelContent)colContents.get(2)).getContent())) {
                    errorData.getIdCards().add(((ExcelContent)colContents.get(2)).getContent());
                }
                ((List)map.get(staffName)).add(((ExcelContent)colContents.get(1)).getContent() + ((ExcelContent)colContents.get(2)).getContent());
            }
            if (((List)map.get(staffName)).stream().distinct().collect(Collectors.toList()).size() <= 1) continue;
            errorDataList.add(errorData);
        }
        if (errorDataList.size() > 0) {
            responseData.setState(ResponseStateEnum.fail);
            responseData.setResult(errorDataList);
            request.getSession().removeAttribute("errorDataList" + fileId);
            request.getSession().setAttribute("errorDataList" + fileId, errorDataList);
        } else {
            responseData.setState(ResponseStateEnum.success);
            request.getSession().setAttribute("excelStaffNameMap" + fileId, (Object)excelStaffNameMap);
        }
        return responseData;
    }

    @RequestMapping(value={"/importHudongStep3Page"})
    public String importHudongStep3Page(ModelMap m, Long fileId, PhcPhysicalCheckQuery param, HttpServletRequest request) {
        List errorDataList = (List)request.getSession().getAttribute("errorDataList" + fileId);
        m.put((Object)"errorDataList", (Object)errorDataList);
        return "work/check/importHudongStep3Page";
    }

    @ResponseBody
    @RequestMapping(value={"/importHudongStep4"})
    public ResponseData<List<CheckImportErrorData>> importHudongStep4(Long fileId, PhcPhysicalCheckQuery param, HttpServletRequest request) throws Exception {
        ResponseData responseData = new ResponseData();
        Map excelStaffNameMap = (Map)request.getSession().getAttribute("excelStaffNameMap" + fileId);
        ArrayList<CheckImportErrorData> errorDataList = new ArrayList<CheckImportErrorData>();
        ArrayList<ArrayList> needAddStaffInfos = new ArrayList<ArrayList>();
        HashMap existedStaffInfosMap = new HashMap();
        Long cid = UserUtils.getLoginStaffCompanyId();
        Map<String, List<HudongSysStaffInfoVo>> sysStaffInfoMap = this.getAllStaffInfoMapByCid(cid);
        for (String staffName : excelStaffNameMap.keySet()) {
            List sameStaffNameList = (List)excelStaffNameMap.get(staffName);
            for (ArrayList colContents : sameStaffNameList) {
                CheckImportErrorData errorData;
                HudongSysStaffInfoVo staffInfoVo;
                List<HudongSysStaffInfoVo> staffInfoVos = sysStaffInfoMap.get(((ExcelContent)colContents.get(0)).getContent());
                if (staffInfoVos == null) {
                    needAddStaffInfos.add(colContents);
                    continue;
                }
                if (staffInfoVos == null) continue;
                if (StringUtils.isNotEmpty((String)((ExcelContent)colContents.get(1)).getContent()) && StringUtils.isEmpty((CharSequence)((ExcelContent)colContents.get(2)).getContent())) {
                    staffInfoVo = staffInfoVos.stream().filter(s -> ((ExcelContent)colContents.get(1)).getContent().equals(s.getWorkNo())).findFirst().orElse(null);
                    if (staffInfoVo == null) {
                        errorData = new CheckImportErrorData();
                        errorData.setStaffName(staffName);
                        errorData.getRowNums().add(((ExcelContent)colContents.get(0)).getRowNum());
                        errorData.getSheetNames().add(((ExcelContent)colContents.get(0)).getSheetName());
                        staffInfoVo = staffInfoVos.stream().filter(s -> StringUtils.isNotEmpty((String)s.getWorkNo())).findFirst().orElse(null);
                        if (staffInfoVo == null) {
                            errorData.setStaffId(staffInfoVos.get(0).getStaffId());
                            errorData.setSysInfoStr(staffInfoVos.get(0).getIdCard());
                            errorData.setImportInfo(((ExcelContent)colContents.get(1)).getContent());
                            errorData.setType(Integer.valueOf(2));
                        } else {
                            errorData.setStaffId(staffInfoVo.getStaffId());
                            errorData.getWorkNo().add(staffInfoVo.getWorkNo());
                            errorData.getIdCards().add(staffInfoVo.getIdCard());
                            errorData.setType(Integer.valueOf(1));
                        }
                        errorDataList.add(errorData);
                        continue;
                    }
                    if (existedStaffInfosMap.get(staffInfoVo.getStaffId()) == null) {
                        existedStaffInfosMap.put(staffInfoVo.getStaffId(), new ArrayList());
                    }
                    ((List)existedStaffInfosMap.get(staffInfoVo.getStaffId())).add(colContents);
                    continue;
                }
                if (StringUtils.isNotEmpty((String)((ExcelContent)colContents.get(2)).getContent()) && StringUtils.isEmpty((CharSequence)((ExcelContent)colContents.get(1)).getContent())) {
                    staffInfoVo = staffInfoVos.stream().filter(s -> ((ExcelContent)colContents.get(2)).getContent().equals(s.getIdCard())).findFirst().orElse(null);
                    if (staffInfoVo == null) {
                        errorData = new CheckImportErrorData();
                        errorData.setStaffName(staffName);
                        errorData.getRowNums().add(((ExcelContent)colContents.get(0)).getRowNum());
                        errorData.getSheetNames().add(((ExcelContent)colContents.get(0)).getSheetName());
                        staffInfoVo = staffInfoVos.stream().filter(s -> StringUtils.isNotEmpty((String)s.getIdCard())).findFirst().orElse(null);
                        if (staffInfoVo == null) {
                            errorData.setStaffId(staffInfoVos.get(0).getStaffId());
                            errorData.setSysInfoStr(staffInfoVos.get(0).getWorkNo());
                            errorData.setImportInfo(((ExcelContent)colContents.get(2)).getContent());
                            errorData.setType(Integer.valueOf(2));
                        } else {
                            errorData.setStaffId(staffInfoVo.getStaffId());
                            errorData.getWorkNo().add(staffInfoVo.getWorkNo());
                            errorData.getIdCards().add(staffInfoVo.getIdCard());
                            errorData.setType(Integer.valueOf(1));
                        }
                        errorDataList.add(errorData);
                        continue;
                    }
                    if (existedStaffInfosMap.get(staffInfoVo.getStaffId()) == null) {
                        existedStaffInfosMap.put(staffInfoVo.getStaffId(), new ArrayList());
                    }
                    ((List)existedStaffInfosMap.get(staffInfoVo.getStaffId())).add(colContents);
                    continue;
                }
                staffInfoVo = staffInfoVos.stream().filter(s -> ((ExcelContent)colContents.get(1)).getContent().equals(s.getWorkNo()) && ((ExcelContent)colContents.get(2)).getContent().equals(s.getIdCard())).findFirst().orElse(null);
                if (staffInfoVo == null) {
                    errorData = new CheckImportErrorData();
                    errorData.setStaffName(staffName);
                    errorData.getRowNums().add(((ExcelContent)colContents.get(0)).getRowNum());
                    errorData.getSheetNames().add(((ExcelContent)colContents.get(0)).getSheetName());
                    errorData.setStaffId(staffInfoVos.get(0).getStaffId());
                    errorData.getWorkNo().add(staffInfoVos.get(0).getWorkNo());
                    errorData.getIdCards().add(staffInfoVos.get(0).getIdCard());
                    errorData.setStatus(Integer.valueOf(5));
                    errorData.setType(Integer.valueOf(1));
                    errorDataList.add(errorData);
                    continue;
                }
                if (existedStaffInfosMap.get(staffInfoVo.getStaffId()) == null) {
                    existedStaffInfosMap.put(staffInfoVo.getStaffId(), new ArrayList());
                }
                ((List)existedStaffInfosMap.get(staffInfoVo.getStaffId())).add(colContents);
            }
        }
        request.getSession().setAttribute("existedStaffInfosMap" + fileId, existedStaffInfosMap);
        request.getSession().setAttribute("needAddStaffInfos" + fileId, needAddStaffInfos);
        if (errorDataList.size() > 0) {
            responseData.setState(ResponseStateEnum.fail);
            responseData.setResult(errorDataList);
            request.getSession().removeAttribute("errorDataList" + fileId);
            request.getSession().setAttribute("errorDataList" + fileId, errorDataList);
        } else {
            responseData.setState(ResponseStateEnum.success);
            request.getSession().removeAttribute("errorDataList" + fileId);
            request.getSession().setAttribute("excelStaffNameMap" + fileId, (Object)excelStaffNameMap);
        }
        return responseData;
    }

    @RequestMapping(value={"/importHudongStep4Page"})
    public String importHudongStep4Page(ModelMap m, Long fileId, PhcPhysicalCheckQuery param, HttpServletRequest request) {
        List errorDataList = (List)request.getSession().getAttribute("errorDataList" + fileId);
        m.put((Object)"errorDataList", (Object)errorDataList);
        m.put((Object)"type1", errorDataList.stream().filter(s -> s.getType() == 1).collect(Collectors.toList()));
        m.put((Object)"type2", errorDataList.stream().filter(s -> s.getType() == 2).collect(Collectors.toList()));
        return "work/check/importHudongStep4Page";
    }

    @ResponseBody
    @RequestMapping(value={"/importHudongFinal"})
    public ResponseData<String> importHudongFinal(Long fileId, PhcPhysicalCheckQuery param, HttpServletRequest request) throws Exception {
        ResponseData responseData = new ResponseData();
        Map excelStaffNameMap = (Map)request.getSession().getAttribute("excelStaffNameMap" + fileId);
        Map existedStaffInfosMap = (Map)request.getSession().getAttribute("existedStaffInfosMap" + fileId);
        ArrayList needAddStaffInfos = (ArrayList)request.getSession().getAttribute("needAddStaffInfos" + fileId);
        Long cid = UserUtils.getLoginStaffCompanyId();
        Map<String, List<HudongSysStaffInfoVo>> sysStaffInfoMap = this.getAllStaffInfoMapByCid(cid);
        Long loginStaffId = UserUtils.getLoginStaffId();
        if (existedStaffInfosMap.keySet().size() > 0) {
            this.phcPhysicalCheckDataService.addExistCheckResults(existedStaffInfosMap, param.getCheckId(), param.getCheckType(), loginStaffId, cid);
        }
        if (needAddStaffInfos.size() > 0) {
            this.phcPhysicalCheckDataService.addNeedAddStaffInfosCheckResults((List)needAddStaffInfos, param.getCheckId(), param.getCheckType(), loginStaffId, cid);
        }
        if (param.getNeedHandleDatas() != null && param.getNeedHandleDatas().size() > 0) {
            needAddStaffInfos = new ArrayList();
            HashMap needUpdateStaffInfosMap = new HashMap();
            for (CheckImportErrorData errorData : param.getNeedHandleDatas()) {
                List execlStaffs = (List)excelStaffNameMap.get(errorData.getStaffName());
                execlStaffs = execlStaffs.stream().filter(ss -> ss.stream().filter(s -> s.getSheetName().equals(errorData.getSheetNames().get(0)) && s.getRowNum().equals(errorData.getRowNums().get(0))).collect(Collectors.toList()).size() > 0).collect(Collectors.toList());
                if (errorData.getStatus() == 1 || errorData.getStatus() == 3) {
                    needUpdateStaffInfosMap.put(errorData.getStaffId(), execlStaffs);
                    continue;
                }
                if (errorData.getStatus() != 2 && errorData.getStatus() != 4) continue;
                needAddStaffInfos.addAll(execlStaffs);
            }
            if (needAddStaffInfos.size() > 0) {
                this.phcPhysicalCheckDataService.addNeedAddStaffInfosCheckResults(needAddStaffInfos, param.getCheckId(), param.getCheckType(), loginStaffId, cid);
            }
            if (needUpdateStaffInfosMap.keySet().size() > 0) {
                this.phcPhysicalCheckDataService.addNeedUpdateStaffInfosCheckResults(needUpdateStaffInfosMap, param.getCheckId(), param.getCheckType(), loginStaffId, cid);
            }
        }
        responseData.setState(ResponseStateEnum.success);
        responseData.setResult((Object)"\u5bfc\u5165\u6210\u529f!");
        return responseData;
    }

    private Map<String, ArrayList<ArrayList<ExcelContent>>> getImportHudongDatas(Long importFileId) throws Exception {
        Object contents = null;
        ExcelUtil util = ExcelUtil.getInstance();
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        String ossfile = SysFileUtil.getContextPathFileUrlByfid(importFileId);
        HashMap<String, Integer> validColMap = new HashMap<String, Integer>();
        HashMap<String, Integer> startRowMap = new HashMap<String, Integer>();
        validColMap.put("\u76ee\u524d\u672a\u89c1\u5f02\u5e38", 3);
        startRowMap.put("\u76ee\u524d\u672a\u89c1\u5f02\u5e38", 2);
        validColMap.put("\u5176\u4ed6\u75be\u75c5\u6216\u5f02\u5e38", 3);
        startRowMap.put("\u5176\u4ed6\u75be\u75c5\u6216\u5f02\u5e38", 2);
        validColMap.put("\u590d\u67e5", 5);
        startRowMap.put("\u590d\u67e5", 2);
        validColMap.put("\u804c\u4e1a\u7981\u5fcc\u8bc1", 6);
        startRowMap.put("\u804c\u4e1a\u7981\u5fcc\u8bc1", 2);
        validColMap.put("\u7591\u4f3c\u804c\u4e1a\u75c5", 7);
        startRowMap.put("\u7591\u4f3c\u804c\u4e1a\u75c5", 2);
        validColMap.put("\u7f3a\u5fc5\u68c0\u9879", 7);
        startRowMap.put("\u7f3a\u5fc5\u68c0\u9879", 2);
        Map excelContentMap = ExcelUtil.getInstance().getContentHasExcelInfo(ossfile, validColMap, startRowMap);
        return excelContentMap;
    }

    private Map<String, List<HudongSysStaffInfoVo>> getAllStaffInfoMapByCid(Long cid) {
        List allSysStaffs = this.phcPhysicalCheckService.getAllStaffInfoListByCid(cid);
        HashMap<String, List<HudongSysStaffInfoVo>> map = new HashMap<String, List<HudongSysStaffInfoVo>>();
        for (HudongSysStaffInfoVo hssiv : allSysStaffs) {
            if (map.get(hssiv.getRealName()) == null) {
                map.put(hssiv.getRealName(), new ArrayList());
            }
            ((List)map.get(hssiv.getRealName())).add(hssiv);
        }
        return map;
    }
}

