/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.check;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.health.entity.work.check.PhcOccupationalDiseaser;
import cn.smarthse.modules.health.entity.work.check.vo.PhcOccupationalDiseaserParam;
import cn.smarthse.modules.health.entity.work.check.vo.PhcOccupationalDiseaserVo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcSuperviseOccupationalDiseaserVo;
import cn.smarthse.modules.health.service.work.check.IPhcOccupationalDiseaserService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/check/diseaser"})
public class PhcOccupationalDiseaserController
extends ControllerSupport {
    @DubboReference
    IPhcOccupationalDiseaserService phcOccupationalDiseaserService;

    @RequiresPermissions(value={"healthCheck.view"})
    @ResponseBody
    @RequestMapping(value={"listData"})
    public JqGridData<PhcOccupationalDiseaserVo> listData(HttpSession session, JqGridParam gparam, PhcOccupationalDiseaserParam param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        PageInfo list = this.phcOccupationalDiseaserService.getList(gparam, param);
        JqGridData data = new JqGridData(list, gparam);
        return data;
    }

    @RequiresPermissions(value={"healthCheck.view"})
    @ResponseBody
    @RequestMapping(value={"listSuperviseData"})
    public JqGridData<PhcSuperviseOccupationalDiseaserVo> listSuperviseData(HttpSession session, JqGridParam gparam, PhcOccupationalDiseaserParam param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        PageInfo list = this.phcOccupationalDiseaserService.listSuperviseData(gparam, param);
        JqGridData data = new JqGridData(list, gparam);
        return data;
    }

    @RequiresPermissions(value={"healthCheck.view"})
    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String info(@PathVariable Long id, HttpSession session, ModelMap m) {
        PhcOccupationalDiseaser data = null;
        data = id != null ? this.phcOccupationalDiseaserService.getDetailById(id) : new PhcOccupationalDiseaser();
        m.put((Object)"data", (Object)data);
        return "work/check/count/diseaser_info";
    }

    @RequiresPermissions(value={"healthCheck.view"})
    @RequestMapping(value={"/view/supervise/{id}"}, method={RequestMethod.GET})
    public String superviseInfo(@PathVariable Long id, HttpSession session, ModelMap m) {
        PhcSuperviseOccupationalDiseaserVo data = this.phcOccupationalDiseaserService.getSuperviseInfo(id);
        m.put((Object)"data", (Object)data);
        return "work/check/count/diseaser_supervise_info";
    }

    @RequiresPermissions(value={"healthCheck.edit"})
    @RequestMapping(value={"/add"}, method={RequestMethod.GET})
    public String add(PhcOccupationalDiseaser data, HttpSession session, ModelMap m) {
        m.put((Object)"data", (Object)data);
        return "work/check/count/diseaser_edit";
    }

    @RequiresPermissions(value={"healthCheck.edit"})
    @RequestMapping(value={"/edit/{id}"}, method={RequestMethod.GET})
    public String edit(@PathVariable Long id, HttpSession session, ModelMap m) {
        PhcOccupationalDiseaser data = null;
        data = id != null ? this.phcOccupationalDiseaserService.getDetailById(id) : new PhcOccupationalDiseaser();
        m.put((Object)"data", (Object)data);
        return "work/check/count/diseaser_edit";
    }

    @RequiresPermissions(value={"healthCheck.edit"})
    @ResponseBody
    @RequestMapping(value={"/info"}, method={RequestMethod.POST})
    public ResponseData<PhcOccupationalDiseaser> infoPost(HttpSession session, PhcOccupationalDiseaser data) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        data = this.phcOccupationalDiseaserService.insertOrUpdate(data, cid, staffId);
        ResponseData result = new ResponseData();
        result.setResult((Object)data);
        result.setContent("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    @RequiresPermissions(value={"healthCheck.edit"})
    @ResponseBody
    @RequestMapping(value={"/del/{ids}"}, method={RequestMethod.DELETE})
    public ResponseData<String> ajax_delete(@PathVariable String ids, HttpSession session) {
        this.logger.info("ajax-\u3010\u3011-\u5220\u9664\u8bb0\u5f55:" + ids);
        Long staffId = UserUtils.getLoginStaffId();
        this.phcOccupationalDiseaserService.deleteByIds(ids, staffId);
        ResponseData data = new ResponseData();
        data.setResult((Object)ids);
        data.setContent("\u5220\u9664\u6210\u529f");
        return data;
    }

    @RequiresPermissions(value={"healthCheck.view"})
    @RequestMapping(value={"export"})
    public void export(PhcOccupationalDiseaserParam param, HttpSession session, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u804c\u4e1a\u75c5\u4eba\u540d\u5355" + dateFormat.format(new Date()) + ".xls";
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("GBK"), "ISO8859_1"));
        response.setContentType("application/octet-stream; charset=GBK");
        String[] colums = new String[]{"\u59d3\u540d|staffName", "\u5de5\u53f7|staffWorkNo", "\u90e8\u95e8/\u8f66\u95f4|checkDeptName", "\u5c97\u4f4d/\u5de5\u4f5c|checkWorkName", "\u8bca\u65ad\u65f6\u95f4|diagnosedTime", "\u804c\u4e1a\u75c5\u540d\u79f0|diseaseName", "\u4eba\u5458\u5904\u7406\u60c5\u51b5|dealTypeInfo", "\u662f\u5426\u843d\u5b9e|isSureName"};
        param.setCid(UserUtils.getLoginStaffCompanyId());
        List list = this.phcOccupationalDiseaserService.listDetails(param);
        ExportExcel export = new ExportExcel();
        export.simpleExport3("\u804c\u4e1a\u75c5\u4eba\u540d\u5355", colums, list, (OutputStream)response.getOutputStream());
    }
}

