/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.check;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.entity.work.check.PhcDiseaserReport;
import cn.smarthse.modules.health.entity.work.check.vo.PhcDieaserReportGroup;
import cn.smarthse.modules.health.entity.work.check.vo.PhcDiseaserReportQuery;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckStaffResultInfo;
import cn.smarthse.modules.health.service.work.check.IPhcDiseaserReportService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/check/diseaser/report"})
public class PhcDiseaserReportController
extends ControllerSupport {
    @DubboReference
    IPhcDiseaserReportService reportService;

    @RequiresPermissions(value={"healthCheck.view"})
    @RequestMapping
    public String page_index(@RequestParam(value="page", required=false, defaultValue="1") int pageIndex, HttpSession session, ModelMap m, PhcDiseaserReport report) {
        this.logger.info("\u3010\u3011-\u6c47\u603b\u9996\u9875");
        return "work/check/report/report_list";
    }

    @RequiresPermissions(value={"healthCheck.view"})
    @ResponseBody
    @RequestMapping(value={"listData"})
    public JqGridData<PhcDiseaserReport> listData(HttpSession session, JqGridParam gparam, PhcDiseaserReportQuery param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        UserUtils.startWebDataScope();
        PageInfo list = this.reportService.getList(gparam, param);
        JqGridData data = new JqGridData(list, gparam);
        return data;
    }

    @RequiresPermissions(value={"healthCheck.view"})
    @RequestMapping(value={"/view"}, method={RequestMethod.GET})
    public String view(PhcDiseaserReport report, HttpSession session, ModelMap m) {
        report = report.getId() != null ? (PhcDiseaserReport)this.reportService.getById(report.getId()) : new PhcDiseaserReport();
        m.put((Object)"data", (Object)report);
        return "work/check/report/report_info";
    }

    @RequiresPermissions(value={"healthCheck.edit"})
    @RequestMapping(value={"/add"}, method={RequestMethod.GET})
    public String add(PhcDiseaserReport report, HttpSession session, ModelMap m) {
        return "work/check/report/report_edit";
    }

    @RequiresPermissions(value={"healthCheck.edit"})
    @RequestMapping(value={"/edit"}, method={RequestMethod.GET})
    public String edit(PhcDiseaserReport report, HttpSession session, ModelMap m) {
        report = report.getId() != null ? (PhcDiseaserReport)this.reportService.getById(report.getId()) : new PhcDiseaserReport();
        m.put((Object)"data", (Object)report);
        return "work/check/report/report_edit";
    }

    @RequiresPermissions(value={"healthCheck.edit"})
    @ResponseBody
    @RequestMapping(value={"/info"}, method={RequestMethod.POST})
    public ResponseData<PhcDiseaserReport> infoPost(HttpServletRequest request, PhcDiseaserReport report) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        String[] reportFilesIds = request.getParameterValues("reportFilesIds");
        report.setReportIds(reportFilesIds);
        if (report.getId() == null && StringUtils.isEmpty((CharSequence)report.getOrgId())) {
            report.setOrgId("" + UserUtils.getOrgId());
        }
        report = this.reportService.insertOrUpdate(report, cid, staffId);
        ResponseData data = new ResponseData();
        data.setResult((Object)report);
        data.setContent("\u64cd\u4f5c\u6210\u529f");
        return data;
    }

    @RequiresPermissions(value={"healthCheck.edit"})
    @ResponseBody
    @RequestMapping(value={"/del/{ids}"}, method={RequestMethod.DELETE})
    public ResponseData<String> ajax_delete(@PathVariable String ids, HttpSession session) {
        this.logger.info("ajax-\u3010\u3011-\u5220\u9664\u8bb0\u5f55:" + ids);
        Long staffId = UserUtils.getLoginStaffId();
        this.reportService.deleteByIds(ids, staffId);
        ResponseData data = new ResponseData();
        data.setResult((Object)ids);
        data.setContent("\u5220\u9664\u6210\u529f");
        return data;
    }

    @RequiresPermissions(value={"healthCheck.view"})
    @RequestMapping(value={"export"})
    public void export(PhcDiseaserReportQuery data, HttpSession session, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.logger.info("ajax-\u3010\u3011-\u5bfc\u51faExcel");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\uff08\u7591\u4f3c\uff09\u804c\u4e1a\u75c5\u4eba\u4e0a\u62a5\u5df2\u5b8c\u6210\u6e05\u5355" + dateFormat.format(new Date()) + ".xls";
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("GBK"), "ISO8859_1"));
        response.setContentType("application/octet-stream; charset=GBK");
        String[] colums = new String[]{"\u5de5\u4f5c\u540d\u79f0|checkName", "\u4e0a\u62a5\u65f6\u95f4|reportTime", "\u4f53\u68c0\u65f6\u95f4|checkDate", "\u7591\u4f3c\u804c\u4e1a\u75c5\u4eba\u6570|suspectedCount", "\u786e\u8bca\u804c\u4e1a\u75c5\u4eba\u6570|sureCount", "\u7f16\u5236\u4eba|createByName"};
        data.setCid(UserUtils.getLoginStaffCompanyId());
        data.setStatus(Byte.valueOf((byte)1));
        UserUtils.startWebDataScope();
        List list = this.reportService.listDetails(data);
        ExportExcel export = new ExportExcel();
        export.simpleExport3("\uff08\u7591\u4f3c\uff09\u804c\u4e1a\u75c5\u4eba\u4e0a\u62a5\u5df2\u5b8c\u6210\u6e05\u5355", colums, list, (OutputStream)response.getOutputStream());
    }

    @ResponseBody
    @RequestMapping(value={"/cout/{id}"}, method={RequestMethod.GET})
    public PhcDieaserReportGroup queryCheckInfo(@PathVariable Long id, HttpSession session) {
        PhcDieaserReportGroup info = this.reportService.getDieaseInfosByCheckId(id);
        return info;
    }

    @ResponseBody
    @RequestMapping(value={"/check/diseaser"}, method={RequestMethod.GET})
    public List<PhcPhysicalCheckStaffResultInfo> queryCheckDiseaserInfo(Long checkId, Boolean isDiseaser) {
        List infos = this.reportService.queryCheckDiseaserInfo(checkId, isDiseaser);
        return infos;
    }
}

