/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.check;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.health.entity.work.check.PhcCheckResultDetail;
import cn.smarthse.modules.health.entity.work.check.PhcDiagnoseDiseaseProcess;
import cn.smarthse.modules.health.entity.work.check.vo.PhcDieaserUnprocessInfo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcDiseaserUnProcessParam;
import cn.smarthse.modules.health.service.work.check.IPhcDiagnoseDiseaseProcessService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/check/disease/process"})
public class PhcDiagnoseDiseaseProcessController
extends ControllerSupport {
    @DubboReference
    private IPhcDiagnoseDiseaseProcessService processService;

    @RequiresPermissions(value={"healthCheck.view"})
    @RequestMapping
    public String page_index(@RequestParam(value="page", required=false, defaultValue="1") int pageIndex, HttpSession session, ModelMap m, PhcDiseaserUnProcessParam param) {
        this.logger.info("\u3010\u3011-\u6c47\u603b\u9996\u9875");
        return "work/check/disease/disease_list";
    }

    @RequiresPermissions(value={"healthCheck.view"})
    @ResponseBody
    @RequestMapping(value={"listData"})
    public JqGridData<PhcDieaserUnprocessInfo> listData(JqGridParam gparam, PhcDiseaserUnProcessParam param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        UserUtils.startWebDataScope();
        PageInfo list = this.processService.getUnprocessPage(gparam, param);
        JqGridData data = new JqGridData(list, gparam);
        return data;
    }

    @RequiresPermissions(value={"healthCheck.view"})
    @RequestMapping(value={"/view"}, method={RequestMethod.GET})
    public String view(PhcDiagnoseDiseaseProcess data, String fromPage, HttpSession session, ModelMap m) {
        data = data.getId() != null ? this.processService.getDetailById(data.getId()) : new PhcDiagnoseDiseaseProcess();
        m.put((Object)"data", (Object)data);
        m.put((Object)"fromPage", (Object)fromPage);
        return "work/check/disease/disease_info";
    }

    @RequiresPermissions(value={"healthCheck.view"})
    @RequestMapping(value={"/staff"}, method={RequestMethod.GET})
    public String staff(PhcDiagnoseDiseaseProcess data, HttpSession session, ModelMap m) {
        data = data.getStaffId() != null && data.getCheckId() != null ? this.processService.getDetailByInfo(data) : new PhcDiagnoseDiseaseProcess();
        m.put((Object)"data", (Object)data);
        return "work/check/disease/disease_info";
    }

    @RequiresPermissions(value={"healthCheck.edit"})
    @RequestMapping(value={"/edit"}, method={RequestMethod.GET})
    public String edit(PhcDiagnoseDiseaseProcess data, String fromPage, HttpSession session, ModelMap m) {
        data = data.getId() != null ? this.processService.getDetailById(data.getId()) : new PhcDiagnoseDiseaseProcess();
        m.put((Object)"data", (Object)data);
        m.put((Object)"fromPage", (Object)fromPage);
        return "work/check/disease/disease_edit";
    }

    @RequiresPermissions(value={"healthCheck.edit"})
    @ResponseBody
    @RequestMapping(value={"/info"}, method={RequestMethod.POST})
    public ResponseData<PhcDiagnoseDiseaseProcess> infoPost(HttpServletRequest request, PhcDiagnoseDiseaseProcess data) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        this.setFiles(request, data);
        data.setOrgId(UserUtils.getOrgId());
        data = this.processService.insertOrUpdate(data, cid, staffId);
        ResponseData result = new ResponseData();
        result.setResult((Object)data);
        result.setContent("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    private void setFiles(HttpServletRequest request, PhcDiagnoseDiseaseProcess data) {
        List details = data.getDetails();
        if (details == null) {
            return;
        }
        int i = 0;
        for (PhcCheckResultDetail d : details) {
            String[] certIds = request.getParameterValues("certIds" + i);
            String[] credenceIds = request.getParameterValues("credenceIds" + i);
            d.setCertIds(certIds);
            d.setCredenceIds(credenceIds);
            ++i;
        }
    }
}

