/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.certificate;

import cn.hutool.core.lang.Pair;
import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.LayUiResponseResult;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.mapper.HseJsonArray;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.ZipCompressorUtil;
import cn.smarthse.framework.encrypt.annotation.ApiEncrypt;
import cn.smarthse.modules.common.enums.BigLogBusinessModuleEnum;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.model.bigdata.BigLog;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideService;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.work.certificate.CertificateFiles;
import cn.smarthse.modules.health.entity.work.certificate.CertificateStaff;
import cn.smarthse.modules.health.entity.work.certificate.CertificateStaffDetail;
import cn.smarthse.modules.health.enums.certificate.CertificateExpireDealEnum;
import cn.smarthse.modules.health.enums.certificate.CertificateStaffTypeEnum;
import cn.smarthse.modules.health.enums.certificate.OccHeaStaffTypeEnum;
import cn.smarthse.modules.health.enums.certificate.SpecialEquipOperationsDetailTypeEnum;
import cn.smarthse.modules.health.enums.certificate.SpecialEquipOperationsTypeEnum;
import cn.smarthse.modules.health.enums.certificate.SpecialOperationsDetailTypeEnum;
import cn.smarthse.modules.health.enums.certificate.SpecialOperationsTypeEnum;
import cn.smarthse.modules.health.enums.certificate.StStaffTypeEnum;
import cn.smarthse.modules.health.service.base.company.ICompanyFunctionalOrganizationMemberService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveUpdateService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateCompanyService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateDeviceDetailService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateFilesService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateStaffDetailService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateStaffService;
import cn.smarthse.modules.health.supervise.entity.keyFactory.KeyFactoryApprovalHistory;
import cn.smarthse.modules.health.supervise.enums.keyFactory.KeyFactoryTypeEnum;
import cn.smarthse.modules.health.supervise.service.keyFactory.IKeyFactoryApprovalHistoryService;
import cn.smarthse.modules.health.supervise.service.keyFactory.IKeyFactoryService;
import cn.smarthse.modules.health.vo.work.certificate.CertificateStaffDetailVo;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.controller.base.BaseController;
import cn.smarthse.web.util.StaffUtil;
import cn.smarthse.web.util.SysFileUtil;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import com.sx.log.enums.ActionTypeEnum;
import com.sx.log.enums.UserRoleEnum;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/certificate"})
public class CertificateStaffController
extends ControllerSupport {
    @DubboReference
    private ICertificateStaffService certificateStaffService;
    @DubboReference
    private ICertificateStaffDetailService certificateStaffDetailService;
    @DubboReference
    private ICertificateCompanyService certificateCompanyService;
    @DubboReference
    private IStaffInfoService stafInfoService;
    @DubboReference
    private ICertificateFilesService certificateFilesService;
    @DubboReference
    private ICertificateDeviceDetailService certificateDeviceDetailService;
    @DubboReference(timeout=600000, check=false)
    private IKeyFactoryApprovalHistoryService keyFactoryApprovalHistoryService;
    @DubboReference
    private ILiteArchiveUpdateService archiveUpdateService;
    @DubboReference(timeout=600000, check=false)
    private IKeyFactoryService keyFactoryService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideService companyProvideService;
    @Autowired
    private BaseController baseController;
    @Autowired
    private RedisClient redisClient;
    @DubboReference
    private ICompanyFunctionalOrganizationMemberService memberServcie;

    @Log(title="\u4eba\u5458\u8bc1\u4e66\u6e05\u5355", type=2)
    @RequiresPermissions(value={"certificate.view"})
    @RequestMapping(value={"/certStaffList"})
    public String certificaateIndex(HttpSession session, Model m) {
        return "work/certificate/certificateStaffList";
    }

    @Log(title="\u4eba\u5458\u8bc1\u4e66\u6e05\u5355", type=2)
    @RequiresPermissions(value={"certificate"})
    @RequestMapping(value={"/certStaffListLite"})
    public String certStaffListLite(HttpSession session, Model m) {
        return "views/keyFactorManagement/certStaffListLite/newCertificateStaffList";
    }

    @GetMapping(value={"/test"})
    @ResponseBody
    public String test() {
        this.certificateStaffDetailService.setSourceId(UserUtils.getLoginStaffCompanyId());
        return "success";
    }

    @RequestMapping(value={"/viewCertStaff"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData viewCertStaff(Long id) {
        if (id == null) {
            return ResponseData.success(null);
        }
        CertificateStaffDetail record = (CertificateStaffDetail)this.certificateStaffDetailService.getById(id);
        List filesList = this.certificateFilesService.getByCerid(record.getId());
        record.setFiles(filesList);
        return ResponseData.success((Object)record);
    }

    @RequestMapping(value={"/viewCertApprovalList"}, method={RequestMethod.GET})
    @ResponseBody
    public LayUiResponseResult<KeyFactoryApprovalHistory> viewCertApprovalList(KeyFactoryApprovalHistory param, int page, int rows) {
        param.setCid(UserUtils.getLoginStaffCompanyId());
        param.setType(KeyFactoryTypeEnum.TRAIN.getCode());
        PageInfo listPageInfo = this.keyFactoryApprovalHistoryService.getKeyFactoryOperatorHistories(param, page, rows);
        return new LayUiResponseResult(listPageInfo);
    }

    @ResponseBody
    @RequestMapping(value={"getCertSatffListData"}, method={RequestMethod.GET})
    public JqGridData<CertificateStaff> getCertSatffListData(JqGridParam param, String keyWord) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        CertificateStaff info = new CertificateStaff();
        info.setCid(cid);
        info.setName(keyWord);
        PageInfo certPage = this.certificateStaffService.getCertficateList(info, param);
        return new JqGridData(certPage, param);
    }

    @ResponseBody
    @RequestMapping(value={"getCertSatffListDataLite"}, method={RequestMethod.GET})
    public JqGridData<CertificateStaffDetail> getCertStaffListDataLite(JqGridParam param, String keyWord, String certId, String status, Boolean chooseCert, Long memberId, Date nowDate) {
        String[] split;
        Long cid = UserUtils.getLoginStaffCompanyId();
        CertificateStaffDetail info = new CertificateStaffDetail();
        if (StringUtils.isNotEmpty((String)status)) {
            List statusList = Arrays.stream(status.split(",")).map(Byte::valueOf).collect(Collectors.toList());
            info.setStatusList(statusList);
        }
        if (StringUtils.isNotEmpty((String)certId) && (split = certId.split(",")).length == 1) {
            info.setCertId(Long.valueOf(certId));
        }
        info.setCid(cid);
        info.setStaffName(keyWord);
        if (chooseCert != null) {
            info.setChooseCert(chooseCert);
        }
        if (memberId != null) {
            info.setMemberId(memberId);
            if (keyWord != null) {
                info.setStaffName(this.memberServcie.getInfoById(memberId).getStaffName());
            }
        }
        PageInfo certPage = this.certificateStaffDetailService.getLitePageDataByParam(info, param, nowDate, null);
        return new JqGridData(certPage, param);
    }

    @Log(title="\u4eba\u5458\u8bc1\u4e66\u65b0\u589e", type=20)
    @RequiresPermissions(value={"certificate.edit"})
    @RequestMapping(value={"/addCerStaff"}, method={RequestMethod.GET})
    public String addCerStaff(ModelMap m, Long id, Long nameId, Boolean isList) {
        Long staffid = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        CertificateStaff data = new CertificateStaff();
        data = id != null ? (CertificateStaff)this.certificateStaffService.getById(id) : this.certificateStaffService.addWithHistory(data, staffid, cid);
        if (nameId != null) {
            CertificateStaff cer = this.certificateStaffService.getByNameId(nameId, cid);
            if (cer != null) {
                data = cer;
            } else {
                data.setNameId(nameId);
                data.setName(CertificateStaffTypeEnum.getNameById((Long)nameId));
            }
        }
        m.put((Object)"data", (Object)data);
        m.put((Object)"isList", (Object)isList);
        return "work/certificate/certificateStaffAdd";
    }

    @Log(title="\u4eba\u5458\u8bc1\u4e66\u65b0\u589e", type=20)
    @RequiresPermissions(value={"certificate.edit"})
    @RequestMapping(value={"/editCerStaff"}, method={RequestMethod.GET})
    public String editCerStaff(ModelMap m, Long id, Long nameId, Boolean isList) {
        Long staffid = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        CertificateStaff data = new CertificateStaff();
        data = id != null ? (CertificateStaff)this.certificateStaffService.getById(id) : this.certificateStaffService.addWithHistory(data, staffid, cid);
        if (nameId != null) {
            CertificateStaff cer = this.certificateStaffService.getByNameId(nameId, cid);
            if (cer != null) {
                data = cer;
            } else {
                data.setNameId(nameId);
                data.setName(CertificateStaffTypeEnum.getNameById((Long)nameId));
            }
        }
        m.put((Object)"data", (Object)data);
        m.put((Object)"isList", (Object)isList);
        return "work/certificate/certificateStaffAdd";
    }

    @RequiresPermissions(value={"certificate.view"})
    @RequestMapping(value={"/viewCerStaff"}, method={RequestMethod.GET})
    public String viewCerStaff(ModelMap m, Long id, Boolean isCount) {
        CertificateStaff data = (CertificateStaff)this.certificateStaffService.getById(id);
        m.put((Object)"data", (Object)data);
        m.put((Object)"isCount", (Object)isCount);
        return "work/certificate/certificateStaffView";
    }

    @RequiresPermissions(value={"certificate.view"})
    @RequestMapping(value={"/viewHseCerStaff"}, method={RequestMethod.GET})
    public String viewHseCerStaff(ModelMap m, Long nameId) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        CertificateStaff data = this.certificateStaffService.getHseTrainCert(cid, nameId);
        m.put((Object)"data", (Object)data);
        return "work/certificate/certificateStaffView";
    }

    @RequiresPermissions(value={"certificate.view"})
    @RequestMapping(value={"getCertStaffsViewList"}, method={RequestMethod.GET})
    public String getCertStaffsViewList(ModelMap m, Long certid, String keyword, Long nameId, Integer staffType) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        CertificateStaffDetail info = new CertificateStaffDetail();
        info.setCid(cid);
        info.setCertId(certid);
        info.setStaffName(keyword);
        info.setStaffType(staffType);
        List list = this.certificateStaffDetailService.getListNoIncludeNoWorkedByParam(info, nameId);
        m.put((Object)"list", (Object)list);
        return "work/certificate/staffPage/staffViewCertContent";
    }

    @ResponseBody
    @RequestMapping(value={"getCertStaffsDetailListData"}, method={RequestMethod.GET})
    public JqGridData<CertificateStaffDetail> getCertStaffsDetailListData(JqGridParam param, Long certid, String keyword, Long nameId, Integer staffType) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        CertificateStaffDetail info = new CertificateStaffDetail();
        info.setCid(cid);
        info.setCertId(certid);
        info.setStaffName(keyword);
        info.setStaffType(staffType);
        PageInfo certPage = this.certificateStaffDetailService.getPageDataByParam(info, nameId, param);
        return new JqGridData(certPage, param);
    }

    @RequiresPermissions(value={"certificate.edit"})
    @Log(title="\u65b0\u589e/\u7f16\u8f91\u4eba\u5458\u8bc1\u4e66", type=21)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"/addCertificateStaff"}, method={RequestMethod.POST})
    public ResponseData<CertificateStaff> addCertificateDevice(HttpServletRequest request, ModelMap m, CertificateStaff record) {
        ResponseData data = new ResponseData();
        Long staffid = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long orgId = UserUtils.getOrgId();
        if (StringUtils.isEmpty((CharSequence)record.getOrgId())) {
            record.setOrgId("" + orgId);
        }
        if (record.getId() != null) {
            CertificateStaff info = (CertificateStaff)this.certificateStaffService.getById(record.getId());
            if (info.getNameId() != null) {
                this.certificateStaffService.updateWithHistory(record, staffid);
                data.setResult((Object)record);
                data.setState(ResponseStateEnum.success);
                data.setContent("\u7f16\u8f91\u6210\u529f\uff01");
            } else {
                Boolean haveName = this.certificateStaffService.haveThisName(record.getNameId(), cid);
                if (haveName.booleanValue()) {
                    data.setResult((Object)record);
                    data.setState(ResponseStateEnum.warning);
                    data.setContent("\u8be5\u8bc1\u4e66\u540d\u79f0\u7684\u4eba\u5458\u8bc1\u4e66\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u8bc1\u4e66\u540d\u79f0\u6216\u53bb\u7f16\u8f91\u8be5\u8bc1\u4e66\uff01");
                } else {
                    this.certificateStaffService.updateWithHistory(record, staffid);
                    data.setResult((Object)record);
                    data.setState(ResponseStateEnum.success);
                    data.setContent("\u65b0\u589e\u6210\u529f\uff01");
                }
            }
        } else {
            Boolean haveName = this.certificateStaffService.haveThisName(record.getNameId(), cid);
            if (haveName.booleanValue()) {
                data.setResult((Object)record);
                data.setState(ResponseStateEnum.warning);
                data.setContent("\u8be5\u8bc1\u4e66\u540d\u79f0\u7684\u4eba\u5458\u8bc1\u4e66\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u8bc1\u4e66\u540d\u79f0\u6216\u53bb\u7f16\u8f91\u8be5\u8bc1\u4e66\uff01");
            } else {
                this.certificateStaffService.addWithHistory(record, staffid, cid);
                data.setResult((Object)record);
                data.setState(ResponseStateEnum.success);
                data.setContent("\u65b0\u589e\u6210\u529f\uff01");
            }
        }
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"/cancelStaffSave"}, method={RequestMethod.POST})
    public ResponseData<CertificateStaff> cancelStaffSave(HttpServletRequest request, ModelMap m, Long Id) {
        ResponseData data = new ResponseData();
        Long staffid = UserUtils.getLoginStaffId();
        CertificateStaff cert = (CertificateStaff)this.certificateStaffService.getById(Id);
        if (cert.getNameId() == null) {
            this.certificateStaffService.delete((Object)cert, staffid);
        }
        return data;
    }

    @RequiresPermissions(value={"certificate.edit"})
    @Log(title="\u5220\u9664\u4eba\u5458\u8bc1\u4e66", type=22)
    @ResponseBody
    @RequestMapping(value={"/delCertStaff"}, method={RequestMethod.DELETE})
    public ResponseData<Integer> delCertDevice(HttpSession session, Long id, ModelMap m) {
        ResponseData data = new ResponseData();
        CertificateStaff info = new CertificateStaff();
        Long staffid = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        info.setId(id);
        try {
            this.certificateStaffService.deleteWithHis(info, staffid, cid);
            data.setContent("\u5220\u9664\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            data.setContent("\u5220\u9664\u5931\u8d25\uff01");
        }
        return data;
    }

    @RequiresPermissions(value={"certificate.edit"})
    @RequestMapping(value={"/addGetCertStaff"}, method={RequestMethod.GET})
    public String addGetCertStaff(ModelMap m, Long certId, Long nameId) {
        m.put((Object)"certId", (Object)certId);
        return "work/certificate/staffPage/certificateStaffDetailAdd";
    }

    @ResponseBody
    @RequestMapping(value={"/getStaff"}, method={RequestMethod.GET})
    public ResponseData<StaffInfo> getStaff(ModelMap m, Long id) {
        ResponseData data = new ResponseData();
        StaffInfo staff = StaffUtil.getStaffDetailById(id);
        data.setResult((Object)staff);
        return data;
    }

    @RequiresPermissions(value={"certificate.edit"})
    @Log(title="\u65b0\u589e\u53d6\u8bc1\u4eba\u5458", type=20)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"/addGetCertStaff"}, method={RequestMethod.POST})
    public ResponseData<CertificateStaffDetail> addCertDeviceDetail(HttpServletRequest request, ModelMap m, CertificateStaffDetail record) {
        ResponseData data = new ResponseData();
        Long staffid = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        List list = record.getStaffs();
        int i = 0;
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (CertificateStaffDetail staff : list) {
                if (staff.getStaffName() == null) continue;
                staff.setDataSource(Byte.valueOf((byte)1));
                staff.setStatus(record.getStatus());
                staff.setCertId(record.getCertId());
                staff.setIssuingAuthority(record.getIssuingAuthority());
                staff.setCollectionDate(record.getCollectionDate());
                staff.setCertCreateDate(record.getCertCreateDate());
                staff.setValidityDate(record.getValidityDate());
                staff.setRepeatData(record.getRepeatData());
                staff.setRepeatNote(record.getRepeatNote());
                staff.setExpireDeal(CertificateExpireDealEnum.edit.getValue());
                String[] fileids = request.getParameterValues("certFiles" + i);
                List<CertificateFiles> fileList = this.getFiles(fileids);
                staff.setFiles(fileList);
                this.certificateStaffDetailService.addWithFile(staff, staffid, cid);
                ++i;
            }
        }
        data.setResult((Object)record);
        data.setContent("\u7f16\u8f91\u6210\u529f\uff01");
        return data;
    }

    private List<CertificateFiles> getFiles(String[] fileids) {
        if (fileids == null || fileids.length == 0 || Arrays.equals(fileids, new String[]{""})) {
            return null;
        }
        ArrayList<CertificateFiles> files = new ArrayList<CertificateFiles>();
        for (String fileid : fileids) {
            CertificateFiles certfile = new CertificateFiles();
            long id = Long.parseLong(fileid);
            SysFileModel file = SysFileUtil.getFileById(id);
            certfile.setFileId(Long.valueOf(id));
            assert (file != null);
            certfile.setFileName(file.getFileName());
            certfile.setFileUrl(file.getOssUrl());
            files.add(certfile);
        }
        return files;
    }

    @RequiresPermissions(value={"certificate.edit"})
    @Log(title="\u5220\u9664\u53d6\u8bc1\u4eba\u5458", type=22)
    @ResponseBody
    @RequestMapping(value={"/delCertStaffDetail"}, method={RequestMethod.DELETE})
    public ResponseData<Integer> delCertStaffDetail(HttpSession session, Long id, ModelMap m) {
        ResponseData data = new ResponseData();
        CertificateStaffDetail info = new CertificateStaffDetail();
        Long staffid = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        info.setId(id);
        try {
            this.certificateStaffDetailService.deleteWithHis(info, staffid, cid);
            data.setContent("\u5220\u9664\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            data.setContent("\u5220\u9664\u5931\u8d25\uff01");
        }
        return data;
    }

    @RequiresPermissions(value={"certificate.view"})
    @RequestMapping(value={"getCertStaffsList"}, method={RequestMethod.GET})
    public String getCertStaffsList(ModelMap m, Long certid, String keyword, Long nameId) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        CertificateStaffDetail info = new CertificateStaffDetail();
        info.setCid(cid);
        info.setCertId(certid);
        info.setStaffName(keyword);
        List list = this.certificateStaffDetailService.getListNoIncludeNoWorkedByParam(info, nameId);
        m.put((Object)"list", (Object)list);
        return "work/certificate/staffPage/staffCertContent";
    }

    @RequiresPermissions(value={"certificate.edit"})
    @RequestMapping(value={"/editStaffCert"}, method={RequestMethod.GET})
    public String editStaffCert(ModelMap m, Long id, Long nameId) {
        CertificateStaffDetail data = this.certificateStaffDetailService.getByIdWithFile(id);
        StaffInfo staff = StaffUtil.getStaffDetailById(data.getStaffId());
        String staffName = this.stafInfoService.getStaffNameIncludeDelStatusAndDepByStaffId(data.getStaffId());
        if (staffName == null || "".equals(staffName)) {
            staffName = data.getStaffName();
        }
        if (staff != null && staff.getStaffBasicInfo() != null) {
            data.setGender(staff.getStaffBasicInfo().getGender());
        }
        m.put((Object)"scName", (Object)staffName);
        m.put((Object)"data", (Object)data);
        if (nameId != null) {
            if (nameId.equals(CertificateStaffTypeEnum.SaftyTrain.getId())) {
                List list = StStaffTypeEnum.getAllValues();
                m.put((Object)"list", (Object)list);
                return "work/certificate/staffPage/simpleStaffEdit1";
            }
            if (nameId.equals(CertificateStaffTypeEnum.OccTrain.getId())) {
                List list = OccHeaStaffTypeEnum.getAllValues();
                m.put((Object)"list", (Object)list);
                return "work/certificate/staffPage/simpleStaffEdit1";
            }
            if (nameId.equals(CertificateStaffTypeEnum.SpeacialEquipOp.getId())) {
                List list = SpecialEquipOperationsTypeEnum.getAllValues();
                List detailList = SpecialEquipOperationsDetailTypeEnum.getListByFcode((Integer)data.getWorkType());
                m.put((Object)"list", (Object)list);
                m.put((Object)"detailList", (Object)detailList);
                return "work/certificate/staffPage/simpleStaffEdit2";
            }
            if (nameId.equals(CertificateStaffTypeEnum.SpeacialOperat.getId())) {
                List list = SpecialOperationsTypeEnum.getAllValues();
                List detailList = SpecialOperationsDetailTypeEnum.getListByFcode((Integer)data.getWorkType());
                m.put((Object)"list", (Object)list);
                m.put((Object)"detailList", (Object)detailList);
                return "work/certificate/staffPage/simpleStaffEdit2";
            }
            return "work/certificate/staffPage/simpleStaffEdit";
        }
        return "work/certificate/staffPage/simpleStaffEdit";
    }

    @RequiresPermissions(value={"certificate.edit"})
    @Log(title="\u65b0\u589e\u53d6\u8bc1\u4eba\u5458", type=20)
    @RequestMapping(value={"/addStaffCertLite"}, method={RequestMethod.GET})
    public String addStaffCertLite(ModelMap m) {
        CertificateStaffDetail data = new CertificateStaffDetail();
        m.put((Object)"data", (Object)data);
        return "work/certificate/staffPage/staffCertEditLite";
    }

    @RequiresPermissions(value={"certificate.edit"})
    @Log(title="\u7f16\u8f91\u53d6\u8bc1\u4eba\u5458", type=21)
    @RequestMapping(value={"/editStaffCertLite"}, method={RequestMethod.GET})
    public String editStaffCertLite(ModelMap m, Long id) {
        CertificateStaffDetail data = new CertificateStaffDetail();
        if (id != null) {
            data = this.certificateStaffDetailService.getByIdWithFile(id);
        }
        m.put((Object)"data", (Object)data);
        return "work/certificate/staffPage/staffCertEditLite";
    }

    @RequiresPermissions(value={"certificate.edit"})
    @Log(title="\u514b\u9686\u53d6\u8bc1\u4eba\u5458", type=21)
    @RequestMapping(value={"/cloneStaffCertLite"}, method={RequestMethod.GET})
    public String cloneStaffCertLite(ModelMap m, Long id) {
        CertificateStaffDetail data = this.certificateStaffDetailService.getByIdWithFile(id);
        if (data != null) {
            data.setId(null);
            data.setStaffId(null);
            data.setStaffName(null);
            data.setFiles(null);
        }
        m.put((Object)"data", (Object)data);
        return "work/certificate/staffPage/staffCertEditLite";
    }

    @RequiresPermissions(value={"certificate.edit"})
    @RequestMapping(value={"/cloneStaffCert"}, method={RequestMethod.GET})
    public String cloneStaffCert(ModelMap m, Long id, Long nameId) {
        CertificateStaffDetail data = this.certificateStaffDetailService.getByIdWithFile(id);
        m.put((Object)"data", (Object)data);
        if (nameId != null) {
            if (nameId.equals(CertificateStaffTypeEnum.SaftyTrain.getId())) {
                List list = StStaffTypeEnum.getAllValues();
                m.put((Object)"list", (Object)HseJsonArray.getInstance().fromObject((Object)list));
                return "work/certificate/staffPage/cloneStaffCert1";
            }
            if (nameId.equals(CertificateStaffTypeEnum.OccTrain.getId())) {
                List list = OccHeaStaffTypeEnum.getAllValues();
                m.put((Object)"list", (Object)HseJsonArray.getInstance().fromObject((Object)list));
                return "work/certificate/staffPage/cloneStaffCert1";
            }
            if (nameId.equals(CertificateStaffTypeEnum.SpeacialEquipOp.getId())) {
                List list = SpecialEquipOperationsTypeEnum.getAllValues();
                List detailList = SpecialEquipOperationsDetailTypeEnum.getListByFcode((Integer)data.getWorkType());
                m.put((Object)"list", (Object)HseJsonArray.getInstance().fromObject((Object)list));
                m.put((Object)"detailList", (Object)detailList);
                return "work/certificate/staffPage/cloneStaffCert2";
            }
            if (nameId.equals(CertificateStaffTypeEnum.SpeacialOperat.getId())) {
                List list = SpecialOperationsTypeEnum.getAllValues();
                List detailList = SpecialOperationsDetailTypeEnum.getListByFcode((Integer)data.getWorkType());
                m.put((Object)"list", (Object)HseJsonArray.getInstance().fromObject((Object)list));
                m.put((Object)"detailList", (Object)detailList);
                return "work/certificate/staffPage/cloneStaffCert2";
            }
            return "work/certificate/staffPage/cloneStaffCert";
        }
        return "work/certificate/staffPage/cloneStaffCert";
    }

    @ResponseBody
    @RequestMapping(value={"getWorkTypeDetailList"}, method={RequestMethod.GET})
    public List<Map<String, Object>> getWorkTypeDetailList(Integer type, Long nameId) {
        if (nameId != null) {
            if (nameId.equals(CertificateStaffTypeEnum.SpeacialEquipOp.getId())) {
                return SpecialEquipOperationsDetailTypeEnum.getListByFcode((Integer)type);
            }
            if (nameId.equals(CertificateStaffTypeEnum.SpeacialOperat.getId())) {
                return SpecialOperationsDetailTypeEnum.getListByFcode((Integer)type);
            }
        }
        return null;
    }

    @RequiresPermissions(value={"certificate.edit"})
    @Log(title="\u7f16\u8f91\u53d6\u8bc1\u4eba\u5458", type=21)
    @ResponseBody
    @RequestMapping(value={"/editStaffCert"}, method={RequestMethod.POST})
    @BigLog(userRole=UserRoleEnum.ENTERPRISE_TYPE, actionType=ActionTypeEnum.WORK_START_TYPE, businessModule=BigLogBusinessModuleEnum.module2, businessIdParamName="keyFactoryId")
    @ApiEncrypt(request=true)
    public ResponseData<CertificateStaffDetail> editCertDeviceDetail(HttpServletRequest request, ModelMap m, @RequestBody CertificateStaffDetail record) {
        ActionTypeEnum actionType;
        Long keyFactoryId;
        ResponseData data = new ResponseData();
        Company currentCompany = UserUtils.getCurrentCompany();
        StaffInfo loginStaff = UserUtils.getLoginStaff();
        assert (loginStaff != null);
        assert (currentCompany != null);
        Long cid = currentCompany.getId();
        record.setExpireDeal(CertificateExpireDealEnum.edit.getValue());
        String[] fileids = request.getParameterValues("certFiles");
        if (fileids == null || fileids.length == 0) {
            fileids = new String[]{record.getCertFiles()};
        }
        List<CertificateFiles> fileList = this.getFiles(fileids);
        record.setFiles(fileList);
        record.setCid(cid);
        if (record.getId() != null) {
            this.certificateStaffDetailService.updateWithFile(record, loginStaff.getId());
            keyFactoryId = this.certificateStaffDetailService.submitApproval(currentCompany, loginStaff, record);
            actionType = ActionTypeEnum.BIZ_LOG_TYPE;
        } else {
            Long id = this.certificateStaffDetailService.addWithFile(record, loginStaff.getId(), cid);
            record.setId(id);
            keyFactoryId = this.certificateStaffDetailService.submitApproval(currentCompany, loginStaff, record);
            actionType = ActionTypeEnum.WORK_START_TYPE;
        }
        this.archiveUpdateService.refreshArchive(cid, "302");
        if (Objects.equals(record.getStatus(), (byte)3)) {
            this.baseController.passKeyFactorAuditIfTrainBase(currentCompany, loginStaff, record.getId());
        }
        data.setResult((Object)record);
        data.setContent("\u7f16\u8f91\u6210\u529f\uff01");
        request.setAttribute("keyFactoryId", (Object)keyFactoryId);
        request.setAttribute("actionType", (Object)actionType.getValue());
        return data;
    }

    @Log(title="\u5230\u671f\u4eba\u5458\u8bc1\u4e66\u5217\u8868", type=2)
    @RequiresPermissions(value={"certificate.view"})
    @RequestMapping(value={"/expireCertStaffList"})
    public String expireCertStaffList(HttpSession session, ModelMap m) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        int expireStaffNum = this.certificateStaffDetailService.getExpireCertficateNum(cid);
        int expireComNum = this.certificateCompanyService.getExpireCertficateNum(cid);
        int expireDevNum = this.certificateDeviceDetailService.getExpireCertficateNum(cid);
        m.put((Object)"expireComNum", (Object)expireComNum);
        m.put((Object)"expireStaffNum", (Object)expireStaffNum);
        m.put((Object)"expireDevNum", (Object)expireDevNum);
        return "work/certificate/expireCertStaffList";
    }

    @ResponseBody
    @RequestMapping(value={"getExpireStafflistData"}, method={RequestMethod.GET})
    public JqGridData<CertificateStaffDetail> getExpireStafflistData(JqGridParam param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        CertificateStaffDetail info = new CertificateStaffDetail();
        info.setCid(cid);
        PageInfo certPage = this.certificateStaffDetailService.getExpireCertficateList(info, param);
        return new JqGridData(certPage, param);
    }

    @RequiresPermissions(value={"certificate.edit"})
    @Log(title="\u5ffd\u7565\u4eba\u5458\u8bc1\u4e66\u5230\u671f\u63d0\u9192", type=21)
    @ResponseBody
    @RequestMapping(value={"/ignoreExpireStaff"}, method={RequestMethod.DELETE})
    public ResponseData<Integer> ignoreExpireStaff(HttpSession session, Long id, ModelMap m) {
        ResponseData data = new ResponseData();
        CertificateStaffDetail info = new CertificateStaffDetail();
        Long staffid = UserUtils.getLoginStaffId();
        info.setId(id);
        info.setExpireDeal(CertificateExpireDealEnum.ignore.getValue());
        try {
            this.certificateStaffDetailService.update((Object)info, staffid);
            data.setContent("\u5ffd\u7565\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            data.setContent("\u5ffd\u7565\u5931\u8d25\uff01");
        }
        return data;
    }

    @RequiresPermissions(value={"certificate.view"})
    @RequestMapping(value={"/editExpireCertStaff"}, method={RequestMethod.GET})
    public String editExpireCertStaff(ModelMap m, Long id, Boolean isedit) {
        CertificateStaffDetail certificateStaffDetail = (CertificateStaffDetail)this.certificateStaffDetailService.getById(id);
        CertificateStaff data = (CertificateStaff)this.certificateStaffService.getById(certificateStaffDetail.getCertId());
        Boolean isExpire = true;
        m.put((Object)"isExpire", (Object)isExpire);
        m.put((Object)"data", (Object)data);
        if (isedit != null && isedit.booleanValue()) {
            return "work/certificate/certificateStaffAdd";
        }
        return "work/certificate/certificateStaffView";
    }

    @RequiresPermissions(value={"certificate.view"})
    @RequestMapping(value={"/countCertStaffList"})
    public String countCertStaffList(HttpSession session, Model m) {
        return "work/certificate/countCertStaffList";
    }

    @RequiresPermissions(value={"certificate.view"})
    @Log(title="\u5bfc\u51fa\u4eba\u5458\u8bc1\u4e66\u6e05\u5355", type=24)
    @RequestMapping(value={"exportCertStaff"})
    public void exportCertComp(HttpServletResponse response) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u4eba\u5458\u8bc1\u4e66\u6e05\u5355" + dateFormat.format(new Date()) + ".zip";
        Long cid = UserUtils.getLoginStaffCompanyId();
        String[] colums = new String[]{"\u5e8f\u53f7|id", "\u8bc1\u4e66\u540d\u79f0|certName", "\u4eba\u5458\u7c7b\u522b/\u4f5c\u4e1a\u79cd\u7c7b|staffTypeName", "\u4eba\u5458\u59d3\u540d|staffName", "\u6027\u522b|sex", "\u5de5\u53f7|workNo", "\u5c97\u4f4d/\u5de5\u79cd|workNames", "\u90e8\u95e8|orgNames", "\u53d1\u8bc1\u673a\u5173|issuingAuthority", "\u8bc1\u4e66\u7f16\u53f7|certNo", "\u521d\u9886\u65e5\u671f|collectionDate", "\u53d6\u8bc1\u65e5\u671f|certCreateDate", "\u6709\u6548\u671f\u81f3|validityDate", "\u590d\u5ba1\u65e5\u671f|repeatData"};
        CertificateStaff info = new CertificateStaff();
        info.setCid(cid);
        List list = this.certificateStaffService.getCertStaffNoIncludeNoWorkedByParam(info);
        HashMap filesMap = new HashMap();
        Long index = 0L;
        for (CertificateStaffDetailVo staff : list) {
            Object workType;
            List files = this.certificateFilesService.getByCerid(staff.getId());
            staff.setFiles(files);
            if (staff.getNameId() != null) {
                if (staff.getNameId().equals(CertificateStaffTypeEnum.SaftyTrain.getId())) {
                    staff.setStaffTypeName(StStaffTypeEnum.getNameByCode((Integer)staff.getStaffType()));
                } else if (staff.getNameId().equals(CertificateStaffTypeEnum.OccTrain.getId())) {
                    staff.setStaffTypeName(OccHeaStaffTypeEnum.getNameByCode((Integer)staff.getStaffType()));
                } else if (staff.getNameId().equals(CertificateStaffTypeEnum.SpeacialOperat.getId())) {
                    workType = SpecialOperationsTypeEnum.getNameByCode((Integer)staff.getWorkType()) + "-" + SpecialOperationsDetailTypeEnum.getNameByCode((Integer)staff.getWorkTypeDetail());
                    staff.setStaffTypeName((String)workType);
                } else if (staff.getNameId().equals(CertificateStaffTypeEnum.SpeacialEquipOp.getId())) {
                    workType = SpecialEquipOperationsTypeEnum.getNameByCode((Integer)staff.getWorkType()) + "-" + SpecialEquipOperationsDetailTypeEnum.getNameByCode((Integer)staff.getWorkTypeDetail());
                    staff.setStaffTypeName((String)workType);
                }
            }
            workType = index;
            index = index + 1L;
            String pathName = staff.getStaffName().replace("(\u5df2\u5220\u9664)", "").replace("/", "-") + staff.getCertName();
            filesMap.put(pathName, new ArrayList());
            for (CertificateFiles file : staff.getFiles()) {
                File file1 = SysFileUtil.getFileForTrainByfid(file.getFileId());
                if (file1 == null) continue;
                ((List)filesMap.get(pathName)).add(file1);
            }
            staff.setId(index);
        }
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("GBK"), "ISO8859_1"));
        response.setContentType("application/octet-stream; charset=GBK");
        ExportExcel listexcel = new ExportExcel();
        File xlsFile = File.createTempFile("temp", ".xls");
        listexcel.simpleExport2("\u4eba\u5458\u8bc1\u4e66\u6e05\u5355", colums, list, (OutputStream)new FileOutputStream(xlsFile));
        File xls = new File(xlsFile.getParent() + File.separator + "\u4eba\u5458\u8bc1\u4e66\u6e05\u5355" + dateFormat.format(new Date()) + ".xls");
        xlsFile.renameTo(xls);
        xls.createNewFile();
        filesMap.put("rootDir", new ArrayList());
        ((List)filesMap.get("rootDir")).add(xls);
        ZipCompressorUtil.getDownZipFile(filesMap, (OutputStream)response.getOutputStream());
        xlsFile.delete();
        xls.delete();
    }

    @RequiresPermissions(value={"certificate.edit"})
    @RequestMapping(value={"/batchEdit"}, method={RequestMethod.GET})
    public String batchEdit(ModelMap m, Long certId, Long nameId) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        CertificateStaffDetail info = new CertificateStaffDetail();
        info.setCid(cid);
        info.setCertId(certId);
        List certlist = this.certificateStaffDetailService.getBatchEditList(info, nameId);
        CertificateStaffDetail record = new CertificateStaffDetail();
        if (certlist != null && certlist.size() > 0) {
            record = (CertificateStaffDetail)certlist.get(0);
            record.setStaffs(certlist);
        }
        m.put((Object)"data", (Object)record);
        if (nameId != null) {
            if (nameId.equals(CertificateStaffTypeEnum.SaftyTrain.getId())) {
                List list = StStaffTypeEnum.getAllValues();
                m.put((Object)"list", (Object)list);
                return "work/certificate/staffPage/batchStaffEdit1";
            }
            if (nameId.equals(CertificateStaffTypeEnum.OccTrain.getId())) {
                List list = OccHeaStaffTypeEnum.getAllValues();
                m.put((Object)"list", (Object)list);
                return "work/certificate/staffPage/batchStaffEdit1";
            }
            if (nameId.equals(CertificateStaffTypeEnum.SpeacialEquipOp.getId())) {
                List list = SpecialEquipOperationsTypeEnum.getAllValues();
                m.put((Object)"list", (Object)list);
                return "work/certificate/staffPage/batchStaffEdit2";
            }
            if (nameId.equals(CertificateStaffTypeEnum.SpeacialOperat.getId())) {
                List list = SpecialOperationsTypeEnum.getAllValues();
                m.put((Object)"list", (Object)list);
                return "work/certificate/staffPage/batchStaffEdit2";
            }
            return "work/certificate/staffPage/batchStaffEdit";
        }
        return "work/certificate/staffPage/batchStaffEdit";
    }

    @RequiresPermissions(value={"certificate.edit"})
    @RequestMapping(value={"/batchEditSelect"}, method={RequestMethod.GET})
    public String batchEditSelect(ModelMap m, Long certId, Long nameId, String detailIds) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        CertificateStaffDetail info = new CertificateStaffDetail();
        info.setCid(cid);
        info.setCertId(certId);
        info.setDetailIds(detailIds + "0");
        List certlist = this.certificateStaffDetailService.getBatchEditList(info, nameId);
        CertificateStaffDetail record = new CertificateStaffDetail();
        if (certlist != null && certlist.size() > 0) {
            record = (CertificateStaffDetail)certlist.get(0);
            record.setStaffs(certlist);
        }
        m.put((Object)"data", (Object)record);
        if (nameId != null) {
            if (nameId.equals(CertificateStaffTypeEnum.SaftyTrain.getId())) {
                List list = StStaffTypeEnum.getAllValues();
                m.put((Object)"list", (Object)list);
                return "work/certificate/staffPage/batchStaffEdit1";
            }
            if (nameId.equals(CertificateStaffTypeEnum.OccTrain.getId())) {
                List list = OccHeaStaffTypeEnum.getAllValues();
                m.put((Object)"list", (Object)list);
                return "work/certificate/staffPage/batchStaffEdit1";
            }
            if (nameId.equals(CertificateStaffTypeEnum.SpeacialEquipOp.getId())) {
                List list = SpecialEquipOperationsTypeEnum.getAllValues();
                m.put((Object)"list", (Object)list);
                return "work/certificate/staffPage/batchStaffEdit2";
            }
            if (nameId.equals(CertificateStaffTypeEnum.SpeacialOperat.getId())) {
                List list = SpecialOperationsTypeEnum.getAllValues();
                m.put((Object)"list", (Object)list);
                return "work/certificate/staffPage/batchStaffEdit2";
            }
            return "work/certificate/staffPage/batchStaffEdit";
        }
        return "work/certificate/staffPage/batchStaffEdit";
    }

    @RequiresPermissions(value={"certificate.edit"})
    @Log(title="\u6279\u91cf\u4fee\u6539\u53d6\u8bc1\u4eba\u5458", type=21)
    @ResponseBody
    @RequestMapping(value={"/batchEditCertStaff"}, method={RequestMethod.POST})
    public ResponseData<CertificateStaffDetail> batchEditCertStaff(HttpServletRequest request, ModelMap m, CertificateStaffDetail record) {
        ResponseData data = new ResponseData();
        Long staffid = UserUtils.getLoginStaffId();
        List list = record.getStaffs();
        int i = 0;
        if (list != null && list.size() > 0) {
            for (CertificateStaffDetail staff : list) {
                if (staff.getStaffName() == null) continue;
                staff.setCertId(record.getCertId());
                staff.setIssuingAuthority(record.getIssuingAuthority());
                staff.setCollectionDate(record.getCollectionDate());
                staff.setCertCreateDate(record.getCertCreateDate());
                staff.setValidityDate(record.getValidityDate());
                staff.setRepeatData(record.getRepeatData());
                staff.setRepeatNote(record.getRepeatNote());
                staff.setExpireDeal(CertificateExpireDealEnum.edit.getValue());
                String[] fileids = request.getParameterValues("certFiles" + i);
                List<CertificateFiles> fileList = this.getFiles(fileids);
                staff.setFiles(fileList);
                this.certificateStaffDetailService.updateWithFile(staff, staffid);
                ++i;
            }
        }
        data.setResult((Object)record);
        data.setContent("\u7f16\u8f91\u6210\u529f\uff01");
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"/getCreateIsEque"}, method={RequestMethod.GET})
    public ResponseData<Boolean> editCertDeviceDetail(HttpServletRequest request, ModelMap m, Long certId) {
        ResponseData data = this.certificateStaffDetailService.isEqualOfCreateTime(certId);
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"getStaffCertByStaffId"}, method={RequestMethod.GET})
    public JqGridData<CertificateStaffDetail> getStaffCertByStaffId(JqGridParam param, CertificateStaffDetail info) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        info.setCid(cid);
        PageInfo certPage = this.certificateStaffDetailService.getStaffCertByStaffId(info, param);
        return new JqGridData(certPage, param);
    }

    @ResponseBody
    @RequestMapping(value={"getCertFilesByCertId"}, method={RequestMethod.GET})
    public List<CertificateFiles> getCertFilesByCertId(Long id) {
        return this.certificateStaffDetailService.getCertFilesByCertId(id);
    }

    @RequiresPermissions(value={"certificate.edit"})
    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"/setTermination"})
    @BigLog(userRole=UserRoleEnum.ENTERPRISE_TYPE, actionType=ActionTypeEnum.WORK_END_TYPE, businessModule=BigLogBusinessModuleEnum.module2, businessIdParamName="keyFactoryId")
    public ResponseData<String> setTermination(ModelMap modelMap, Long id, HttpServletRequest request) {
        ActionTypeEnum actionType;
        ResponseData data = new ResponseData();
        Long loginStaffId = UserUtils.getLoginStaffId();
        Company currentCompany = UserUtils.getCurrentCompany();
        if (id == null) {
            this.logger.info("\u4f01\u4e1a\u8d1f\u8d23\u4eba\u57f9\u8bad\u7ba1\u7406\u9996\u9875--\u8bbe\u7f6e\u7ec8\u6b62\u7684id\u4e3a\u7a7a");
            data.setState(ResponseStateEnum.fail);
            data.setContent("\u8bbe\u7f6e\u7ec8\u6b62\u7684id\u4e3a\u7a7a");
            request.setAttribute("actionType", (Object)ActionTypeEnum.BIZ_LOG_TYPE.getValue());
            return data;
        }
        CertificateStaffDetail csd = new CertificateStaffDetail();
        csd.setId(id);
        Pair msgKeyFactoryIdPair = this.certificateStaffDetailService.setTermination(csd, loginStaffId, currentCompany);
        String msg = (String)msgKeyFactoryIdPair.getKey();
        Long keyFactoryId = (Long)msgKeyFactoryIdPair.getValue();
        if ("\u6210\u529f".equals(msg)) {
            data.setContent("\u8bbe\u7f6e\u4e3a\u7ec8\u6b62\u72b6\u6001\u6210\u529f");
            actionType = ActionTypeEnum.WORK_END_TYPE;
        } else {
            data.setState(ResponseStateEnum.fail);
            data.setContent("\u8bbe\u7f6e\u4e3a\u7ec8\u6b62\u72b6\u6001\u5931\u8d25,\u539f\u56e0\uff1a" + msg);
            actionType = ActionTypeEnum.BIZ_LOG_TYPE;
        }
        request.setAttribute("keyFactoryId", (Object)keyFactoryId);
        request.setAttribute("actionType", (Object)actionType.getValue());
        return data;
    }
}

