/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.certificate;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.health.entity.work.certificate.CertificateDevice;
import cn.smarthse.modules.health.entity.work.certificate.CertificateDeviceDetail;
import cn.smarthse.modules.health.entity.work.certificate.CertificateFiles;
import cn.smarthse.modules.health.enums.certificate.CertificateExpireDealEnum;
import cn.smarthse.modules.health.service.work.certificate.ICertificateCompanyService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateDeviceDetailService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateDeviceService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateStaffDetailService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.SysFileUtil;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/certificate"})
public class CertificateDeviceController
extends ControllerSupport {
    @DubboReference
    private ICertificateDeviceService certificateDeviceService;
    @DubboReference
    private ICertificateDeviceDetailService certificateDeviceDetailService;
    @DubboReference
    private ICertificateCompanyService certificateCompanyService;
    @DubboReference
    private ICertificateStaffDetailService certificateStaffDetailService;

    @Log(title="\u8bbe\u5907\u8bc1\u4e66\u6e05\u5355", type=2)
    @RequiresPermissions(value={"certificate.view"})
    @RequestMapping(value={"/certDeviceList"})
    public String certificaate_index(HttpSession session, Model m) {
        return "work/certificate/certificateDeviceList";
    }

    @ResponseBody
    @RequestMapping(value={"getDeviceListData"}, method={RequestMethod.GET})
    public JqGridData<CertificateDevice> getDeviceListData(JqGridParam param, String deviceName) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        CertificateDevice info = new CertificateDevice();
        info.setCid(cid);
        info.setDeviceName(deviceName);
        UserUtils.startWebDataScope();
        PageInfo certPage = this.certificateDeviceService.getCertficateList(info, param);
        JqGridData data = new JqGridData(certPage, param);
        return data;
    }

    @RequiresPermissions(value={"certificate.edit"})
    @RequestMapping(value={"/addCerDevice"}, method={RequestMethod.GET})
    public String addCerDevice(ModelMap m, Long id, Boolean isList) {
        Long staffid = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        CertificateDevice certificateDevice = new CertificateDevice();
        certificateDevice = id != null ? (CertificateDevice)this.certificateDeviceService.getById(id) : this.certificateDeviceService.addWithHistory(certificateDevice, staffid, cid);
        m.put((Object)"isList", (Object)isList);
        m.put((Object)"data", (Object)certificateDevice);
        return "work/certificate/certificateDeviceAdd";
    }

    @RequiresPermissions(value={"certificate.edit"})
    @RequestMapping(value={"/cloneCerDevice"}, method={RequestMethod.GET})
    public String cloneCerDevice(ModelMap m, Long id, Boolean isList) {
        Long staffid = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        CertificateDevice certificateDevice = new CertificateDevice();
        certificateDevice = this.certificateDeviceService.addWithHistory(certificateDevice, staffid, cid);
        CertificateDevice oldCert = (CertificateDevice)this.certificateDeviceService.getById(id);
        certificateDevice.setStorageLocation(oldCert.getStorageLocation());
        List list = this.certificateDeviceDetailService.getCertListByCertId(id);
        if (list != null) {
            for (CertificateDeviceDetail info : list) {
                info.setCertId(certificateDevice.getId());
                info.setId(null);
                info.setCreateDate(null);
                info.setUpdateBy(null);
                info.setUpdateDate(null);
                info.setCreateBy(null);
                this.certificateDeviceDetailService.addCertDeviceDetail(info, staffid, cid);
            }
        }
        m.put((Object)"isList", (Object)isList);
        m.put((Object)"data", (Object)certificateDevice);
        return "work/certificate/certificateDeviceAdd";
    }

    @RequiresPermissions(value={"certificate.view"})
    @RequestMapping(value={"getCertDevicesList"}, method={RequestMethod.GET})
    public String getCertDevicesList(ModelMap m, Long certid) {
        List list = this.certificateDeviceDetailService.getCertListByCertId(certid);
        m.put((Object)"list", (Object)list);
        return "work/certificate/deviceCertContent";
    }

    @RequiresPermissions(value={"certificate.view"})
    @RequestMapping(value={"/viewCerDevice"}, method={RequestMethod.GET})
    public String viewCerDevice(ModelMap m, Long id, Boolean isCount) {
        CertificateDevice certificateDevice = new CertificateDevice();
        if (id != null) {
            certificateDevice = (CertificateDevice)this.certificateDeviceService.getById(id);
        }
        List list = this.certificateDeviceDetailService.getCertListByCertId(certificateDevice.getId());
        m.put((Object)"isCount", (Object)isCount);
        m.put((Object)"list", (Object)list);
        m.put((Object)"data", (Object)certificateDevice);
        return "work/certificate/certificateDeviceView";
    }

    @ResponseBody
    @RequestMapping(value={"/cancelDeviceSave"}, method={RequestMethod.POST})
    public ResponseData<CertificateDevice> cancelDeviceSave(HttpServletRequest request, ModelMap m, Long Id) {
        ResponseData data = new ResponseData();
        Long staffid = UserUtils.getLoginStaffId();
        CertificateDevice certificateDevice = (CertificateDevice)this.certificateDeviceService.getById(Id);
        if (certificateDevice.getDeviceId() == null) {
            this.certificateDeviceService.delete((Object)certificateDevice, staffid);
            this.certificateDeviceDetailService.delByCertId(certificateDevice.getId(), staffid);
        }
        return data;
    }

    @RequiresPermissions(value={"certificate.edit"})
    @Log(title="\u65b0\u589e/\u7f16\u8f91\u8bbe\u5907\u8bc1\u4e66", type=21)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"/addCertificateDevice"}, method={RequestMethod.POST})
    public ResponseData<CertificateDevice> addCertificateDevice(HttpServletRequest request, ModelMap m, CertificateDevice record) {
        Boolean haveName;
        ResponseData data = new ResponseData();
        Long staffid = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long orgId = UserUtils.getOrgId();
        if (StringUtils.isEmpty((CharSequence)record.getOrgId())) {
            record.setOrgId("" + orgId);
        }
        if ((haveName = this.certificateDeviceService.haveThisDevice(record.getId(), record.getDeviceId(), cid)).booleanValue()) {
            data.setResult((Object)record);
            data.setState(ResponseStateEnum.warning);
            data.setContent("\u8be5\u8bbe\u5907\u8bc1\u4e66\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u8bbe\u5907\u6216\u53bb\u7f16\u8f91\u8be5\u8bbe\u5907\u8bc1\u4e66\uff01");
        } else {
            if (record.getId() != null) {
                this.certificateDeviceService.updateWithHistory(record, staffid);
            } else {
                this.certificateDeviceService.addWithHistory(record, staffid, cid);
            }
            data.setResult((Object)record);
            data.setContent("\u7f16\u8f91\u6210\u529f\uff01");
        }
        return data;
    }

    @RequiresPermissions(value={"certificate.edit"})
    @Log(title="\u5220\u9664\u8bbe\u5907\u8bc1\u4e66", type=22)
    @ResponseBody
    @RequestMapping(value={"/delCertDevice"}, method={RequestMethod.DELETE})
    public ResponseData<Integer> delCertDevice(HttpSession session, Long id, ModelMap m) {
        ResponseData data = new ResponseData();
        CertificateDevice info = new CertificateDevice();
        Long staffid = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        info.setId(id);
        info.setIsValid(Boolean.valueOf(false));
        try {
            this.certificateDeviceService.delWithHis(info, staffid, cid);
            data.setContent("\u5220\u9664\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            data.setContent("\u5220\u9664\u5931\u8d25\uff01");
        }
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"getDeviceListById"}, method={RequestMethod.GET})
    public List<CertificateDeviceDetail> getDeviceListById(Long id) {
        List list = this.certificateDeviceDetailService.getCertListByCertId(id);
        return list;
    }

    @RequiresPermissions(value={"certificate.edit"})
    @RequestMapping(value={"addDetailCert"}, method={RequestMethod.GET})
    public String addDetailCert(ModelMap m, Long deviceId, Long id) {
        CertificateDeviceDetail cerDevice = new CertificateDeviceDetail();
        if (id != null) {
            cerDevice = this.certificateDeviceDetailService.getByIdWithAll(id);
            deviceId = cerDevice.getCertId();
        }
        m.put((Object)"data", (Object)cerDevice);
        m.put((Object)"deviceId", (Object)deviceId);
        return "work/certificate/certificateDeviceDetailAdd";
    }

    @RequiresPermissions(value={"certificate.edit"})
    @Log(title="\u65b0\u589e\u8bbe\u5907\u8bc1\u4e66", type=20)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"/addCertDeviceDetail"}, method={RequestMethod.POST})
    public ResponseData<CertificateDeviceDetail> addCertDeviceDetail(HttpServletRequest request, ModelMap m, CertificateDeviceDetail record) {
        ResponseData data = new ResponseData();
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        String[] fileids = request.getParameterValues("certFiles");
        List<CertificateFiles> fileList = this.getFiles(fileids);
        record.setFiles(fileList);
        record.setExpireDeal(CertificateExpireDealEnum.edit.getValue());
        this.certificateDeviceDetailService.addCertDeviceDetail(record, staffid, cid);
        data.setResult((Object)record);
        data.setContent("\u6dfb\u52a0\u6210\u529f\uff01");
        data.setState(ResponseStateEnum.success);
        return data;
    }

    @RequiresPermissions(value={"certificate.edit"})
    @Log(title="\u7f16\u8f91\u8bbe\u5907\u8bc1\u4e66", type=21)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"/editCertDeviceDetail"}, method={RequestMethod.POST})
    public ResponseData<CertificateDeviceDetail> editCertDeviceDetail(HttpServletRequest request, ModelMap m, CertificateDeviceDetail record) {
        ResponseData data = new ResponseData();
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        String[] fileids = request.getParameterValues("certFiles");
        List<CertificateFiles> fileList = this.getFiles(fileids);
        record.setFiles(fileList);
        record.setExpireDeal(CertificateExpireDealEnum.edit.getValue());
        this.certificateDeviceDetailService.updateCertDeviceDetail(record, staffid, cid);
        data.setResult((Object)record);
        data.setContent("\u7f16\u8f91\u6210\u529f");
        return data;
    }

    @RequiresPermissions(value={"certificate.edit"})
    @Log(title="\u5220\u9664\u8bbe\u5907\u8bc1\u4e66", type=22)
    @ResponseBody
    @RequestMapping(value={"/delCertDeviceDetail"}, method={RequestMethod.DELETE})
    public ResponseData<Integer> delCertDeviceDetail(HttpSession session, Long id, ModelMap m) {
        ResponseData data = new ResponseData();
        CertificateDeviceDetail info = new CertificateDeviceDetail();
        Long staffid = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        info.setId(id);
        info.setIsValid(Boolean.valueOf(false));
        try {
            this.certificateDeviceDetailService.delWithHis(info, staffid, cid);
            data.setContent("\u5220\u9664\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            data.setContent("\u5220\u9664\u5931\u8d25\uff01");
        }
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"/haveThisDeviceCert"}, method={RequestMethod.GET})
    public ResponseData<Boolean> haveThisDeviceCert(HttpSession session, Long deviceId, ModelMap m) {
        ResponseData data = new ResponseData();
        Long cid = UserUtils.getLoginStaffCompanyId();
        Boolean haveName = this.certificateDeviceService.haveThisDevice(null, deviceId, cid);
        if (haveName.booleanValue()) {
            data.setResult((Object)false);
            data.setState(ResponseStateEnum.warning);
            data.setContent("\u8be5\u9879\u8bbe\u5907\u5df2\u5b58\u5728\u8be5\u540d\u79f0\u7684\u8bc1\u4e66\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u8bc1\u4e66\u540d\u79f0\uff01");
        } else {
            data.setResult((Object)true);
            data.setContent("\u53ef\u4ee5\uff01");
            data.setState(ResponseStateEnum.success);
        }
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"/haveThisNameAdd"}, method={RequestMethod.GET})
    public ResponseData<Boolean> haveThisNameAdd(HttpSession session, Long nameId, Long certId, ModelMap m) {
        ResponseData data = new ResponseData();
        Long cid = UserUtils.getLoginStaffCompanyId();
        Boolean haveName = this.certificateDeviceDetailService.haveThisName(nameId, cid, certId);
        if (haveName.booleanValue()) {
            data.setResult((Object)false);
            data.setState(ResponseStateEnum.warning);
            data.setContent("\u8be5\u9879\u8bbe\u5907\u5df2\u5b58\u5728\u8be5\u540d\u79f0\u7684\u8bc1\u4e66\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u8bc1\u4e66\u540d\u79f0\uff01");
        } else {
            data.setResult((Object)true);
            data.setContent("\u53ef\u4ee5\uff01");
            data.setState(ResponseStateEnum.success);
        }
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"/haveThisNameEdit"}, method={RequestMethod.GET})
    public ResponseData<Boolean> haveThisNameEdit(HttpSession session, Long nameId, Long certId, Long deviceId, ModelMap m) {
        ResponseData data = new ResponseData();
        Long cid = UserUtils.getLoginStaffCompanyId();
        CertificateDeviceDetail info = (CertificateDeviceDetail)this.certificateDeviceDetailService.getById(certId);
        if (info.getNameId().equals(nameId)) {
            data.setResult((Object)true);
            data.setContent("\u53ef\u4ee5\u6dfb\u52a0\uff01");
            data.setState(ResponseStateEnum.success);
        } else {
            Boolean haveName = this.certificateDeviceDetailService.haveThisName(nameId, cid, deviceId);
            if (haveName.booleanValue()) {
                data.setResult((Object)false);
                data.setState(ResponseStateEnum.warning);
                data.setContent("\u8be5\u9879\u8bbe\u5907\u5df2\u5b58\u5728\u8be5\u540d\u79f0\u7684\u8bc1\u4e66\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u8bc1\u4e66\u540d\u79f0\uff01");
            } else {
                data.setResult((Object)true);
                data.setContent("\u53ef\u4ee5\u6dfb\u52a0\uff01");
                data.setState(ResponseStateEnum.success);
            }
        }
        return data;
    }

    private List<CertificateFiles> getFiles(String[] fileids) {
        if (fileids == null || fileids.length == 0) {
            return null;
        }
        ArrayList<CertificateFiles> files = new ArrayList<CertificateFiles>();
        for (int a = 0; a < fileids.length; ++a) {
            CertificateFiles certfile = new CertificateFiles();
            long id = Long.parseLong(fileids[a]);
            SysFileModel file = SysFileUtil.getFileById(id);
            certfile.setFileId(Long.valueOf(id));
            certfile.setFileName(file.getFileName());
            certfile.setFileUrl(file.getOssUrl());
            files.add(certfile);
        }
        return files;
    }

    @Log(title="\u5230\u671f\u8bbe\u5907\u8bc1\u4e66\u5217\u8868", type=2)
    @RequiresPermissions(value={"certificate.view"})
    @RequestMapping(value={"/expireCertDeviceList"})
    public String expireCertDeviceList(HttpSession session, ModelMap m) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        int expireComNum = this.certificateCompanyService.getExpireCertficateNum(cid);
        int expireStaffNum = this.certificateStaffDetailService.getExpireCertficateNum(cid);
        int expireDevNum = this.certificateDeviceDetailService.getExpireCertficateNum(cid);
        m.put((Object)"expireComNum", (Object)expireComNum);
        m.put((Object)"expireStaffNum", (Object)expireStaffNum);
        m.put((Object)"expireDevNum", (Object)expireDevNum);
        return "work/certificate/expireCertDeviceList";
    }

    @ResponseBody
    @RequestMapping(value={"getExpireDevicelistData"}, method={RequestMethod.GET})
    public JqGridData<CertificateDeviceDetail> getExpireDevicelistData(JqGridParam param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        CertificateDeviceDetail info = new CertificateDeviceDetail();
        info.setCid(cid);
        PageInfo certPage = this.certificateDeviceDetailService.getExpireCertficateList(info, param);
        JqGridData data = new JqGridData(certPage, param);
        return data;
    }

    @RequiresPermissions(value={"certificate.edit"})
    @Log(title="\u5ffd\u7565\u8bbe\u5907\u8bc1\u4e66\u5230\u671f\u63d0\u9192", type=21)
    @ResponseBody
    @RequestMapping(value={"/ignoreExpireDevice"}, method={RequestMethod.DELETE})
    public ResponseData<Integer> ignoreExpireDevice(HttpSession session, Long id, ModelMap m) {
        ResponseData data = new ResponseData();
        CertificateDeviceDetail info = new CertificateDeviceDetail();
        Long staffid = UserUtils.getLoginStaffId();
        info.setId(id);
        info.setExpireDeal(CertificateExpireDealEnum.ignore.getValue());
        try {
            this.certificateDeviceDetailService.update((Object)info, staffid);
            data.setContent("\u5ffd\u7565\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            data.setContent("\u5220\u9664\u5931\u8d25\uff01");
        }
        return data;
    }

    @RequiresPermissions(value={"certificate.view"})
    @RequestMapping(value={"/editExpireCert"}, method={RequestMethod.GET})
    public String editExpireCert(ModelMap m, Long id, Boolean isedit) {
        CertificateDeviceDetail certificateDeviceDetail = (CertificateDeviceDetail)this.certificateDeviceDetailService.getById(id);
        CertificateDevice certificateDevice = (CertificateDevice)this.certificateDeviceService.getById(certificateDeviceDetail.getCertId());
        List list = this.certificateDeviceDetailService.getCertListByCertId(certificateDevice.getId());
        Boolean isExpire = true;
        m.put((Object)"list", (Object)list);
        m.put((Object)"data", (Object)certificateDevice);
        m.put((Object)"isExpire", (Object)isExpire);
        if (isedit != null && isedit.booleanValue()) {
            return "work/certificate/certificateDeviceAdd";
        }
        return "work/certificate/certificateDeviceView";
    }

    @RequiresPermissions(value={"certificate.view"})
    @RequestMapping(value={"/countCertDeviceList"})
    public String countCertDeviceList(HttpSession session, Model m) {
        return "work/certificate/countCertDeviceList";
    }

    @RequiresPermissions(value={"certificate.view"})
    @Log(title="\u5bfc\u51fa\u8bbe\u5907\u8bc1\u4e66\u6e05\u5355", type=24)
    @RequestMapping(value={"exportCertDevice"})
    public void exportCertComp(HttpServletResponse response) throws Exception {
        this.logger.info("ajax-\u3010\u8bbe\u5907\u8bc1\u4e66\u6e05\u5355\u3011-\u5bfc\u51faExcel");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u8bbe\u5907\u8bc1\u4e66\u6e05\u5355" + dateFormat.format(new Date()) + ".xls";
        Long cid = UserUtils.getLoginStaffCompanyId();
        String[] colums = new String[]{"\u5e8f\u53f7|serialNum", "\u8bbe\u5907\u540d\u79f0|deviceName", "\u8bbe\u5907\u7c7b\u522b|deviceType", "\u8bbe\u5907\u578b\u53f7|deviceModel", "\u8bbe\u5907\u8bc1\u4e66|certStr"};
        List list = this.certificateDeviceService.getExportListByCid(cid);
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("GBK"), "ISO8859_1"));
        response.setContentType("application/octet-stream; charset=GBK");
        ExportExcel listexcel = new ExportExcel();
        listexcel.simpleExport3("\u8bbe\u5907\u8bc1\u4e66\u6e05\u5355", colums, list, (OutputStream)response.getOutputStream());
    }
}

