/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.certificate;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.jqgrid.ParamSeachFieldVO;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.modules.health.entity.base.device.DeviceListView;
import cn.smarthse.modules.health.entity.base.device.DeviceQueryVo;
import cn.smarthse.modules.health.entity.work.certificate.CertificateImportVo;
import cn.smarthse.modules.health.entity.work.certificate.CertificateName;
import cn.smarthse.modules.health.enums.staff.StaffInfoImportStateEnum;
import cn.smarthse.modules.health.service.base.device.IDeviceListViewService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateDeviceService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateNameService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateStaffDetailService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.SysFileUtil;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/certificate"})
public class CertificateController
extends ControllerSupport {
    @DubboReference
    private ICertificateNameService certificateNameService;
    @DubboReference
    private IDeviceListViewService deviceListViewService;
    @DubboReference
    private ICertificateDeviceService certificateDeviceService;
    @DubboReference
    private ICertificateStaffDetailService certificateStaffDetailService;

    @RequestMapping(value={"selectName"}, method={RequestMethod.GET})
    public String infoTypes(HttpSession session, ModelMap m, String nameType, Long certId) {
        m.put((Object)"nameType", (Object)nameType);
        m.put((Object)"certId", (Object)certId);
        return "work/certificate/certNameSelect";
    }

    @RequestMapping(value={"getSelectNameList"}, method={RequestMethod.GET})
    public String getSelectNameList(HttpSession session, ModelMap m, CertificateName info) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        info.setCid(cid);
        List list = this.certificateNameService.getListByType(info);
        m.put((Object)"query", (Object)info);
        m.put((Object)"list", (Object)list);
        return "work/certificate/certNameSelectList";
    }

    @RequiresPermissions(value={"certificate.view"})
    @RequestMapping(value={"/nameSet"}, method={RequestMethod.GET})
    public String nameSet(CertificateName name, HttpSession session, ModelMap m) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        name.setCid(cid);
        m.put((Object)"query", (Object)name);
        return "work/certificate/nameSet";
    }

    @ResponseBody
    @RequestMapping(value={"getCertNameByType"}, method={RequestMethod.GET})
    public JqGridData<CertificateName> getCertNameByType(JqGridParam param, CertificateName info) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        info.setCid(cid);
        PageInfo certPage = this.certificateNameService.getCertNameList(info, param);
        JqGridData data = new JqGridData(certPage, param);
        return data;
    }

    @RequestMapping(value={"/getCertName"}, method={RequestMethod.GET})
    public String getCertName(HttpSession session, ModelMap m, CertificateName info) {
        if (info != null && info.getId() != null) {
            info = (CertificateName)this.certificateNameService.getById(info.getId());
        }
        m.put((Object)"data", (Object)info);
        return "work/certificate/certNameInfo";
    }

    @RequiresPermissions(value={"certificate.edit"})
    @Log(title="\u65b0\u589e/\u7f16\u8f91\u8bc1\u4e66\u540d\u79f0", type=20)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"/addCertName"}, method={RequestMethod.POST})
    public ResponseData<Integer> addType(CertificateName info, ModelMap m) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData data = new ResponseData();
        Boolean haveName = this.certificateNameService.haveThisName(info.getName(), cid, info.getNameType());
        if (haveName.booleanValue()) {
            data.setState(ResponseStateEnum.warning);
            data.setContent("\u8bc1\u4e66\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        } else {
            if (info != null && info.getId() != null) {
                this.certificateNameService.updateWithHistory(info, staffid);
            } else {
                info = this.certificateNameService.addWithHistory(info, staffid, cid);
            }
            data.setContent("\u64cd\u4f5c\u6210\u529f\uff01");
        }
        return data;
    }

    @RequiresPermissions(value={"certificate.edit"})
    @Log(title="\u5220\u9664\u8bc1\u4e66\u540d\u79f0", type=22)
    @ResponseBody
    @RequestMapping(value={"/delCertName"}, method={RequestMethod.DELETE})
    public ResponseData<Integer> delCertName(HttpSession session, Long id, ModelMap m) {
        ResponseData data = new ResponseData();
        CertificateName info = new CertificateName();
        Long staffid = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        info.setId(id);
        info.setIsValid(Boolean.valueOf(false));
        try {
            this.certificateNameService.delWithHis(info, staffid, cid);
            data.setContent("\u5220\u9664\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            data.setContent("\u5220\u9664\u5931\u8d25\uff01");
        }
        return data;
    }

    @RequiresPermissions(value={"certificate.view"})
    @RequestMapping(value={"/goCertNamePage"}, method={RequestMethod.GET})
    public String goCertNamePage(Byte nameType, HttpSession session, ModelMap m) {
        m.put((Object)"nameType", (Object)nameType);
        return "work/certificate/nameSetPage";
    }

    @RequestMapping(value={"/selectDevice"})
    public String selectOneDevice() {
        return "work/certificate/selectOneDevice";
    }

    @ResponseBody
    @RequestMapping(value={"deviceListData"})
    public JqGridData<DeviceListView> listData(HttpSession session, JqGridParam param, DeviceQueryVo query) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        this.setQueryInfo(param, query);
        param.setCid(cid);
        PageInfo page = this.deviceListViewService.getDeviceInfoItemList(param);
        List list = page.getList();
        if (list != null) {
            for (DeviceListView de : list) {
                Boolean haveName = this.certificateDeviceService.haveThisDevice(null, de.getId(), cid);
                if (!haveName.booleanValue()) continue;
                de.setIsValid(Boolean.valueOf(false));
            }
        }
        JqGridData data = new JqGridData(page, param);
        return data;
    }

    private void setQueryInfo(JqGridParam param, DeviceQueryVo query) {
        Boolean isDefault;
        if (query.getOnlyCommonly() != null && query.getOnlyCommonly().booleanValue()) {
            ParamSeachFieldVO e = new ParamSeachFieldVO();
            e.setSearchField("onlyCommonly");
            e.setSearchValue("1");
            param.getPostDatas().add(e);
        }
        if ((isDefault = query.getIsDefault()) != null && !isDefault.booleanValue()) {
            return;
        }
        if (query.getDefaultTypePid() != null) {
            ParamSeachFieldVO e = new ParamSeachFieldVO();
            e.setSearchField("typePid");
            e.setSearchValue(String.valueOf(query.getDefaultTypePid()));
            param.getPostDatas().add(e);
        }
    }

    @Log(title="\u4eba\u5458\u8bc1\u4e66\u6e05\u5355", type=2)
    @RequestMapping(value={"/goToCertImport"})
    public String goToCertImport(HttpSession session, Model m) {
        return "work/certificate/certificateStaffImportPage";
    }

    @RequestMapping(value={"getImportCertPage"})
    public String getImportStaffPage(ModelMap m) {
        return "work/certificate/importCertPage";
    }

    @RequestMapping(value={"/importCertInfo"})
    public String importWorkInfo(Long fileId, HttpServletResponse response, HttpServletRequest request, ModelMap m) throws Exception {
        String importResult;
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        String ossfile = SysFileUtil.getContextPathFileUrlByfid(fileId);
        Boolean haveError = false;
        Boolean isImport = false;
        List list = this.certificateStaffDetailService.getCertInfoFromExcel(ossfile);
        if (list == null || list.size() < 1) {
            m.put((Object)"noData", (Object)true);
            return "work/certificate/importCertInfo";
        }
        ArrayList<CertificateImportVo> errorList = new ArrayList<CertificateImportVo>();
        for (CertificateImportVo vo : list) {
            if (vo.getDataState().byteValue() != StaffInfoImportStateEnum.error.getValue()) continue;
            errorList.add(vo);
        }
        try {
            int importNum = this.certificateStaffDetailService.importCertInfo(list);
            isImport = true;
            importResult = "\u5bfc\u5165\u6210\u529f\uff01\u5bfc\u5165\u8bc1\u4e66\u6570\u636e" + importNum + "\u6761\u3002";
            m.put((Object)"importResult", (Object)importResult);
        }
        catch (Exception e) {
            isImport = true;
            importResult = "\u5bfc\u5165\u5931\u8d25" + String.valueOf(e);
            m.put((Object)"importResult", (Object)importResult);
        }
        if (errorList != null && errorList.size() > 0) {
            haveError = true;
            m.put((Object)"haveError", (Object)haveError);
        }
        m.put((Object)"isImport", (Object)isImport);
        return "work/certificate/importCertInfo";
    }
}

