/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.certificate;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.health.entity.work.certificate.CertificateCompany;
import cn.smarthse.modules.health.entity.work.certificate.CertificateFiles;
import cn.smarthse.modules.health.enums.certificate.CertificateExpireDealEnum;
import cn.smarthse.modules.health.service.work.certificate.ICertificateCompanyService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateDeviceDetailService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateFilesService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateStaffDetailService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.SysFileUtil;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/certificate"})
public class CertificateCompanyController
extends ControllerSupport {
    @DubboReference
    private ICertificateCompanyService certificateCompanyService;
    @DubboReference
    private ICertificateStaffDetailService certificateStaffDetailService;
    @DubboReference
    private ICertificateDeviceDetailService certificateDeviceDetailService;
    @DubboReference
    ICertificateFilesService certificateFilesService;

    @Log(title="\u4f01\u4e1a\u8bc1\u4e66\u5217\u8868", type=2)
    @RequiresPermissions(value={"certificate.view"})
    @RequestMapping(value={"/certCompList"})
    public String certificaate_index(HttpSession session, Model m) {
        return "work/certificate/certificateCompanyList";
    }

    @ResponseBody
    @RequestMapping(value={"getComlistData"}, method={RequestMethod.GET})
    public JqGridData<CertificateCompany> getComlistData(JqGridParam param, String name) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        CertificateCompany info = new CertificateCompany();
        info.setCid(cid);
        info.setName(name);
        UserUtils.startWebDataScope();
        PageInfo certPage = this.certificateCompanyService.getCertficateList(info, param);
        if (certPage != null && CollectionUtils.isNotEmpty((Collection)certPage.getList())) {
            List list = certPage.getList();
            for (CertificateCompany cer : list) {
                List files = this.certificateFilesService.getByCerid(cer.getId());
                Object filename = null;
                String fileStr = null;
                if (files == null || files.size() == 0) continue;
                cer.setFiles(files);
                for (CertificateFiles file : files) {
                    String url = this.ossClientBean.getUrl(file.getFileUrl());
                    String str = "<a href='" + url + "'  target='_blank'>" + file.getFileName() + "</a>";
                    if (filename == null) {
                        filename = file.getFileName();
                        fileStr = str;
                        continue;
                    }
                    filename = (String)filename + "," + file.getFileName();
                    fileStr = fileStr + "," + str;
                }
                cer.setFileStr(fileStr);
                cer.setFileNames(filename);
            }
        }
        JqGridData data = new JqGridData(certPage, param);
        return data;
    }

    @RequiresPermissions(value={"certificate.edit"})
    @RequestMapping(value={"/addCerComp"}, method={RequestMethod.GET})
    public String addCerComp(ModelMap m, Long id, Boolean isList, Boolean isExpire) {
        CertificateCompany certificateCompany = new CertificateCompany();
        if (id != null) {
            certificateCompany = this.certificateCompanyService.getByIdWithFile(id);
        }
        m.put((Object)"isExpire", (Object)isExpire);
        m.put((Object)"isList", (Object)isList);
        m.put((Object)"data", (Object)certificateCompany);
        return "work/certificate/certificateCompanyAdd";
    }

    @RequiresPermissions(value={"certificate.edit"})
    @Log(title="\u65b0\u589e/\u7f16\u8f91\u4f01\u4e1a\u8bc1\u4e66", type=21)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"/addCertificateCompany"}, method={RequestMethod.POST})
    public ResponseData<CertificateCompany> addCertificateCompany(HttpServletRequest request, ModelMap m, CertificateCompany record) {
        ResponseData data = new ResponseData();
        Long staffid = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        String[] fileids = request.getParameterValues("certFiles");
        Long orgId = UserUtils.getOrgId();
        if (record.getId() != null && StringUtils.isEmpty((CharSequence)record.getOrgId())) {
            record.setOrgId("" + orgId);
        }
        List<CertificateFiles> fileList = this.getFiles(fileids);
        record.setFiles(fileList);
        record.setExpireDeal(CertificateExpireDealEnum.edit.getValue());
        if (record.getId() != null) {
            this.certificateCompanyService.updateCertComp(record, staffid);
            data.setResult((Object)record);
            data.setState(ResponseStateEnum.success);
            data.setContent("\u7f16\u8f91\u6210\u529f\uff01");
        } else {
            Boolean haveName = this.certificateCompanyService.haveThisName(record.getNameId(), cid);
            if (haveName.booleanValue()) {
                data.setResult((Object)record);
                data.setState(ResponseStateEnum.warning);
                data.setContent("\u8be5\u8bc1\u4e66\u540d\u79f0\u7684\u8bc1\u4e66\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u8bc1\u4e66\u540d\u79f0\u6216\u8005\u53bb\u7f16\u8f91\u8be5\u8bc1\u4e66\uff01");
            } else {
                this.certificateCompanyService.addCertComp(record, staffid, cid);
                data.setResult((Object)record);
                data.setState(ResponseStateEnum.success);
                data.setContent("\u65b0\u589e\u6210\u529f\uff01");
            }
        }
        return data;
    }

    @RequiresPermissions(value={"certificate.view"})
    @RequestMapping(value={"/viewCerComp"}, method={RequestMethod.GET})
    public String viewCerComp(ModelMap m, Long id, Boolean isCount, Boolean isExpire) {
        CertificateCompany certificateCompany = new CertificateCompany();
        if (id != null) {
            certificateCompany = this.certificateCompanyService.getByIdWithFile(id);
        }
        m.put((Object)"data", (Object)certificateCompany);
        m.put((Object)"isExpire", (Object)isExpire);
        m.put((Object)"isCount", (Object)isCount);
        return "work/certificate/certificateCompanyView";
    }

    @RequiresPermissions(value={"certificate.edit"})
    @Log(title="\u5220\u9664\u4f01\u4e1a\u8bc1\u4e66", type=22)
    @ResponseBody
    @RequestMapping(value={"/delCertComp"}, method={RequestMethod.DELETE})
    public ResponseData<Integer> delCertComp(HttpSession session, Long id, ModelMap m) {
        ResponseData data = new ResponseData();
        CertificateCompany info = new CertificateCompany();
        Long staffid = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        info.setId(id);
        info.setIsValid(Boolean.valueOf(false));
        try {
            this.certificateCompanyService.deleWithHis(info, staffid, cid);
            data.setContent("\u5220\u9664\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            data.setContent("\u5220\u9664\u5931\u8d25\uff01");
        }
        return data;
    }

    @Log(title="\u5230\u671f\u4f01\u4e1a\u8bc1\u4e66\u5217\u8868", type=2)
    @RequiresPermissions(value={"certificate.view"})
    @RequestMapping(value={"/expireCertCompList"})
    public String expireCertCompList(HttpSession session, ModelMap m) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        int expireComNum = this.certificateCompanyService.getExpireCertficateNum(cid);
        int expireStaffNum = this.certificateStaffDetailService.getExpireCertficateNum(cid);
        int expireDevNum = this.certificateDeviceDetailService.getExpireCertficateNum(cid);
        m.put((Object)"expireComNum", (Object)expireComNum);
        m.put((Object)"expireStaffNum", (Object)expireStaffNum);
        m.put((Object)"expireDevNum", (Object)expireDevNum);
        return "work/certificate/expireCertCompanyList";
    }

    @RequiresPermissions(value={"certificate.edit"})
    @Log(title="\u5ffd\u7565\u4f01\u4e1a\u8bc1\u4e66\u5230\u671f\u63d0\u9192", type=21)
    @ResponseBody
    @RequestMapping(value={"/ignoreExpireComp"}, method={RequestMethod.DELETE})
    public ResponseData<Integer> ignoreExpireComp(HttpSession session, Long id, ModelMap m) {
        ResponseData data = new ResponseData();
        CertificateCompany info = new CertificateCompany();
        Long staffid = UserUtils.getLoginStaffId();
        info.setId(id);
        info.setExpireDeal(CertificateExpireDealEnum.ignore.getValue());
        try {
            this.certificateCompanyService.update((Object)info, staffid);
            data.setContent("\u5ffd\u7565\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            data.setContent("\u5220\u9664\u5931\u8d25\uff01");
        }
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"getExpireComlistData"}, method={RequestMethod.GET})
    public JqGridData<CertificateCompany> getExpireComlistData(JqGridParam param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        CertificateCompany info = new CertificateCompany();
        info.setCid(cid);
        PageInfo certPage = this.certificateCompanyService.getExpireCertficateList(info, param);
        JqGridData data = new JqGridData(certPage, param);
        return data;
    }

    @RequiresPermissions(value={"certificate.view"})
    @RequestMapping(value={"/countCertCompList"})
    public String countCertCompList(HttpSession session, Model m) {
        return "work/certificate/countCertCompanyList";
    }

    @RequiresPermissions(value={"certificate.view"})
    @Log(title="\u5bfc\u51fa\u4f01\u4e1a\u8bc1\u4e66\u6e05\u5355", type=24)
    @RequestMapping(value={"exportCertComp"})
    public void exportCertComp(HttpServletResponse response) throws Exception {
        this.logger.info("ajax-\u3010\u4f01\u4e1a\u8bc1\u4e66\u6e05\u5355\u3011-\u5bfc\u51faExcel");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u4f01\u4e1a\u8bc1\u4e66\u6e05\u5355" + dateFormat.format(new Date()) + ".xls";
        Long cid = UserUtils.getLoginStaffCompanyId();
        String[] colums = new String[]{"\u5e8f\u53f7|serialNum", "\u8bc1\u4e66\u540d\u79f0|name", "\u7f16\u53f7|certificateNo", "\u53d6\u8bc1\u65e5\u671f|certCreateDate", "\u6709\u6548\u671f\u81f3|validityDate", "\u590d\u5ba1\u65e5\u671f|repeatData", "\u9644\u4ef6|fileNames"};
        List list = this.certificateCompanyService.getExportListByCid(cid);
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("GBK"), "ISO8859_1"));
        response.setContentType("application/octet-stream; charset=GBK");
        ExportExcel listexcel = new ExportExcel();
        listexcel.simpleExport3("\u4f01\u4e1a\u8bc1\u4e66\u6e05\u5355", colums, list, (OutputStream)response.getOutputStream());
    }

    private List<CertificateFiles> getFiles(String[] fileids) {
        if (fileids == null || fileids.length == 0) {
            return null;
        }
        ArrayList<CertificateFiles> files = new ArrayList<CertificateFiles>();
        for (int a = 0; a < fileids.length; ++a) {
            CertificateFiles certfile = new CertificateFiles();
            long id = Long.parseLong(fileids[a]);
            SysFileModel file = SysFileUtil.getFileById(id);
            certfile.setFileId(Long.valueOf(id));
            certfile.setFileName(file.getFileName());
            certfile.setFileUrl(file.getOssUrl());
            files.add(certfile);
        }
        return files;
    }
}

