/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.accident;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.BusinessNoTypeEnum;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.entity.work.accident.EmeAccident;
import cn.smarthse.modules.health.entity.work.accident.EmeAccidentFiles;
import cn.smarthse.modules.health.service.base.IBusinessNoService;
import cn.smarthse.modules.health.service.work.accident.IEmeAccidentLevelService;
import cn.smarthse.modules.health.service.work.accident.IEmeAccidentService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/accident"})
public class EmeAccidentController
extends ControllerSupport {
    @DubboReference
    private IEmeAccidentService emeAccidentService;
    @DubboReference
    private IBusinessNoService businessNoService;
    @DubboReference
    private IEmeAccidentLevelService emeAccidentLevelService;

    @RequiresPermissions(value={"accident.view"})
    @RequestMapping
    public String page_index(EmeAccident data, HttpSession session, ModelMap m) {
        this.logger.info("\u3010\u3011-\u6c47\u603b\u9996\u9875");
        data.setStatus(Byte.valueOf((byte)0));
        m.put((Object)"query", (Object)data);
        return "work/accident/accident_unfinish_list";
    }

    @RequiresPermissions(value={"accident.view"})
    @RequestMapping(value={"/count"}, method={RequestMethod.GET})
    public String count(EmeAccident data, HttpSession session, ModelMap m) {
        this.logger.info("\u3010\u3011-\u6c47\u603b\u9996\u9875");
        data.setStatus(Byte.valueOf((byte)1));
        m.put((Object)"query", (Object)data);
        return "work/accident/accident_count";
    }

    @RequiresPermissions(value={"accident.view"})
    @ResponseBody
    @RequestMapping(value={"listData"})
    public JqGridData<EmeAccident> listData(HttpSession session, JqGridParam gparam, EmeAccident param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        UserUtils.startWebDataScope();
        PageInfo list = this.emeAccidentService.getAccidentList(gparam, param);
        JqGridData data = new JqGridData(list, gparam);
        return data;
    }

    private void getLevel(ModelMap m, Long cid) {
        List list = this.emeAccidentLevelService.list(cid);
        m.put((Object)"levelList", (Object)list);
    }

    @RequiresPermissions(value={"accident.edit"})
    @RequestMapping(value={"/add"}, method={RequestMethod.GET})
    public String info(HttpSession session, ModelMap m, EmeAccident data) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        data.setNo(this.businessNoService.getBusinessNo(cid, BusinessNoTypeEnum.EMEACCIDENT.getCode()));
        m.put((Object)"data", (Object)data);
        this.getLevel(m, cid);
        return "work/accident/accident_edit";
    }

    @RequiresPermissions(value={"accident.edit"})
    @RequestMapping(value={"/edit/{id}"}, method={RequestMethod.GET})
    public String edit(HttpSession session, ModelMap m, @PathVariable Long id, String op) {
        EmeAccident data = null;
        data = id != null ? this.emeAccidentService.getDetailById(id) : new EmeAccident();
        Long cid = UserUtils.getLoginStaffCompanyId();
        this.getLevel(m, cid);
        m.put((Object)"data", (Object)data);
        return "work/accident/accident_edit";
    }

    @RequiresPermissions(value={"accident.view"})
    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(HttpSession session, ModelMap m, @PathVariable Long id, String op) {
        EmeAccident data = null;
        data = id != null ? this.emeAccidentService.getDetailById(id) : new EmeAccident();
        m.put((Object)"data", (Object)data);
        return "work/accident/accident_info";
    }

    @RequiresPermissions(value={"accident.edit"})
    @ResponseBody
    @RequestMapping(value={"/info"}, method={RequestMethod.POST})
    public ResponseData<EmeAccident> info(HttpSession session, HttpServletRequest request, EmeAccident emeAccidentForm) {
        this.logger.info("ajax-\u3010\u3011-\u65b0\u589e");
        ResponseData data = new ResponseData();
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        if (emeAccidentForm.getId() == null && StringUtils.isEmpty((CharSequence)emeAccidentForm.getOrgId())) {
            emeAccidentForm.setOrgId("" + UserUtils.getOrgId());
        }
        this.setFilesByRequest(request, emeAccidentForm);
        emeAccidentForm = this.emeAccidentService.insertOrUpdate(emeAccidentForm, cid, staffId);
        data.setContent("\u64cd\u4f5c\u6210\u529f");
        data.setResult((Object)emeAccidentForm);
        return data;
    }

    private void setFilesByRequest(HttpServletRequest request, EmeAccident data) {
        String[] photosIds = request.getParameterValues("photosIds");
        String[] reportsIds = request.getParameterValues("reportsIds");
        String[] othersIds = request.getParameterValues("othersIds");
        data.setPhotos(this.convertFileIds(photosIds));
        data.setReports(this.convertFileIds(reportsIds));
        data.setOthers(this.convertFileIds(othersIds));
    }

    private List<EmeAccidentFiles> convertFileIds(String[] fileIds) {
        ArrayList<EmeAccidentFiles> files = new ArrayList<EmeAccidentFiles>();
        if (fileIds == null || fileIds.length == 0) {
            return files;
        }
        for (String fileId : fileIds) {
            EmeAccidentFiles file = new EmeAccidentFiles();
            file.setFileId(Long.valueOf(Long.parseLong(fileId)));
            files.add(file);
        }
        return files;
    }

    @RequiresPermissions(value={"accident.edit"})
    @ResponseBody
    @RequestMapping(value={"/del/{ids}"}, method={RequestMethod.DELETE})
    public ResponseData<String> ajax_delete(@PathVariable String ids, HttpSession session) {
        this.logger.info("ajax-\u3010\u3011-\u5220\u9664\u8bb0\u5f55:" + ids);
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        this.emeAccidentService.deleteByIds(ids, staffId, cid);
        ResponseData data = new ResponseData();
        data.setResult((Object)ids);
        data.setContent("\u5220\u9664\u6210\u529f");
        return data;
    }

    @RequiresPermissions(value={"accident.view"})
    @RequestMapping(value={"export"})
    public void export(EmeAccident data, HttpSession session, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.logger.info("ajax-\u3010\u3011-\u5bfc\u51faExcel");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u5df2\u5b8c\u6210\u4e8b\u6545\u6e05\u5355" + dateFormat.format(new Date()) + ".xls";
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("GBK"), "ISO8859_1"));
        response.setContentType("application/octet-stream; charset=GBK");
        String[] colums = new String[]{"\u4e8b\u6545\u540d\u79f0|name", "\u4e8b\u6545\u7b49\u7ea7|levelName", "\u4e8b\u53d1\u65f6\u95f4|happenTimeStr", "\u5b8c\u6210\u65f6\u95f4|updateDate"};
        data.setCid(UserUtils.getLoginStaffCompanyId());
        data.setStatus(Byte.valueOf((byte)1));
        UserUtils.startWebDataScope();
        List list = this.emeAccidentService.exprotList(data);
        ExportExcel export = new ExportExcel();
        export.simpleExport3("\u5df2\u5b8c\u6210\u4e8b\u6545\u6e05\u5355", colums, list, (OutputStream)response.getOutputStream());
    }

    @RequiresPermissions(value={"accident.edit"})
    @ResponseBody
    @RequestMapping(value={"/cancel/{ids}"}, method={RequestMethod.POST})
    public ResponseData<String> cancel(@PathVariable String ids, HttpSession session) {
        this.logger.info("ajax-\u3010\u3011-\u5220\u9664\u8bb0\u5f55:" + ids);
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        this.emeAccidentService.cancelByIds(ids, staffId, cid);
        ResponseData data = new ResponseData();
        data.setResult((Object)ids);
        data.setContent("\u4f5c\u5e9f\u6210\u529f");
        return data;
    }
}

