/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.township;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.township.manage.model.vo.company.CompanyPatrolDetailDataVo;
import cn.smarthse.township.manage.model.vo.company.CompanyPatrolIndexDataVo;
import cn.smarthse.township.manage.model.vo.company.CompanyRiskNotificationDataVo;
import cn.smarthse.township.manage.provider.company.IPatrolToCompanyProviderService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/township/patrol"})
public class PatrolController
extends ControllerSupport {
    @DubboReference
    private IPatrolToCompanyProviderService patrolToCompanyProviderService;

    @Log(title="\u4e61\u9547\u534f\u7ba1\u2014\u2014\u5de1\u67e5", type=2)
    @RequestMapping(value={"/index"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"assistRecord"})
    public String index() {
        return "views/townshipCooperativeManagement/helpRecord/list";
    }

    @ResponseBody
    @RequestMapping(value={"/getCompanyPatrolIndexData"}, method={RequestMethod.GET})
    public ResponseData<Map<Integer, List<CompanyPatrolIndexDataVo>>> getCompanyPatrolIndexData() {
        Long cid = UserUtils.getLoginStaffCompanyId();
        ResponseData responseData = new ResponseData();
        responseData.setResult((Object)this.patrolToCompanyProviderService.getCompanyPatrolIndexData(cid));
        return responseData;
    }

    @Log(title="\u4e61\u9547\u534f\u7ba1\u2014\u2014\u8be6\u60c5", type=2)
    @RequestMapping(value={"/detail/{patrolId}"}, method={RequestMethod.GET})
    public String detail(ModelMap m, @PathVariable(value="patrolId") Long patrolId) {
        m.put((Object)"patrolId", (Object)patrolId);
        return "views/townshipCooperativeManagement/helpRecord/detail";
    }

    @ResponseBody
    @RequestMapping(value={"/getCompanyPatrolIDetailData/{patrolId}"}, method={RequestMethod.GET})
    public ResponseData<CompanyPatrolDetailDataVo> getCompanyPatrolIDetailData(@PathVariable(value="patrolId") Long patrolId) {
        ResponseData responseData = new ResponseData();
        responseData.setResult((Object)this.patrolToCompanyProviderService.getCompanyPatrolIDetailData(patrolId));
        return responseData;
    }

    @Log(title="\u4e61\u9547\u534f\u7ba1\u2014\u2014\u98ce\u9669\u544a\u77e5", type=2)
    @RequestMapping(value={"/riskNotification/{patrolId}"}, method={RequestMethod.GET})
    public String riskNotification(ModelMap m, @PathVariable(value="patrolId") Long patrolId) {
        m.put((Object)"patrolId", (Object)patrolId);
        return "views/townshipCooperativeManagement/helpRecord/riskNotification";
    }

    @ResponseBody
    @RequestMapping(value={"/getRiskNotificationData/{patrolId}"}, method={RequestMethod.GET})
    public ResponseData<CompanyRiskNotificationDataVo> getRiskNotificationData(@PathVariable(value="patrolId") Long patrolId) {
        ResponseData responseData = new ResponseData();
        responseData.setResult((Object)this.patrolToCompanyProviderService.getCompanyRiskNotificationData(patrolId));
        return responseData;
    }

    @Generated
    public PatrolController() {
    }
}

