/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.tools;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.common.util.PinyinUtil;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.enums.SysParamGroupEnum;
import cn.smarthse.modules.datacentre.model.harmfactor.DcHarmFactorQueryModel;
import cn.smarthse.modules.datacentre.model.platform.riskFactors.HarmModel;
import cn.smarthse.modules.datacentre.model.system.IndustryModel;
import cn.smarthse.modules.datacentre.model.system.SysParamModel;
import cn.smarthse.modules.datacentre.model.system.riskFactors.HarmFactor;
import cn.smarthse.modules.datacentre.model.system.riskFactors.HarmFactorGroupModel;
import cn.smarthse.modules.datacentre.provider.system.ISysParamProvideService;
import cn.smarthse.modules.datacentre.provider.system.IndustryProvideService;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IRiskFactorsProvideByPlatformService;
import cn.smarthse.modules.health.entity.base.disease.Disease;
import cn.smarthse.modules.health.entity.base.disease.DiseaseType;
import cn.smarthse.modules.health.entity.base.occriskfactor.OccupationalRiskFactors;
import cn.smarthse.modules.health.enums.hccheckplan.OccTypeEnum;
import cn.smarthse.modules.health.service.base.occriskfactor.IOccupationalRiskFactorsService;
import cn.smarthse.modules.health.service.sys.IParamService;
import cn.smarthse.modules.health.service.work.shield.IProtectListService;
import cn.smarthse.modules.health.supervise.service.company.IDcCompanyService;
import cn.smarthse.modules.health.supervise.service.disease.IDiseaseThirdService;
import cn.smarthse.modules.health.thirdOrganization.model.org.OrgQueryParamModel;
import cn.smarthse.modules.health.thirdOrganization.model.org.SelectOrgVo;
import cn.smarthse.modules.health.thirdOrganization.model.org.SuperviseOrgListVo;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrganizationService;
import cn.smarthse.services.wanda.api.entity.WandaDictValue;
import cn.smarthse.services.wanda.api.service.IWandaDictionaryService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/toole/plugIns"})
public class PlugInController
extends ControllerSupport {
    private final String BASE_PATH = "/plugIns";
    @DubboReference
    private IOccupationalRiskFactorsService occupationalRiskFactorsService;
    @DubboReference(version="1.0.0")
    private IHarmFactorService harmFactorProvider;
    @DubboReference
    private IProtectListService protectListService;
    @DubboReference
    private IDiseaseThirdService diseaseThirdService;
    @DubboReference
    private IParamService paramService;
    @DubboReference
    private IThirdOrganizationService thirdOrganizationService;
    @DubboReference(version="1.0.0")
    IRiskFactorsProvideByPlatformService riskFactorsProvideByPlatformService;
    @DubboReference(version="1.0.0")
    private IndustryProvideService industryProvideService;
    @DubboReference(timeout=5000000)
    private IDcCompanyService dcCompanyService;
    @DubboReference(version="1.0.0")
    private IHarmFactorService harmFactorService;
    @DubboReference(version="1.0.0")
    private ISysParamProvideService sysParamProvideService;
    @DubboReference(timeout=60000)
    private IWandaDictionaryService wandaDictionaryService;

    @RequestMapping(value={"/index"})
    public String index() {
        return "/plugIns/index";
    }

    @RequestMapping(value={"/organizationSelect"})
    public String organizationSelect() {
        return "/plugIns/organizationSelect";
    }

    @RequestMapping(value={"/organSelectMore"})
    public String organSelectMore() {
        return "/plugIns/organizationSelectMore";
    }

    @RequestMapping(value={"/areaSelectMore"})
    public String areaSelectMore() {
        return "/plugIns/areaSelectMore";
    }

    @RequestMapping(value={"/areaHarmSelectMore"})
    public String areaHarmSelectMore() {
        return "/plugIns/areaHarmSelectMore";
    }

    @RequestMapping(value={"/areaSelectSignle"})
    public String areaSelectSignle() {
        return "/plugIns/areaSelectSignle";
    }

    @RequestMapping(value={"/selectOneStaffInfo"})
    public String selectOneStaffInfo() {
        return "/plugIns/selectOneStaffInfo";
    }

    @RequestMapping(value={"/selectMoreStaffInfo"})
    public String selectMoreStaffInfo(ModelMap m, Long contactGroupId) {
        if (contactGroupId != null) {
            m.put((Object)"contactGroupId", (Object)contactGroupId);
        }
        return "/plugIns/selectMoreStaffInfo";
    }

    @RequestMapping(value={"/selectMoreStaffInfoFile6"})
    public String selectMoreStaffInfoFile6(ModelMap m, Long contactGroupId) {
        if (contactGroupId != null) {
            m.put((Object)"contactGroupId", (Object)contactGroupId);
        }
        return "/plugIns/selectMoreStaffInfoFile6";
    }

    @RequestMapping(value={"/selectOneWorkRoleInfo"})
    public String selectOneWorkRoleInfo(String workIds, ModelMap m) {
        m.put((Object)"workIds", (Object)workIds);
        return "/plugIns/selectOneWorkRoleInfoForImp";
    }

    @RequestMapping(value={"/selectRadioWorkRoleOrgHarm"})
    public String selectRadioWorkRoleOrgHarm(String workIds, ModelMap m, String harmTypes) {
        m.put((Object)"workIds", (Object)workIds);
        m.put((Object)"harmTypes", (Object)harmTypes);
        return "/plugIns/selectRadioWorkRoleOrgHarm";
    }

    @RequestMapping(value={"/selectOneDeviceType"})
    public String selectOneDeviceType(ModelMap m) {
        return "/plugIns/selectOneDeviceType";
    }

    @RequestMapping(value={"/selectOneWorkRoleInfoOnlyHarms"})
    public String selectOneWorkRoleInfoOnlyHarms(String workIds, ModelMap m) {
        m.put((Object)"workIds", (Object)workIds);
        return "/plugIns/selectOneWorkRoleInfoOnlyHarms";
    }

    @RequestMapping(value={"/selectOneWorkRoleInfoOnlyHarmsSelf"})
    public String selectOneWorkRoleInfoOnlyHarmsSelf(String workIds, ModelMap m) {
        return "/plugIns/selectOneWorkRoleInfoOnlyHarmsSelf";
    }

    @RequestMapping(value={"/selectOneWorkRoleInfoOnlyHarmsTypical"})
    public String selectOneWorkRoleInfoOnlyHarmsTypical(String workIds, ModelMap m) {
        return "/plugIns/selectOneWorkRoleInfoOnlyHarmsTypical";
    }

    @RequestMapping(value={"/selectMoreWorkRoleInfo"})
    public String selectMoreWorkRoleInfo(String workIds, Long reWork, ModelMap m) {
        m.put((Object)"workIds", (Object)workIds);
        m.put((Object)"reWork", (Object)reWork);
        return "/plugIns/selectMoreWorkRoleInfoForImp";
    }

    @RequestMapping(value={"/selectShieldSignle"})
    public String selectShieldSignle() {
        return "/plugIns/selectShieldSignle";
    }

    @RequestMapping(value={"/selectShieldMore"})
    public String selectShieldMore(ModelMap m, Long workId, String staffIds) {
        m.put((Object)"workId", (Object)workId);
        m.put((Object)"staffIds", (Object)staffIds);
        return "/plugIns/selectShieldMore";
    }

    @RequestMapping(value={"/selectOneMatte"})
    public String selectOneMatte() {
        return "/plugIns/selectOneMatte";
    }

    @RequestMapping(value={"/selectMatte"})
    public String selectMatte(Model model, String selectIds) {
        model.addAttribute("selectIds", (Object)selectIds);
        return "/plugIns/selectMatte";
    }

    @RequestMapping(value={"/selectOneTpCompany"})
    public String selectOneTmCompany() {
        return "/plugIns/selectOneTpCompany";
    }

    @RequestMapping(value={"/selectOneDevice"})
    public String selectOneDevice() {
        return "/plugIns/selectOneDevice";
    }

    @RequestMapping(value={"/selectDevice"})
    public String selectDevice(String onlyCommonly, ModelMap model) {
        if (StringUtils.isNotEmpty((CharSequence)onlyCommonly) && onlyCommonly.equals("1")) {
            model.addAttribute("onlyCommonly", (Object)true);
        }
        return "/plugIns/selectDevice";
    }

    @RequestMapping(value={"/selectOneProtectionDevice"})
    public String selectOneProtectionDevice() {
        return "/plugIns/selectOneProtectionDevice";
    }

    @RequestMapping(value={"/selectOneEvaluate"})
    public String selectOneEvaluate(String param) {
        return "/plugIns/selectOneEvaluate";
    }

    @RequestMapping(value={"/selectProtectionDevice"})
    public String selectProtectionDevice() {
        return "/plugIns/selectProtectionDevice";
    }

    @RequestMapping(value={"sselect/harmfactors"})
    public String singleSelectHarmfactor() {
        return "/plugIns/sselect-HarmFactors";
    }

    @RequestMapping(value={"sselect/harmfactors2"})
    public String singleSelectHarmfactor2(String parameter, ModelMap m, String harmTypes, DcHarmFactorQueryModel dcHarmFactorQueryModel) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        if (parameter == null) {
            parameter = "";
        }
        try {
            if (StringUtils.isNotBlank((CharSequence)harmTypes)) {
                List<String> strings = Arrays.asList(StringUtils.splitByWholeSeparator((String)harmTypes, (String)","));
                dcHarmFactorQueryModel.setHarmTypesList(strings);
            }
            dcHarmFactorQueryModel.setCid(cid);
            dcHarmFactorQueryModel.setKeyword(parameter);
            List harmFactors = this.harmFactorService.selectListByQueryModel(dcHarmFactorQueryModel);
            m.put((Object)"harmlist", (Object)harmFactors);
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u51fa\u9519\uff1a" + e.getMessage());
        }
        return "/plugIns/sselect-HarmFactors2";
    }

    @RequestMapping(value={"/selectOneSysMatte"})
    public String selectOneSysMatte() {
        return "/plugIns/selectOneSysMatte";
    }

    @RequestMapping(value={"/selectOneSysParamTree"})
    public String selectOneSysParamTree(ModelMap modelMap) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Map industryUpdateLog = this.dcCompanyService.getIndustryUpdateLog(cid);
        modelMap.put((Object)"isQuanLiuCheng", industryUpdateLog.get("isQuanLiuCheng"));
        modelMap.put((Object)"industryCategory", industryUpdateLog.get("industryCategory"));
        return "/plugIns/selectOneSysParamTree";
    }

    @RequestMapping(value={"/selectOneInduTree"})
    public String selectOneInduTree() {
        return "/plugIns/selectOneInduTree";
    }

    @RequestMapping(value={"sselect/harmfactors-list"})
    public String singleSelectHarmfactorList(Model model, String selectIds) {
        model.addAttribute("selectIds", (Object)selectIds);
        return "/plugIns/sselect-HarmFactors-list";
    }

    @RequestMapping(value={"sselect/yszyb-list"})
    public String singleSelectYszybFactorList(Model model, String selectIds) {
        model.addAttribute("selectIds", (Object)selectIds);
        return "/plugIns/sselect-yszybFactors-list";
    }

    @RequestMapping(value={"sselect/ysjjz-list"})
    public String singleSelectYsjjzFactorList(Model model, String selectIds) {
        model.addAttribute("selectIds", (Object)selectIds);
        return "/plugIns/sselect-ysjjzFactors-list";
    }

    @RequestMapping(value={"sselect/harmfactors-listByHarmType"})
    public String singleSelectHarmfactorListByHarmType(Model model, String selectIds, String harmType) {
        model.addAttribute("selectIds", (Object)selectIds);
        model.addAttribute("harmType", (Object)harmType);
        return "/plugIns/sselect-HarmFactors-listByHarmType";
    }

    @RequestMapping(value={"sselect/harmfactorsHxFc-list"})
    public String harmfactorsHxFcList(Model model, String selectIds) {
        model.addAttribute("selectIds", (Object)selectIds);
        return "/plugIns/harmfactorsHxFc-list";
    }

    @RequestMapping(value={"/addCustomFactor"})
    @ResponseBody
    @RepeatUrlFormData
    @Log(title="\u5371\u5bb3\u56e0\u7d20-\u6dfb\u52a0", type=20)
    public ResponseData<HarmFactor> addCustomFactor(OccupationalRiskFactors occrf) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        ResponseData data = new ResponseData();
        try {
            List harmByNameAndCid = this.harmFactorProvider.getHarmByNameAndCid(occrf.getNameCh(), occrf.getNameCh(), cid);
            if (CollectionUtils.isNotEmpty((Collection)harmByNameAndCid)) {
                data.setContent("\u5df2\u5b58\u5728\u8be5\u5371\u5bb3\u56e0\u7d20\u540d\u79f0");
                data.setState(ResponseStateEnum.fail);
            } else {
                HarmFactor harmFactor = this.harmFactorProvider.addByNameAndType(occrf.getNameCh(), occrf.getType(), cid, loginStaffId);
                data.setResult((Object)harmFactor);
                data.setContent("\u6dfb\u52a0\u6210\u529f");
            }
        }
        catch (Exception e) {
            data.setContent("\u6dfb\u52a0\u5931\u8d25:" + e.getMessage());
            data.setState(ResponseStateEnum.fail);
            this.logger.error(e.getMessage());
        }
        return data;
    }

    @RequestMapping(value={"/del"})
    @ResponseBody
    @Log(title="\u5371\u5bb3\u56e0\u7d20-\u5220\u9664", type=22)
    public ResponseData<String> deleteOtherOccupationalRiskFactorsById(OccupationalRiskFactors occrf) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        ResponseData data = new ResponseData();
        try {
            this.harmFactorProvider.deleteOtherOccupationalRiskFactorsById(occrf.getId());
            data.setContent("\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            data.setState(ResponseStateEnum.fail);
            this.logger.error(e.getMessage());
        }
        return data;
    }

    @GetMapping(value={"/harmfactors"})
    @ResponseBody
    public ResponseData<List<HarmFactorGroupModel>> harmfactors(String keyword, String harmTypes) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        List factorList = new ArrayList();
        if (keyword == null) {
            keyword = "";
        }
        try {
            factorList = this.harmFactorProvider.selectList(cid, keyword, harmTypes);
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u51fa\u9519\uff1a" + e.getMessage());
        }
        Map<String, List<HarmFactor>> typeMap = factorList.stream().filter(f -> StringUtils.isNotEmpty((CharSequence)f.getNameCh())).collect(Collectors.groupingBy(HarmFactor::getType));
        List result = typeMap.keySet().stream().map(t -> {
            HarmFactorGroupModel model = new HarmFactorGroupModel();
            model.setTypeName(t);
            model.setFactorList((List)typeMap.get(t));
            return model;
        }).collect(Collectors.toList());
        return ResponseData.success(result);
    }

    @RequestMapping(value={"sselect/harmfactors-listdata"})
    public String singleSelectHarmfactorListData(String parameter, ModelMap m, String selectIds, String harmTypes) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        List factorList = null;
        if (parameter == null) {
            parameter = "";
        }
        try {
            factorList = this.harmFactorProvider.selectList(cid, parameter, harmTypes);
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u51fa\u9519\uff1a" + e.getMessage());
        }
        if (factorList != null) {
            factorList = factorList.stream().filter(item -> item != null && !"".equalsIgnoreCase(item.getNameCh())).collect(Collectors.toList());
        }
        m.put((Object)"harmlist", (Object)factorList);
        m.put((Object)"selectIds", (Object)selectIds);
        return "/plugIns/sselect-HarmFactors-listdata";
    }

    @RequestMapping(value={"sselect/zyjjzFactors-listdata"})
    public String singleSelectZyjjzFactorListData(String parameter, ModelMap m, String selectIds, String harmTypes) {
        List<Object> factorList = new ArrayList();
        if (parameter == null) {
            parameter = "";
        }
        try {
            Map map = this.wandaDictionaryService.getDictValueByCodeCache(Long.valueOf(20L));
            Set entries = map.entrySet();
            for (Map.Entry entry : entries) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                HarmFactor factor = new HarmFactor();
                factor.setId(Long.valueOf(Long.parseLong(key)));
                factor.setNameCh(value);
                factor.setType("\u804c\u4e1a\u7981\u5fcc\u7684\u5371\u5bb3\u56e0\u7d20");
                if (StringUtils.isNotEmpty((CharSequence)parameter)) {
                    if (value.indexOf(parameter) <= 0) continue;
                    factorList.add(factor);
                    continue;
                }
                factorList.add(factor);
            }
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u51fa\u9519\uff1a" + e.getMessage());
        }
        if (factorList != null) {
            factorList = factorList.stream().filter(item -> item != null && !"".equalsIgnoreCase(item.getNameCh())).collect(Collectors.toList());
        }
        m.put((Object)"harmlist", factorList);
        m.put((Object)"selectIds", (Object)selectIds);
        return "/plugIns/sselect-zyjjzFactors-listdata";
    }

    @RequestMapping(value={"sselect/yszybFactors-listdata"})
    public String singleSelectYszybFactorListData(String parameter, ModelMap m, String selectIds, String harmTypes) {
        List<Object> factorList = new ArrayList();
        if (parameter == null) {
            parameter = "";
        }
        try {
            Map map = this.wandaDictionaryService.getAllWandRiskFactorByCache();
            Set entries = map.entrySet();
            for (Map.Entry entry : entries) {
                String key = (String)entry.getKey();
                WandaDictValue value = (WandaDictValue)entry.getValue();
                HarmFactor factor = new HarmFactor();
                factor.setId(Long.valueOf(Long.parseLong(key)));
                factor.setNameCh(value.getValueLabel());
                factor.setType("\u7591\u4f3c\u804c\u4e1a\u75c5\u540d\u79f0");
                if (StringUtils.isNotEmpty((CharSequence)parameter)) {
                    if (!StringUtils.isNotEmpty((CharSequence)value.getValueLabel()) || value.getValueLabel().indexOf(parameter) <= 0) continue;
                    factorList.add(factor);
                    continue;
                }
                factorList.add(factor);
            }
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u51fa\u9519\uff1a" + e.getMessage());
        }
        if (factorList != null) {
            factorList = factorList.stream().filter(item -> item != null && !"".equalsIgnoreCase(item.getNameCh())).collect(Collectors.toList());
        }
        m.put((Object)"harmlist", factorList);
        m.put((Object)"selectIds", (Object)selectIds);
        return "/plugIns/sselect-yszybFactors-listdata";
    }

    @RequestMapping(value={"sselect/harmfactorsHxFc-listdata"})
    public String singleSelectHarmfactorHxFcListData(String parameter, ModelMap m, String selectIds, String harmTypes) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        List<OccupationalRiskFactors> factorList = null;
        if (parameter == null) {
            parameter = "";
        }
        try {
            List listByGBZ = this.riskFactorsProvideByPlatformService.getListByGBZ(harmTypes, parameter);
            factorList = this.convertOccupationalRiskFactors(listByGBZ);
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u51fa\u9519\uff1a" + e.getMessage());
        }
        m.put((Object)"selectIds", (Object)selectIds);
        m.put((Object)"harmlist", factorList);
        return "/plugIns/sselect-HarmFactors-listdata";
    }

    private List<OccupationalRiskFactors> convertOccupationalRiskFactors(List<HarmModel> listByGBZ) {
        if (CollectionUtils.isNotEmpty(listByGBZ)) {
            ArrayList<OccupationalRiskFactors> factorList = new ArrayList<OccupationalRiskFactors>();
            for (HarmModel harmModel : listByGBZ) {
                if (StringUtils.isBlank((CharSequence)harmModel.getBlendName())) continue;
                OccupationalRiskFactors f = new OccupationalRiskFactors();
                f.setType(harmModel.getType());
                f.setNameCh(harmModel.getBlendName());
                f.setId(harmModel.getId());
                factorList.add(f);
            }
            return factorList;
        }
        return null;
    }

    @RequestMapping(value={"/selectCheckSignle"})
    public String selectCheckSignle() {
        return "/plugIns/selectCheckSignle";
    }

    @RequestMapping(value={"/selectOneHcCheckType"})
    public String selectOneHcCheckType() {
        return "/plugIns/selectOneHcCheckType";
    }

    @RequestMapping(value={"/selectMoreHcCheckType"})
    public String selectMoreHcCheckType() {
        return "/plugIns/selectMoreHcCheckType";
    }

    @RequestMapping(value={"/selectOneOccupationalRiskFactors"})
    public String selectOneOccupationalRiskFactors(Integer type, ModelMap m) {
        m.put((Object)"OccType", (Object)OccTypeEnum.getThisEnumByType((Integer)type));
        return "/plugIns/selectOneOccupationalRiskFactors";
    }

    @RequestMapping(value={"/selectOneStaffCert"})
    public String selectOneStaffCert(Long staffId, Long certNameId, ModelMap m) {
        m.put((Object)"staffId", (Object)staffId);
        m.put((Object)"certNameId", (Object)certNameId);
        return "/plugIns/selectOneStaffCert";
    }

    @RequestMapping(value={"/selectStaffCerts"})
    public String selectStaffCerts(Long staffId, ModelMap m) {
        m.put((Object)"staffId", (Object)staffId);
        return "/plugIns/selectMoreStaffCert";
    }

    @RequestMapping(value={"/selectProtect"})
    public String selectProtect(ModelMap model, Boolean more) {
        model.put((Object)"more", (Object)more);
        List list = this.protectListService.getProtectClassList();
        model.put((Object)"classList", (Object)list);
        return "/plugIns/selectProtect";
    }

    @RequestMapping(value={"/selectDanger"})
    public String selectDanger(ModelMap model, String keyword) {
        model.put((Object)"keyword", (Object)keyword);
        return "/plugIns/selectDanger";
    }

    @RequestMapping(value={"sselect/moreHarmFactors"})
    public String selectHarmFactors() {
        return "/plugIns/sselect-more-harmFactors";
    }

    @RequestMapping(value={"sselect/moreHarmfactorsData"})
    public String selectHarmFactorsData(String parameter, ModelMap m) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        List factorList = null;
        if (parameter == null) {
            parameter = "";
        }
        try {
            factorList = this.occupationalRiskFactorsService.selectShieldHarmList(cid, parameter);
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u51fa\u9519\uff1a" + e.getMessage());
        }
        m.put((Object)"harmlist", (Object)factorList);
        return "/plugIns/sselect-more-harmFactors-data";
    }

    @RequestMapping(value={"/organizationSelectStaff"})
    public String organizationSelectStaff(String orgPid, ModelMap m) {
        m.put((Object)"orgPid", (Object)orgPid);
        return "/plugIns/organizationSelectStaff";
    }

    @RequestMapping(value={"/selectMoreHarmArea"})
    public String selectMoreHarmArea(String harmTypes, String selecteds, ModelMap m) {
        m.put((Object)"harmTypes", (Object)harmTypes);
        m.put((Object)"selecteds", (Object)selecteds);
        return "/plugIns/selectMoreHarmArea";
    }

    @RequestMapping(value={"/selectOrg"})
    public String selectOrg() {
        return "/plugIns/selectOrg";
    }

    @RequestMapping(value={"/selectOneOrg"})
    public String selectOneOrg(String orgType, Model model) {
        model.addAttribute("orgType", (Object)orgType);
        return "/plugIns/selectOneOrg";
    }

    @RequestMapping(value={"/selectDiseases"})
    public String selectDiseases(ModelMap m, String selectedIds) {
        List diseaseTypes = this.diseaseThirdService.listTypes();
        DiseaseType all = new DiseaseType();
        all.setDiseaseTypeName("\u5168\u90e8");
        all.setId(null);
        diseaseTypes.add(all);
        m.addAttribute("diseaseTypes", (Object)diseaseTypes);
        m.put((Object)"selectedIds", (Object)selectedIds);
        return "/township/reform/components/selectDiseases";
    }

    @RequestMapping(value={"/listDiseases"})
    @ResponseBody
    public List<Disease> listDiseases(Integer type, String searchKey, String isNotNeed) {
        List list = this.diseaseThirdService.listDiseases(type, searchKey, isNotNeed);
        return list;
    }

    @RequestMapping(value={"/selectSuspectDiseases"})
    public String selectSuspectDiseases(ModelMap m) {
        List diseaseTypes = this.diseaseThirdService.listTypes();
        m.addAttribute("diseaseTypes", (Object)diseaseTypes);
        return "/plugIns/selectSuspectDiseases";
    }

    @RequestMapping(value={"getExamPage"}, method={RequestMethod.GET})
    public String getExamPage(ModelMap m) {
        return "/plugIns/selectExam";
    }

    @RequestMapping(value={"/selectMoreIndus"})
    public String selectMoreIndus() {
        return "/plugIns/selectMoreIndus";
    }

    @ResponseBody
    @RequestMapping(value={"indu/data"}, method={RequestMethod.GET})
    public ResponseData<List<IndustryModel>> data(String search) {
        ResponseData data = new ResponseData();
        try {
            PageInfo industryList = this.industryProvideService.getIndustryList(Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE), search);
            if (industryList != null && CollectionUtils.isNotEmpty((Collection)industryList.getList())) {
                List industryListList = industryList.getList();
                if (CollectionUtils.isNotEmpty((Collection)industryListList)) {
                    industryListList = industryListList.stream().filter(i -> i.getPid() != null && !i.getPid().equals(0L)).collect(Collectors.toList());
                }
                data.setResult((Object)industryListList);
            }
            return data;
        }
        catch (Exception e) {
            data.setState(ResponseStateEnum.fail);
            data.setContent("\u67e5\u8be2\u5931\u8d25\uff01");
            return data;
        }
    }

    @RequestMapping(value={"/selectHarms"})
    public String selectHarms(ModelMap m, HarmFactor factor, String selectedIds) {
        m.put((Object)"factor", (Object)factor);
        m.put((Object)"selectedIds", (Object)selectedIds);
        return "/plugIns/selectHarms";
    }

    @RequestMapping(value={"/listHarm"})
    @ResponseBody
    public Map<String, List<HarmFactor>> listHarm(HarmFactor factor) {
        Map sortByHarm = this.harmFactorService.getSortByHarm(factor);
        return sortByHarm;
    }

    @RequestMapping(value={"/selectTrainVideos"})
    public String selectTrainVideos(ModelMap m) {
        return "/plugIns/selectTrainVideos";
    }

    @RequestMapping(value={"/selectSpecialOperation"})
    public String selectSpecialOperation(ModelMap m) {
        return "/plugIns/selectSpecialOperation";
    }

    @ResponseBody
    @RequestMapping(value={"/getSpecialOperation"})
    public List<SysParamModel> getSpecialOperation(Integer type, String keyWord) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        List<SysParamModel> list = new ArrayList();
        if (type != null) {
            if (type == 1) {
                list = this.sysParamProvideService.getSysParamListByChildrenSearch(SysParamGroupEnum.occup_exposure_workingtype.getValue(), keyWord);
                for (SysParamModel pa : list) {
                    pa.setParamValue(pa.getParamCode() + pa.getParamValue());
                }
            } else if (type == 2) {
                list = this.sysParamProvideService.getSysParamListByChildrenSearch(SysParamGroupEnum.spec_operation_type.getValue(), keyWord);
            } else if (type == 3) {
                list = this.sysParamProvideService.getSysParamListByChildrenSearch(SysParamGroupEnum.spec_working_type.getValue(), keyWord);
            }
        } else {
            List list1 = this.sysParamProvideService.getSysParamListByChildrenSearch(SysParamGroupEnum.occup_exposure_workingtype.getValue(), keyWord);
            for (SysParamModel pa : list1) {
                pa.setParamValue(pa.getParamCode() + pa.getParamValue());
            }
            List list2 = this.sysParamProvideService.getSysParamListByChildrenSearch(SysParamGroupEnum.occup_exposure_workingtype.getValue(), keyWord);
            List list3 = this.sysParamProvideService.getSysParamListByChildrenSearch(SysParamGroupEnum.occup_exposure_workingtype.getValue(), keyWord);
            list.addAll(list1);
            list.addAll(list2);
            list.addAll(list3);
        }
        return list;
    }

    @RequestMapping(value={"sselect/harmfactorsForInvestigation"})
    public String singleSelectHarmfactorForInvestigation() {
        return "/plugIns/sselect-HarmFactorsForInvestigation";
    }

    @RequestMapping(value={"sselect/singleSelectHarmfactor3"})
    public String singleSelectHarmfactor3(String parameter, ModelMap m, String harmTypes) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        List factorList = null;
        try {
            factorList = this.harmFactorService.getHarmFactorsForInvestigation(parameter, cid);
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u51fa\u9519\uff1a" + e.getMessage());
        }
        m.put((Object)"harmlist", (Object)factorList);
        return "/plugIns/sselect-HarmFactors3";
    }

    @RequestMapping(value={"/selectOrgList.json"})
    @ResponseBody
    public List<SelectOrgVo> selectOrgList(String name, Integer orgType) {
        OrgQueryParamModel queryParamModel = new OrgQueryParamModel();
        queryParamModel.setName(name);
        queryParamModel.setOrgTypes("" + orgType);
        queryParamModel.setPage(Integer.valueOf(1));
        queryParamModel.setRows(Integer.valueOf(Integer.MAX_VALUE));
        Company currentCompany = UserUtils.getCurrentCompany();
        if (currentCompany != null) {
            queryParamModel.setLoginUserAreaId(currentCompany.getAreaId());
        }
        PageInfo pageInfo = this.thirdOrganizationService.queryPage(queryParamModel);
        List list = pageInfo.getList();
        return this.parseSelectOrgVo(list);
    }

    private List<SelectOrgVo> parseSelectOrgVo(List<SuperviseOrgListVo> orgList) {
        ArrayList<SelectOrgVo> list = new ArrayList<SelectOrgVo>();
        HashSet charNameSet = new HashSet();
        for (SuperviseOrgListVo org : orgList) {
            SelectOrgVo vo = new SelectOrgVo();
            vo.setId("" + org.getId());
            vo.setName(org.getName());
            char firstChar = PinyinUtil.getFirstLetter((String)vo.getName());
            vo.setpId("" + firstChar);
            vo.setOpen(false);
            list.add(vo);
        }
        return list;
    }
}

