/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.tools;

import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.common.util.pdf.HtmlToPdf;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.web.controller.ControllerSupport;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.FileNameMap;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/pdf"})
public class PdfController
extends ControllerSupport {
    @DubboReference(timeout=5000000)
    ISysFileProvideService fileService;

    @ResponseBody
    @RequestMapping(value={"/getFileType"})
    public String getFileType(HttpServletRequest request, Long filId) throws Exception {
        String fileUrl = this.fileService.getFileUrl(filId);
        String lastP = fileUrl.substring(fileUrl.lastIndexOf("."), fileUrl.length());
        String pdfDirPath = File.separator + "static" + File.separator + "pdfFiles";
        File dir = CommonUtil.getFile((String[])new String[]{request.getServletContext().getRealPath(pdfDirPath)});
        if (dir.exists()) {
            FileUtils.cleanDirectory((File)dir);
        }
        dir.mkdir();
        File dirFile = new File(request.getServletContext().getRealPath(pdfDirPath + File.separator + "viewFile" + lastP));
        FileUtils.copyURLToFile((URL)new URL(fileUrl), (File)dirFile);
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        String mimeType = fileNameMap.getContentTypeFor(dirFile.getName());
        if (mimeType == null) {
            return "noType";
        }
        if (mimeType.indexOf("image") == 0) {
            return "images";
        }
        if (mimeType.indexOf("pdf") > 0) {
            return "pdf";
        }
        return mimeType;
    }

    @RequestMapping(value={"/viewer"})
    public String viewer(Model model, HttpServletRequest request, Long filId) throws Exception {
        String fileUrl = this.fileService.getFileUrl(filId);
        String lastP = fileUrl.substring(fileUrl.lastIndexOf("."), fileUrl.length());
        model.addAttribute("viewFile", (Object)("pdfFiles/viewFile" + lastP));
        return "pdf/viewerFile";
    }

    @ResponseBody
    @RequestMapping(value={"isExitFile"})
    public boolean isExitFile(HttpServletRequest request, String fileName, long dirFileLength) {
        File file = CommonUtil.getFile((String[])new String[]{request.getServletContext().getRealPath(File.separator + "static" + File.separator + "pdfFiles" + File.separator + fileName)});
        return file.exists() && file.length() == dirFileLength;
    }

    @ResponseBody
    @RequestMapping(value={"toConvertPdf"})
    public void toConvertPdf(HttpServletResponse response, ModelMap m, String fileUrl) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("-O", "Landscape");
        String lastP = fileUrl.substring(fileUrl.lastIndexOf("."), fileUrl.length());
        File file = File.createTempFile("yunlan", lastP);
        FileUtils.copyURLToFile((URL)new URL(fileUrl), (File)file);
        File filePdf = File.createTempFile("finalPdf", ".pdf");
        HtmlToPdf.html2PdfByParam((String)file.getAbsolutePath(), (String)filePdf.getAbsolutePath(), params);
        FileCopyUtils.copy((InputStream)new FileInputStream(filePdf), (OutputStream)response.getOutputStream());
    }
}

