/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.tools;

import cn.hutool.crypto.digest.MD5;
import cn.hutool.http.HttpUtil;
import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.beans.OssClientBean;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.file.FileUploadSimple;
import cn.smarthse.common.framework.file.FileUtil;
import cn.smarthse.common.framework.file.UploadFileParameter;
import cn.smarthse.common.framework.file.UploadFilePathEnum;
import cn.smarthse.common.framework.file.UploadState;
import cn.smarthse.common.framework.mapper.JsonMapper;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.NoSpecalCrypUtil;
import cn.smarthse.common.util.ServletsUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.uploader.FileResourceEnum;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.AppConfigHolder;
import cn.smarthse.web.util.SysFileUtil;
import cn.smarthse.web.util.UserUtils;
import com.alibaba.fastjson.JSONObject;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Date;
import java.util.UUID;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.commons.io.FilenameUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import ws.schild.jave.MultimediaObject;
import ws.schild.jave.info.MultimediaInfo;

@Controller
@RequestMapping(value={"${adminPath}/file"})
public class FileController
extends ControllerSupport {
    @DubboReference(timeout=5000000)
    ISysFileProvideService fileService;
    @Autowired
    OssClientBean ossClientBean;
    @Value(value="${previewServUrl:}")
    private String previewServUrl;
    @Value(value="${health_online_training_aes_key}")
    private String aesKey;

    @ResponseBody
    @RequestMapping(value={"{fileId}"}, method={RequestMethod.GET})
    public String getSysFileById(@PathVariable(value="fileId") Long id, HttpServletRequest req) {
        if (id == null) {
            return "";
        }
        if (this.isActualize()) {
            String baseURL = req.getScheme() + "://" + req.getServerName() + ":" + req.getServerPort() + req.getContextPath();
            SysFileModel smartHseFileById = this.fileService.getSmartHseFileById(id);
            if (smartHseFileById != null) {
                smartHseFileById.setOssUrl(baseURL + "/file/downloadLocal/" + id);
                return JsonMapper.toJsonString((Object)smartHseFileById);
            }
        }
        return JsonMapper.toJsonString((Object)this.fileService.getFileById(id));
    }

    @Deprecated
    @ResponseBody
    @RequestMapping(value={"{fileId}/getOssUrl"}, method={RequestMethod.GET})
    public String getSysFileById(String ossUrl) {
        return this.ossClientBean.getUrl(ossUrl);
    }

    @Log(title="\u4e0a\u4f20\u9644\u4ef6", type=26)
    @ResponseBody
    @RequestMapping(value={"upload"}, method={RequestMethod.POST})
    public ResponseData<SysFileModel> ajax_uploadV2(HttpServletRequest request, @RequestPart(value="file") MultipartFile fileData, @RequestParam(value="allowedTypes", required=false) String allowedTypes) throws IOException {
        ResponseData data = new ResponseData(ResponseStateEnum.success);
        String fileExtension = cn.hutool.core.io.FileUtil.getSuffix((String)fileData.getOriginalFilename());
        ResponseData checkResult = FileUtil.isAllowedFile((MultipartFile)fileData, (String)allowedTypes);
        if (checkResult.getState().notEquals(ResponseStateEnum.success)) {
            return ResponseData.fail((String)checkResult.getContent());
        }
        String filehash = String.valueOf(MD5.create().digestHex(fileData.getBytes()));
        SysFileModel existSysFile = this.fileService.getFileByHash(filehash);
        if (existSysFile != null) {
            data.setResult((Object)existSysFile);
            data.setContent("\u4e0a\u4f20\u6587\u4ef6 \u6210\u529f(hash\u503c\u5b58\u5728)\uff01");
            return data;
        }
        Long loginStaffCompanyId = UserUtils.getLoginStaffCompanyId();
        Long cid = loginStaffCompanyId == null ? 1L : loginStaffCompanyId;
        String ossFileName = FileUploadSimple.getNumberName((String)fileExtension);
        String uploadDir = UploadFileParameter.FILE_PATH + FileResourceEnum.companyHealth_07.getCode() + File.separator + cid + File.separator + UploadFilePathEnum.Common.getPath() + File.separator + FileUploadSimple.getDataPath() + File.separator;
        String ossUrl = (uploadDir + ossFileName).replace("\\", "/");
        String uploadedFilePath = this.ossClientBean.OSSPutObject(ossFileName, fileData.getInputStream(), uploadDir, fileData.getContentType(), fileData.getSize());
        if (StringUtils.isBlank((CharSequence)uploadedFilePath)) {
            data.setContent("\u6587\u4ef6\u4e0a\u4f20\u5230OSS\u5931\u8d25\uff01");
            return data;
        }
        SysFileModel file = new SysFileModel();
        file.setResource(Integer.valueOf(FileResourceEnum.thirdOrg_04.getValue()));
        file.setFileName(fileData.getOriginalFilename());
        file.setFileSize(String.valueOf(fileData.getSize()));
        file.setFileExt(fileExtension);
        file.setFileHash(filehash);
        file.setCreatorIp(StringUtils.getRemoteAddr((HttpServletRequest)request));
        file.setOssUrl(ossUrl);
        file.setCid(UserUtils.getLoginStaffCompanyId());
        this.logger.debug("\u4e0a\u4f20\u6587\u4ef6\uff1a{}", (Object)file.getFileName());
        file = this.fileService.addSysFile(file, UserUtils.getLoginStaffId());
        data.setResult((Object)file);
        data.setContent("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff01");
        return data;
    }

    @Log(title="\u4e0a\u4f20\u9644\u4ef6", type=26)
    @ResponseBody
    @RequestMapping(value={"layuiUpload"}, method={RequestMethod.POST})
    public ResponseData<SysFileModel> layuiUpload(HttpServletRequest req, @RequestPart(value="file") MultipartFile file, @RequestParam(value="allowedTypes", required=false) String allowedTypes) throws Exception {
        return this.ajax_uploadV2(req, file, allowedTypes);
    }

    @ResponseBody
    @RequestMapping(value={"appealUpload"}, method={RequestMethod.POST})
    public ResponseData<SysFileModel> appealUpload(HttpServletRequest req, @RequestPart(value="file") MultipartFile file, @RequestParam(value="allowedTypes", required=false) String allowedTypes) throws Exception {
        return this.ajax_uploadV2(req, file, allowedTypes);
    }

    @Deprecated
    @Log(title="\u4e0a\u4f20\u9644\u4ef6", type=26)
    @ResponseBody
    @RequestMapping(value={"upload/old"}, method={RequestMethod.POST})
    public ResponseData<SysFileModel> ajax_upload(Integer type, String filehash, HttpServletRequest req) throws Exception {
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        UploadFilePathEnum pathEnum = UploadFilePathEnum.getCode((int)type);
        String uploadDir = cid + "/" + pathEnum.getPath();
        UploadFileParameter up = new UploadFileParameter();
        up.setType(type);
        up.setRequest(req);
        up.setFileDescription(pathEnum.getDesc());
        up.setUploadDir(uploadDir);
        ResponseData data = new ResponseData();
        try {
            UploadState state = up.getUploadState();
            if (state != UploadState.UPLOAD_SUCCSSS) {
                data.setState(ResponseStateEnum.fail);
                data.setContent(state.getState());
                return data;
            }
            String ossfile = null;
            if (this.ossClientBean != null && this.ossClientBean.isAsynch()) {
                String fullname = StringUtils.isEmpty((CharSequence)FilenameUtils.getExtension((String)up.getOriginalFilename())) ? up.getOriginalFilename() : up.getOriginalFilename();
                ossfile = this.ossClientBean.OSSPutObject(up.getFileName(), up.getFile(), uploadDir, fullname, filehash);
            } else {
                String configDataDir;
                Object pathFileName = up.getRealPath() + up.getFileName();
                ossfile = ((String)(pathFileName = ((String)pathFileName).replaceAll("\\\\", "/"))).replaceAll(configDataDir = AppConfigHolder.getConfig("ossclient.ossdir"), "");
                if (StringUtils.isNotBlank((CharSequence)ossfile) && ossfile.startsWith("/")) {
                    ossfile = ossfile.substring(1);
                }
            }
            SysFileModel file = new SysFileModel();
            file.setFileName(up.getOriginalFilename());
            file.setFileSize("" + up.getFilesize());
            file.setFileExt(up.getFileExt());
            file.setFileHash(filehash);
            file.setCreatorIp(StringUtils.getRemoteAddr((HttpServletRequest)req));
            file.setOssUrl(ossfile);
            file.setDescription(pathEnum.getDesc());
            file.setResource(Integer.valueOf(FileResourceEnum.companyHealth_07.getValue()));
            if (StringUtils.isEmpty((CharSequence)ossfile)) {
                file.setOssUrl(StringUtils.local2url((String)up.getRealPath(), (String)UploadFileParameter.FILE_PATH));
            }
            file = this.fileService.addSysFile(file, loginStaffId, cid);
            if (this.isActualize()) {
                String baseURL = req.getScheme() + "://" + req.getServerName() + ":" + req.getServerPort() + req.getContextPath();
                file.setFullPath(baseURL + "/file/downloadLocal/" + file.getId());
            }
            data.setResult((Object)file);
            data.setContent(up.getUploadState().getState());
            data.setState(ResponseStateEnum.success);
        }
        catch (Exception e) {
            e.printStackTrace();
            data.setState(ResponseStateEnum.fail);
            data.setContent("\u6587\u4ef6\u4e0a\u4f20\u51fa\u9519\uff01");
            return data;
        }
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"check/{filehash}"}, method={RequestMethod.POST})
    public ResponseData<SysFileModel> ajax_check_filemd5(@PathVariable(value="filehash") String filehash, HttpServletRequest req) throws Exception {
        this.logger.info("\u3010\u7cfb\u7edf\u9644\u4ef6\u3011->\u3010\u9a8c\u8bc1{}\u3011", (Object)filehash);
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        SysFileModel record = this.fileService.getFileByCid(cid, filehash);
        ResponseData data = new ResponseData();
        if (record != null) {
            String filename = req.getParameter("filename");
            if (!record.getFileName().equals(filename)) {
                if (StringUtils.isNotBlank((CharSequence)filename) && filename.indexOf(".") > -1) {
                    String fileNameNoEx = FilenameUtils.getBaseName((String)filename);
                    String ex = filename.replace(fileNameNoEx + ".", "");
                    record.setFileExt(ex);
                }
                record.setId(null);
                record.setFileName(filename);
                record.setCreatorIp(StringUtils.getRemoteAddr((HttpServletRequest)req));
                record = this.fileService.addSysFile(record, loginStaffId, cid);
            }
            data.setResult((Object)record);
            data.setState(ResponseStateEnum.success);
        } else {
            data.setState(ResponseStateEnum.warning);
        }
        return data;
    }

    @Log(title="\u4e0b\u8f7d\u9644\u4ef6", type=25)
    @RequestMapping(value={"download/{fileid}"})
    public String fileDownload(@PathVariable Long fileid, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.logger.info("\u3010\u7cfb\u7edf\u9644\u4ef6\u3011  fileid={}", (Object)fileid);
        if (this.ossClientBean == null || !this.ossClientBean.isAsynch()) {
            String forwardUrl = "forward:/" + this.ossClientBean.getAdminPath() + "/file/downloadLocal/" + fileid;
            return forwardUrl;
        }
        SysFileModel f = SysFileUtil.getFileById(fileid);
        if (f == null) {
            return "file_404";
        }
        String url = this.ossClientBean.getUrl(f.getOssUrl());
        response.setHeader("Referer", "ohonline.oss-cn-hangzhou-zwynet-d01-a.internet.cloud.zj.gov.cn");
        response.sendRedirect(url);
        return null;
    }

    @ResponseBody
    @RequestMapping(value={"getVideoTime"}, method={RequestMethod.POST})
    public String getVideoTime(Long fileId) throws IOException {
        SysFileModel record = this.fileService.getFileById(fileId);
        File file = this.ossClientBean.downloadTempFileFromOss(record.getDestPath(), record.getFileExt());
        if (file != null) {
            try {
                MultimediaInfo m = new MultimediaObject(file).getInfo();
                file.delete();
                return String.valueOf(new BigDecimal((float)m.getDuration() / 1000.0f).setScale(0, 4));
            }
            catch (Exception e) {
                return "0";
            }
        }
        return "0";
    }

    @Log(title="\u4e0b\u8f7d\u672c\u5730\u9644\u4ef6", type=25)
    @RequestMapping(value={"downloadLocal/{fileid}"})
    public void downloadLocal(@PathVariable Long fileid, HttpServletRequest request, HttpServletResponse response) throws IOException {
        SysFileModel f = SysFileUtil.getFileById(fileid);
        if (f == null) {
            throw new HealthException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6587\u4ef6");
        }
        Object realPath = AppConfigHolder.getConfig("ossclient.ossdir");
        realPath = StringUtils.isBlank((CharSequence)realPath) ? request.getSession().getServletContext().getRealPath("/") : (String)realPath + File.separator;
        OutputStream os = null;
        InputStream inputStream = null;
        try {
            int length;
            this.logger.debug((String)realPath + f.getOssUrl());
            inputStream = new FileInputStream((String)realPath + f.getDestPath());
            os = response.getOutputStream();
            ServletsUtil.setFileDownloadHeader((HttpServletResponse)response, (String)f.getFileName(), (HttpServletRequest)request);
            byte[] b = new byte[2048];
            while ((length = inputStream.read(b)) > 0) {
                os.write(b, 0, length);
            }
        }
        catch (FileNotFoundException fe) {
            this.logger.error("\u7cfb\u7edf\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6587\u4ef6:{}", (Object)((String)realPath + f.getDestPath()));
            response.setCharacterEncoding("UTF-8");
            response.setContentType("text/json; charset=UTF-8");
            ServletOutputStream output = response.getOutputStream();
            output.write("\u7cfb\u7edf\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6587\u4ef6".getBytes(StandardCharsets.UTF_8));
            output.flush();
            output.close();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (os != null) {
                os.flush();
                os.close();
            }
        }
    }

    @Log(title="\u4e0b\u8f7d\u672c\u5730\u9644\u4ef6", type=25)
    @RequestMapping(value={"downloadLocalByUrl"})
    public void downloadLocalByUrl(String url, HttpServletRequest request, HttpServletResponse response) throws IOException {
        SysFileModel sf;
        Object realPath = AppConfigHolder.getConfig("ossclient.ossdir");
        realPath = StringUtils.isBlank((CharSequence)realPath) ? request.getSession().getServletContext().getRealPath("/") : (String)realPath + "/";
        if (StringUtils.isNotBlank((CharSequence)url) && url.indexOf("?") > 0) {
            url = url.substring(0, url.indexOf("?"));
        }
        if ((sf = this.fileService.getFileByUrl(url)) != null) {
            ServletsUtil.setFileDownloadHeader((HttpServletResponse)response, (String)sf.getFileName(), (HttpServletRequest)request);
        }
        OutputStream os = null;
        InputStream inputStream = null;
        try {
            int length;
            File f = new File((String)realPath + url);
            inputStream = new FileInputStream(f);
            if (sf == null) {
                ServletsUtil.setFileDownloadHeader((HttpServletResponse)response, (String)f.getName(), (HttpServletRequest)request);
            }
            os = response.getOutputStream();
            byte[] b = new byte[2048];
            while ((length = inputStream.read(b)) > 0) {
                os.write(b, 0, length);
            }
        }
        catch (FileNotFoundException fe) {
            throw new HealthException("\u7cfb\u7edf\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6587\u4ef6");
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (os != null) {
                os.flush();
                os.close();
            }
        }
    }

    @Log(title="\u4e0b\u8f7d\u5916\u7f51\u9644\u4ef6", type=25)
    @RequestMapping(value={"downloadOutUrl"})
    public void downloadOutUrl(String url, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String noQueryUrl = url.substring(0, url.contains("?") ? url.indexOf("?") : url.length());
        String fileName = noQueryUrl.substring(noQueryUrl.lastIndexOf("/") + 1);
        String suffixName = "";
        if (!fileName.contains(".") && (fileName.endsWith("doc") || fileName.endsWith("docx"))) {
            if (fileName.endsWith("doc")) {
                suffixName = "doc";
            } else if (fileName.endsWith("docx")) {
                suffixName = "docx";
            }
        }
        suffixName = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
        File destFile = null;
        OutputStream os = null;
        InputStream inputStream = null;
        try {
            int length;
            destFile = File.createTempFile(UUID.randomUUID().toString(), suffixName);
            HttpUtil.downloadFile((String)url, (File)destFile);
            ServletsUtil.setFileDownloadHeader((HttpServletResponse)response, (String)fileName, (HttpServletRequest)request);
            inputStream = new FileInputStream(destFile);
            os = response.getOutputStream();
            byte[] b = new byte[2048];
            while ((length = inputStream.read(b)) > 0) {
                os.write(b, 0, length);
            }
        }
        catch (Exception e) {
            this.logger.error("\u8f6c\u6362\u5f02\u5e38\uff1a", (Throwable)e);
            throw e;
        }
        finally {
            if (destFile != null) {
                destFile.delete();
            }
            if (inputStream != null) {
                inputStream.close();
            }
            if (os != null) {
                os.flush();
                os.close();
            }
        }
    }

    @RequestMapping(value={"onlineView"})
    public String onlineViewFile(@RequestParam(value="fileId") Long fileId, @RequestParam(value="fileType", required=false) String fileType, ModelMap m, HttpServletRequest req) throws Exception {
        if (fileId == null) {
            return null;
        }
        Object ossUrl = "";
        SysFileModel file = this.fileService.getFileById(fileId);
        if (this.isActualize()) {
            String baseURL = req.getScheme() + "://" + req.getServerName() + ":" + req.getServerPort() + req.getContextPath();
            ossUrl = baseURL + "/file/downloadLocal/" + fileId;
        } else {
            ossUrl = file.getOssUrl();
        }
        String fileName = StringUtils.deleteWhitespace((String)file.getFileName());
        fileName = URLEncoder.encode(fileName, "UTF-8");
        ossUrl = ((String)ossUrl).indexOf("?") > -1 ? (String)ossUrl + "&fullfilename=" + fileName + "&fileType=" + fileType : (String)ossUrl + "?fullfilename=" + fileName + "&fileType=" + fileType;
        Object redirectUrl = "";
        if (StringUtils.isNotBlank((CharSequence)this.previewServUrl)) {
            JSONObject jsonObject = new JSONObject();
            Date date = DateUtils.addMinute((Date)new Date(), (int)30);
            jsonObject.put("expieTime", (Object)date.getTime());
            String secMsg = NoSpecalCrypUtil.encrypt((String)jsonObject.toJSONString(), (String)this.aesKey);
            ossUrl = Base64.getUrlEncoder().withoutPadding().encodeToString(((String)ossUrl).getBytes(StandardCharsets.UTF_8));
            redirectUrl = this.previewServUrl + "?token=" + secMsg + "&url=" + (String)ossUrl + "&fileType=" + fileType;
        } else {
            redirectUrl = ossUrl;
        }
        return "redirect:" + (String)redirectUrl;
    }

    @RequestMapping(value={"picView"})
    public String picDialogModal(@RequestParam(value="fileId") Long fileId, ModelMap m, HttpServletRequest req) {
        if (this.isActualize()) {
            SysFileModel f = SysFileUtil.getFileById(fileId);
            String baseURL = req.getScheme() + "://" + req.getServerName() + ":" + req.getServerPort() + req.getContextPath();
            m.put((Object)"ossUrl", (Object)(baseURL + "/file/downloadLocal/" + fileId));
            return "plugIns/pictureDialogModal";
        }
        SysFileModel file = this.fileService.getFileById(fileId);
        String ossUrl = file.getOssUrl();
        m.put((Object)"ossUrl", (Object)ossUrl);
        return "plugIns/pictureDialogModal";
    }

    @RequestMapping(value={"getPicUrl"})
    @ResponseBody
    public ResponseData<String> getPicUrl(@RequestParam(value="fileId") Long fileId, ModelMap m) {
        ResponseData data = new ResponseData();
        SysFileModel file = this.fileService.getFileById(fileId);
        String ossUrl = file.getOssUrl();
        data.setResult((Object)ossUrl);
        return data;
    }
}

