/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.tools;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.modules.platform.model.AreaVo2;
import cn.smarthse.modules.platform.model.SysAreaModel;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/ajax/district"})
public class DistrictController
extends ControllerSupport {
    @DubboReference(version="1.0.0")
    ISysAreaProvideService sysAreaProvideService;

    @ResponseBody
    @RequestMapping(value={"province"}, method={RequestMethod.GET})
    public ResponseData<List<AreaModel>> getProvinceList() {
        this.logger.debug("\u8bfb\u53d6\u6240\u6709\u7684\u7701\u4efd");
        ResponseData result = new ResponseData();
        result.setResult((Object)this.sysAreaProvideService.getAllProvinceList());
        return result;
    }

    @ResponseBody
    @RequestMapping(value={"city/{provinceId}"}, method={RequestMethod.GET})
    public ResponseData<List<AreaModel>> getCityListById(@PathVariable(value="provinceId") Long provinceId) throws Exception {
        this.logger.debug("\u6839\u636e\u7701\u4efd\u83b7\u53d6\u5e02 provinceId\uff1a{}", (Object)provinceId);
        ResponseData result = new ResponseData();
        if (provinceId != null) {
            result.setResult((Object)this.sysAreaProvideService.getCityList(provinceId));
        }
        return result;
    }

    @ResponseBody
    @RequestMapping(value={"area/{cityId}"}, method={RequestMethod.GET})
    public ResponseData<List<AreaModel>> getAreaListById(@PathVariable(value="cityId") Long cityId) throws Exception {
        this.logger.debug("\u6839\u636e\u5e02\u83b7\u53d6\u533a cityId\uff1a" + cityId);
        ResponseData result = new ResponseData();
        if (cityId != null) {
            result.setResult((Object)this.sysAreaProvideService.getAreaList(cityId));
        }
        return result;
    }

    @ResponseBody
    @RequestMapping(value={"street/{areaId}"}, method={RequestMethod.GET})
    public ResponseData<List<AreaModel>> getStreetListById(@PathVariable(value="areaId") Long areaId) throws Exception {
        this.logger.debug("\u6839\u636e\u533a\u83b7\u53d6\u4e61\u6751\u8857\u9053 areaId\uff1a{}", (Object)areaId);
        ResponseData result = new ResponseData();
        if (areaId != null) {
            result.setResult((Object)this.sysAreaProvideService.getStreetList(areaId));
        }
        return result;
    }

    @ResponseBody
    @RequestMapping(value={"getUserAreaData"}, method={RequestMethod.GET})
    public List<AreaVo2> getUserAreaData(Long parentId) throws Exception {
        Long areaId = UserUtils.getCurrentCompanyFromDataCenter().getAreaId();
        if (parentId != null) {
            areaId = parentId;
        }
        ArrayList<AreaVo2> vo2List = new ArrayList<AreaVo2>();
        if (areaId == 0L) {
            List allProvinceList = this.sysAreaProvideService.getAllProvinceList();
            for (AreaModel areaModel : allProvinceList) {
                AreaVo2 vo2 = new AreaVo2();
                vo2.setId(areaModel.getId());
                vo2.setLabel(areaModel.getName());
                vo2.setValue("" + areaModel.getId());
                vo2.setLeaf(false);
                vo2.setLevel(1);
                vo2List.add(vo2);
            }
            return vo2List;
        }
        List areaModelList = this.sysAreaProvideService.getChildByParentId(areaId, "");
        if (CollectionUtils.isNotEmpty((Collection)areaModelList)) {
            List<AreaVo2> collect = areaModelList.stream().map(a -> {
                AreaVo2 areaVo2 = new AreaVo2();
                areaVo2.setValue("" + a.getId());
                areaVo2.setLevel((int)a.getLevel().byteValue());
                if (a.getLevel() != null && a.getLevel() < 4) {
                    areaVo2.setLeaf(false);
                } else {
                    areaVo2.setLeaf(true);
                }
                areaVo2.setLabel(a.getName());
                return areaVo2;
            }).collect(Collectors.toList());
            return collect;
        }
        return Collections.emptyList();
    }

    @ResponseBody
    @RequestMapping(value={"getChildByParentId"}, method={RequestMethod.GET})
    public List<SysAreaModel> getChildByParentId(Long id, Long parentId, String areaName) throws Exception {
        this.logger.debug("\u6839\u636eparentId \u83b7\u53d6\u5b50\u8282\u70b9  id\uff1a{}", (Object)id);
        if (id == null && parentId != null) {
            id = parentId;
        }
        List sysAreaList = this.sysAreaProvideService.getChildByParentId(id, areaName);
        ArrayList<SysAreaModel> sysAreaModels = new ArrayList<SysAreaModel>();
        if (CommonUtil.listIsNotEmpty((List)sysAreaList)) {
            sysAreaList.forEach(en -> {
                SysAreaModel model = new SysAreaModel();
                BeanUtils.copyProperties((Object)en, (Object)model);
                model.setAreaLevel(en.getLevel());
                if (en.getLevel() == 1) {
                    model.setName(en.getProvinceName());
                } else if (en.getLevel() == 2) {
                    model.setName(en.getCityName());
                } else if (en.getLevel() == 3) {
                    model.setName(en.getAreaName());
                } else if (en.getLevel() == 4) {
                    model.setName(en.getStreetName());
                }
                if (en.getLevel() < 4) {
                    model.setIsParent(Boolean.valueOf(true));
                } else {
                    model.setIsParent(Boolean.valueOf(false));
                }
                sysAreaModels.add(model);
            });
        }
        return sysAreaModels;
    }
}

