/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.thirdorg;

import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrgQualification;
import cn.smarthse.modules.health.thirdOrganization.model.org.OrgQueryParamModel;
import cn.smarthse.modules.health.thirdOrganization.model.org.SuperviseOrgListVo;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrgQualificationService;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.web.controller.thirdorg.BaseOrgController;
import cn.smarthse.web.controller.thirdorg.ThirdOrgManageControllerHelper;
import cn.smarthse.web.util.SysFileUtil;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/thirdOrg"})
public class ThirdOrgManageController
extends BaseOrgController {
    @DubboReference
    private IThirdOrgQualificationService thirdOrgQualificationService;
    @DubboReference(timeout=5000000)
    private ISysFileProvideService sysfileService;
    @Autowired
    private ThirdOrgManageControllerHelper helper;

    @RequestMapping(value={"/detectionOrg"})
    public String detectionOrg(Model model) {
        return "thirdOrg/detectionOrgListV1_6";
    }

    @RequestMapping(value={"/examOrg"})
    public String examOrg(Model model) {
        AreaModel area = this.getCurrentComArea();
        Long provinceId = area.getProvinceId();
        Long cityId = area.getCityId();
        Long areaId = area.getAreaId();
        model.addAttribute("provinceId", provinceId == null ? "" : provinceId);
        model.addAttribute("cityId", cityId == null ? "" : cityId);
        model.addAttribute("areaId", areaId == null ? "" : areaId);
        return "thirdOrg/examOrgList";
    }

    @RequestMapping(value={"/trainOrg"})
    public String trainOrg(Model model) {
        AreaModel area = this.getCurrentComArea();
        Long provinceId = area.getProvinceId();
        Long cityId = area.getCityId();
        Long areaId = area.getAreaId();
        model.addAttribute("provinceId", provinceId == null ? "" : provinceId);
        model.addAttribute("cityId", cityId == null ? "" : cityId);
        model.addAttribute("areaId", areaId == null ? "" : areaId);
        return "thirdOrg/trainOrgList";
    }

    @RequestMapping(value={"/thirdOrgList.json"})
    @ResponseBody
    public JqGridData<SuperviseOrgListVo> thirdOrgList(OrgQueryParamModel queryModel, Byte ownLevel) {
        PageInfo<SuperviseOrgListVo> pageInfo = this.helper.examOrgPageInfo(queryModel);
        JqGridParam param = new JqGridParam();
        param.setPage(queryModel.getPage().intValue());
        param.setRows(queryModel.getRows().intValue());
        return new JqGridData(pageInfo, param);
    }

    @RequestMapping(value={"/detectionOrgListV1_6.json"})
    @ResponseBody
    public JqGridData<SuperviseOrgListVo> detectionOrgList(OrgQueryParamModel queryModel) {
        PageInfo<SuperviseOrgListVo> pageInfo = this.helper.detectionOrgPageInfo(queryModel);
        JqGridParam param = new JqGridParam();
        param.setPage(queryModel.getPage().intValue());
        param.setRows(queryModel.getRows().intValue());
        return new JqGridData(pageInfo, param);
    }

    @RequestMapping(value={"/trainOrgList.json"})
    @ResponseBody
    public JqGridData<SuperviseOrgListVo> trainOrgList(OrgQueryParamModel queryModel, Byte ownLevel) {
        PageInfo<SuperviseOrgListVo> pageInfo = this.helper.trainOrgPageInfo(queryModel);
        JqGridParam param = new JqGridParam();
        param.setPage(queryModel.getPage().intValue());
        param.setRows(queryModel.getRows().intValue());
        return new JqGridData(pageInfo, param);
    }

    @RequestMapping(value={"/export"})
    public void export(HttpServletResponse response, OrgQueryParamModel queryModel, Byte ownLevel) throws IOException, ExecutionException, InterruptedException {
        queryModel.setPage(Integer.valueOf(1));
        queryModel.setRows(Integer.valueOf(Integer.MAX_VALUE));
        Object fileName = "\u7b2c\u4e09\u65b9\u673a\u6784-";
        String[] colums = null;
        PageInfo<SuperviseOrgListVo> pageInfo = null;
        if (queryModel.getOrgTypes() != null) {
            if (queryModel.getOrgTypes().equals("2")) {
                fileName = (String)fileName + "\u4f53\u68c0\u673a\u6784.xls";
                colums = new String[]{"\u540d\u79f0|name", "\u672c\u5e74\u5ea6\u4e0a\u62a5\u4f53\u68c0\u9879\u76ee\u6570|examReportNum", "\u6cd5\u5b9a\u4ee3\u8868\u4eba|legalPerson", "\u6cd5\u5b9a\u4ee3\u8868\u4eba\u7535\u8bdd|legalPersonPhone", "\u7701\u4efd|provinceName", "\u57ce\u5e02|cityName", "\u5730\u5740|address", "\u8d26\u53f7|username"};
                pageInfo = this.helper.examOrgPageInfo(queryModel);
            } else if (queryModel.getOrgTypes().equals("4")) {
                fileName = (String)fileName + "\u8bca\u65ad\u673a\u6784.xls";
                colums = new String[]{"\u673a\u6784\u540d\u79f0|name", "\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801|creditCode", "\u6cd5\u5b9a\u4ee3\u8868\u4eba|legalPerson", "\u6cd5\u5b9a\u4ee3\u8868\u4eba\u7535\u8bdd|legalPersonPhone", "\u8054\u7cfb\u4eba|contactName", "\u8054\u7cfb\u4eba\u7535\u8bdd|contactPhone", "\u673a\u6784\u5730\u5740|address", "\u8bca\u65ad\u9879\u76ee|diagnoseProjects"};
            } else if (queryModel.getOrgTypes().equals("8")) {
                fileName = (String)fileName + "\u9274\u5b9a\u673a\u6784.xls";
                colums = new String[]{"\u673a\u6784\u540d\u79f0|name", "\u8054\u7cfb\u4eba|contactName", "\u8054\u7cfb\u4eba\u7535\u8bdd|contactPhone", "\u5730\u673a\u6784\u5740|address"};
            } else if (queryModel.getOrgTypes().equals("1")) {
                fileName = (String)fileName + "\u68c0\u6d4b\u8bc4\u4ef7\u673a\u6784.xls";
                colums = new String[]{"\u540d\u79f0|name", "\u8d44\u8d28\u7b49\u7ea7(0:\u65e0\uff0c1\uff1a\u7532\u7ea7\uff0c2\uff1a\u4e59\u7ea7\uff0c3\uff1a\u4e19\u7ea7)|level", "\u6cd5\u5b9a\u4ee3\u8868\u4eba|legalPerson", "\u672c\u5e74\u5ea6\u4e0a\u62a5\u68c0\u6d4b\u6570|checkNum", "\u672c\u5e74\u5ea6\u4e0a\u62a5\u73b0\u72b6\u8bc4\u4ef7\u9879\u76ee\u6570|nowEvaluateNum", "\u672c\u5e74\u5ea6\u4e0a\u62a5\u9884\u63a7\u8bc4\u9879\u76ee\u6570|preEvaluateNum", "\u6cd5\u5b9a\u4ee3\u8868\u4eba\u7535\u8bdd|legalPersonPhone", "\u7701\u4efd|provinceName", "\u57ce\u5e02|cityName", "\u5730\u5740|address", "\u8d26\u53f7|username"};
                pageInfo = this.helper.detectionOrgPageInfo(queryModel);
            } else if (queryModel.getOrgTypes().equals("6")) {
                fileName = (String)fileName + "\u57f9\u8bad\u673a\u6784.xls";
                colums = new String[]{"\u673a\u6784\u540d\u79f0|name", "\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801|creditCode", "\u6cd5\u5b9a\u4ee3\u8868\u4eba|legalPerson", "\u6cd5\u5b9a\u4ee3\u8868\u4eba\u7535\u8bdd|legalPersonPhone", "\u8054\u7cfb\u4eba|contactName", "\u8054\u7cfb\u4eba\u7535\u8bdd|contactPhone", "\u673a\u6784\u5730\u5740|address"};
                pageInfo = this.helper.trainOrgPageInfo(queryModel);
            }
        }
        List dataList = pageInfo.getList();
        dataList.stream().forEach(u -> u.setAddress(u.getAddress().replaceAll(">", "")));
        response.setContentType("application/vnd.ms-excel");
        response.addHeader("Content-Disposition", "attachment; filename*=utf-8'zh_cn'" + URLEncoder.encode(new String(((String)fileName).getBytes()), "utf-8"));
        ExportExcel listexcel = new ExportExcel();
        listexcel.simpleExport2("\u7b2c\u4e09\u65b9\u673a\u6784", colums, dataList, (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"qualification.json"})
    @ResponseBody
    public JqGridData<ThirdOrgQualification> qualification(JqGridParam jqGridParam, Integer qType, Long id) {
        PageInfo pageInfo = this.thirdOrgQualificationService.queryPage(jqGridParam, id, qType);
        pageInfo.getList().forEach(thirdOrgQualification -> {
            thirdOrgQualification.setStrId(String.valueOf(thirdOrgQualification.getId()));
            List sysFiles = this.sysfileService.getListByIds(thirdOrgQualification.getSysFileIds());
            if (sysFiles == null) {
                return;
            }
            for (SysFileModel sysFile : sysFiles) {
                sysFile.setOssUrl(SysFileUtil.getFileUrl(sysFile.getOssUrl()));
            }
            thirdOrgQualification.setSysFiles(sysFiles);
        });
        return new JqGridData(pageInfo, jqGridParam);
    }

    @RequestMapping(value={"/detail"})
    public String detail(Model model, Long id, Integer type) {
        model.addAttribute("orgType", (Object)type);
        SuperviseOrgListVo org = this.thirdOrganizationService.getOrgDetailInfo(id);
        model.addAttribute("org", (Object)org);
        switch (type) {
            case 1: {
                return "thirdOrg/detectionOrgDetailV1_6";
            }
            case 2: {
                return "thirdOrg/examOrgDetail";
            }
            case 6: {
                return "thirdOrg/trainOrgDetail";
            }
        }
        return "thirdOrg/detectionOrgDetailV1_6";
    }
}

