/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.sys.message;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.health.entity.sys.message.Message;
import cn.smarthse.modules.health.entity.sys.message.MessageUser;
import cn.smarthse.modules.health.entity.sys.message.vo.MessageCount;
import cn.smarthse.modules.health.entity.sys.message.vo.MessageParam;
import cn.smarthse.modules.health.entity.work.reform.vo.CompanyTipsVo;
import cn.smarthse.modules.health.enums.sys.MessageBusinessFromEnum;
import cn.smarthse.modules.health.service.sys.message.IMessageService;
import cn.smarthse.modules.health.service.sys.message.IMessageUserService;
import cn.smarthse.modules.health.service.work.reform.ICompanyRiskProspectService;
import cn.smarthse.web.controller.CacheControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.smarthse.exception.ServiceException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/sys/message"})
public class MessageController
extends CacheControllerSupport {
    @DubboReference
    private IMessageService messageService;
    @DubboReference
    private IMessageUserService messageUserService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    private static final String MESSAGE_CACHENAME = "message_cache_name";
    @DubboReference(version="1.0.0")
    private ICompanyRiskProspectService companyRiskProspectService;

    @GetMapping(value={"training"})
    @RequiresPermissions(value={"onlineTrainMessage"})
    public String trainingIndex() {
        return "sys/message/train/trainIndex";
    }

    @ResponseBody
    @GetMapping(value={"trainingListData"})
    public JqGridData<Message> trainingMessageListData(Byte type, JqGridParam param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        Integer bussinesFromType = MessageBusinessFromEnum.onlineTraining.getValue();
        CompanySuperviseModel company = this.companyProvideBySuperviseService.getCompanyInfoById(cid);
        if (company == null) {
            return new JqGridData();
        }
        PageInfo listData = this.messageService.getTrainingMessageListData(type, cid, loginStaffId, param, company.getAreaDetailId(), bussinesFromType, Integer.valueOf(company.getBelongType() == null ? 0 : company.getBelongType()));
        return new JqGridData(listData, param);
    }

    @ResponseBody
    @PostMapping(value={"trainingViewStatue/{messageState}"})
    public ResponseData trainingViewState(@PathVariable(name="messageState") Byte messageState, @RequestBody List<Long> ids) {
        MessageUser messageUser = new MessageUser();
        messageUser.setMessageState(messageState);
        messageUser.setUpdateBy(UserUtils.getLoginStaffId());
        messageUser.setUpdateDate(new Date());
        Long loginStaffId = UserUtils.getLoginStaffId();
        Boolean b = this.messageUserService.changeMessageState(ids, messageUser, loginStaffId);
        return b != false ? new ResponseData(ResponseStateEnum.success) : new ResponseData(ResponseStateEnum.fail);
    }

    @ResponseBody
    @GetMapping(value={"trainingNoReadCount"})
    public List<MessageCount> trainingNoReadCount() throws ServiceException {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        MessageParam param = new MessageParam();
        param.setCid(cid);
        param.setUserId(staffId);
        param.setBussinesFromType(MessageBusinessFromEnum.onlineTraining.getValue());
        List noReadCount = this.messageUserService.getNoReadCountBy(param);
        this.logger.info("\u83b7\u53d6\u672a\u8bfb\u57f9\u8bad\u4fe1\u606f\u2014\u2014>\u4f01\u4e1aid:{},\u5458\u5de5id:{},\u672a\u8bfb\u5728\u7ebf\u57f9\u8bad\u6d88\u606f\u76f8\u5173\u5185\u5bb9:{}", new Object[]{cid, staffId, noReadCount});
        return noReadCount;
    }

    @RequestMapping(value={""}, method={RequestMethod.GET})
    public String index(Byte type, Model model) {
        model.addAttribute("type", (Object)type);
        return "sys/message/list";
    }

    @RequestMapping(value={"notice/view"}, method={RequestMethod.GET})
    public String noticeView(Long id, Model model) {
        Message message = this.messageService.getById(id);
        message.setBussinessContent(StringEscapeUtils.unescapeHtml((String)message.getBussinessContent()));
        model.addAttribute("message", (Object)message);
        return "sys/message/notice";
    }

    @ResponseBody
    @RequestMapping(value={"listData"})
    public JqGridData<Message> listData(HttpSession session, JqGridParam param, MessageParam query) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        query.setCid(cid);
        query.setUserId(UserUtils.getLoginStaffId());
        PageInfo list = this.messageService.getPage(param, query);
        return new JqGridData(list, param);
    }

    @ResponseBody
    @RequestMapping(value={"del"}, method={RequestMethod.POST})
    public ResponseData<Long> ajax_del(Long id) throws ServiceException {
        this.logger.info("ajax-\u7cfb\u7edf\u7ba1\u7406\u300b\u89d2\u8272\u7ba1\u7406\u300b\u7f16\u8f91");
        Long loginStaffId = UserUtils.getLoginStaffId();
        this.messageService.deleteById(id, loginStaffId);
        ResponseData resultData = new ResponseData(ResponseStateEnum.success);
        resultData.setResult((Object)id);
        return resultData;
    }

    @ResponseBody
    @RequestMapping(value={"count"})
    public List<MessageCount> ajax_list() throws ServiceException {
        this.logger.info("ajax-\u7cfb\u7edf\u7ba1\u7406\u300b\u7cfb\u7edf\u6d88\u606f\u300b\u6d88\u606f\u5217\u8868");
        MessageParam param = new MessageParam();
        param.setCid(UserUtils.getLoginStaffCompanyId());
        param.setUserId(UserUtils.getLoginStaffId());
        List list = this.getCacheData(MESSAGE_CACHENAME, this.generateCacheKey("getUnreadMessageCount", UserUtils.getLoginStaffCompanyId(), UserUtils.getLoginStaffId()), () -> this.messageService.getUnreadMessageCount(param), 300);
        return list;
    }

    @RequestMapping(value={"evaluate/view"}, method={RequestMethod.GET})
    public String evaluateView(Long id, Model model, HttpServletRequest req) {
        Message message = this.messageService.getById(id);
        model.addAttribute("message", (Object)message);
        return "sys/message/evaluate";
    }

    @RequestMapping(value={"scene/view"}, method={RequestMethod.GET})
    public String sceneView(Long id, Model model, HttpServletRequest req) {
        Message message = this.messageService.getById(id);
        if (message != null) {
            message.setBussinessContent(StringEscapeUtils.unescapeHtml((String)message.getBussinessContent()));
        }
        model.addAttribute("message", (Object)message);
        return "sys/message/scene";
    }

    @RequestMapping(value={"workPlan/view"}, method={RequestMethod.GET})
    public String workPlan(Long id, Model model, HttpServletRequest req) {
        Message message = this.messageService.getById(id);
        model.addAttribute("message", (Object)message);
        return "sys/message/workPlan";
    }

    @GetMapping(value={"/riskResolution/prePushRisk"})
    public String riskForesightIndex() {
        return "views/riskMitigationManagement/prePushRisk/index";
    }

    @ResponseBody
    @GetMapping(value={"/getRiskForesight"})
    public ResponseData<List<CompanyTipsVo>> getRiskForesight(String riskType, String riskName, String restTime) {
        Long cid = UserUtils.getLoginStaff().getCid();
        List companyTips = this.companyRiskProspectService.getCompanyTips(cid, Integer.valueOf(1));
        if (companyTips == null) {
            return ResponseData.fail((String)"\u672a\u67e5\u5230\u6570\u636e");
        }
        for (CompanyTipsVo companyTip : companyTips) {
            LocalDate fistWarningTime = LocalDate.parse(companyTip.getDate(), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            companyTip.setTipsTime(fistWarningTime.minusMonths(1L).format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            LocalDate now = LocalDate.now();
            companyTip.setRestTime(Long.valueOf(ChronoUnit.DAYS.between(now, fistWarningTime)));
        }
        if (riskType != null && !riskType.isEmpty()) {
            Byte type = Byte.parseByte(riskType);
            companyTips = companyTips.stream().filter(tip -> type.equals(tip.getRiskType())).collect(Collectors.toList());
        }
        if (riskName != null && !riskName.isEmpty()) {
            companyTips = companyTips.stream().filter(tip -> tip.getName() != null && tip.getName().contains(riskName)).collect(Collectors.toList());
        }
        if (restTime != null && !restTime.isEmpty()) {
            int time = Integer.parseInt(restTime);
            companyTips = companyTips.stream().filter(tip -> tip.getRestTime() != null && tip.getRestTime() < (long)time).collect(Collectors.toList());
        }
        return ResponseData.success((Object)companyTips);
    }
}

