/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.sys.legal;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.health.entity.sys.SysParam;
import cn.smarthse.modules.health.entity.sys.legal.SysLegal;
import cn.smarthse.modules.health.entity.sys.legal.SysLegalUploadFile;
import cn.smarthse.modules.health.enums.syslegal.SysLegalTypeEnum;
import cn.smarthse.modules.health.service.base.ICompanyService;
import cn.smarthse.modules.health.service.sys.ISysParamService;
import cn.smarthse.modules.health.service.sys.legal.ISysLegalService;
import cn.smarthse.modules.health.service.sys.legal.ISysLegalUploadFileService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/sys/legal"})
public class SysLegalController
extends ControllerSupport {
    @DubboReference
    ISysLegalService sysLegalServiceImpl;
    @DubboReference
    ISysLegalUploadFileService sysLegalUploadFileServiceImpl;
    @DubboReference
    ICompanyService companyService;
    @DubboReference
    private ISysParamService sysParamService;
    @DubboReference(version="1.0.0")
    ICompanyProvideByHSEService companyProvideByHSEService;

    @RequiresPermissions(value={"base.legal.view"})
    @RequestMapping(method={RequestMethod.GET})
    public String page_List(Model model) {
        this.logger.info("\u6cd5\u5f8b\u6cd5\u89c4\u300b\u6cd5\u5f8b\u6cd5\u89c4\u5217\u8868");
        return "sys/legal/list";
    }

    @RequiresPermissions(value={"base.legal.view"})
    @ResponseBody
    @RequestMapping(value={"listData"})
    public JqGridData<SysLegal> listData(JqGridParam param) {
        this.logger.info(param.toString());
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        String typeCode = null;
        CompanyBaseInfoModel companyBaseInfoModel = this.companyProvideByHSEService.getCompanyById(cid);
        if (companyBaseInfoModel != null && companyBaseInfoModel.getIndustryCategory() != null) {
            SysParam comIndustryCategory = (SysParam)this.sysParamService.getById(companyBaseInfoModel.getIndustryCategory());
            typeCode = comIndustryCategory.getParamCode();
        }
        PageInfo list = this.sysLegalServiceImpl.getSysLegalListByGridParam(param, typeCode);
        JqGridData data = new JqGridData(list, param);
        return data;
    }

    @RequiresPermissions(value={"base.legal.view"})
    @RequestMapping(value={"viewsearchfeedback"}, method={RequestMethod.GET})
    public String page_viewSearchFeedback() {
        this.logger.info("\u6cd5\u5f8b\u6cd5\u89c4\u300b\u5217\u8868\u53cd\u9988");
        return "sys/legal/dialog_searchFeedback";
    }

    @RequiresPermissions(value={"base.legal.view"})
    @RequestMapping(value={"viewlistfeedback"}, method={RequestMethod.GET})
    public String page_viewListFeedback(Long id, Integer fromTable, Model model) {
        this.logger.info("\u6cd5\u5f8b\u6cd5\u89c4\u300b\u5217\u8868\u53cd\u9988");
        model.addAttribute("legalId", (Object)id);
        model.addAttribute("fromTable", (Object)fromTable);
        return "sys/legal/dialog_listFeedback";
    }

    @RequiresPermissions(value={"base.legal.edit"})
    @RequestMapping(value={"viewfileup"}, method={RequestMethod.GET})
    public String page_viewFileUp(Long id, Integer fromTable, Model model) {
        this.logger.info("\u6cd5\u5f8b\u6cd5\u89c4\u300b\u4e0a\u4f20\u9644\u4ef6");
        model.addAttribute("id", (Object)id);
        model.addAttribute("fromTable", (Object)fromTable);
        return "sys/legal/dialog_fileUp";
    }

    @Log(title="\u6cd5\u5f8b\u6cd5\u89c4\u4e0a\u4f20\u9644\u4ef6", type=26)
    @RequiresPermissions(value={"base.legal.edit"})
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"fileup"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_fileUp(Long id, Integer fromTable, Long[] fileId2) {
        this.logger.info("ajax-\u6cd5\u5f8b\u6cd5\u89c4\u300b\u4e0a\u4f20\u9644\u4ef6");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData r = new ResponseData();
        if (id == null) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u65e0\u6cd5\u83b7\u53d6\u8be5\u6761\u6570\u636e");
            return r;
        }
        if (fileId2.length == 0) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u9009\u62e9\u9700\u8981\u4e0a\u4f20\u7684\u9644\u4ef6\u540e,\u8bf7\u7b49\u5f85\u8fdb\u5ea6\u6761\u5b8c\u6210");
            return r;
        }
        this.sysLegalUploadFileServiceImpl.addFile(id, fromTable, fileId2, cid, staffid);
        return r;
    }

    @Log(title="\u6cd5\u5f8b\u6cd5\u89c4\u5220\u9664\u9644\u4ef6", type=22)
    @RequiresPermissions(value={"base.legal.edit"})
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"delfile"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_delFile(Long id, Long fileId) {
        this.logger.info("ajax-\u6cd5\u5f8b\u6cd5\u89c4\u300b\u5220\u9664\u9644\u4ef6");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData r = new ResponseData();
        if (id != null && fileId != null) {
            List list = this.sysLegalUploadFileServiceImpl.getByLegalIdAndFileId(cid, id, fileId);
            if (list.size() > 0) {
                SysLegalUploadFile sysLegalUploadFile = (SysLegalUploadFile)list.get(0);
                sysLegalUploadFile.setIsValid(Boolean.valueOf(false));
                this.sysLegalUploadFileServiceImpl.update((Object)sysLegalUploadFile, staffid);
            }
        } else {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u65e0\u6cd5\u83b7\u53d6\u8be5\u6761\u6570\u636e");
            return r;
        }
        return r;
    }

    @Log(title="\u6cd5\u5f8b\u6cd5\u89c4\u5bfc\u51fa", type=24)
    @RequiresPermissions(value={"base.legal.view"})
    @RequestMapping(value={"/legalexport"})
    public void legalExport(HttpServletResponse response) throws Exception {
        this.logger.info("ajax-\u3010\u6cd5\u5f8b\u6cd5\u89c4\u3011-\u5bfc\u51faExcel");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u6cd5\u5f8b\u6cd5\u89c4\u6807\u51c6\u6e05\u5355" + dateFormat.format(new Date()) + ".xls";
        String[] colums = new String[]{"\u540d\u79f0|title", "\u7c7b\u522b|typeName", "\u6587\u53f7|fileNo", "\u9881\u5e03\u90e8\u95e8|departmentIssued", "\u5b9e\u65bd\u65e5\u671f|date", "\u72b6\u6001|statusName"};
        Long cid = UserUtils.getLoginStaffCompanyId();
        List list = this.sysLegalServiceImpl.getSysLegalListByFocus(cid);
        for (SysLegal sysLegal : list) {
            sysLegal.setDate(dateFormat.format(sysLegal.getExecuteDate()));
            if (sysLegal.getLastUpdateDate() == null || sysLegal.getLegalType().equals(SysLegalTypeEnum.type6.getValue()) || sysLegal.getLegalType().equals(SysLegalTypeEnum.type8.getValue()) || sysLegal.getLegalType().equals(SysLegalTypeEnum.type7.getValue())) continue;
            sysLegal.setDate(dateFormat.format(sysLegal.getLastUpdateDate()));
        }
        response.setContentType("application/vnd.ms-excel");
        response.addHeader("Content-Disposition", "attachment; filename*=utf-8'zh_cn'" + URLEncoder.encode(new String(fileName.getBytes()), "utf-8"));
        ExportExcel listexcel = new ExportExcel();
        listexcel.simpleExport2("\u6cd5\u5f8b\u6cd5\u89c4", colums, list, (OutputStream)response.getOutputStream());
    }
}

