/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.sys.dic;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.leak.ResponseLeakUtil;
import cn.smarthse.modules.health.entity.sys.dic.DicType;
import cn.smarthse.modules.health.entity.sys.dic.DicValue;
import cn.smarthse.modules.health.service.sys.dic.IDicTypeService;
import cn.smarthse.modules.health.service.sys.dic.IDicValueService;
import cn.smarthse.modules.health.vo.sys.dic.DicValueVo;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/sys/dicValue"})
public class DicValueController {
    @DubboReference
    private IDicValueService dicValueService;
    @DubboReference
    private IDicTypeService dicTypeService;

    @RequestMapping(value={"/index"}, method={RequestMethod.GET})
    public String index(Model model, Long dicId) {
        DicType dicType = (DicType)this.dicTypeService.getById(dicId);
        assert (dicType != null);
        model.addAttribute("dicType", (Object)dicType);
        return "sys/dic/valueIndex";
    }

    @RequestMapping(value={"/dicValue"}, method={RequestMethod.GET})
    public String dicValue(Model model, Long id, Long dicId) {
        DicType dicType = (DicType)this.dicTypeService.getById(dicId);
        model.addAttribute("dicType", (Object)dicType);
        if (id != null) {
            DicValue dicValue = (DicValue)this.dicValueService.getById(id);
            model.addAttribute("dicValue", (Object)dicValue);
            if (dicValue.getPid() != null) {
                DicValue parent = (DicValue)this.dicValueService.getById(dicValue.getPid());
                model.addAttribute("parent", (Object)parent);
            }
        }
        return "sys/dic/dicValue";
    }

    @RequestMapping(value={"/selectDicValue"}, method={RequestMethod.GET})
    public String selectDicValue(Model model, Long dicId) {
        model.addAttribute("dicId", (Object)dicId);
        List list = this.dicValueService.query(dicId, null, Integer.valueOf(1), 1, Integer.MAX_VALUE).getList();
        model.addAttribute("list", (Object)list);
        return "sys/dic/selectDicValue";
    }

    @RequestMapping(value={"/selectDicValueList.json"})
    @ResponseBody
    public List<DicValueVo> dicValueList(String valueLabel, Long dicId) {
        return this.dicValueService.query(dicId, valueLabel, Integer.valueOf(1), 1, Integer.MAX_VALUE).getList();
    }

    @RequestMapping(value={"/dicValueList.json"})
    @ResponseBody
    public PageInfo<DicValueVo> dicValueList(Model model, JqGridParam jqGridParam, Long dicId, String valueLabel, Integer status) {
        return this.dicValueService.query(dicId, valueLabel, status, jqGridParam.getPage(), jqGridParam.getRows());
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public ResponseData<Object> delete(String ids) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        if (!StringUtils.isEmpty((CharSequence)ids)) {
            String[] idArr = ids.split(",");
            ArrayList<Long> idList = new ArrayList<Long>();
            for (String s : idArr) {
                idList.add(Long.parseLong(s));
            }
            this.dicValueService.deleteMulit(idList, loginStaffId);
        }
        ResponseData responseData = new ResponseData();
        responseData.setState(ResponseStateEnum.success);
        return responseData;
    }

    @RequestMapping(value={"/addDicValue"})
    @ResponseBody
    public ResponseData<DicValue> addDicType(DicValue dicValue) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        dicValue.setCreateBy(loginStaffId);
        dicValue.setUpdateBy(loginStaffId);
        dicValue = (DicValue)this.dicValueService.add((Object)dicValue);
        ResponseData responseData = new ResponseData();
        responseData.setState(ResponseStateEnum.success);
        responseData.setResult((Object)dicValue);
        return responseData;
    }

    @RequestMapping(value={"/updateDicValue"})
    @ResponseBody
    public ResponseData<DicValue> updateDicType(DicValue dicValue) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        dicValue.setUpdateBy(loginStaffId);
        DicValue old = (DicValue)this.dicValueService.getById(dicValue.getId());
        old.setUpdateBy(loginStaffId);
        old.setUpdateDate(new Date());
        old.setValueLabel(dicValue.getValueLabel());
        old.setValue(dicValue.getValue());
        old.setSortNum(dicValue.getSortNum());
        old.setPid(dicValue.getPid());
        old.setDefaultValue(dicValue.getDefaultValue());
        old.setRemark(dicValue.getRemark());
        old.setStatus(dicValue.getStatus());
        this.dicValueService.updateByPrimaryKey((Object)old, loginStaffId);
        ResponseData responseData = new ResponseData();
        responseData.setState(ResponseStateEnum.success);
        responseData.setResult((Object)old);
        return responseData;
    }

    @RequestMapping(value={"/dicValueExport"}, method={RequestMethod.GET})
    public void dicValueExport(HttpServletResponse response, Long dicId, String valueLabel, Integer status) throws IOException {
        DicType dicType = (DicType)this.dicTypeService.getById(dicId);
        String[] colums = new String[]{"id|id", "\u5b57\u5178\u6807\u7b7e|valueLabel", "\u5b57\u5178\u952e\u503c|value", "\u7236\u7ea7|parentValueLabel", "\u72b6\u6001(1:\u542f\u7528 2\uff1a\u505c\u7528)|status", "\u662f\u5426\u662f\u7cfb\u7edf\u9ed8\u8ba4|defaultValue", "\u5907\u6ce8|remark", "\u521b\u5efa\u65f6\u95f4|createDate"};
        List list = this.dicValueService.query(dicId, valueLabel, status, 1, Integer.MAX_VALUE).getList();
        String fileName = URLEncoder.encode(String.format(dicType.getName() + "-\u5b57\u5178\u6570\u636e-%s.xls", LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE)), "UTF-8").replaceAll("\\+", "%20");
        ResponseLeakUtil.setReponseFileName((HttpServletResponse)response, (String)fileName);
        response.setContentType("application/octet-stream; charset=GBK");
        ExportExcel listexcel = new ExportExcel();
        listexcel.simpleExport2("\u5de5\u4f5c\u573a\u6240\u6e05\u5355", colums, list, (OutputStream)response.getOutputStream());
    }
}

