/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.sys.dic;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.entity.sys.dic.DicType;
import cn.smarthse.modules.health.service.sys.dic.IDicTypeService;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/sys/dic"})
public class DicController {
    @DubboReference
    private IDicTypeService dicTypeService;

    @RequestMapping(value={"/index"}, method={RequestMethod.GET})
    public String index(Model model) {
        return "sys/dic/index";
    }

    @RequestMapping(value={"/dicType"}, method={RequestMethod.GET})
    public String dicType(Model model, Long id) {
        if (id != null) {
            DicType dicType = (DicType)this.dicTypeService.getById(id);
            model.addAttribute("dicType", (Object)dicType);
        }
        return "sys/dic/dicType";
    }

    @RequestMapping(value={"/typeList.json"})
    @ResponseBody
    public PageInfo<DicType> typeList(Model model, JqGridParam jqGridParam, String nameOrTypeCode, Integer status, @DateTimeFormat(pattern="yyyy-MM-dd") Date startDate, @DateTimeFormat(pattern="yyyy-MM-dd") Date endDate) {
        return this.dicTypeService.query(nameOrTypeCode, status, startDate, endDate, jqGridParam.getPage(), jqGridParam.getRows());
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public ResponseData<Object> delete(String ids) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        if (!StringUtils.isEmpty((CharSequence)ids)) {
            String[] idArr = ids.split(",");
            ArrayList<Long> idList = new ArrayList<Long>();
            for (String s : idArr) {
                idList.add(Long.parseLong(s));
            }
            this.dicTypeService.deleteMulit(idList, loginStaffId);
        }
        ResponseData responseData = new ResponseData();
        responseData.setState(ResponseStateEnum.success);
        return responseData;
    }

    @RequestMapping(value={"/addDicType"})
    @ResponseBody
    public ResponseData<DicType> addDicType(DicType dicType) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        dicType.setCreateBy(loginStaffId);
        dicType.setUpdateBy(loginStaffId);
        dicType = (DicType)this.dicTypeService.add((Object)dicType);
        ResponseData responseData = new ResponseData();
        responseData.setState(ResponseStateEnum.success);
        responseData.setResult((Object)dicType);
        return responseData;
    }

    @RequestMapping(value={"/updateDicType"})
    @ResponseBody
    public ResponseData<DicType> updateDicType(DicType dicType) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        dicType.setUpdateBy(loginStaffId);
        DicType old = (DicType)this.dicTypeService.getById(dicType.getId());
        old.setUpdateBy(loginStaffId);
        old.setUpdateDate(new Date());
        old.setDataType(dicType.getDataType());
        old.setName(dicType.getName());
        old.setRemark(dicType.getRemark());
        old.setStatus(dicType.getStatus());
        old.setTypeCode(dicType.getTypeCode());
        this.dicTypeService.updateByPrimaryKey((Object)old, loginStaffId);
        ResponseData responseData = new ResponseData();
        responseData.setState(ResponseStateEnum.success);
        responseData.setResult((Object)old);
        return responseData;
    }

    @RequestMapping(value={"/dicTypeExport"}, method={RequestMethod.GET})
    public void dicTypeExport(HttpServletResponse response, String nameOrTypeCode, Integer status, @DateTimeFormat(pattern="yyyy-MM-dd") Date startDate, @DateTimeFormat(pattern="yyyy-MM-dd") Date endDate) throws IOException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u5b57\u5178" + dateFormat.format(new Date()) + ".xls";
        String[] colums = new String[]{"id|id", "\u5b57\u5178\u540d\u79f0|name", "\u5b57\u5178\u7c7b\u578b|typeCode", "\u72b6\u6001(1:\u542f\u7528 2\uff1a\u505c\u7528)|status", "\u5907\u6ce8|remark", "\u521b\u5efa\u65f6\u95f4|createDate"};
        List list = this.dicTypeService.query(nameOrTypeCode, status, startDate, endDate, 1, Integer.MAX_VALUE).getList();
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("GBK"), "ISO8859_1"));
        response.setContentType("application/octet-stream; charset=GBK");
        ExportExcel listexcel = new ExportExcel();
        listexcel.simpleExport2("\u5de5\u4f5c\u573a\u6240\u6e05\u5355", colums, list, (OutputStream)response.getOutputStream());
    }
}

