/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.sys;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.modules.health.entity.sys.SysUser;
import cn.smarthse.modules.health.entity.sys.SysUserInvite;
import cn.smarthse.modules.health.service.sys.ISysUserInviteService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.StaffUtil;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/sys/user/invite"})
public class UserInviteController
extends ControllerSupport {
    @DubboReference
    ISysUserInviteService userInviteService;

    @RequiresPermissions(value={"sys.user.view"})
    @RequestMapping(method={RequestMethod.GET})
    public String page_List(HttpServletRequest request, HttpServletResponse response, Model model) {
        this.logger.info("\u7cfb\u7edf\u7ba1\u7406\u300b\u7528\u6237\u9080\u8bf7\u5217\u8868");
        return "sys/user/invite-list";
    }

    @RequiresPermissions(value={"sys.user.view"})
    @ResponseBody
    @RequestMapping(value={"listData"})
    public JqGridData<SysUserInvite> listData(HttpSession session, JqGridParam param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        PageInfo list = this.userInviteService.getListByGridParam(param);
        for (SysUserInvite userInvite : list.getList()) {
            userInvite.setStaffname(StaffUtil.getStaffNameOrgByStaffId(userInvite.getInviteStaffId()));
        }
        JqGridData data = new JqGridData(list, param);
        return data;
    }

    @Log(title="\u7528\u6237\u9080\u8bf7", type=2)
    @RequiresPermissions(value={"sys.user.edit"})
    @ResponseBody
    @RequestMapping(value={"add"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_inviteUser(String username, Long inviteStaffId, HttpServletRequest request, HttpServletResponse response) {
        this.logger.info("ajax-\u7cfb\u7edf\u7ba1\u7406\u300b\u9080\u8bf7\u7528\u6237{},\u5458\u5de5\u7f16\u53f7:{}", (Object)username, (Object)inviteStaffId);
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        SysUser user = UserUtils.getByLoginName(username);
        if (!(user == null || user.getCid() != null && user.getCid().equals(cid))) {
            if (user.getCid() != null && !user.getCid().equals(cid)) {
                this.userInviteService.initUsername(user, inviteStaffId, cid, loginStaffId);
                return new ResponseData(ResponseStateEnum.success);
            }
            if (user.getCid() == null) {
                this.userInviteService.initUsername(user, inviteStaffId, cid, loginStaffId);
                return new ResponseData(ResponseStateEnum.success);
            }
        }
        return new ResponseData(ResponseStateEnum.fail, "\u65e0\u6cd5\u53d1\u8d77\u9080\u8bf7!");
    }

    @Log(title="\u91cd\u65b0\u53d1\u8d77\u7528\u6237\u9080\u8bf7", type=2)
    @RepeatUrlFormData
    @RequiresPermissions(value={"sys.user.edit"})
    @ResponseBody
    @RequestMapping(value={"again/{id}"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_inviteAgainUser(@PathVariable(value="id") Long id, HttpServletRequest request, HttpServletResponse response) {
        this.logger.info("ajax-\u7cfb\u7edf\u7ba1\u7406\u300b\u91cd\u65b0\u9080\u8bf7\u7528\u6237");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        this.userInviteService.initAgain(id, cid, loginStaffId);
        return new ResponseData(ResponseStateEnum.success);
    }

    @RequiresPermissions(value={"sys.user.edit"})
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"del/{id}"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_inviteDelete(@PathVariable(value="id") Long id) {
        this.logger.info("ajax-\u7cfb\u7edf\u7ba1\u7406\u300b\u5220\u9664\u9080\u8bf7");
        Long loginStaffId = UserUtils.getLoginStaffId();
        SysUserInvite userInvite = (SysUserInvite)this.userInviteService.getById(id);
        this.userInviteService.delete((Object)userInvite, loginStaffId);
        return new ResponseData();
    }
}

