/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.sys;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.provider.log.ISysOperLogProviderService;
import cn.smarthse.modules.health.entity.sys.SecUserRole;
import cn.smarthse.modules.health.entity.sys.SysUser;
import cn.smarthse.modules.health.entity.sys.vo.SecPermissionParam;
import cn.smarthse.modules.health.entity.sys.vo.UserFormVO;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.sys.ISecRoleService;
import cn.smarthse.modules.health.service.sys.ISecUserRoleService;
import cn.smarthse.modules.health.service.sys.ISysUserService;
import cn.smarthse.modules.sys.annotation.PasswordLog;
import cn.smarthse.modules.sys.enumd.BusinessTypeEnum;
import cn.smarthse.modules.sys.enumd.OperatorDataSourceEnum;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.util.StringUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.smarthse.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/sys/user"})
public class UserController
extends ControllerSupport {
    @DubboReference
    ISysUserService userService;
    @DubboReference
    IStaffInfoService staffService;
    @DubboReference
    ISecRoleService secRoleService;
    @DubboReference
    ISecUserRoleService userRoleService;
    @DubboReference
    private ISysOperLogProviderService sysOperLogService;
    @Value(value="${customSysUser}")
    protected String customSysUser;

    @Log(title="\u7528\u6237\u5217\u8868\u9875", type=2)
    @RequiresPermissions(value={"sys.user"})
    @RequestMapping(method={RequestMethod.GET})
    public String page_List(HttpServletRequest request, HttpServletResponse response, Model model) {
        this.logger.info("\u7cfb\u7edf\u7ba1\u7406\u300b\u7528\u6237\u5217\u8868");
        Boolean staffImport = false;
        String serviceName = request.getServerName();
        Boolean isManger = UserUtils.getCurrentUser().getIsManger();
        String userName = UserUtils.getCurrentUser().getUsername();
        String uName = "15068756653";
        String u1Name = "zhkc";
        if (userName != null && (userName.equals(uName) || userName.equals(u1Name))) {
            staffImport = true;
        }
        model.addAttribute("staffImport", (Object)staffImport);
        model.addAttribute("userName", (Object)userName);
        model.addAttribute("isManger", (Object)isManger);
        model.addAttribute("customSysUser", (Object)this.customSysUser);
        if ("true".equals(this.customSysUser)) {
            return "sys/user/custom/custom_list";
        }
        return "sys/user/list";
    }

    @RequiresPermissions(value={"sys.user.view"})
    @ResponseBody
    @RequestMapping(value={"listData"})
    public JqGridData<SysUser> listData(HttpSession session, JqGridParam param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        PageInfo list = this.userService.getUserListByGridParam(param);
        JqGridData data = new JqGridData(list, param);
        return data;
    }

    @Log(title="\u7528\u6237\u67e5\u770b", type=2)
    @RequiresPermissions(value={"sys.user.view"})
    @RequestMapping(value={"view/{userId}"}, method={RequestMethod.GET})
    public String page_viewUser(@PathVariable(value="userId") Long userId, Model model) {
        this.logger.info("\u7cfb\u7edf\u7ba1\u7406\u300b\u7528\u6237\u67e5\u770b");
        if (!"true".equals(this.isActualize)) {
            SysUser viewUser = UserUtils.getLiteSysUserById(userId);
            model.addAttribute("viewUser", (Object)viewUser);
        } else {
            SysUser viewUser = UserUtils.getSysUserById(userId);
            model.addAttribute("viewUser", (Object)viewUser);
        }
        return "sys/user/dialog_viewUser";
    }

    @RequiresPermissions(value={"sys.user.edit"})
    @RequestMapping(value={"add"}, method={RequestMethod.GET})
    public String page_addUser(HttpServletRequest request, HttpServletResponse response, Model model) {
        this.logger.info("\u7cfb\u7edf\u7ba1\u7406\u300b\u7528\u6237\u65b0\u589e");
        Long cid = UserUtils.getLoginStaffCompanyId();
        ArrayList<Long> roleIds = new ArrayList<Long>();
        if (!"true".equals(this.isActualize)) {
            roleIds.add(1L);
            roleIds.add(2L);
            roleIds.add(33000000000001L);
        }
        List roleList = this.secRoleService.getListBycid(cid, roleIds);
        this.logger.error("roleList===" + String.valueOf(roleList));
        if (!"true".equals(this.isActualize)) {
            roleList.forEach(s -> {
                if (s.getRolename().equals("\u4e00\u822c\u7528\u6237(\u6d59\u6c5f)")) {
                    s.setRolename("EHS\u7ba1\u7406\u5458(\u6d59\u6c5f)");
                    if (StringUtils.isNotEmpty((String)s.getDescription())) {
                        s.setDescription(s.getDescription().replace("\u4e00\u822c\u7528\u6237(\u6d59\u6c5f)", "EHS\u7ba1\u7406\u5458(\u6d59\u6c5f)"));
                    }
                }
            });
        }
        model.addAttribute("roleList", (Object)roleList);
        if ("true".equals(this.customSysUser)) {
            return "sys/user/custom/dialog_addCustomUser";
        }
        return "sys/user/dialog_addUser";
    }

    @Log(title="\u7528\u6237\u65b0\u589e", type=20)
    @RequiresPermissions(value={"sys.user.edit"})
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"add"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_addUser(UserFormVO userForm, HttpServletRequest request, HttpServletResponse response) {
        this.logger.info("ajax-\u7cfb\u7edf\u7ba1\u7406\u300b\u7528\u6237\u65b0\u589e");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        SysUser user = UserUtils.getByLoginName(userForm.getUsername());
        if (user != null) {
            return new ResponseData(ResponseStateEnum.fail, "\u8be5\u8d26\u53f7\u5df2\u5b58\u5728\uff0c\u4e0d\u53ef\u91cd\u590d\u6dfb\u52a0!");
        }
        this.userService.addCustomUser(userForm, loginStaffId, cid);
        return new ResponseData();
    }

    @RequiresPermissions(value={"sys.user.edit"})
    @ResponseBody
    @RequestMapping(value={"check"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_checkUser(String username, HttpServletRequest request, HttpServletResponse response) throws ServiceException {
        this.logger.info("ajax-\u7cfb\u7edf\u7ba1\u7406\u300b\u7528\u6237\u9a8c\u8bc1:{}", (Object)username);
        Long cid = UserUtils.getLoginStaffCompanyId();
        if (StringUtil.isEmpty((String)username)) {
            return new ResponseData(ResponseStateEnum.fail, "\u7528\u6237\u540d\u53c2\u6570\u9519\u8bef!");
        }
        SysUser user = UserUtils.getByLoginName(username);
        if (user != null) {
            if (user.getCid() != null && user.getCid().equals(cid)) {
                return new ResponseData(ResponseStateEnum.fail, "\u7528\u6237\u5df2\u5b58\u5728!");
            }
            if (user.getCid() != null && !user.getCid().equals(cid)) {
                return new ResponseData(ResponseStateEnum.warning, "\u7528\u6237\u5df2\u5b58\u5728!");
            }
            if (user.getCid() == null) {
                return new ResponseData(ResponseStateEnum.warning, "\u7528\u6237\u5df2\u5b58\u5728!");
            }
        }
        return new ResponseData(ResponseStateEnum.success);
    }

    private void setRoleList(Long userId, Long cid, Model m) {
        SecPermissionParam query = new SecPermissionParam();
        query.setCid(cid);
        query.setUserId(userId);
        List roleList = this.secRoleService.getListByQuery(query);
        if (!"true".equals(this.isActualize) && roleList != null && roleList.size() > 0) {
            roleList = roleList.stream().filter(s -> {
                boolean flag = false;
                if (s.getId() == 1L || s.getId() == 2L || s.getCid() != null) {
                    flag = true;
                    if (s.getId() == 2L) {
                        s.setRolename("\u4e00\u822c\u7528\u6237");
                        s.setDescription(s.getDescription().replace("EHS\u7ba1\u7406\u5458", "\u4e00\u822c\u7528\u6237"));
                    }
                }
                return flag;
            }).collect(Collectors.toList());
        }
        m.addAttribute("roleList", (Object)roleList);
    }

    @RequiresPermissions(value={"sys.user.edit"})
    @RequestMapping(value={"edit/{userId}"}, method={RequestMethod.GET})
    public String page_editUser(@PathVariable(value="userId") Long userId, Model model) {
        this.logger.info("\u7cfb\u7edf\u7ba1\u7406\u300b\u7528\u6237\u4fee\u6539");
        Long cid = UserUtils.getLoginStaffCompanyId();
        SysUser viewUser = UserUtils.getSysUserById(userId);
        model.addAttribute("viewUser", (Object)viewUser);
        SecUserRole param = new SecUserRole();
        param.setSysUserId(userId);
        param.setSecRoleId(Long.valueOf(1L));
        List roles = this.userRoleService.getListByUserId(param);
        if (roles != null && roles.size() > 0) {
            return "sys/user/editSuperUser";
        }
        this.setRoleList(userId, cid, model);
        if ("true".equals(this.customSysUser)) {
            return "sys/user/custom/dialog_editCustomUser";
        }
        return "sys/user/dialog_editUser";
    }

    @PasswordLog(businessType=BusinessTypeEnum.CHANGEPASSWORD, dataOf=OperatorDataSourceEnum.ENTERPRISE)
    @Log(title="\u7528\u6237\u4fee\u6539", type=21)
    @RequiresPermissions(value={"sys.user.edit"})
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"edit"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_editUser(UserFormVO userForm) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        ResponseData data = new ResponseData();
        if (this.sysOperLogService.isPasswordAvailable(userForm.getPassword(), UserUtils.getCurrentUser().getUsername(), OperatorDataSourceEnum.ENTERPRISE.getValue()).booleanValue()) {
            data.setState(ResponseStateEnum.fail);
            data.setContent("\u4e0d\u53ef\u4f7f\u7528\u5386\u53f2\u5bc6\u7801\u6216\u521d\u59cb\u5bc6\u7801");
            return data;
        }
        this.userService.editCustomUser(userForm, loginStaffId, cid);
        return data;
    }

    @Log(title="\u7528\u6237\u5220\u9664", type=22)
    @RequiresPermissions(value={"sys.user.edit"})
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"del/{userId}"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_delUser(@PathVariable(value="userId") Long userId) {
        this.logger.info("ajax-\u7cfb\u7edf\u7ba1\u7406\u300b\u7528\u6237\u5220\u9664");
        Long loginStaffId = UserUtils.getLoginStaffId();
        SysUser viewUser = UserUtils.getSysUserById(userId);
        if (viewUser != null && viewUser.getIsManger() != null && viewUser.getIsManger().booleanValue()) {
            ResponseData r = new ResponseData(ResponseStateEnum.fail);
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u7ba1\u7406\u5458\u8d26\u53f7\u4e0d\u80fd\u5220\u9664");
            return r;
        }
        this.userService.deleteUser(viewUser, loginStaffId);
        return new ResponseData(ResponseStateEnum.success);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ResponseBody
    @RequestMapping(value={"check/staff"}, method={RequestMethod.POST})
    public ResponseData<String> checkStaff(Long userId, Long staffId) {
        this.logger.info("ajax-\u6821\u9a8c\u5458\u5de5\u4fe1\u606f");
        Long cid = UserUtils.getLoginStaffCompanyId();
        ResponseData data = new ResponseData(ResponseStateEnum.fail);
        try {
            String result = this.userService.checkStaff(cid, staffId);
            if (StringUtils.isNotEmpty((String)result)) {
                data.setResult((Object)result);
                ResponseData responseData = data;
                return responseData;
            }
            SysUser user = this.userService.getStaffUser(cid, staffId, userId);
            if (user != null) {
                data.setState(ResponseStateEnum.warning);
                data.setResult((Object)("\u8be5\u5458\u5de5\u5df2\u5173\u8054\u8d26\u53f7\u3010" + user.getUsername() + "\u3011\uff0c\u70b9\u51fb\u786e\u5b9a\u5c06\u89e3\u7ed1\u8be5\u8d26\u53f7\uff0c\u5e76\u5c06\u8be5\u5458\u5de5\u7ed1\u5b9a\u5230\u5f53\u524d\u8d26\u53f7"));
                ResponseData responseData = data;
                return responseData;
            }
            data.setState(ResponseStateEnum.success);
        }
        catch (Exception e) {
            e.printStackTrace();
            data.setResult((Object)"\u7cfb\u7edf\u5f02\u5e38\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        finally {
            return data;
        }
    }

    @Log(title="\u7528\u6237\u542f\u7528/\u7981\u7528", type=22)
    @RequiresPermissions(value={"sys.user.edit"})
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"/enable"}, method={RequestMethod.POST})
    public ResponseData<String> enableUser(Long userId, Boolean isForbidden) {
        this.logger.info("ajax-\u7cfb\u7edf\u7ba1\u7406\u300b\u7528\u6237\u542f\u7528");
        Long loginStaffId = UserUtils.getLoginStaffId();
        SysUser user = (SysUser)this.userService.getById(userId);
        if (user != null) {
            user.setIsForbidden(isForbidden);
            this.userService.update((Object)user, loginStaffId);
        }
        return new ResponseData(ResponseStateEnum.success);
    }
}

