/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.sys;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.common.util.Digests;
import cn.smarthse.common.util.Encodes;
import cn.smarthse.common.util.RandomGenerator;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.framework.limit.annotaion.RequestLimit;
import cn.smarthse.modules.datacentre.provider.log.ISysOperLogProviderService;
import cn.smarthse.modules.datacentre.provider.sms.ISMSProviderService;
import cn.smarthse.modules.health.entity.sys.SysUser;
import cn.smarthse.modules.health.service.sys.ISysUserService;
import cn.smarthse.modules.sys.annotation.PasswordLog;
import cn.smarthse.modules.sys.enumd.BusinessTypeEnum;
import cn.smarthse.modules.sys.enumd.OperatorDataSourceEnum;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.security.shiro.ShiroPrincipal;
import cn.smarthse.web.util.LoginUtil;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.util.StringUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/sys/user"})
public class UserBindingController
extends ControllerSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserBindingController.class);
    @DubboReference
    private ISysOperLogProviderService sysOperLogService;
    @DubboReference
    ISysUserService sysUserService;
    @DubboReference(version="1.0.0")
    ISMSProviderService smsProviderService;
    @Autowired
    RedisClient redisClient;
    private static final String VCODECACHENAME = "vcodeCache";
    private String MSGSIGN = "\u3010\u667a\u6167\u804c\u5b89\u73af\u4fdd\u79d1\u6280\u3011";

    @RequiresPermissions(value={"sys.user.view"})
    @RequestMapping(value={"bindingInfo"}, method={RequestMethod.GET})
    public String page_List(HttpServletRequest request, HttpServletResponse response, Model model) {
        this.logger.debug("\u7cfb\u7edf\u7ba1\u7406\u300b\u8d26\u53f7\u7ed1\u5b9a");
        Long userId = UserUtils.getCurrentUserId();
        SysUser user = (SysUser)this.sysUserService.getById(userId);
        if (user != null && user.getMobile() != null) {
            StringBuilder sb = new StringBuilder(user.getMobile());
            sb.replace(3, 7, "****");
            user.setMobile(sb.toString());
        }
        model.addAttribute("user", (Object)user);
        return "sys/user/userBinding";
    }

    @ResponseBody
    @RequestMapping(value={"/sendVcode"}, method={RequestMethod.GET})
    public ResponseData<String> home(String mobile) {
        ResponseData response = new ResponseData();
        if (StringUtils.isBlank((CharSequence)mobile)) {
            response.setState(ResponseStateEnum.fail);
            response.setContent("\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return response;
        }
        if (!CommonUtil.checkMobile((String)mobile)) {
            response.setState(ResponseStateEnum.fail);
            response.setContent("\u624b\u673a\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e");
            return response;
        }
        String cacheVcode = (String)this.redisClient.get("vcodeCache:" + mobile);
        if (org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{cacheVcode})) {
            response.setState(ResponseStateEnum.fail);
            response.setContent("\u9891\u7e41\u64cd\u4f5c\uff1a\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4e00\u5206\u949f\u53ea\u80fd\u53d1\u4e00\u6b21");
            return response;
        }
        String vcode = RandomGenerator.getRandomNum((int)6);
        this.smsProviderService.sendVcode(vcode, mobile);
        this.logger.info("\u804c\u4e1a\u5065\u5eb7==\u300b\u53d1\u9001\u624b\u673a\u9a8c\u8bc1\u7801  \u624b\u673a\uff1a" + mobile + ", \u9a8c\u8bc1\u7801\uff1a" + vcode);
        this.redisClient.set("vcodeCache:" + mobile, (Object)vcode, 60L);
        response.setContent("\u9a8c\u8bc1\u7801\u5df2\u53d1\u9001\uff0c\u8bf7\u6ce8\u610f\u67e5\u6536");
        return response;
    }

    @ResponseBody
    @RequestMapping(value={"binding"}, method={RequestMethod.POST})
    public ResponseData<String> binding(String mobile, String vcode, String validateCode, HttpServletRequest request) {
        this.logger.debug("ajax-\u7cfb\u7edf\u7ba1\u7406\u300b\u7528\u6237\u7ed1\u5b9a:{}", (Object)mobile);
        ResponseData response = new ResponseData();
        if (StringUtil.isEmpty((String)validateCode) || !LoginUtil.validate(request, validateCode)) {
            response.setState(ResponseStateEnum.fail);
            response.setContent("\u56fe\u5f62\u9a8c\u8bc1\u7801\u8f93\u5165\u9519\u8bef");
            return response;
        }
        if (StringUtil.isEmpty((String)vcode)) {
            response.setState(ResponseStateEnum.fail);
            response.setContent("\u8bf7\u8f93\u5165\u624b\u673a\u9a8c\u8bc1\u7801");
            return response;
        }
        String cacheVcode = (String)this.redisClient.get("vcodeCache:" + mobile);
        if (!vcode.equals(cacheVcode)) {
            response.setState(ResponseStateEnum.fail);
            response.setContent("\u624b\u673a\u9a8c\u8bc1\u7801\u8f93\u5165\u9519\u8bef");
            return response;
        }
        Long userId = UserUtils.getCurrentUserId();
        SysUser user = (SysUser)this.sysUserService.getById(userId);
        user.setMobile(mobile);
        Boolean isBinded = this.sysUserService.isBindedPhone(mobile);
        if (isBinded.booleanValue()) {
            response.setState(ResponseStateEnum.fail);
            response.setContent("\u8be5\u624b\u673a\u53f7\u5df2\u7ed1\u5b9a\u5176\u4ed6\u8d26\u53f7");
            return response;
        }
        try {
            this.sysUserService.update((Object)user, userId);
            response.setState(ResponseStateEnum.success);
            StringBuilder sb = new StringBuilder(mobile);
            sb.replace(3, 7, "****");
            response.setResult((Object)sb.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setState(ResponseStateEnum.fail);
            response.setContent("\u7ed1\u5b9a\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        return response;
    }

    @RequiresPermissions(value={"changePassWord"})
    @RequestMapping(value={"changePassWord"}, method={RequestMethod.GET})
    public String changePassWord() {
        return "sys/user/changePassword";
    }

    @RequiresPermissions(value={"changePassWord"})
    @RequestMapping(value={"changePassWordNew"}, method={RequestMethod.GET})
    public String changePassWordNew() {
        return "views/businessComponents/changePassword";
    }

    @PasswordLog(businessType=BusinessTypeEnum.CHANGEPASSWORD, dataOf=OperatorDataSourceEnum.ENTERPRISE)
    @ResponseBody
    @RequestLimit
    @RequestMapping(value={"changePass"}, method={RequestMethod.POST})
    public ResponseData<String> changePass(String oldPassword, String newPassword) {
        ResponseData response = new ResponseData();
        if (StringUtils.isBlank((CharSequence)oldPassword) || StringUtils.isBlank((CharSequence)newPassword)) {
            response.setState(ResponseStateEnum.fail);
            response.setContent("\u53c2\u6570\u9519\u8bef");
            return response;
        }
        if (oldPassword.equals(newPassword)) {
            response.setState(ResponseStateEnum.fail);
            response.setContent("\u65b0\u65e7\u5bc6\u7801\u4e0d\u80fd\u76f8\u540c");
            return response;
        }
        SysUser userById = (SysUser)this.sysUserService.getById(UserUtils.getCurrentUserId());
        if (!StringUtils.getPassword((String)userById.getSalt(), (String)oldPassword).equals(userById.getPassword())) {
            response.setState(ResponseStateEnum.fail);
            response.setContent("\u65e7\u5bc6\u7801\u4e0d\u6b63\u786e");
            return response;
        }
        if (this.sysOperLogService.isPasswordAvailable(newPassword, userById.getUsername(), OperatorDataSourceEnum.ENTERPRISE.getValue()).booleanValue()) {
            response.setState(ResponseStateEnum.fail);
            response.setContent("\u4e0d\u53ef\u4f7f\u7528\u5386\u53f2\u5bc6\u7801\u6216\u521d\u59cb\u5bc6\u7801");
            return response;
        }
        SysUser user = new SysUser();
        user.setId(userById.getId());
        byte[] salt = Digests.generateSalt((int)8);
        user.setSalt(Encodes.hexEncode((byte[])salt));
        byte[] hashPassword = Digests.sha1((byte[])newPassword.getBytes(), (byte[])salt, (int)1024);
        user.setPassword(Encodes.hexEncode((byte[])hashPassword));
        user.setIsDefaultPwd(Boolean.valueOf(false));
        Date date = new Date();
        user.setUpdateDate(date);
        this.sysUserService.update((Object)user, userById.getId());
        ShiroPrincipal principal = UserUtils.getPrincipal();
        principal.setSysUser((SysUser)this.sysUserService.getById(userById.getId()));
        principal.setDefaultPwd(false);
        UserUtils.reflushPrincipal(principal);
        response.setState(ResponseStateEnum.success);
        response.setContent("\u5bc6\u7801\u4fee\u6539\u6210\u529f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        return response;
    }

    @GetMapping(value={"/needChangePwd"})
    @ResponseBody
    public ResponseData<Integer> isPasswordAvailable() {
        List list = this.sysUserService.isDefaultPwdList();
        return ResponseData.success((Object)list.size());
    }
}

