/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.sys;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.common.util.RandomGenerator;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.framework.encrypt.annotation.ApiEncrypt;
import cn.smarthse.framework.limit.annotaion.RequestLimit;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.modules.datacentre.provider.sms.ISMSProviderWelinkService;
import cn.smarthse.modules.health.bind.enums.UserBindLogTypeEnum;
import cn.smarthse.modules.health.bind.model.ConfirmAccountParam;
import cn.smarthse.modules.health.bind.model.SysUserBindParam;
import cn.smarthse.modules.health.bind.service.ISysUserBindService;
import cn.smarthse.modules.health.bind.vo.SysUserBindLogVo;
import cn.smarthse.modules.health.bind.vo.SysUserBindVo;
import cn.smarthse.modules.health.entity.sys.SysUser;
import cn.smarthse.modules.health.service.base.ICompanyService;
import cn.smarthse.modules.sys.enumd.UserSystemWideEnum;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.security.shiro.ShiroPrincipal;
import cn.smarthse.web.util.LoginUtil;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import jodd.util.StringUtil;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/sys/userBind"})
public class SysUserBindController
extends ControllerSupport {
    @DubboReference
    private ISysUserBindService userBindService;
    @DubboReference
    private ISMSProviderWelinkService smsProvider;
    @Resource
    private ICompanyService companyService;
    private static final String VCODECACHENAME = "bindVcodeCache:web";
    private static final String VCODECACHENAMERATE = "bindVcodeCacheRate:web";
    private static final String sms_cache_name = "sms_login:web:";
    private static final String vcode_template_bind = "\u3010\u6d59\u6c5f\u7701\u75be\u63a7\u5c40\u3011\u60a8\u6b63\u5728\u8fdb\u884c\u7ed1\u5b9a\u624b\u673a\u53f7\u7684\u64cd\u4f5c\uff0c\u9a8c\u8bc1\u7801\u662f\uff1a %s \uff08\u5207\u52ff\u544a\u77e5\u4ed6\u4eba\uff09\uff0c\u6709\u6548\u671f5\u5206\u949f\uff0c\u8bf7\u5c3d\u5feb\u8fdb\u884c\u540e\u7eed\u64cd\u4f5c\u3002";
    private static final String vcode_template_rebind = "\u3010\u6d59\u6c5f\u7701\u75be\u63a7\u5c40\u3011\u60a8\u6b63\u5728\u8fdb\u884c\u624b\u673a\u53f7\u6362\u7ed1\uff0c\u6362\u7ed1\u9a8c\u8bc1\u7801\u4e3a %s \uff08\u5207\u52ff\u544a\u77e5\u4ed6\u4eba\uff09\uff0c5\u5206\u949f\u5185\u6709\u6548\uff0c\u8bf7\u5c3d\u5feb\u8fdb\u884c\u540e\u7eed\u64cd\u4f5c\u3002";
    @Autowired
    private RedisClient redisClient;

    @ResponseBody
    @ApiEncrypt(request=true)
    @RequestLimit
    @RequestMapping(value={"sendVcode"}, method={RequestMethod.POST})
    public ResponseData<String> sendVcode(@RequestBody SysUserBindParam vo) {
        if (StringUtils.isBlank((CharSequence)vo.getBindTel())) {
            return ResponseData.fail((String)"\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!CommonUtil.checkMobile((String)vo.getBindTel())) {
            return ResponseData.fail((String)"\u624b\u673a\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        String rateLimitKey = VCODECACHENAMERATE + vo.getBindTel();
        Map lastSentData = (Map)this.redisClient.get(rateLimitKey);
        if (lastSentData != null) {
            long lastSentTime = Long.parseLong(lastSentData.get("timestamp").toString());
            long currentTime = System.currentTimeMillis();
            if (currentTime - lastSentTime < 60000L) {
                return ResponseData.fail((String)"\u9891\u7e41\u64cd\u4f5c\uff1a\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4e00\u5206\u949f\u53ea\u80fd\u53d1\u4e00\u6b21");
            }
        }
        String vcode = RandomGenerator.getRandomNum((int)6);
        String template = Objects.equals(UserBindLogTypeEnum.REBIND.getValue(), vo.getType()) ? vcode_template_rebind : vcode_template_bind;
        this.smsProvider.singleSendSms(vo.getBindTel(), String.format(template, vcode));
        this.logger.info("\u804c\u4e1a\u5065\u5eb7==\u300b\u53d1\u9001\u624b\u673a\u9a8c\u8bc1\u7801  \u624b\u673a\uff1a" + vo.getBindTel() + ", \u9a8c\u8bc1\u7801\uff1a" + vcode);
        HashMap<String, Object> rateLimitData = new HashMap<String, Object>();
        rateLimitData.put("vcode", vcode);
        rateLimitData.put("timestamp", System.currentTimeMillis());
        this.redisClient.set(rateLimitKey, rateLimitData, 60L);
        this.redisClient.set(VCODECACHENAME + vo.getBindTel(), (Object)vcode, 300L);
        return ResponseData.success((String)"\u9a8c\u8bc1\u7801\u5df2\u53d1\u9001\uff0c\u8bf7\u6ce8\u610f\u67e5\u6536");
    }

    @PostMapping(value={"bind"})
    @ResponseBody
    @RequestLimit
    @ApiEncrypt(request=true)
    public ResponseData<SysUserBindVo> bind(@RequestBody SysUserBindParam vo) {
        Long userId = UserUtils.getCurrentUserId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        vo.setUserId(userId);
        vo.setCid(cid);
        this.userBindService.bindTel(vo, UserSystemWideEnum.ZLWQ_COMPANY.getCode());
        ShiroPrincipal principal = UserUtils.getPrincipal();
        principal.setBindTel(DesensitizationUtils.desensitized((CharSequence)vo.getBindTel(), (DesensitizationType)DesensitizationType.MOBILE_PHONE));
        principal.setBindName(DesensitizationUtils.name((String)vo.getBindName()));
        principal.setCheckVcode(1);
        UserUtils.reflushPrincipal(principal);
        SysUserBindVo bindVo = new SysUserBindVo();
        bindVo.setBindTel(DesensitizationUtils.desensitized((CharSequence)vo.getBindTel(), (DesensitizationType)DesensitizationType.MOBILE_PHONE));
        bindVo.setRedirect(Objects.equals(UserBindLogTypeEnum.REBIND.getValue(), vo.getType()) ? "/login" : "/indexhomev2");
        return ResponseData.success((Object)bindVo);
    }

    @ResponseBody
    @GetMapping(value={"getBindLog"})
    public ResponseData<JqGridData<SysUserBindLogVo>> getBindLog(SysUserBindParam param) {
        SysUser user = UserUtils.getCurrentUser();
        param.setCid(user.getCid());
        param.setSystemSource(Byte.valueOf(String.valueOf(UserSystemWideEnum.ZLWQ_COMPANY.getCode())));
        PageInfo pageInfo = this.userBindService.getBindLogList(param);
        return ResponseData.success((Object)new JqGridData(pageInfo, (JqGridParam)param));
    }

    @PostMapping(value={"/appealBindInfo"})
    @ResponseBody
    @ApiEncrypt(request=true)
    public ResponseData<Object> appealBindInfo(@RequestBody SysUserBindParam vo) {
        vo.setSystemWide(UserSystemWideEnum.ZLWQ_COMPANY.getCode());
        if (vo.getUsername() == null && vo.getUnifiedSocialCc() == null) {
            vo.setUsername(UserUtils.getCurrentUser().getUsername());
        }
        return this.userBindService.changeBindInfo(vo);
    }

    @PostMapping(value={"/confirmAccount"})
    @ResponseBody
    public ResponseData<Object> confirmAccount(@RequestBody ConfirmAccountParam param, HttpServletRequest request) {
        String validateCode = param.getValidateCode();
        ResponseData response = new ResponseData();
        if (StringUtil.isEmpty((CharSequence)validateCode) || !LoginUtil.validate(request, validateCode)) {
            response.setState(ResponseStateEnum.fail);
            response.setContent("\u56fe\u5f62\u9a8c\u8bc1\u7801\u8f93\u5165\u9519\u8bef");
            return response;
        }
        param.setSystemWide(UserSystemWideEnum.ZLWQ_COMPANY.getCode());
        return this.userBindService.confirmAccount(param);
    }
}

