/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.sys;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.modules.datacentre.model.system.SysParamModel;
import cn.smarthse.modules.datacentre.provider.system.ISysParamProvideService;
import cn.smarthse.modules.datacentre.provider.system.IndustryProvideService;
import cn.smarthse.modules.health.entity.sys.SysParam;
import cn.smarthse.modules.health.service.sys.ISysParamService;
import cn.smarthse.web.controller.ControllerSupport;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/sys/param"})
public class SysParamController
extends ControllerSupport {
    @DubboReference
    private ISysParamService sysParamService;
    @DubboReference(version="1.0.0")
    private ISysParamProvideService sysParamProvideService;
    @DubboReference(version="1.0.0")
    private IndustryProvideService industryProvideService;

    @ResponseBody
    @RequestMapping(value={"getSysParamByGroup"}, method={RequestMethod.GET})
    public ResponseData<List<SysParam>> getSysParamData(ModelMap m, String group, String search, String code) {
        ResponseData data = new ResponseData();
        try {
            ArrayList sysParamList = new ArrayList();
            if ("industrial_classification".equals(group)) {
                List industryModels = this.industryProvideService.searchIndustryList(search, code);
                if (CommonUtil.listIsNotEmpty((List)industryModels)) {
                    industryModels.forEach(model -> {
                        SysParam sysParam = new SysParam();
                        BeanUtils.copyProperties((Object)model, (Object)sysParam);
                        sysParam.setParamCode(model.getCode());
                        sysParam.setParamValue(model.getName());
                        sysParam.setPid(model.getPid());
                        sysParamList.add(sysParam);
                    });
                }
            } else {
                List sysParamListByChildren = this.sysParamProvideService.getSysParamListByChildrenSearch(group, search);
                if (CommonUtil.listIsNotEmpty((List)sysParamListByChildren)) {
                    sysParamListByChildren.forEach(model -> {
                        SysParam sysParam = new SysParam();
                        BeanUtils.copyProperties((Object)model, (Object)sysParam);
                        sysParam.setPid(model.getParentId());
                        sysParamList.add(sysParam);
                    });
                }
            }
            data.setResult(sysParamList);
            return data;
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u62a5\u9519\uff1a{}", (Throwable)e);
            data.setState(ResponseStateEnum.fail);
            data.setContent("\u67e5\u8be2\u5931\u8d25\uff01");
            return data;
        }
    }

    @ResponseBody
    @RequestMapping(value={"{paramId}"}, method={RequestMethod.GET})
    public ResponseData<SysParam> getSysParamDataById(@PathVariable(value="paramId") Long id) {
        ResponseData data = new ResponseData();
        try {
            SysParamModel sysParamModel = this.sysParamProvideService.getById(id);
            SysParam sysParam = new SysParam();
            BeanUtils.copyProperties((Object)sysParamModel, (Object)sysParam);
            sysParam.setPid(sysParamModel.getParentId());
            data.setResult((Object)sysParam);
            return data;
        }
        catch (Exception e) {
            data.setState(ResponseStateEnum.fail);
            data.setContent("\u67e5\u8be2\u5931\u8d25\uff01");
            return data;
        }
    }
}

