/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.sys;

import cn.smarthse.common.framework.beans.OssClientBean;
import cn.smarthse.common.util.leak.ResponseLeakUtil;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.web.controller.ControllerSupport;
import com.aliyun.oss.model.OSSObject;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"${adminPath}/sys/file"})
public class SysFileController
extends ControllerSupport {
    @DubboReference(timeout=5000000)
    private ISysFileProvideService sysFileService;
    @Autowired
    OssClientBean ossClientBean;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/zipDownload"})
    public void zipDownload(HttpServletResponse response, String fileIds, String fileName) {
        response.setContentType("application/force-download");
        ZipOutputStream zos = null;
        BufferedInputStream bis = null;
        FilterOutputStream out = null;
        byte[] buffer = new byte[102400];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        List fileList = this.sysFileService.getListByIds(fileIds);
        zos = new ZipOutputStream(baos);
        try {
            for (SysFileModel ossfile : fileList) {
                String url = ossfile.getOssUrl();
                String name = ossfile.getFileName();
                OSSObject object = this.ossClientBean.getClient().getObject(this.ossClientBean.getBucketName(), url);
                bis = new BufferedInputStream(object.getObjectContent());
                zos.putNextEntry(new ZipEntry(name));
                int i = bis.read(buffer);
                while (i != -1) {
                    zos.write(buffer, 0, i);
                    i = bis.read(buffer);
                }
                zos.closeEntry();
            }
            fileName = URLEncoder.encode(String.format(fileName, "UTF-8").replaceAll("\\+", "%20"));
            ResponseLeakUtil.setReponseFileName((HttpServletResponse)response, (String)fileName);
            out = new BufferedOutputStream((OutputStream)response.getOutputStream());
            out.write(baos.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                zos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

