/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.sys;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.modules.health.entity.sys.SecPermission;
import cn.smarthse.modules.health.entity.sys.SecRole;
import cn.smarthse.modules.health.entity.sys.SecRolePermission;
import cn.smarthse.modules.health.entity.sys.vo.RoleFormVO;
import cn.smarthse.modules.health.entity.sys.vo.SecPermissionParam;
import cn.smarthse.modules.health.enums.datascope.DataScopeEnum;
import cn.smarthse.modules.health.service.sys.ISecPermissionService;
import cn.smarthse.modules.health.service.sys.ISecRolePermissionService;
import cn.smarthse.modules.health.service.sys.ISecRoleService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.smarthse.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/sys/role"})
public class RoleController
extends ControllerSupport {
    @DubboReference
    ISecRoleService secRoleService;
    @DubboReference
    ISecPermissionService permissionService;
    @DubboReference
    ISecRolePermissionService rolePermissionService;

    @RequiresPermissions(value={"sys.role"})
    @RequestMapping(method={RequestMethod.GET})
    public String page_List(HttpServletRequest request, HttpServletResponse response, Model model) {
        this.logger.info("\u7cfb\u7edf\u7ba1\u7406\u300b\u89d2\u8272\u7ba1\u7406\u300b\u5217\u8868");
        Boolean staffImport = false;
        String serviceName = request.getServerName();
        String userName = UserUtils.getCurrentUser().getUsername();
        String uName = "15068756653";
        String u1Name = "zhkc";
        if (userName != null && (userName.equals(uName) || userName.equals(u1Name))) {
            staffImport = true;
        }
        model.addAttribute("staffImport", (Object)staffImport);
        return "sys/role/list";
    }

    @RequiresPermissions(value={"sys.role.view"})
    @ResponseBody
    @RequestMapping(value={"listData"})
    public JqGridData<SecRole> listData(HttpSession session, JqGridParam param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        ArrayList<Long> roleIds = new ArrayList<Long>();
        if (!"true".equals(this.isActualize)) {
            roleIds.add(1L);
            roleIds.add(2L);
            roleIds.add(33000000000001L);
        }
        PageInfo list = this.secRoleService.getRoleList(param, roleIds);
        ArrayList roleList = new ArrayList();
        list.getList().forEach(r -> {
            if (!r.getRolename().equals("\u4e00\u822c\u7528\u6237(\u6d59\u6c5f)")) {
                roleList.add(r);
            }
        });
        list.setList(roleList);
        return new JqGridData(list, param);
    }

    @RequiresPermissions(value={"sys.role.view"})
    @RequestMapping(value={"permission"}, method={RequestMethod.GET})
    public String permission(Long permissionParentId, Boolean type, Model model) {
        this.getPermissions(permissionParentId, model);
        model.addAttribute("isView", (Object)type);
        return "sys/role/dialog_permission";
    }

    @RequiresPermissions(value={"sys.role.view"})
    @RequestMapping(value={"view/{id}"}, method={RequestMethod.GET})
    public String page_view(@PathVariable(value="id") Long id, Model model) {
        this.logger.info("\u7cfb\u7edf\u7ba1\u7406\u300b\u89d2\u8272\u7ba1\u7406\u300b\u67e5\u770b");
        SecRole secRole = this.getRoleInfos(id, model);
        this.getRolePermissions(id, model);
        if (secRole != null && secRole.getDataScope() != null) {
            String dataScopeName = DataScopeEnum.getName((Byte)secRole.getDataScope());
            model.addAttribute("dataScopeName", (Object)dataScopeName);
        }
        return "sys/role/dialog_view";
    }

    private void getRolePermissions(Long roleId, Model model) {
        SecPermissionParam query = new SecPermissionParam();
        query.setRoleId(roleId);
        List permissonDetailList = this.permissionService.getRolePermissionDetailList(query);
        model.addAttribute("permissonDetailList", (Object)permissonDetailList);
    }

    private void getPermissions(Long permissionParentId, Model model) {
        SecPermissionParam query = new SecPermissionParam();
        query.setParentId(permissionParentId);
        if (!"true".equals(this.isActualize)) {
            query.setIsActualize(Boolean.valueOf(false));
        }
        Map rolePermissionGroups = this.permissionService.getPermissionGroups(query);
        model.addAttribute("permissionParentId", (Object)permissionParentId);
        model.addAttribute("rolePermissionGroups", (Object)rolePermissionGroups);
    }

    private SecRole getRoleInfos(Long id, Model model) {
        Long permissionParentId = 1L;
        SecRole role = null;
        if (id == null) {
            role = new SecRole();
            role.setDataScope(Byte.valueOf((byte)3));
        } else {
            role = (SecRole)this.secRoleService.getById(id);
        }
        model.addAttribute("record", (Object)role);
        ArrayList<Long> perIds = new ArrayList<Long>();
        if (!"true".equals(this.isActualize)) {
            perIds.add(1L);
            perIds.add(2L);
            perIds.add(3L);
            perIds.add(5L);
            perIds.add(7L);
        }
        List permissionGroup = this.permissionService.getSecPermissionGroupList(perIds);
        permissionGroup.forEach(permission -> {
            if (permission.getPermissionName().equals("\u5173\u952e\u5de5\u4f5c")) {
                permission.setPermissionName("\u4e3b\u4f53\u5c65\u804c\u8fc7\u7a0b\u7ba1\u7406");
            }
            if (permission.getPermissionName().equals("\u81ea\u6211\u8bc4\u5b9a")) {
                permission.setPermissionName("\u5206\u7c7b\u81ea\u67e5");
            }
        });
        model.addAttribute("permissionGroup", (Object)permissionGroup);
        if (permissionGroup != null && permissionGroup.size() > 0) {
            SecPermission firstPermissionGroup = (SecPermission)permissionGroup.get(0);
            model.addAttribute("firstGroup", permissionGroup.get(0));
            permissionParentId = firstPermissionGroup.getId();
        }
        model.addAttribute("dataScopeEnums", (Object)DataScopeEnum.values());
        this.getPermissions(permissionParentId, model);
        return role;
    }

    @RequiresPermissions(value={"sys.role.edit"})
    @RequestMapping(value={"add"}, method={RequestMethod.GET})
    public String page_add(HttpServletRequest request, HttpServletResponse response, Model model) {
        this.logger.info("\u7cfb\u7edf\u7ba1\u7406\u300b\u89d2\u8272\u7ba1\u7406\u300b\u65b0\u589e");
        this.getRoleInfos(null, model);
        return "sys/role/dialog_edit";
    }

    @RequiresPermissions(value={"sys.role.edit"})
    @RequestMapping(value={"edit/{id}"}, method={RequestMethod.GET})
    public String page_edit(@PathVariable(value="id") Long id, HttpServletRequest request, HttpServletResponse response, Model model) {
        this.logger.info("\u7cfb\u7edf\u7ba1\u7406\u300b\u89d2\u8272\u7ba1\u7406\u300b\u7f16\u8f91");
        SecRole role = this.getRoleInfos(id, model);
        this.getRolePermissions(id, model);
        if (role.getCid() == null) {
            return "sys/role/dialog_view";
        }
        return "sys/role/dialog_edit";
    }

    @Log(title="\u4fee\u6539\u89d2\u8272", type=21)
    @RequiresPermissions(value={"sys.role.edit"})
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"edit"}, method={RequestMethod.POST})
    public ResponseData<SecRole> ajax_edit(HttpServletRequest request, HttpServletResponse response, RoleFormVO roleForm) throws ServiceException {
        this.logger.info("ajax-\u7cfb\u7edf\u7ba1\u7406\u300b\u89d2\u8272\u7ba1\u7406\u300b\u7f16\u8f91");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        this.setRolePermissionsByRequest(request, roleForm);
        SecRole role = this.rolePermissionService.editForm(roleForm, loginStaffId, cid);
        ResponseData resultData = new ResponseData(ResponseStateEnum.success);
        resultData.setResult((Object)role);
        return resultData;
    }

    private void setRolePermissionsByRequest(HttpServletRequest request, RoleFormVO data) {
        String[] permissionDetailIds = request.getParameterValues("permissionDetailId");
        if (permissionDetailIds == null || permissionDetailIds.length == 0) {
            return;
        }
        ArrayList<SecRolePermission> rpList = new ArrayList<SecRolePermission>();
        for (String permissionDetailId : permissionDetailIds) {
            SecRolePermission srp = new SecRolePermission();
            srp.setSecPermissionDetailId(Long.valueOf(Long.parseLong(permissionDetailId)));
            rpList.add(srp);
        }
        data.setRpList(rpList);
    }

    @Log(title="\u5220\u9664\u89d2\u8272", type=22)
    @RequiresPermissions(value={"sys.role.edit"})
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"del/{id}"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_del(@PathVariable(value="id") Long id) {
        this.logger.info("ajax-\u7cfb\u7edf\u7ba1\u7406\u300b\u89d2\u8272\u7ba1\u7406\u300b\u5220\u9664");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        SecRole role = (SecRole)this.secRoleService.getById(id);
        if (role.getCid() == null) {
            return new ResponseData(ResponseStateEnum.fail, "\u7cfb\u7edf\u81ea\u5e26\u89d2\u8272\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        if (role.getCid().longValue() != cid.longValue()) {
            return new ResponseData(ResponseStateEnum.fail, "\u5220\u9664\u5931\u8d25\uff01");
        }
        this.secRoleService.delete((Object)role, loginStaffId);
        return new ResponseData(ResponseStateEnum.success);
    }
}

