/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.sys;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.modules.health.entity.sys.ProjectFeedBack;
import cn.smarthse.modules.health.entity.work.check.PhcOccupationalDiseaserDetail;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheck;
import cn.smarthse.modules.health.enums.sys.FeedBackTypeEnum;
import cn.smarthse.modules.health.service.sys.IProjectFeedBackService;
import cn.smarthse.modules.health.service.work.check.IPhcOccupationalDiseaserDetailService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/feedback"})
public class ProjectFeedBackController
extends ControllerSupport {
    @DubboReference
    IPhcPhysicalCheckService phcPhysicalCheckService;
    @DubboReference
    IProjectFeedBackService projectFeedBackService;
    @DubboReference
    private IPhcOccupationalDiseaserDetailService diseaserDetailService;

    @RequestMapping(value={"/check"})
    public String toCheckFeedBackPage(ModelMap m) {
        return "work/check/dialog/check_feedback";
    }

    @RequestMapping(value={"/check/detail"})
    public String toCheckFeedBackDetailPage(ModelMap m) {
        return "work/check/dialog/check_feedback_detail";
    }

    @RequestMapping(value={"/check/add"})
    @ResponseBody
    public ResponseData<Long> addCheckFeedBack(ProjectFeedBack data, @RequestParam(value="projectId") Long projectId) {
        PhcPhysicalCheck check = this.phcPhysicalCheckService.getDetailById(projectId);
        data.setThirdorgId(check.getHospital());
        this.logger.info("\u3010\u4f53\u68c0\u53cd\u9988\u6dfb\u52a0\u3011");
        Long cid = UserUtils.getLoginStaffCompanyId();
        data.setCid(cid);
        ResponseData res = new ResponseData();
        data.setProjectId(projectId);
        data.setType(FeedBackTypeEnum.check.getValue());
        data.setThirdorgId(check.getHospital());
        ProjectFeedBack feedBack = this.projectFeedBackService.addFeedBack(data);
        res.setResult((Object)feedBack.getId());
        return res;
    }

    @RequestMapping(value={"/diseaser/add"})
    @ResponseBody
    public ResponseData<Long> addDiseaserFeedBack(ProjectFeedBack data, @RequestParam(value="projectId") Long projectId) {
        this.logger.info("\u3010\u804c\u4e1a\u75c5\u4eba\u540d\u5355\u53cd\u9988\u6dfb\u52a0\u3011");
        Long cid = UserUtils.getLoginStaffCompanyId();
        data.setCid(cid);
        ResponseData res = new ResponseData();
        data.setProjectId(projectId);
        PhcOccupationalDiseaserDetail detail = (PhcOccupationalDiseaserDetail)this.diseaserDetailService.getById(projectId);
        if (detail != null) {
            data.setThirdorgId(detail.getDiagnosedId());
        }
        data.setType(FeedBackTypeEnum.disease.getValue());
        ProjectFeedBack feedBack = this.projectFeedBackService.addFeedBack(data);
        res.setResult((Object)feedBack.getId());
        return res;
    }
}

