/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.sys;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.health.entity.sys.SecPermission;
import cn.smarthse.modules.health.entity.sys.SecResource;
import cn.smarthse.modules.health.entity.sys.vo.SecPermissionParam;
import cn.smarthse.modules.health.service.sys.ISecPermissionService;
import cn.smarthse.modules.health.service.sys.ISecResourceService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/sys/permission"})
public class PermissionController
extends ControllerSupport {
    @DubboReference
    ISecPermissionService permissionService;
    @DubboReference
    ISecResourceService resourceService;

    @RequiresPermissions(value={"sys.permission.view"})
    @RequestMapping(method={RequestMethod.GET})
    public String page_List(HttpServletRequest request, HttpServletResponse response, Model model, Long groupId) {
        this.logger.info("\u7cfb\u7edf\u7ba1\u7406\u300b\u6743\u9650\u7ba1\u7406\u300b\u5217\u8868");
        ArrayList<Long> perIds = new ArrayList<Long>();
        if (!"true".equals(this.isActualize)) {
            perIds.add(1L);
            perIds.add(2L);
            perIds.add(5L);
            perIds.add(7L);
        }
        List permissionGroup = this.permissionService.getSecPermissionGroupList(perIds);
        Boolean staffImport = false;
        String serviceName = request.getServerName();
        if (serviceName.contains("51vip")) {
            staffImport = true;
        } else {
            String userName = UserUtils.getCurrentUser().getUsername();
            String uName = "15068756653";
            if (userName != null && userName.equals(uName)) {
                staffImport = true;
            }
        }
        model.addAttribute("staffImport", (Object)staffImport);
        model.addAttribute("permissionGroup", (Object)permissionGroup);
        model.addAttribute("groupId", (Object)groupId);
        return "sys/permission/list";
    }

    @RequiresPermissions(value={"sys.permission.view"})
    @ResponseBody
    @RequestMapping(value={"listData"})
    public JqGridData<SecPermission> listData(HttpSession session, JqGridParam param, SecPermissionParam query) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        PageInfo list = this.permissionService.getSecPermissionList(param, query);
        JqGridData data = new JqGridData(list, param);
        return data;
    }

    @RequiresPermissions(value={"sys.permission.view"})
    @RequestMapping(value={"view/{id}"}, method={RequestMethod.GET})
    public String page_view(@PathVariable(value="id") Long id, Model model) {
        this.logger.info("\u7cfb\u7edf\u7ba1\u7406\u300b\u6743\u9650\u7ba1\u7406\u300b\u67e5\u770b");
        SecPermission permission = this.permissionService.getByIDWithEntity(id);
        if (permission.getSecResourceId() != null && permission.getSecResourceId() > 0L) {
            SecResource resource = (SecResource)this.resourceService.getById(permission.getSecResourceId());
            model.addAttribute("resource", (Object)resource);
        }
        model.addAttribute("record", (Object)permission);
        return "sys/permission/dialog_view";
    }
}

