/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.sys;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.modules.health.entity.sys.Param;
import cn.smarthse.modules.health.service.sys.IParamService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/sys/param"})
public class ParamController
extends ControllerSupport {
    @DubboReference
    private IParamService paramService;

    @Log(title="\u83b7\u53d6\u53c2\u6570\u5217\u8868", type=2)
    @RequiresPermissions(value={"sys.param.view"})
    @RequestMapping(value={"index"}, method={RequestMethod.GET})
    public String page_List(HttpServletRequest request, HttpServletResponse response, Model model) {
        this.logger.info("\u7cfb\u7edf\u7ba1\u7406\u300b\u7cfb\u7edf\u53c2\u6570\u5217\u8868");
        return "sys/param/list";
    }

    @ResponseBody
    @RequestMapping(value={"listData"}, method={RequestMethod.GET})
    public JqGridData<Param> getParamList(JqGridParam gparam, Param param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        PageInfo page = this.paramService.getParamPage(gparam, param);
        JqGridData data = new JqGridData(page, gparam);
        return data;
    }

    @RequiresPermissions(value={"sys.param.edit"})
    @RequestMapping(value={"add"}, method={RequestMethod.GET})
    public String page_add(HttpServletRequest request, HttpServletResponse response, ModelMap m, Long id) {
        this.logger.info("\u7cfb\u7edf\u7ba1\u7406\u300b\u53c2\u6570\u65b0\u589e");
        Param info = new Param();
        if (id != null) {
            info = (Param)this.paramService.getById(id);
        }
        m.put((Object)"data", (Object)info);
        return "sys/param/dialog_addParam";
    }

    @RequiresPermissions(value={"sys.param.edit"})
    @Log(title="\u53c2\u6570\u65b0\u589e/\u7f16\u8f91", type=20)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"add"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_addUser(Param info, HttpServletRequest request, HttpServletResponse response) {
        this.logger.info("ajax-\u7cfb\u7edf\u7ba1\u7406\u300b\u53c2\u6570\u65b0\u589e/\u7f16\u8f91");
        ResponseData res = new ResponseData();
        Long staffid = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        Boolean ishave = this.paramService.haveThisrKeyByCid(info.getId(), cid, info.getParamKey());
        if (ishave.booleanValue()) {
            res.setContent("\u8be5\u952e\u540d\u53c2\u6570\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u952e\u540d");
            res.setState(ResponseStateEnum.warning);
        } else {
            if (info != null && info.getId() != null) {
                this.paramService.update((Object)info, staffid);
            } else {
                this.paramService.add((Object)info, staffid, cid);
            }
            res.setContent("\u7f16\u8f91\u6210\u529f\uff01");
        }
        return res;
    }

    @RequiresPermissions(value={"sys.param.edit"})
    @Log(title="\u5220\u9664\u7cfb\u7edf\u53c2\u6570", type=22)
    @ResponseBody
    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    public ResponseData<Integer> delete(Long id, ModelMap m) {
        this.logger.info("\u3010\u5220\u9664\u7cfb\u7edf\u53c2\u6570\u3011- \u5220\u9664");
        ResponseData data = new ResponseData();
        Param info = (Param)this.paramService.getById(id);
        info.setIsValid(Boolean.valueOf(false));
        this.paramService.update((Object)info);
        data.setContent("\u5220\u9664\u6210\u529f\uff01");
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"name"}, method={RequestMethod.GET})
    public String getByKey(String paramKey) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        String name = this.paramService.getByKey(paramKey, cid);
        return name;
    }
}

