/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.sys;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.health.entity.sys.SysLog;
import cn.smarthse.modules.health.service.sys.ISysLogService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/sys/log"})
public class LogController
extends ControllerSupport {
    @DubboReference
    ISysLogService logService;

    @RequiresPermissions(value={"sys.log"})
    @RequestMapping(method={RequestMethod.GET})
    public String page_List(HttpServletRequest request, HttpServletResponse response, Model model) {
        this.logger.info("\u7cfb\u7edf\u7ba1\u7406\u300b\u6743\u9650\u7ba1\u7406\u300b\u5217\u8868");
        Boolean staffImport = false;
        String serviceName = request.getServerName();
        String userName = UserUtils.getCurrentUser().getUsername();
        String uName = "15068756653";
        String u1Name = "zhkc";
        if (userName != null && (userName.equals(uName) || userName.equals(u1Name))) {
            staffImport = true;
        }
        model.addAttribute("staffImport", (Object)staffImport);
        return "sys/log/list";
    }

    @RequiresPermissions(value={"sys.log.view"})
    @ResponseBody
    @RequestMapping(value={"listData"})
    public JqGridData<SysLog> listData(HttpSession session, JqGridParam param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        PageInfo list = this.logService.getList(param);
        return new JqGridData(list, param);
    }

    @RequiresPermissions(value={"sys.log.view"})
    @RequestMapping(value={"view/{id}"}, method={RequestMethod.GET})
    public String page_view(@PathVariable(value="id") Long id, Model model) {
        this.logger.info("\u7cfb\u7edf\u7ba1\u7406\u300b\u6743\u9650\u7ba1\u7406\u300b\u67e5\u770b");
        return "sys/log/dialog_view";
    }

    @RequestMapping(value={"error"})
    public String errorpage(ModelMap m, String month) throws Exception {
        return "sys/log/error";
    }

    @RequestMapping(value={"/error/listData"})
    @ResponseBody
    public JqGridData<SysLog> errorListData(JqGridParam param) {
        PageInfo pageLogInfo = this.logService.getErrorList(param);
        JqGridData data = new JqGridData(pageLogInfo, param);
        return data;
    }

    @RequestMapping(value={"error/{id}"})
    public String viewLog(ModelMap m, @PathVariable(value="id") Long id) throws Exception {
        SysLog log = (SysLog)this.logService.getById(id);
        m.addAttribute("log", (Object)log);
        return "sys/log/viewLog";
    }
}

