/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.supervisionlaw;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.mapper.JsonMapper;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.modules.health.supervise.entity.supAndLawInfo.SupervisionSupInfo;
import cn.smarthse.modules.health.supervise.enums.SuperviseLawYrdwJcjgEnum;
import cn.smarthse.modules.health.supervise.model.supervisionlaw.SupervisionLawListSearchParamModel;
import cn.smarthse.modules.health.supervise.model.supervisionlaw.SupervisionListModel;
import cn.smarthse.modules.health.supervise.service.supervisionlaw.ISupervisionLawService;
import cn.smarthse.modules.health.supervise.vo.JsonJcxVo;
import cn.smarthse.util.common.StringUtils;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"supervise"})
public class SuperviseController {
    @DubboReference(timeout=60000)
    ISupervisionLawService supervisionLawService;

    @RequestMapping(value={"/index"})
    @RequiresPermissions(value={"supervise"})
    public String supervisionIndex(ModelMap m) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Integer earliestYearSup = this.supervisionLawService.getEarliestYearSup(cid);
        m.put((Object)"defaultYear", (Object)earliestYearSup);
        return "views/supervisionAndLawEnforcementManagement/supervise/superviseList";
    }

    @ResponseBody
    @RequestMapping(value={"/listData"})
    public JqGridData<SupervisionListModel> listData(JqGridParam jParam, SupervisionLawListSearchParamModel param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        PageInfo page = this.supervisionLawService.getSupervisionInfoList(jParam, param);
        JqGridData data = new JqGridData(page, jParam);
        return data;
    }

    @RequestMapping(value={"/view"})
    public String view(ModelMap m, Long id) {
        SupervisionSupInfo info = this.supervisionLawService.getSupervisionSupInfoById(id);
        if (StringUtils.isNotEmpty((String)info.getYrdwJcjg())) {
            String yrdwJcjg = SuperviseLawYrdwJcjgEnum.getNameByCode((Integer)Integer.valueOf(info.getYrdwJcjg()));
            info.setYrdwJcjg(yrdwJcjg);
        }
        if (StringUtils.isNotEmpty((String)info.getJcx())) {
            List jcx = JsonMapper.jsonToList((String)info.getJcx(), JsonJcxVo.class);
            m.put((Object)"jcx", (Object)jcx);
        }
        if (StringUtils.isNotEmpty((String)info.getROrgname())) {
            m.put((Object)"rOrgname", (Object)info.getROrgname());
        }
        DesensitizationUtils.setDesensitizationFieldFromObject((Object)info);
        m.put((Object)"info", (Object)info);
        return "/views/supervisionAndLawEnforcementManagement/supervise/superviseDetail";
    }
}

