/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.supervisionlaw;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.modules.health.supervise.entity.supAndLawInfo.SupervisionExeLawInfo;
import cn.smarthse.modules.health.supervise.model.supervisionlaw.ExLawListModel;
import cn.smarthse.modules.health.supervise.model.supervisionlaw.SupervisionLawListSearchParamModel;
import cn.smarthse.modules.health.supervise.service.supervisionlaw.ISupervisionLawService;
import cn.smarthse.util.common.StringUtils;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"punish"})
public class PunishController {
    @DubboReference(timeout=60000)
    ISupervisionLawService supervisionLawService;

    @RequestMapping(value={"/index"})
    @RequiresPermissions(value={"punish"})
    public String lawIndex(ModelMap m) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Integer earliestYearExeLaw = this.supervisionLawService.getEarliestYearExeLaw(cid);
        m.put((Object)"defaultYear", (Object)earliestYearExeLaw);
        return "/views/supervisionAndLawEnforcementManagement/punish/punishList";
    }

    @ResponseBody
    @RequestMapping(value={"/listData"})
    public JqGridData<ExLawListModel> listData(JqGridParam jParam, SupervisionLawListSearchParamModel param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        PageInfo page = this.supervisionLawService.getExeLawInfoList(jParam, param);
        JqGridData data = new JqGridData(page, jParam);
        return data;
    }

    @RequestMapping(value={"/view"})
    public String view(ModelMap m, Long id) {
        SupervisionExeLawInfo info = this.supervisionLawService.getSupervisionExeLawInfoById(id);
        if (StringUtils.isNotEmpty((String)info.getROrgname())) {
            m.put((Object)"rOrgname", (Object)info.getROrgname());
        }
        DesensitizationUtils.setDesensitizationFieldFromObject((Object)info);
        m.put((Object)"info", (Object)info);
        return "/views/supervisionAndLawEnforcementManagement/punish/punishDetail";
    }
}

