/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.riskev;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.util.Java2WordGeneratorTemp;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.pdf.HtmlToPdf;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.service.base.selfjudge.ISelfInspectionRiskAssessmentReportInfoService;
import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrganization;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrganizationService;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluate;
import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluateData;
import cn.smarthse.services.hfi.api.model.riskev.EvQueryParam;
import cn.smarthse.services.hfi.api.model.riskev.QueryPageRiskEvDataParam;
import cn.smarthse.services.hfi.api.pojo.vo.riskev.RiskDecisionVo;
import cn.smarthse.services.hfi.api.pojo.vo.riskev.RiskExposeEvaluateVo;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import cn.smarthse.services.hfi.api.service.riskev.IRiskExposeEvaluateDataService;
import cn.smarthse.services.hfi.api.service.riskev.IRiskExposeEvaluateService;
import cn.smarthse.util.common.date.DateUtils;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/riskev"})
public class RiskEvController
extends ControllerSupport {
    @DubboReference(timeout=60000)
    IRiskExposeEvaluateDataService evaluateDataService;
    @DubboReference
    IRiskExposeEvaluateService evaluateService;
    @DubboReference
    ICheckPlanService checkPlanService;
    @DubboReference(version="1.0.0")
    ISysAreaProvideService areaProvideService;
    @DubboReference(version="1.0.0")
    ICompanyProvideService companyProvideService;
    @DubboReference
    IThirdOrganizationService organizationService;
    @DubboReference(version="1.0.0")
    ISysAreaProvideService provideService;
    @DubboReference
    ISelfInspectionRiskAssessmentReportInfoService reportInfoService;

    @RequestMapping(value={"/evDetail"})
    public String evDetail(Long evId, ModelMap m) {
        String[] split;
        RiskExposeEvaluate ev = (RiskExposeEvaluate)this.evaluateService.getById((Serializable)evId);
        m.addAttribute("ev", (Object)ev);
        m.addAttribute("tableType", (Object)1);
        if (StringUtils.isNotEmpty((String)ev.getRedundantSourceTablesIds()) && (split = ev.getRedundantSourceTablesIds().split(",")).length == 2) {
            List collect = Arrays.stream(split).map(Long::parseLong).collect(Collectors.toList());
            List infoList = this.evaluateService.getInfoList(collect);
            for (RiskExposeEvaluate temp : infoList) {
                if (temp.getWandaZywsCheckId() == null) {
                    m.addAttribute("ev1", (Object)temp);
                    continue;
                }
                m.addAttribute("ev2", (Object)temp);
            }
            m.addAttribute("tableType", (Object)2);
        }
        if (ev.getOrgId() != null) {
            ThirdOrganization org = (ThirdOrganization)this.organizationService.getById(ev.getOrgId());
            m.addAttribute("org", (Object)org);
        }
        if (ev.getProjectAreaId() != null) {
            AreaModel area = this.provideService.getAreaById(ev.getProjectAreaId());
            m.addAttribute("area", (Object)area.getFullname());
        }
        if (ev.getReportStatus() == 4) {
            RiskDecisionVo decisionVo = this.evaluateService.queryTouchNumAndLevel(evId);
            m.addAttribute("decisionVo", (Object)decisionVo);
        }
        return "views/classificationSelfAssessment/viewExposureReiskPage";
    }

    @ResponseBody
    @RequestMapping(value={"/evList.json"})
    public PageInfo<RiskExposeEvaluateVo> evList(EvQueryParam param, String startTimeStr, String endTimeStr) {
        if (startTimeStr != null && !"".equals(startTimeStr)) {
            param.setStartTime(DateUtils.parseDateTime((String)(startTimeStr + " 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if (endTimeStr != null && !"".equals(endTimeStr)) {
            param.setEndTime(DateUtils.parseDateTime((String)(endTimeStr + " 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        param.setCid(UserUtils.getLoginStaffCompanyId());
        PageInfo page = this.reportInfoService.pageRiskExposeEvaluateVo(param);
        for (RiskExposeEvaluateVo risk : page.getList()) {
            String[] split;
            ThirdOrganization org;
            if (risk.getOrgName() == null && risk.getOrgId() != null && (org = (ThirdOrganization)this.organizationService.getById(risk.getOrgId())) != null) {
                risk.setOrgName(org.getName());
            }
            if (!StringUtils.isNotEmpty((String)risk.getRedundantSourceTablesIds()) || (split = risk.getRedundantSourceTablesIds().split(",")).length != 2) continue;
            risk.setTableType(Integer.valueOf(2));
            List collect = Arrays.stream(split).map(Long::parseLong).collect(Collectors.toList());
            List infoList = this.evaluateService.getInfoList(collect);
            for (RiskExposeEvaluate temp : infoList) {
                if (temp.getWandaZywsCheckId() == null) {
                    risk.setOrgName1(temp.getOrgName());
                    risk.setReportStatus1(temp.getReportStatus());
                    continue;
                }
                risk.setOrgName2(temp.getOrgName());
                risk.setReportStatus2(temp.getReportStatus());
            }
        }
        return page;
    }

    @ResponseBody
    @RequestMapping(value={"/queryDataList.json"})
    public PageInfo<RiskExposeEvaluateData> queryDataList(QueryPageRiskEvDataParam param) {
        PageInfo page = this.evaluateDataService.queryPageDataList(param);
        return page;
    }

    @ResponseBody
    @RequestMapping(value={"/getEarlyCheckPlan"})
    public ResponseData<String> getEarlyCheckPlan() {
        Long cid = UserUtils.getLoginStaffCompanyId();
        return ResponseData.success((String)this.checkPlanService.getEarlyCheckPlan(cid, Arrays.asList(2, 3), null));
    }

    @RequestMapping(value={"/exportProject"})
    public void export(HttpServletRequest request, HttpServletResponse response, QueryPageRiskEvDataParam param) throws IOException, InvocationTargetException, IllegalAccessException, NoSuchMethodException, InterruptedException {
        param.setPage(Integer.valueOf(1));
        param.setRows(Integer.valueOf(Integer.MAX_VALUE));
        RiskExposeEvaluate ev = (RiskExposeEvaluate)this.evaluateService.getById((Serializable)param.getEvId());
        PageInfo pageInfo = this.evaluateDataService.queryPageDataList(param);
        RiskDecisionVo decisionVo = this.evaluateService.queryTouchNumAndLevel(param.getEvId());
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        for (RiskExposeEvaluateData data : pageInfo.getList()) {
            if (StringUtils.isEmpty((CharSequence)data.getCtwa())) {
                data.setCtwa("/");
            }
            if (StringUtils.isEmpty((CharSequence)data.getCste())) {
                data.setCste("/");
            }
            if (StringUtils.isEmpty((CharSequence)data.getCstel())) {
                data.setCstel("/");
            }
            if (StringUtils.isEmpty((CharSequence)data.getCme())) {
                data.setCme("/");
            }
            if (StringUtils.isEmpty((CharSequence)data.getExceedLimit())) {
                data.setExceedLimit("/");
            }
            if (StringUtils.isEmpty((CharSequence)data.getNoiseLevel())) {
                data.setNoiseLevel("/");
            }
            if (StringUtils.isEmpty((CharSequence)data.getOtherFactorValue())) {
                data.setOtherFactorValue("/");
            }
            if (data.getCheckTouchLevel() == null) {
                data.setCheckTouchLevel(Integer.valueOf(3));
            }
            if (!StringUtils.isEmpty((CharSequence)data.getPePcTwa())) continue;
            data.setPePcTwa("/");
        }
        dataMap.put("evDataList", pageInfo.getList());
        dataMap.put("decisionVo", decisionVo);
        dataMap.put("comName", UserUtils.getCurrentCompany().getName());
        File f = new File("riskev_data_" + UserUtils.getCurrentUserId() + "_" + System.currentTimeMillis() + ".html");
        File pdf = new File("riskev_data_" + UserUtils.getCurrentUserId() + "_" + System.currentTimeMillis() + ".pdf");
        String templateName = "rist_ev_data_2007.ftl";
        if (ev.getTargetStandardId().equals(2L)) {
            templateName = "rist_ev_data_2019.ftl";
        }
        String realPath = "riskev/" + templateName;
        File file = Java2WordGeneratorTemp.createDoc(dataMap, (String)realPath, (String)f.getAbsolutePath());
        response.setContentType("application/vnd.ms-excel");
        response.addHeader("Content-Disposition", "attachment; filename*=utf-8'zh_cn'" + URLEncoder.encode(new String("\u7528\u4eba\u5355\u4f4d\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u63a5\u89e6\u60c5\u51b5\u4e00\u89c8\u8868.pdf".getBytes()), "utf-8"));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("-O", "Landscape");
        params.put("-L", "20mm");
        HtmlToPdf.html2PdfByParam((String)f.getAbsolutePath(), (String)pdf.getAbsolutePath(), params);
        FileCopyUtils.copy((InputStream)new FileInputStream(pdf), (OutputStream)response.getOutputStream());
        file.delete();
        pdf.delete();
    }

    public double getCeilDouble(double number) {
        String str = new DecimalFormat("0.0000000000").format(number);
        String[] fore = str.split("[1-9]", 2);
        String[] split = str.split(".", 2);
        int aft = Integer.parseInt(split[1].substring(1));
        int len = ("" + aft).length();
        aft = (int)Math.ceil((double)aft / Math.pow(10.0, len - 1));
        return Double.parseDouble(fore[0] + aft);
    }
}

