/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.newcompliance;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.work.certificate.CertificateStaffDetail;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyExitItem;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyInfo;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyItemdata;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyObjectionApply;
import cn.smarthse.modules.health.newcompliance.enums.NewComplianceExitTypeEnum;
import cn.smarthse.modules.health.newcompliance.model.NewComplianceValidModel;
import cn.smarthse.modules.health.newcompliance.model.NewCompliantChargePersonCertificateParam;
import cn.smarthse.modules.health.newcompliance.model.NewFieldValidResultModel;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyExitItemService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyInfoService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyObjectionApplyService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceScoreRefreshService;
import cn.smarthse.modules.health.newcompliance.service.INewCompliantChargePersonCertificateService;
import cn.smarthse.modules.health.newcompliance.vo.NewComplianceCollectInfo;
import cn.smarthse.modules.health.newcompliance.vo.NewComplianceCompanyExitItemListVo;
import cn.smarthse.modules.health.newcompliance.vo.NewComplianceCompanyExitItemVo;
import cn.smarthse.modules.health.newcompliance.vo.NewComplianceItemInfoVo;
import cn.smarthse.modules.health.newcompliance.vo.NewCompliantChargePersonCertificateVo;
import cn.smarthse.modules.health.newcompliance.vo.NewSaveItemDataParam;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicNewService;
import cn.smarthse.modules.health.supervise.entity.sysparam.ImportantIndustryCategory;
import cn.smarthse.modules.health.supervise.service.importantIndustryCategory.IImportantIndustryCategoryService;
import cn.smarthse.modules.health.vo.summary.ReformSearchVo;
import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluate;
import cn.smarthse.services.hfi.api.model.riskev.EvQueryParam;
import cn.smarthse.services.hfi.api.service.riskev.IRiskExposeEvaluateService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.alibaba.excel.util.StringUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import java.time.LocalDateTime;
import java.time.Year;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.redisson.api.RLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/newcomplianceinfo"})
public class NewComplianceInfoController
extends ControllerSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewComplianceInfoController.class);
    @DubboReference
    INewComplianceCompanyInfoService infoService;
    @DubboReference
    INewComplianceScoreRefreshService scoreRefreshService;
    @DubboReference
    private INewCompliantChargePersonCertificateService personCertificateService;
    @DubboReference
    IStaffInfoService staffInfoService;
    @DubboReference(timeout=5000000)
    ISysFileProvideService sysFileProvideService;
    @DubboReference
    INewComplianceCompanyExitItemService exitItemService;
    @DubboReference
    private IImportantIndustryCategoryService categoryService;
    @DubboReference
    INewComplianceCompanyObjectionApplyService objectionApplyService;
    @DubboReference
    private IRiskExposeEvaluateService riskExposeEvaluateService;
    @DubboReference
    private IReformItemBasicNewService reformService;
    private static final String COMPLIANCE_LOCK_KEY = "NewComplianceInfoController:";

    @GetMapping(value={"recalculateScore"})
    @Log(title="recalculateScore", type=2)
    @ResponseBody
    public String recalculateScore() {
        Long cid = UserUtils.getLoginStaffCompanyId();
        this.scoreRefreshService.newComplianceDayScoreChangeRecord(null);
        return "success";
    }

    @GetMapping(value={"syncExitItem"})
    @Log(title="\u540c\u6b65\u9000\u51fa\u9879", type=2)
    @ResponseBody
    public String syncExitItem() {
        Long cid = UserUtils.getLoginStaffCompanyId();
        this.exitItemService.syncExitItem(Collections.singletonList(cid));
        return "success";
    }

    @RequestMapping(value={"initcompliance"})
    @ResponseBody
    @Log(title="\u521d\u59cb\u5316\u5408\u89c4\u6570\u636e", type=2)
    public NewComplianceCompanyInfo initcompliance() {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        return this.infoService.addCompliance(cid, loginStaffId);
    }

    @RequestMapping(value={"submitcompliance"}, method={RequestMethod.POST})
    @ResponseBody
    @Log(title="\u63d0\u4ea4\u5408\u89c4\u6570\u636e", type=2)
    public ResponseData<NewComplianceCompanyInfo> submitcompliance(Long complianceId) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        List basicViews = this.reformService.getReformItemBasicCountView(new ReformSearchVo().setCid(cid));
        if (CollectionUtils.isNotEmpty((Collection)basicViews)) {
            return ResponseData.fail((String)"\u8d35\u516c\u53f8\u5b58\u5728\u672a\u5316\u89e3\u7684\u98ce\u9669\uff0c\u9700\u5148\u5b8c\u6210 \u98ce\u9669\u5316\u89e3>\uff0c\u65b9\u53ef\u8fdb\u884c\u4e0b\u4e00\u6b65");
        }
        NewComplianceCompanyInfo newComplianceCompanyInfo = this.infoService.submitCompliance(cid, complianceId, loginStaffId);
        return ResponseData.success((Object)newComplianceCompanyInfo);
    }

    @RequestMapping(value={"savepromisedata"})
    @ResponseBody
    @Log(title="\u4fdd\u5b58\u4f01\u4e1a\u627f\u8bfa\u5185\u5bb9\u6570\u636e", type=2)
    public ResponseData<Boolean> savePromiseData(@RequestBody NewSaveItemDataParam param) {
        ResponseData data = new ResponseData();
        try {
            Boolean flag = this.infoService.savePromiseData(param.getItemdata());
            data.setResult((Object)flag);
            return data;
        }
        catch (Exception e) {
            data.setState(ResponseStateEnum.fail);
            return data;
        }
    }

    @RequestMapping(value={"updatepagestate"})
    @ResponseBody
    @Log(title="\u66f4\u65b0\u9996\u6b21\u8fdb\u5165\u627f\u8bfa\u5185\u5bb9\u72b6\u6001", type=2)
    public ResponseData<String> updatepagestate(Long complianceId) {
        ResponseData data = new ResponseData();
        try {
            NewComplianceCompanyInfo info = new NewComplianceCompanyInfo();
            info.setId(complianceId);
            info.setFirstTimeInPromisepage(Boolean.valueOf(false));
            this.infoService.update((Object)info, UserUtils.getLoginStaffId());
            data.setResult((Object)"\u66f4\u65b0\u6210\u529f");
            return data;
        }
        catch (Exception e) {
            data.setState(ResponseStateEnum.fail);
            return data;
        }
    }

    @RequestMapping(value={"getItemInfo"})
    @ResponseBody
    public NewComplianceItemInfoVo getItemInfo(Long complianceId, String code) {
        return this.infoService.getItemVo(complianceId, code, null, false);
    }

    @RequestMapping(value={"getItemCollectInfo"})
    @ResponseBody
    public NewComplianceCollectInfo getItemCollectInfo(Long complianceId) {
        return this.infoService.getItemCollectInfo(complianceId);
    }

    @RequestMapping(value={"/getExitItemInfo"})
    @ResponseBody
    public List<NewComplianceCompanyExitItemListVo> getExitItemInfo(Long complianceId) {
        List list = this.exitItemService.getItemByComplianceIdAndType(complianceId, null);
        List applyList = this.objectionApplyService.listObjectionApply(complianceId, Arrays.asList(10001L, 10002L, 10003L, 10004L), Integer.valueOf(2), Arrays.asList(1));
        Map applyMap = applyList.stream().collect(Collectors.toMap(NewComplianceCompanyObjectionApply::getItemcodeId, Function.identity()));
        HashMap<Integer, Long> keyMapping = new HashMap<Integer, Long>();
        keyMapping.put(1, 10001L);
        keyMapping.put(2, 10002L);
        keyMapping.put(3, 10003L);
        keyMapping.put(4, 10004L);
        List exitItem = this.exitItemService.queryHasExititems(complianceId);
        Map<Integer, List<NewComplianceCompanyExitItem>> hasExititemsMap = exitItem.stream().collect(Collectors.groupingBy(NewComplianceCompanyExitItem::getType));
        List fine = hasExititemsMap.getOrDefault(NewComplianceExitTypeEnum.FINE.getKey(), Collections.emptyList());
        List<NewComplianceCompanyExitItem> reference = hasExititemsMap.getOrDefault(NewComplianceExitTypeEnum.REFERENCE_DATA.getKey(), Collections.emptyList());
        if (list != null && !list.isEmpty()) {
            list.forEach(vo -> vo.setProveFiles(this.sysFileProvideService.getListByIds(vo.getProveFile())));
        }
        Map<Integer, List<NewComplianceCompanyExitItemVo>> map = list.stream().collect(Collectors.groupingBy(NewComplianceCompanyExitItemVo::getType));
        ArrayList<NewComplianceCompanyExitItemListVo> rsd = new ArrayList<NewComplianceCompanyExitItemListVo>();
        rsd.addAll(map.entrySet().stream().map(entry -> this.createItemListVo((Integer)entry.getKey(), (List)entry.getValue(), applyMap, keyMapping, fine, reference)).collect(Collectors.toList()));
        this.handleMissingTypes(rsd, map, keyMapping, reference);
        return rsd;
    }

    @RequestMapping(value={"loadRefData"})
    @ResponseBody
    public Map<String, ?> loadRefData(HttpServletRequest request, Long complianceId, String itemCode) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Map<String, Object> parameterMap = request.getParameterMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            String[] paramValues = (String[])entry.getValue();
            return paramValues.length > 0 ? paramValues[0] : null;
        }));
        return this.loadData(parameterMap, itemCode, complianceId, 1);
    }

    @RequestMapping(value={"loadItemData"})
    @ResponseBody
    public Map<String, ?> loadItemData(String itemCode, Long complianceId, Integer loadRefFlag) {
        return this.loadData(null, itemCode, complianceId, loadRefFlag);
    }

    private Map<String, ?> loadData(Map<String, Object> parameterMap, String itemCode, Long complianceId, Integer loadRefFlag) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        List complianceCompanyItemdata = this.scoreRefreshService.loadItemData(cid, complianceId, itemCode, loadRefFlag);
        if (CollectionUtils.isNotEmpty((Collection)complianceCompanyItemdata)) {
            Map<String, Object> dataMap = complianceCompanyItemdata.stream().collect(Collectors.toMap(NewComplianceCompanyItemdata::getFieldName, v -> v.getResultData() == null ? "" : v.getResultData(), (v1, v2) -> v1));
            return dataMap;
        }
        return Collections.emptyMap();
    }

    @RequestMapping(value={"syncRefresh"})
    @Log(title="\u5237\u65b0\u4f01\u4e1a\u5408\u89c4\u6570\u636e\u4e0e\u5206\u6570", type=2)
    @ResponseBody
    public String syncRefresh(HttpServletRequest request, Long cid, String itemCode) {
        if (cid == null) {
            cid = UserUtils.getLoginStaffCompanyId();
        }
        Map<String, Object> parameterMap = request.getParameterMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            String[] paramValues = (String[])entry.getValue();
            return paramValues.length > 0 ? paramValues[0] : null;
        }));
        log.info("\u8fdb\u5165syncRefresh\u65b9\u6cd5.........");
        if (StringUtils.isNotBlank((CharSequence)itemCode)) {
            this.scoreRefreshService.syncRefresh(cid, parameterMap, new String[]{itemCode});
        } else {
            this.scoreRefreshService.syncRefresh(cid, parameterMap, new String[0]);
        }
        return "\u5b8c\u6210";
    }

    @RequestMapping(value={"validaFristStepData"})
    @ResponseBody
    public ResponseData<List<NewComplianceValidModel>> validaFristStepData(@RequestBody NewSaveItemDataParam promiseData) {
        ResponseData r = new ResponseData();
        if (CollectionUtils.isEmpty((Collection)promiseData.getItemdata())) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u627f\u8bfa\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            return r;
        }
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long complianceId = ((NewComplianceCompanyItemdata)promiseData.getItemdata().get(0)).getComplianceId();
        List<NewComplianceValidModel> firstValidModelList = this.validateItemData(promiseData.getItemdata(), cid, complianceId);
        if (CollectionUtils.isNotEmpty(firstValidModelList)) {
            r.setResult(firstValidModelList);
            return r;
        }
        Boolean flag = this.infoService.savePromiseData(promiseData.getItemdata());
        String[] itemCodes = new String[]{"06", "10", "09", "11", "12", "13"};
        List validModels = this.scoreRefreshService.validaFristStepData(cid, itemCodes);
        if (CollectionUtils.isEmpty((Collection)validModels)) {
            NewComplianceCompanyInfo info = (NewComplianceCompanyInfo)this.infoService.getById(complianceId);
            info.setStep(Byte.valueOf((byte)2));
            info.setFirstTimeInPromisepage(Boolean.valueOf(false));
            this.infoService.updateByPrimaryKey((Object)info, UserUtils.getLoginStaffId());
        }
        r.setResult((Object)validModels);
        return r;
    }

    public List<NewFieldValidResultModel> validStaffInfo(List<NewComplianceCompanyItemdata> allValidItemDataList, Long cid) {
        if (CollectionUtils.isEmpty(allValidItemDataList)) {
            return null;
        }
        ArrayList<NewFieldValidResultModel> fields = new ArrayList<NewFieldValidResultModel>();
        Integer localWorkNum = 0;
        Integer outWorkNum = 0;
        List staffInfoList = this.staffInfoService.getStaffInfoWorkNum(Collections.singletonList(cid), null);
        if (CollectionUtils.isNotEmpty((Collection)staffInfoList) && staffInfoList.get(0) != null) {
            localWorkNum = ((StaffInfo)staffInfoList.get(0)).getLocalWorkNum();
            outWorkNum = ((StaffInfo)staffInfoList.get(0)).getOutWorkNum();
        }
        String localNum = String.valueOf(localWorkNum);
        String outNum = String.valueOf(outWorkNum);
        String hasOccupationalTransfer = this.getItemDataResult(allValidItemDataList, 11201L, "hasOccupationalTransfer");
        String isExistOutWork = this.getItemDataResult(allValidItemDataList, 11202L, "isExistOutWork");
        String implementation = this.getItemDataResult(allValidItemDataList, 11202L, "implementation");
        String localNumCommit = this.getItemDataResult(allValidItemDataList, 11303L, "localNumCommit");
        String outNumCommit = this.getItemDataResult(allValidItemDataList, 11303L, "outNumCommit");
        if (StringUtils.isBlank((CharSequence)localNumCommit)) {
            fields.add(new NewFieldValidResultModel().setFiledName("localNumCommit").setReason("\u672c\u4f01\u4e1a\u63a5\u5bb3\u4eba\u5458\u672a\u586b\u5199"));
        } else if (!localNumCommit.equals(localNum)) {
            fields.add(new NewFieldValidResultModel().setFiledName("localNumCommit").setReason("\u5f53\u524d\u586b\u5199\u7684\u63a5\u5bb3\u4eba\u6570\u4e0e\u7cfb\u7edf\u4e2d\u672c\u4f01\u4e1a\u63a5\u5bb3\u4eba\u5458\u5217\u8868\u4e2d\u6570\u636e\u4e0d\u4e00\u81f4\uff0c\u82e5\u786e\u8ba4\u586b\u5199\u7684\u63a5\u5bb3\u4eba\u5458\u6570\u91cf\u51c6\u786e\uff0c\u8bf7\u70b9\u51fb\u3010\u4fe1\u606f\u7f16\u8f91\u3011\u7ef4\u62a4\u7cfb\u7edf\u4e2d\u672c\u4f01\u4e1a\u63a5\u5bb3\u4eba\u5458\u4fe1\u606f"));
        }
        if (StringUtils.isBlank((CharSequence)outNumCommit)) {
            if (!outNum.equals("0")) {
                fields.add(new NewFieldValidResultModel().setFiledName("localNumCommit").setReason("\u5916\u6765\u63a5\u5bb3\u4eba\u5458\u672a\u586b\u5199"));
            }
        } else if (!outNumCommit.equals(outNum)) {
            fields.add(new NewFieldValidResultModel().setFiledName("localNumCommit").setReason("\u5f53\u524d\u586b\u5199\u7684\u63a5\u5bb3\u4eba\u6570\u4e0e\u7cfb\u7edf\u4e2d\u63a5\u5bb3\u4eba\u5458\u5217\u8868\u4e2d\u6570\u636e\u4e0d\u4e00\u81f4\uff0c\u82e5\u786e\u8ba4\u586b\u5199\u7684\u5916\u6765\u63a5\u5bb3\u4eba\u5458\u6570\u91cf\u51c6\u786e\uff0c\u8bf7\u70b9\u51fb\u3010\u4fe1\u606f\u7f16\u8f91\u3011\u7ef4\u62a4\u7cfb\u7edf\u4e2d\u5916\u6765\u63a5\u5bb3\u4eba\u5458\u4fe1\u606f"));
        }
        if (Objects.equals(outNum, "0")) {
            if (Objects.equals(isExistOutWork, "1")) {
                fields.add(new NewFieldValidResultModel().setFiledName("isExistOutWork").setReason("\u5f53\u524d\u5916\u6765\u63a5\u5bb3\u4eba\u6570\u4e3a\u201c0\u201d\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5b58\u5728\u5916\u6765\u63a5\u5bb3\u4eba\u5458"));
            }
        } else if (Objects.equals(outNum, "1") && Objects.equals(isExistOutWork, "0")) {
            fields.add(new NewFieldValidResultModel().setFiledName("isExistOutWork").setReason("\u5f53\u524d\u5916\u6765\u63a5\u5bb3\u4eba\u6570\u4e0d\u4e3a\u201c0\u201d\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5b58\u5728\u5916\u6765\u63a5\u5bb3\u4eba\u5458"));
        }
        if (Objects.equals(isExistOutWork, "1")) {
            if (Objects.equals(hasOccupationalTransfer, "2")) {
                fields.add(new NewFieldValidResultModel().setFiledName("hasOccupationalTransfer").setReason("\u5b58\u5728\u5916\u6765\u63a5\u5bb3\u4eba\u5458,\u3010\u662f\u5426\u5b58\u5728\u8fdd\u89c4\u804c\u4e1a\u75c5\u5371\u5bb3\u4f5c\u4e1a\u8f6c\u79fb\u7684\u884c\u4e3a\u3011\u4e0d\u53ef\u4e3a\u5408\u7406\u7f3a\u9879"));
            }
            if (Objects.equals(implementation, "2")) {
                fields.add(new NewFieldValidResultModel().setFiledName("implementation").setReason("\u5b58\u5728\u5916\u6765\u63a5\u5bb3\u4eba\u5458,\u3010\u662f\u5426\u6309\u7167\u89c4\u5b9a\u843d\u5b9e\u52b3\u52a1\u6d3e\u9063\u4eba\u5458\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5\u3001\u804c\u4e1a\u5065\u5eb7\u57f9\u8bad\u3001\u804c\u4e1a\u75c5\u5371\u5bb3\u4e2a\u4eba\u9632\u62a4\u7b49\u7b49\u4e49\u52a1\u3011\u4e0d\u53ef\u4e3a\u5408\u7406\u7f3a\u9879"));
            }
        } else if (Objects.equals(isExistOutWork, "0")) {
            if (!Objects.equals(hasOccupationalTransfer, "2")) {
                fields.add(new NewFieldValidResultModel().setFiledName("hasOccupationalTransfer").setReason("\u4e0d\u5b58\u5728\u5916\u6765\u63a5\u5bb3\u4eba\u5458,\u3010\u662f\u5426\u5b58\u5728\u8fdd\u89c4\u804c\u4e1a\u75c5\u5371\u5bb3\u4f5c\u4e1a\u8f6c\u79fb\u7684\u884c\u4e3a\u3011\u53ea\u80fd\u4e3a\u5408\u7406\u7f3a\u9879"));
            }
            if (!Objects.equals(implementation, "2")) {
                fields.add(new NewFieldValidResultModel().setFiledName("implementation").setReason("\u4e0d\u5b58\u5728\u5916\u6765\u63a5\u5bb3\u4eba\u5458,\u3010\u662f\u5426\u6309\u7167\u89c4\u5b9a\u843d\u5b9e\u52b3\u52a1\u6d3e\u9063\u4eba\u5458\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5\u3001\u804c\u4e1a\u5065\u5eb7\u57f9\u8bad\u3001\u804c\u4e1a\u75c5\u5371\u5bb3\u4e2a\u4eba\u9632\u62a4\u7b49\u7b49\u4e49\u52a1\u3011\u53ea\u80fd\u4e3a\u5408\u7406\u7f3a\u9879"));
            }
        }
        return fields;
    }

    public List<NewComplianceValidModel> validateItemData(List<NewComplianceCompanyItemdata> itemdata, Long cid, Long complianceId) {
        ArrayList<NewComplianceValidModel> validModels = new ArrayList<NewComplianceValidModel>();
        List<NewFieldValidResultModel> resultModels = this.validStaffInfo(itemdata, cid);
        if (CollectionUtils.isNotEmpty(resultModels)) {
            NewComplianceValidModel cm12 = new NewComplianceValidModel();
            cm12.setCode("12");
            cm12.setFields(resultModels);
            validModels.add(cm12);
        }
        List itemdataList06 = this.scoreRefreshService.loadItemData(cid, complianceId, "06", Integer.valueOf(1));
        NewComplianceValidModel cm06 = new NewComplianceValidModel();
        cm06.setCode("06");
        ArrayList<NewFieldValidResultModel> fields06 = new ArrayList<NewFieldValidResultModel>();
        String fcTotalNum = this.getItemDataResult(itemdata, 10603L, "fcTotalNum");
        String fcNotDispositionNum = this.getItemDataResult(itemdata, 10603L, "fcNotDispositionNum");
        if (!StringUtils.isEmpty((CharSequence)fcTotalNum) && !StringUtils.isEmpty((CharSequence)fcNotDispositionNum) && Integer.parseInt(fcNotDispositionNum) > Integer.parseInt(fcTotalNum)) {
            fields06.add(new NewFieldValidResultModel().setFiledName("fcTotalNum").setReason("\u672a\u5b89\u6392\u590d\u67e5\u4eba\u6570\u4e0d\u80fd\u5927\u4e8e\u7d2f\u8ba1\u9700\u590d\u67e5\u4eba\u6570"));
            fields06.add(new NewFieldValidResultModel().setFiledName("fcNotDispositionNum").setReason("\u672a\u5b89\u6392\u590d\u67e5\u4eba\u6570\u4e0d\u80fd\u5927\u4e8e\u7d2f\u8ba1\u9700\u590d\u67e5\u4eba\u6570"));
        }
        String ljYszybTotalNum = this.getItemDataResult(itemdataList06, 10604L, "ljYszybTotalNum");
        String ljYszybNotDispositionNum = this.getItemDataResult(itemdata, 10604L, "ljYszybNotDispositionNum");
        String ljYszybDispositionNum = this.getItemDataResult(itemdata, 10604L, "ljYszybDispositionNum");
        if (!(StringUtils.isEmpty((CharSequence)ljYszybTotalNum) || StringUtils.isEmpty((CharSequence)ljYszybNotDispositionNum) || StringUtils.isEmpty((CharSequence)ljYszybDispositionNum) || Integer.parseInt(ljYszybNotDispositionNum) + Integer.parseInt(ljYszybDispositionNum) == Integer.parseInt(ljYszybTotalNum))) {
            fields06.add(new NewFieldValidResultModel().setFiledName("ljYszybNotDispositionNum").setReason("\u672a\u4e0a\u62a5\u7591\u4f3c\u804c\u4e1a\u75c5\u60a3\u8005\u548c\u5df2\u4e0a\u62a5\u7591\u4f3c\u804c\u4e1a\u75c5\u60a3\u8005\u4e4b\u548c\u5fc5\u987b\u7b49\u4e8e\u7d2f\u8ba1\u53d1\u73b0\u7591\u4f3c\u804c\u4e1a\u75c5\u60a3\u8005"));
            fields06.add(new NewFieldValidResultModel().setFiledName("ljYszybDispositionNum").setReason("\u672a\u4e0a\u62a5\u7591\u4f3c\u804c\u4e1a\u75c5\u60a3\u8005\u548c\u5df2\u4e0a\u62a5\u7591\u4f3c\u804c\u4e1a\u75c5\u60a3\u8005\u4e4b\u548c\u5fc5\u987b\u7b49\u4e8e\u7d2f\u8ba1\u53d1\u73b0\u7591\u4f3c\u804c\u4e1a\u75c5\u60a3\u8005"));
        }
        String ljZybTotalNum = this.getItemDataResult(itemdata, 10605L, "ljZybTotalNum");
        String ljZybNotDispositionNum = this.getItemDataResult(itemdata, 10605L, "ljZybNotDispositionNum");
        if (!StringUtils.isEmpty((CharSequence)ljZybTotalNum) && !StringUtils.isEmpty((CharSequence)ljZybNotDispositionNum) && Integer.parseInt(ljZybNotDispositionNum) > Integer.parseInt(ljZybTotalNum)) {
            fields06.add(new NewFieldValidResultModel().setFiledName("ljZybTotalNum").setReason("\u672a\u4e0a\u62a5\u804c\u4e1a\u75c5\u60a3\u8005\u4e0d\u80fd\u5927\u4e8e\u7d2f\u8ba1\u53d1\u73b0\u804c\u4e1a\u75c5\u60a3\u8005"));
            fields06.add(new NewFieldValidResultModel().setFiledName("ljZybNotDispositionNum").setReason("\u672a\u4e0a\u62a5\u804c\u4e1a\u75c5\u60a3\u8005\u4e0d\u80fd\u5927\u4e8e\u7d2f\u8ba1\u53d1\u73b0\u804c\u4e1a\u75c5\u60a3\u8005"));
        }
        if (CollectionUtils.isNotEmpty(fields06)) {
            cm06.setFields(fields06);
            validModels.add(cm06);
        }
        NewComplianceValidModel cm11 = new NewComplianceValidModel();
        cm11.setCode("11");
        ArrayList<NewFieldValidResultModel> fields11 = new ArrayList<NewFieldValidResultModel>();
        List itemdataList11 = this.scoreRefreshService.loadItemData(cid, complianceId, "11", Integer.valueOf(1));
        String localFSWorkNum = this.getItemDataResult(itemdataList11, 11104L, "localFSWorkNum");
        String localUnWorkNum = this.getItemDataResult(itemdata, 11104L, "localUnWorkNum");
        String localCompleteWorkNum = this.getItemDataResult(itemdata, 11104L, "localCompleteWorkNum");
        if (!(StringUtils.isEmpty((CharSequence)localFSWorkNum) || StringUtils.isEmpty((CharSequence)localUnWorkNum) || StringUtils.isEmpty((CharSequence)localCompleteWorkNum) || Integer.parseInt(localFSWorkNum) == Integer.parseInt(localUnWorkNum) + Integer.parseInt(localCompleteWorkNum))) {
            fields11.add(new NewFieldValidResultModel().setFiledName("localUnWorkNum").setReason("\u672a\u5f00\u5c55\u4e2a\u4eba\u5242\u91cf\u76d1\u6d4b\u4eba\u6570\u548c\u5df2\u5f00\u5c55\u4e2a\u4eba\u5242\u91cf\u76d1\u6d4b\u4eba\u6570\u4e4b\u548c\u5fc5\u987b\u7b49\u4e8e\u672c\u4f01\u4e1a\u653e\u5c04\u5de5\u4f5c\u4eba\u5458\u4eba\u6570"));
            fields11.add(new NewFieldValidResultModel().setFiledName("localCompleteWorkNum").setReason("\u672a\u5f00\u5c55\u4e2a\u4eba\u5242\u91cf\u76d1\u6d4b\u4eba\u6570\u548c\u5df2\u5f00\u5c55\u4e2a\u4eba\u5242\u91cf\u76d1\u6d4b\u4eba\u6570\u4e4b\u548c\u5fc5\u987b\u7b49\u4e8e\u672c\u4f01\u4e1a\u653e\u5c04\u5de5\u4f5c\u4eba\u5458\u4eba\u6570"));
        }
        String outFSWorkNum = this.getItemDataResult(itemdataList11, 11104L, "outFSWorkNum");
        String outUnWorkNum = this.getItemDataResult(itemdata, 11104L, "outUnWorkNum");
        String outCompleteWorkNum = this.getItemDataResult(itemdata, 11104L, "outCompleteWorkNum");
        if (!(StringUtils.isEmpty((CharSequence)outFSWorkNum) || StringUtils.isEmpty((CharSequence)outUnWorkNum) || StringUtils.isEmpty((CharSequence)outCompleteWorkNum) || Integer.parseInt(outFSWorkNum) == Integer.parseInt(outUnWorkNum) + Integer.parseInt(outCompleteWorkNum))) {
            fields11.add(new NewFieldValidResultModel().setFiledName("outUnWorkNum").setReason("\u672a\u5f00\u5c55\u4e2a\u4eba\u5242\u91cf\u76d1\u6d4b\u4eba\u6570\u548c\u5df2\u5f00\u5c55\u4e2a\u4eba\u5242\u91cf\u76d1\u6d4b\u4eba\u6570\u4e4b\u548c\u5fc5\u987b\u7b49\u4e8e\u52b3\u52a1\u6d3e\u9063\u653e\u5c04\u5de5\u4f5c\u4eba\u5458\u4eba\u6570"));
            fields11.add(new NewFieldValidResultModel().setFiledName("outCompleteWorkNum").setReason("\u672a\u5f00\u5c55\u4e2a\u4eba\u5242\u91cf\u76d1\u6d4b\u4eba\u6570\u548c\u5df2\u5f00\u5c55\u4e2a\u4eba\u5242\u91cf\u76d1\u6d4b\u4eba\u6570\u4e4b\u548c\u5fc5\u987b\u7b49\u4e8e\u52b3\u52a1\u6d3e\u9063\u653e\u5c04\u5de5\u4f5c\u4eba\u5458\u4eba\u6570"));
        }
        if (CollectionUtils.isNotEmpty(fields11)) {
            cm11.setFields(fields11);
            validModels.add(cm11);
        }
        NewComplianceValidModel cm13 = new NewComplianceValidModel();
        cm13.setCode("13");
        ArrayList<NewFieldValidResultModel> fields13 = new ArrayList<NewFieldValidResultModel>();
        List itemdataList13 = this.scoreRefreshService.loadItemData(cid, complianceId, "13", Integer.valueOf(1));
        String exposedLaborCount = this.getItemDataResult(itemdataList13, 11303L, "exposedLaborCount");
        String uninformedCount = this.getItemDataResult(itemdata, 11303L, "uninformedCount");
        String informedCount = this.getItemDataResult(itemdata, 11303L, "informedCount");
        if (!(StringUtils.isEmpty((CharSequence)exposedLaborCount) || StringUtils.isEmpty((CharSequence)uninformedCount) || StringUtils.isEmpty((CharSequence)informedCount) || Integer.parseInt(exposedLaborCount) == Integer.parseInt(uninformedCount) + Integer.parseInt(informedCount))) {
            fields13.add(new NewFieldValidResultModel().setFiledName("uninformedCount").setReason("\u672a\u544a\u77e5\u4eba\u6570\u548c\u5df2\u544a\u77e5\u4eba\u6570\u4e4b\u548c\u5fc5\u987b\u7b49\u4e8e\u63a5\u5bb3\u52b3\u52a8\u8005\u4eba\u6570"));
            fields13.add(new NewFieldValidResultModel().setFiledName("informedCount").setReason("\u672a\u544a\u77e5\u4eba\u6570\u548c\u5df2\u544a\u77e5\u4eba\u6570\u4e4b\u548c\u5fc5\u987b\u7b49\u4e8e\u63a5\u5bb3\u52b3\u52a8\u8005\u4eba\u6570"));
        }
        if (CollectionUtils.isNotEmpty(fields13)) {
            cm13.setFields(fields13);
            validModels.add(cm13);
        }
        return validModels;
    }

    public String getItemDataResult(List<NewComplianceCompanyItemdata> itemdata, Long itemCodeId, String fieldName) {
        if (CollectionUtils.isEmpty(itemdata)) {
            return null;
        }
        List collect = itemdata.stream().filter(f -> {
            if (itemCodeId == null) {
                return Objects.equals(f.getFieldName(), fieldName);
            }
            return Objects.equals(f.getItemcodeId(), itemCodeId) && Objects.equals(f.getFieldName(), fieldName);
        }).map(NewComplianceCompanyItemdata::getResultData).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect)) {
            return (String)collect.get(0);
        }
        return null;
    }

    @GetMapping(value={"/unselectedCertData"})
    public JqGridData<CertificateStaffDetail> getUnselectedCertData(JqGridParam pageParam, CertificateStaffDetail certParam) {
        if (certParam == null) {
            certParam = new CertificateStaffDetail();
        }
        if (certParam.getCid() == null) {
            certParam.setCid(UserUtils.getLoginStaffCompanyId());
        }
        PageInfo certPage = this.personCertificateService.getUnselectedCertPage(pageParam, certParam);
        return new JqGridData(certPage, pageParam);
    }

    @GetMapping(value={"/selectedCertData"})
    public JqGridData<NewCompliantChargePersonCertificateVo> getSelectedCertData(JqGridParam pageParam, NewCompliantChargePersonCertificateParam certParam) {
        if (certParam == null) {
            certParam = new NewCompliantChargePersonCertificateParam();
        }
        if (certParam.getCid() == null) {
            certParam.setCid(UserUtils.getLoginStaffCompanyId());
        }
        PageInfo personCertificate = this.personCertificateService.getSelectedCertPage(pageParam, certParam);
        return new JqGridData(personCertificate, pageParam);
    }

    @GetMapping(value={"/selectOrDeselect"})
    public void selectOrDeselect(Long certificateId) {
        this.personCertificateService.selectOrDeselect(UserUtils.getLoginStaffCompanyId(), certificateId);
    }

    @GetMapping(value={"/getStaffBasicInfo"})
    @ResponseBody
    public List<NewComplianceCompanyItemdata> getStaffBasicInfo(Long complianceId, String supply) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("complianceId", complianceId);
        return this.infoService.getCommitmentContent(UserUtils.getLoginStaffCompanyId(), "staffBasicInfo", map);
    }

    @GetMapping(value={"/getHealthManagementInfo"})
    @ResponseBody
    public List<NewComplianceCompanyItemdata> getHealthManagementInfo(Long complianceId, String supply) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("complianceId", complianceId);
        return this.infoService.getCommitmentContent(UserUtils.getLoginStaffCompanyId(), "healthManagementInfo", map);
    }

    @GetMapping(value={"/getInstitutionInfo"})
    @ResponseBody
    public List<NewComplianceCompanyItemdata> getInstitutionInfo(Long complianceId, String supply) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("complianceId", complianceId);
        return this.infoService.getCommitmentContent(UserUtils.getLoginStaffCompanyId(), "institutionInfo", map);
    }

    @Log(title="\u4f01\u4e1a\u7533\u8ff0", type=20)
    @PostMapping(value={"/sendAppeal"})
    @ResponseBody
    public ResponseData<String> sendAppeal(@Validated @RequestBody NewComplianceCompanyObjectionApply moudel) {
        ResponseData responseData;
        if (moudel.getComplianceId() == null || moudel.getItemcodeId() == null) {
            return ResponseData.fail((String)"\u8bf7\u6c42\u4e0d\u5408\u6cd5\uff0c\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570");
        }
        moudel.setCid(UserUtils.getLoginStaffCompanyId());
        List unprocessedList = this.objectionApplyService.getUnprocessedByCidAndItemcodeId(moudel.getCid(), moudel.getItemcodeId(), Integer.valueOf(2));
        if (unprocessedList != null && !unprocessedList.isEmpty()) {
            return ResponseData.fail((String)"\u8be5\u5c0f\u9879\u5b58\u5728\u672a\u89e3\u51b3\u7684\u4f01\u4e1a\u7533\u8ff0");
        }
        if (moudel.getItemcodeId().compareTo(10701L) == 0 && moudel.getProductionTime() != null && Objects.equals(ResponseStateEnum.fail, (responseData = this.verifyProductionTime(moudel)).getState())) {
            return responseData;
        }
        Long userId = UserUtils.getCurrentUser().getId();
        this.objectionApplyService.sendAppeal(moudel, userId);
        return ResponseData.success();
    }

    @Log(title="\u4f01\u4e1a\u64a4\u9500\u7533\u8bc9", type=20)
    @GetMapping(value={"/withdrawAppeal"})
    @ResponseBody
    public ResponseData<String> withdrawAppeal(Long appealId) {
        NewComplianceCompanyObjectionApply apply = (NewComplianceCompanyObjectionApply)this.objectionApplyService.getById(appealId);
        if (appealId == null || apply == null) {
            return ResponseData.fail((String)"\u8bf7\u6c42\u4e0d\u5408\u6cd5\uff0c\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570");
        }
        if (apply.getStatus() == 2) {
            return ResponseData.fail((String)"\u8be5\u7533\u8ff0\u5df2\u7ec8\u6b62");
        }
        Long userId = UserUtils.getCurrentUser().getId();
        this.objectionApplyService.withdrawAppeal(apply, userId);
        return ResponseData.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Log(title="\u6dfb\u52a0\u9ed8\u8ba4\u521d\u59cb\u503c", type=2)
    @ResponseBody
    @GetMapping(value={"addDefaultValue"})
    public String addDefaultValue(Long complianceId, String type) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        RLock lock = this.redissonClient.getLock(String.valueOf(cid));
        if (lock.tryLock()) {
            try {
                this.scoreRefreshService.addDefaultValue(complianceId, type);
            }
            catch (Exception e) {
                this.logger.error("\u6dfb\u52a0\u9ed8\u8ba4\u521d\u59cb\u503c\u51fa\u9519\uff08\u6216\u8d85\u65f6\uff09:{}", (Object)e.getMessage());
            }
            finally {
                lock.unlock();
            }
        }
        return "\u6210\u529f";
    }

    private NewComplianceCompanyExitItemListVo createItemListVo(Integer key, List<NewComplianceCompanyExitItemVo> itemList, Map<Long, NewComplianceCompanyObjectionApply> applyMap, Map<Integer, Long> keyMapping, List<NewComplianceCompanyExitItem> fine, List<NewComplianceCompanyExitItem> reference) {
        NewComplianceCompanyExitItemListVo itemListVo = new NewComplianceCompanyExitItemListVo();
        List list = Collections.emptyList();
        if (itemList != null && CollectionUtils.isNotEmpty(itemList)) {
            int currentYear = Year.now().getValue();
            list = itemList.stream().filter(vo -> {
                if (vo.getStatus() != 1) {
                    return false;
                }
                int dateYear = Optional.ofNullable(vo.getDate()).map(date -> date.toInstant().atZone(ZoneId.systemDefault()).getYear()).orElse(currentYear);
                if (Objects.equals(key, NewComplianceExitTypeEnum.FINE.getKey())) {
                    return vo.getLevel() > 1 && dateYear >= currentYear;
                }
                if (Objects.equals(key, NewComplianceExitTypeEnum.OCCUPATIONAL_DISEASE_1_4.getKey())) {
                    return dateYear >= currentYear - 2;
                }
                if (Objects.equals(key, NewComplianceExitTypeEnum.OCCUPATIONAL_DISEASE_5.getKey())) {
                    return dateYear >= currentYear - 5;
                }
                if (Objects.equals(key, NewComplianceExitTypeEnum.FALSIFICATION.getKey())) {
                    return true;
                }
                return true;
            }).collect(Collectors.toList());
        }
        itemListVo.setType(key);
        itemListVo.setItemList(list);
        itemListVo.setAppealObj((NewComplianceCompanyObjectionApply)applyMap.getOrDefault(keyMapping.get(key), null));
        boolean hasExititems = this.isFineType(key) && !fine.isEmpty() || reference.size() > 0 && this.checkOccupationalDisease(reference.size(), key);
        itemListVo.setHasExititems(Boolean.valueOf(hasExititems));
        return itemListVo;
    }

    private void handleMissingTypes(List<NewComplianceCompanyExitItemListVo> rsd, Map<Integer, List<NewComplianceCompanyExitItemVo>> map, Map<Integer, Long> keyMapping, List<NewComplianceCompanyExitItem> reference) {
        Set<Integer> existingKeys = map.keySet();
        Set<Integer> allKeys = keyMapping.keySet();
        for (Integer key : allKeys) {
            if (existingKeys.contains(key) || !this.shouldCreateForReference(reference.size(), key)) continue;
            rsd.add(this.createItemListVo(key, Collections.emptyList(), Collections.emptyMap(), keyMapping, Collections.emptyList(), reference));
        }
    }

    private boolean shouldCreateForReference(int referenceSize, Integer key) {
        if (Objects.equals(NewComplianceExitTypeEnum.OCCUPATIONAL_DISEASE_1_4.getKey(), key)) {
            return referenceSize < 5;
        }
        return Objects.equals(NewComplianceExitTypeEnum.OCCUPATIONAL_DISEASE_5.getKey(), key);
    }

    private boolean isFineType(Integer key) {
        return Objects.equals(NewComplianceExitTypeEnum.FINE.getKey(), key);
    }

    private boolean checkOccupationalDisease(int referenceSize, Integer key) {
        if (Objects.equals(NewComplianceExitTypeEnum.OCCUPATIONAL_DISEASE_1_4.getKey(), key)) {
            return referenceSize < 5;
        }
        if (Objects.equals(NewComplianceExitTypeEnum.OCCUPATIONAL_DISEASE_5.getKey(), key)) {
            return referenceSize >= 5;
        }
        return false;
    }

    @ResponseBody
    @GetMapping(value={"/getComplianceIndustryList"})
    public ResponseData<JqGridData<ImportantIndustryCategory>> getComplianceIndustryList(JqGridParam pageParam, String keyWord) {
        PageInfo importantIndustryCategoryPageInfo = this.categoryService.listCategoryPage(pageParam, keyWord);
        JqGridData data = new JqGridData(importantIndustryCategoryPageInfo, pageParam);
        return ResponseData.success((Object)data);
    }

    private ResponseData verifyProductionTime(NewComplianceCompanyObjectionApply objectionApply) {
        List riskList = this.riskExposeEvaluateService.getListByParam(new EvQueryParam().setCid(objectionApply.getCid()).setCheckTypeList(Arrays.asList(2L, 4L)).setIsIgnore(Boolean.valueOf(true)), null);
        if (riskList == null || riskList.size() < 1) {
            return ResponseData.fail((String)"\u6682\u65e0\u68c0\u6d4b\u6570\u636e\uff0c\u65e0\u6cd5\u63d0\u4ea4\u7533\u8bc9\uff0c\u8bf7\u6309\u8981\u6c42\u8fdb\u884c\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u68c0\u6d4b\u5de5\u4f5c");
        }
        Optional<LocalDateTime> latestTimeForCheckType4 = riskList.stream().filter(risk -> 4L == risk.getCheckType()).map(RiskExposeEvaluate::getCheckDate).max(LocalDateTime::compareTo);
        Optional<LocalDateTime> earliestTimeForCheckType2 = riskList.stream().filter(risk -> 2L == risk.getCheckType()).map(RiskExposeEvaluate::getCheckDate).min(LocalDateTime::compareTo);
        LocalDateTime productionTime = objectionApply.getProductionTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        if (latestTimeForCheckType4.isPresent()) {
            if (productionTime.isAfter(latestTimeForCheckType4.get())) {
                return ResponseData.fail((String)"'\u7ae3\u5de5/\u6295\u4ea7\u65f6\u95f4'\u4e0d\u80fd\u665a\u4e8e\u6700\u8fd1\u4e00\u6b21\u63a7\u8bc4\u65f6\u95f4");
            }
        } else if (productionTime.isAfter(earliestTimeForCheckType2.get())) {
            return ResponseData.fail((String)"\u4f01\u4e1a\u65e0'\u63a7\u5236\u6548\u679c\u8bc4\u4ef7'\u4fe1\u606f\uff0c'\u7ae3\u5de5/\u6295\u4ea7\u65f6\u95f4'\u4e0d\u80fd\u665a\u4e8e\u7cfb\u7edf\u4e2d\u6700\u65e9\u7684\u68c0\u6d4b\u65f6\u95f4");
        }
        return ResponseData.success();
    }
}

