/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.newcompliance;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.health.newcompliance.enums.NewSourceEnum;
import cn.smarthse.modules.health.newcompliance.model.NewComplianceCompanyRecordParam;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyChangeRecordService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceScoreChangeRecordV2Service;
import cn.smarthse.modules.health.newcompliance.vo.NewComplianceCompanyRecordVo;
import cn.smarthse.modules.health.newcompliance.vo.NewComplianceScoreChangeRecordVo;
import cn.smarthse.modules.health.newcompliance.vo.NewComplianceScoreChangeRecordVoV2;
import cn.smarthse.modules.health.newcompliance.vo.NewCompliantRecordTypeVo;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import java.util.List;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/newcomplianceRecord"})
@RestController
public class NewComplianceCompanyRecordController
extends ControllerSupport {
    @DubboReference
    private INewComplianceCompanyChangeRecordService companyChangeRecordService;
    @DubboReference
    private INewComplianceScoreChangeRecordV2Service scoreChangeRecordV2Service;

    @GetMapping(value={"/recordTypeList"})
    public List<NewCompliantRecordTypeVo> getRecordTypeList() {
        return this.companyChangeRecordService.getRecordTypeList();
    }

    @GetMapping(value={"/recordPage"})
    public JqGridData<NewComplianceCompanyRecordVo> getRecordPage(JqGridParam pageParam, NewComplianceCompanyRecordParam recordParam) {
        if (recordParam == null) {
            recordParam = new NewComplianceCompanyRecordParam();
        }
        if (recordParam.getCid() == null) {
            recordParam.setCid(UserUtils.getLoginStaffCompanyId());
        }
        PageInfo recordPage = this.companyChangeRecordService.getRecordPage(pageParam, recordParam);
        return new JqGridData(recordPage, pageParam);
    }

    @GetMapping(value={"/objectionProcess"})
    public List<NewComplianceCompanyRecordVo> getObjectionProcess(NewComplianceCompanyRecordParam recParam) {
        if (recParam == null) {
            recParam = new NewComplianceCompanyRecordParam();
        }
        recParam.setSource(NewSourceEnum.COMPANY);
        return this.companyChangeRecordService.getObjectionProcess(recParam);
    }

    @GetMapping(value={"/applyProcess"})
    public List<NewComplianceCompanyRecordVo> getApplyProcess(NewComplianceCompanyRecordParam recParam) {
        if (recParam == null) {
            recParam = new NewComplianceCompanyRecordParam();
        }
        recParam.setSource(NewSourceEnum.COMPANY);
        return this.companyChangeRecordService.getApplyProcess(recParam);
    }

    @GetMapping(value={"/scoreChangeRecord"})
    public JqGridData<NewComplianceScoreChangeRecordVo> getComplianceScoreChangeRecord(JqGridParam pageParam, Long complianceId) {
        PageInfo recordPage = this.companyChangeRecordService.getComplianceScoreChangeRecord(pageParam, complianceId);
        return new JqGridData(recordPage, pageParam);
    }

    @GetMapping(value={"/scoreChangeRecordv2"})
    public JqGridData<NewComplianceScoreChangeRecordVoV2> getscoreChangeRecordv2(JqGridParam pageParam, Long complianceId) {
        PageInfo recordPage = this.scoreChangeRecordV2Service.getComplianceScoreChangeRecord(pageParam, complianceId);
        return new JqGridData(recordPage, pageParam);
    }

    @Generated
    public NewComplianceCompanyRecordController() {
    }
}

