/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.newcompliance;

import cn.hutool.core.date.DateUtil;
import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.BeanUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.compliance.vo.CertTrainStaffInfoVo;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyExitItemRecord;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyInfo;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyProcessRecord;
import cn.smarthse.modules.health.newcompliance.enums.NewComplianceProcessStatusEnum;
import cn.smarthse.modules.health.newcompliance.model.NewComplianceCompanyProcessRecordMoudel;
import cn.smarthse.modules.health.newcompliance.model.NewComplianceCompanyPromiseModel;
import cn.smarthse.modules.health.newcompliance.model.NewComplianceCompanyPromiseParam;
import cn.smarthse.modules.health.newcompliance.service.INewBusinessDataUpdateRefreshService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyExitItemService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyInfoService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyProcessRecordService;
import cn.smarthse.modules.health.newcompliance.vo.NewComplianceCompanyExitItemRecordVo;
import cn.smarthse.modules.health.newcompliance.vo.NewComplianceCompanyListVo;
import cn.smarthse.modules.health.service.base.company.ICompanyFunctionalOrganizationMemberService;
import cn.smarthse.modules.health.service.base.selfjudge.ICompanyHsePreventionControlSelfJudgeService;
import cn.smarthse.modules.health.supervise.entity.sysparam.ImportantIndustryCategory;
import cn.smarthse.modules.health.supervise.entity.sysparam.ImportantIndustryCategoryType;
import cn.smarthse.modules.health.supervise.service.importantIndustryCategory.IImportantIndustryCategoryService;
import cn.smarthse.modules.health.supervise.service.reform.IReformService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"newcomplianceCompany"})
@Controller
public class NewComplianceCompanyController
extends ControllerSupport {
    @DubboReference
    private ICompanyHsePreventionControlSelfJudgeService companyHsePreventionControlSelfJudgeService;
    @DubboReference(check=false)
    private INewComplianceCompanyInfoService complianceCompanyInfoService;
    @DubboReference(check=false)
    private INewComplianceCompanyProcessRecordService processRecordService;
    @DubboReference
    private ICompanyFunctionalOrganizationMemberService funcOrgMemberService;
    @DubboReference
    private INewComplianceCompanyExitItemService exitItemService;
    @DubboReference(timeout=5000000)
    private ISysFileProvideService sysFileProvideService;
    @DubboReference
    private INewBusinessDataUpdateRefreshService businessDataUpdateRefreshService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideService;
    @DubboReference
    private IImportantIndustryCategoryService categoryService;
    @DubboReference
    private IReformService reformService;
    public static final String MZJJ_IMPORTANTTYPE = "8";
    public static final String ZZHY_IMPORTANTTYPE = "7";

    @Log(title="\u9996\u9875", type=2)
    @GetMapping(value={"/index"})
    public String index(ModelMap map) {
        Boolean finishSelfJudge = this.companyHsePreventionControlSelfJudgeService.isFinishSelf(UserUtils.getLoginStaffCompanyId());
        this.businessDataUpdateRefreshService.exeBussinessDataUpdateTaskByCid(UserUtils.getLoginStaffCompanyId());
        NewComplianceCompanyInfo complianceCompanyInfo = this.complianceCompanyInfoService.getLastByCid(UserUtils.getLoginStaffCompanyId());
        CompanySuperviseModel companySuperviseModel = this.companyProvideService.getCompanyInfoById(UserUtils.getLoginStaffCompanyId());
        Integer status = null;
        Long complianceId = null;
        String score = null;
        Byte step = null;
        Integer complianceAccordingType = null;
        Object reformOutDowndate = null;
        if (complianceCompanyInfo != null) {
            complianceId = complianceCompanyInfo.getId();
            status = complianceCompanyInfo.getStatus();
            score = String.valueOf(complianceCompanyInfo.getComplianceScore());
            step = complianceCompanyInfo.getStep();
            complianceAccordingType = complianceCompanyInfo.getComplianceAccordingType();
            if (complianceCompanyInfo.getReformOutDowndate() != null) {
                long reformOutDowndateDayNum = DateUtil.betweenDay((Date)complianceCompanyInfo.getReformOutDowndate(), (Date)new Date(), (boolean)true);
                map.put((Object)"reformOutDowndateDayNum", (Object)reformOutDowndateDayNum);
            }
        }
        map.put((Object)"finishSelfJudge", (Object)finishSelfJudge);
        map.put((Object)"companyName", (Object)UserUtils.getCurrentCompany().getName());
        map.put((Object)"complianceId", (Object)complianceId);
        map.put((Object)"complianceStatus", (Object)status);
        map.put((Object)"complianceStep", (Object)step);
        map.put((Object)"cid", (Object)UserUtils.getLoginStaffCompanyId());
        map.put((Object)"complianceScore", (Object)score);
        map.put((Object)"complianceAccordingType", (Object)complianceAccordingType);
        map.put((Object)"reformOutDowndate", reformOutDowndate);
        map.put((Object)"isShowVictims", (Object)companySuperviseModel.getIsShowVictims());
        List importantTypeByCids = this.complianceCompanyInfoService.getImportantTypeByCids(Arrays.asList(UserUtils.getLoginStaffCompanyId()));
        if (CollectionUtils.isNotEmpty((Collection)importantTypeByCids)) {
            ImportantIndustryCategory importantIndustryCategory = (ImportantIndustryCategory)importantTypeByCids.get(0);
            map.put((Object)"importantIndustryType", (Object)importantIndustryCategory.getImportantTypeStr());
        }
        map.put((Object)"canCompliance", (Object)this.canCompliance(UserUtils.getLoginStaffCompanyId()));
        return "views/complianceCompanyNew/index";
    }

    @RequestMapping(value={"scoreLoss"})
    public String scoreLoss(Long complianceId) {
        return "views/complianceCompanyNew/scoreLoss/index";
    }

    /*
     * Enabled aggressive block sorting
     */
    private Boolean canCompliance(Long cid) {
        boolean bl;
        block5: {
            List<Long> testCidList;
            block4: {
                testCidList = Arrays.asList(99657571579874473L, 19657571579328400L, 19657571579333898L, 19657571579371336L, 8817297664350319439L);
                List importantIndustryCategoryTypes = this.categoryService.listCategoryType(new ImportantIndustryCategoryType().setMenuSet(Integer.valueOf(1)));
                List importantIndustryList = importantIndustryCategoryTypes.stream().map(i -> String.valueOf(i.getImportantType())).distinct().collect(Collectors.toList());
                CompanyBaseInfoModel companyBaseInfoModel = UserUtils.getCurrentCompanyFromDataCenter();
                List importantTypeByCids = this.complianceCompanyInfoService.getImportantTypeByCids(Collections.singletonList(cid));
                if (!CollectionUtils.isNotEmpty((Collection)importantTypeByCids)) break block4;
                if (StringUtils.parseToStringList((String)((ImportantIndustryCategory)importantTypeByCids.get(0)).getImportantTypeStr(), (String)",").stream().anyMatch(importantIndustryList::contains)) break block5;
            }
            if (!testCidList.contains(UserUtils.getLoginStaffCompanyId())) {
                bl = false;
                return bl;
            }
        }
        bl = true;
        return bl;
    }

    @GetMapping(value={"stepsPage/complianceCompany"})
    public String complianceCompanyPage(ModelMap map) {
        NewComplianceCompanyInfo complianceCompanyInfo = this.complianceCompanyInfoService.getLastByCid(UserUtils.getLoginStaffCompanyId());
        map.put((Object)"complianceCompanyInfo", (Object)complianceCompanyInfo);
        return "views/complianceCompanyNew/stepsPage/companyCompliance";
    }

    @GetMapping(value={"/newCompanyGuide/orgList"})
    public String complianceCompanyPage5(ModelMap map) {
        return "newCompanyGuide/itemsPage/orgList";
    }

    @GetMapping(value={"stepsPage/checkSystem"})
    public String checkSystem(ModelMap map) {
        return "views/complianceCompanyNew/stepsPage/checkSystem";
    }

    @GetMapping(value={"stepsPage/settlement"})
    public String settlement(ModelMap map) {
        NewComplianceCompanyInfo complianceCompanyInfo = this.complianceCompanyInfoService.getLastByCid(UserUtils.getLoginStaffCompanyId());
        if (complianceCompanyInfo != null) {
            map.put((Object)"complianceScore", (Object)complianceCompanyInfo.getComplianceScore());
        }
        return "views/complianceCompanyNew/stepsPage/settlement";
    }

    @Log(title="\u627f\u8bfa", type=2)
    @PostMapping(value={"/doPromise"})
    @ResponseBody
    public ResponseData<NewComplianceCompanyInfo> doPromise(@RequestBody NewComplianceCompanyPromiseParam param) {
        Boolean finishSelfJudge = this.companyHsePreventionControlSelfJudgeService.isFinishSelf(UserUtils.getLoginStaffCompanyId());
        if (!finishSelfJudge.booleanValue()) {
            return ResponseData.fail((String)"\u8bf7\u5148\u5b8c\u6210\u81ea\u67e5");
        }
        if (this.canCompliance(UserUtils.getLoginStaffCompanyId()).booleanValue()) {
            NewComplianceCompanyInfo complianceCompanyInfo = this.complianceCompanyInfoService.addCompliance(UserUtils.getLoginStaffCompanyId(), UserUtils.getLoginStaffId());
            complianceCompanyInfo.setStep(Byte.valueOf((byte)1));
            complianceCompanyInfo.setEvaluaterName(param.getEvaluaterName());
            complianceCompanyInfo.setEvaluaterTel(param.getEvaluaterTel());
            complianceCompanyInfo.setCompanyManager(param.getCompanyManager());
            complianceCompanyInfo.setCompanyManagerDuty(param.getCompanyManagerDuty());
            complianceCompanyInfo.setOccManagerName(param.getOccManagerName());
            complianceCompanyInfo.setOccManagerDuty(param.getOccManagerDuty());
            this.complianceCompanyInfoService.update((Object)complianceCompanyInfo);
            this.complianceCompanyInfoService.syncReformOutComplianceData(complianceCompanyInfo.getId(), UserUtils.getLoginStaffCompanyId());
            return ResponseData.success((Object)complianceCompanyInfo);
        }
        return ResponseData.fail((String)"\u8d35\u516c\u53f8\u4e0d\u5c5e\u4e8e\u6728\u8d28\u5bb6\u5177\u5236\u9020\u884c\u4e1a\u6216\u94f8\u9020\u884c\u4e1a\uff0c\u6682\u65f6\u65e0\u6cd5\u8fdb\u884c\u5408\u89c4\u4f01\u4e1a\u627f\u8bfa\uff0c\u8bf7\u5173\u6ce8\u540e\u7eed\u7cfb\u7edf\u5347\u7ea7\u901a\u77e5");
    }

    @Log(title="\u63d0\u4ea4Step", type=2)
    @RequestMapping(value={"commitStep"})
    @ResponseBody
    public ResponseData<NewComplianceCompanyInfo> commitStep(Long complianceId, Byte step) {
        NewComplianceCompanyInfo complianceCompanyInfo = (NewComplianceCompanyInfo)this.complianceCompanyInfoService.getById(complianceId);
        complianceCompanyInfo.setStep(step);
        this.complianceCompanyInfoService.updateByPrimaryKey((Object)complianceCompanyInfo, UserUtils.getLoginStaffId());
        return ResponseData.success((Object)complianceCompanyInfo);
    }

    @Log(title="\u4fee\u6539\u8bc4\u4f30\u4eba\u5458\u4fe1\u606f", type=2)
    @PostMapping(value={"/saveEvaluaterInfo"})
    @ResponseBody
    public ResponseData<NewComplianceCompanyInfo> saveEvaluaterInfo(@RequestBody NewComplianceCompanyPromiseParam param) {
        if (Objects.isNull(param.getComplianceId())) {
            throw new RuntimeException("complianceId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        NewComplianceCompanyInfo complianceCompanyInfo = (NewComplianceCompanyInfo)this.complianceCompanyInfoService.getById(param.getComplianceId());
        if (Objects.isNull(complianceCompanyInfo)) {
            throw new RuntimeException("\u6570\u636e\u6709\u8bef\uff01");
        }
        complianceCompanyInfo.setEvaluaterName(param.getEvaluaterName());
        complianceCompanyInfo.setEvaluaterTel(param.getEvaluaterTel());
        this.complianceCompanyInfoService.update((Object)complianceCompanyInfo);
        return ResponseData.success((Object)complianceCompanyInfo);
    }

    @Log(title="\u5934\u90e8\u6570\u636e\uff08\u6765\u81ea\u4f01\u4e1a\u8868\uff09", type=2)
    @GetMapping(value={"/headData"})
    @ResponseBody
    public ResponseData<NewComplianceCompanyListVo> headData(Long complianceId) {
        NewComplianceCompanyListVo detailById = this.complianceCompanyInfoService.getDetailById(complianceId);
        return ResponseData.success((Object)detailById);
    }

    @Log(title="\u627f\u8bfa\u6570\u636e\uff08\u6765\u81ea\u7528\u6237\u586b\u5199\uff09", type=2)
    @GetMapping(value={"/promiseData"})
    @ResponseBody
    public ResponseData<NewComplianceCompanyPromiseModel> promiseData(Long complianceId) {
        NewComplianceCompanyPromiseModel newComplianceCompanyPromiseModel = this.complianceCompanyInfoService.queryPromiseInfoById(complianceId);
        return ResponseData.success((Object)newComplianceCompanyPromiseModel);
    }

    @Log(title="\u63d0\u4ea4\u5ba1\u6838/\u7533\u8bc9 \u76d1\u7ba1\u5f02\u8bae", type=21)
    @PostMapping(value={"/submitObjection"})
    @ResponseBody
    public ResponseData<String> submitObjection(@Validated @RequestBody NewComplianceCompanyProcessRecordMoudel moudel) {
        NewComplianceCompanyProcessRecord record = new NewComplianceCompanyProcessRecord();
        BeanUtils.copyBeanProp((Object)record, (Object)moudel);
        record.setStatus(NewComplianceProcessStatusEnum.VERIFY.getKey());
        Long cid = UserUtils.getLoginStaffCompanyId();
        record.setCreateDate(new Date());
        record.setCreateBy(cid);
        this.processRecordService.add((Object)record);
        return ResponseData.success();
    }

    @GetMapping(value={"/itempage/{page}"})
    public String itempage(ModelMap map, @PathVariable(value="page") String page) {
        return "views/complianceCompanyNew/itemsPage/" + page;
    }

    @GetMapping(value={"/healthClass"})
    public String healthClass(ModelMap map) {
        return "complianceCompany/itemsPage/healthClass";
    }

    @GetMapping(value={"/riskResolution"})
    public String riskResolution(ModelMap map) {
        return "complianceCompany/itemsPage/riskResolution";
    }

    @GetMapping(value={"/healthTrain"})
    public String healthTrain(ModelMap map) {
        return "complianceCompany/itemsPage/healthTrain";
    }

    @GetMapping(value={"/healthArchives"})
    public String healthArchives(ModelMap map) {
        return "complianceCompany/itemsPage/healthArchives";
    }

    @GetMapping(value={"/certStaffList"})
    @ResponseBody
    public List<CertTrainStaffInfoVo> getCertStaffListByCid(Boolean isComplianceManager) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        return this.funcOrgMemberService.getCertStaffListByCid(cid, isComplianceManager);
    }

    @Log(title="\u67e5\u8be2\u9000\u51fa\u9879\u6570\u636e\u53d8\u66f4\u8bb0\u5f55--\u5206\u9875", type=2)
    @ResponseBody
    @GetMapping(value={"/getRecordDataPage"})
    public ResponseData<JqGridData<NewComplianceCompanyExitItemRecordVo>> getRecordDataPage(JqGridParam pageParam, NewComplianceCompanyExitItemRecord record) {
        if (record.getCid() == null || record.getItemType() == null) {
            return ResponseData.fail((String)"\u67e5\u8be2\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u7f3a\u5c11\u4f01\u4e1aID\u6216\u7c7b\u578b");
        }
        PageInfo page = this.exitItemService.getRecordDataPage(pageParam, record);
        List list = page.getList();
        for (NewComplianceCompanyExitItemRecordVo vo : list) {
            List fileModelList;
            if (vo.getProveFile() == null || !vo.getProveFile().isEmpty() || (fileModelList = this.sysFileProvideService.getListByIds(vo.getProveFile())) == null || fileModelList.isEmpty()) continue;
            vo.setProveFiles(fileModelList);
        }
        return ResponseData.success((Object)new JqGridData(page, pageParam));
    }

    @GetMapping(value={"/refreshNotComplianceCompanyStaffCheckInfo"})
    @ResponseBody
    public String refreshNotComplianceCompanyStaffCheckInfo() {
        Long cid = UserUtils.getLoginStaffCompanyId();
        this.businessDataUpdateRefreshService.refreshNotComplianceCompanyStaffCheckInfo(Collections.singletonList(cid));
        return "success";
    }

    @GetMapping(value={"/determineIndustryComplianc"})
    @ResponseBody
    public ResponseData<Boolean> determineIndustryComplianc() {
        return ResponseData.success((Object)this.canCompliance(UserUtils.getLoginStaffCompanyId()));
    }

    @Generated
    public NewComplianceCompanyController() {
    }
}

