/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.newcompanyguide;

import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.LayUiResponseResult;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.framework.encrypt.annotation.ApiEncrypt;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModelNoDesensitization;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.newcompanyguide.entity.NewCompanyGuideInfo;
import cn.smarthse.modules.health.newcompanyguide.entity.NewCompanyGuideProgress;
import cn.smarthse.modules.health.newcompanyguide.entity.NewCompanyGuideThreeWhilstInfo;
import cn.smarthse.modules.health.newcompanyguide.model.NewCompanyGuideLackMaterialHistoryModel;
import cn.smarthse.modules.health.newcompanyguide.model.NewCompanyGuideLackMaterialModel;
import cn.smarthse.modules.health.newcompanyguide.model.NewCompanyGuideOccupationalHazardInfoModel;
import cn.smarthse.modules.health.newcompanyguide.model.NewCompanyGuideOrgShowModel;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideFinishedReportService;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideInfoService;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideLackMaterialService;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideOccupationalHazardInfoService;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideOrgShowService;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideProgressService;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideThreeWhilstInfoService;
import cn.smarthse.modules.health.newcompanyguide.vo.LackMaterialVo;
import cn.smarthse.modules.health.newcompanyguide.vo.NewCompanyGuideLackMaterialHistoryVo;
import cn.smarthse.modules.health.newcompanyguide.vo.NewCompanyGuideOccupationalHazardInfoVo;
import cn.smarthse.modules.health.newcompanyguide.vo.NewCompanyGuideOrgShowCountVo;
import cn.smarthse.modules.health.newcompanyguide.vo.NewCompanyGuideOrgShowVo;
import cn.smarthse.modules.health.newcompanyguide.vo.NewCompanyGuideSummaryVo;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicCommandService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicNewService;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/newCompanyGuide"})
public class NewCompanyGuideController
extends ControllerSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewCompanyGuideController.class);
    @DubboReference(check=false)
    private INewCompanyGuideThreeWhilstInfoService threeWhilstInfoService;
    @DubboReference(check=false)
    private INewCompanyGuideOccupationalHazardInfoService occupationalHazardInfoService;
    @DubboReference(version="1.0.0")
    ICompanyProvideByHSEService companyProvideByHSEService;
    @DubboReference(check=false)
    private INewCompanyGuideProgressService newCompanyGuideProgressService;
    @DubboReference(check=false)
    private INewCompanyGuideOrgShowService newCompanyGuideOrgShowService;
    @DubboReference(check=false)
    private INewCompanyGuideFinishedReportService finishedReportService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService areaProvideService;
    @DubboReference(check=false)
    private INewCompanyGuideInfoService newCompanyGuideInfoService;
    @DubboReference
    private IReformItemBasicNewService reformItemBasicNewService;
    @DubboReference
    private IReformItemBasicCommandService reformItemBasicCommandService;
    @DubboReference(check=false)
    private INewCompanyGuideLackMaterialService newCompanyGuideLackMaterialService;

    @GetMapping(value={"index"})
    public String recalculateScore(ModelMap map) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        NewCompanyGuideInfo info = this.newCompanyGuideInfoService.getByCid(cid);
        if (Objects.isNull(info.getStep())) {
            Byte step = this.newCompanyGuideProgressService.addNextProgress(cid, UserUtils.getLoginStaffId(), null);
            info.setStep(step);
        }
        map.put((Object)"info", (Object)info);
        map.put((Object)"step", (Object)info.getStep());
        return "views/newCompanyGuide/index";
    }

    @GetMapping(value={"/itempage/{page}"})
    public String itempage(ModelMap map, @PathVariable(value="page") String page) {
        return "views/newCompanyGuide/itemsPage/" + page;
    }

    @GetMapping(value={"/itempage/orgList"})
    public String getOrgList() {
        return "views/newCompanyGuide/itemsPage/orgList";
    }

    @GetMapping(value={"/getCompanyInfo"})
    @ResponseBody
    public ResponseData<CompanyBaseInfoModel> getCompanyInfo() {
        CompanyBaseInfoModel companyInfo = this.threeWhilstInfoService.getCompanyInfo(UserUtils.getLoginStaffCompanyId());
        NewCompanyGuideInfo guideInfo = this.newCompanyGuideInfoService.getByCid(UserUtils.getLoginStaffCompanyId());
        if (ObjectUtil.isNotNull((Object)guideInfo)) {
            companyInfo.setNewCompanyDatasource(guideInfo.getNewCompanyDatasource());
        }
        return ResponseData.success((Object)companyInfo);
    }

    @GetMapping(value={"/getCompanyInfoNoDesensitization"})
    @ResponseBody
    @ApiEncrypt(request=true, response=true)
    public ResponseData<CompanyBaseInfoModelNoDesensitization> getCompanyInfoNoDesensitization() {
        CompanyBaseInfoModel companyInfo = this.threeWhilstInfoService.getCompanyInfo(UserUtils.getLoginStaffCompanyId());
        NewCompanyGuideInfo guideInfo = this.newCompanyGuideInfoService.getByCid(UserUtils.getLoginStaffCompanyId());
        if (ObjectUtil.isNotNull((Object)guideInfo)) {
            companyInfo.setNewCompanyDatasource(guideInfo.getNewCompanyDatasource());
        }
        CompanyBaseInfoModelNoDesensitization companyBaseInfoModelNoDesensitization = new CompanyBaseInfoModelNoDesensitization();
        BeanUtils.copyProperties((Object)companyInfo, (Object)companyBaseInfoModelNoDesensitization);
        return ResponseData.success((Object)companyBaseInfoModelNoDesensitization);
    }

    @PostMapping(value={"/saveCompanyInfo"})
    @ResponseBody
    public ResponseData<Long> saveCompanyInfo(@RequestBody CompanyBaseInfoModel companyModel) {
        Long cid;
        companyModel.setCid(UserUtils.getLoginStaffCompanyId());
        try {
            cid = this.threeWhilstInfoService.saveCompany(companyModel, UserUtils.getLoginStaffId());
        }
        catch (Exception e) {
            return ResponseData.fail((String)e.getMessage());
        }
        return ResponseData.success((Object)cid);
    }

    @ResponseBody
    @GetMapping(value={"/getThreeWhilstInfoByCid"})
    public ResponseData<NewCompanyGuideThreeWhilstInfo> getThreeWhilstInfoByCid() {
        return ResponseData.success((Object)this.threeWhilstInfoService.getThreeWhilstInfoByCid(UserUtils.getLoginStaffCompanyId()));
    }

    @ResponseBody
    @PostMapping(value={"/saveThreeWhilstInfo"})
    public ResponseData<Long> saveThreeWhilstInfo(@RequestBody NewCompanyGuideThreeWhilstInfo info) {
        Long id;
        info.setCid(UserUtils.getLoginStaffCompanyId());
        try {
            id = this.threeWhilstInfoService.saveThreeWhilstInfo(info, UserUtils.getLoginStaffId());
        }
        catch (Exception e) {
            return ResponseData.fail((String)e.getMessage());
        }
        return ResponseData.success((Object)id);
    }

    @ResponseBody
    @GetMapping(value={"/getEvaluateList"})
    public ResponseData<List<NewCompanyGuideOccupationalHazardInfoVo>> getEvaluateList(Byte step) {
        return ResponseData.success((Object)this.occupationalHazardInfoService.getEvaluateList(UserUtils.getLoginStaffCompanyId(), step));
    }

    @ResponseBody
    @PostMapping(value={"/saveOccEvaluate"})
    public ResponseData saveOccEvaluate(@RequestBody NewCompanyGuideOccupationalHazardInfoModel hazardInfoModel) {
        try {
            this.occupationalHazardInfoService.saveOccEvaluate(hazardInfoModel.getList(), UserUtils.getLoginStaffCompanyId(), UserUtils.getLoginStaffId());
        }
        catch (Exception e) {
            return ResponseData.fail((String)e.getMessage());
        }
        return ResponseData.success();
    }

    @ResponseBody
    @PostMapping(value={"/saveEvaluationInfo"})
    public ResponseData saveEvaluationInfo(@RequestBody NewCompanyGuideOccupationalHazardInfoModel hazardInfoModel) {
        Date testRunBeginTime = hazardInfoModel.getThreeWhilstInfo().getTestRunBeginTime();
        Date actualStartTime = hazardInfoModel.getThreeWhilstInfo().getActualStartTime();
        if (testRunBeginTime != null && actualStartTime != null && testRunBeginTime.after(actualStartTime)) {
            return ResponseData.fail((String)"\u8bd5\u8fd0\u884c\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u5b9e\u9645\u5f00\u5de5\u65f6\u95f4");
        }
        try {
            this.threeWhilstInfoService.saveEvaluationInfo(hazardInfoModel, UserUtils.getLoginStaffCompanyId(), UserUtils.getLoginStaffId());
        }
        catch (Exception e) {
            return ResponseData.fail((String)e.getMessage());
        }
        return ResponseData.success();
    }

    @GetMapping(value={"/summaryData"})
    @ResponseBody
    public ResponseData<NewCompanyGuideSummaryVo> summaryData() {
        return ResponseData.success((Object)this.newCompanyGuideProgressService.summaryInfo(UserUtils.getLoginStaffCompanyId()));
    }

    @GetMapping(value={"/listShowOrg"})
    @ResponseBody
    public ResponseData<JqGridData<NewCompanyGuideOrgShowVo>> listShowOrg(NewCompanyGuideOrgShowModel orgShowModel) {
        if (orgShowModel.getOrgAreaId() != null) {
            AreaModel area = this.areaProvideService.getAreaById(orgShowModel.getOrgAreaId());
            orgShowModel.setOrgAreaLevel(area.getLevel());
        }
        CompanyBaseInfoModel company = UserUtils.getCurrentCompanyFromDataCenter();
        AreaModel area = this.areaProvideService.getAreaById(company.getAreaId());
        orgShowModel.setAreaId(area.getAreaId());
        orgShowModel.setCid(company.getId());
        PageInfo pageInfo = this.newCompanyGuideOrgShowService.listOrgDataByCid(orgShowModel);
        return ResponseData.success((Object)new JqGridData(pageInfo, (JqGridParam)orgShowModel));
    }

    @ResponseBody
    @GetMapping(value={"/showOrgCount"})
    public ResponseData<NewCompanyGuideOrgShowCountVo> showOrgCount(NewCompanyGuideOrgShowModel orgShowModel) {
        CompanyBaseInfoModel company = UserUtils.getCurrentCompanyFromDataCenter();
        AreaModel area = this.areaProvideService.getAreaById(company.getAreaId());
        orgShowModel.setAreaId(area.getAreaId());
        return ResponseData.success((Object)this.newCompanyGuideOrgShowService.showOrgCount(orgShowModel.getAreaId()));
    }

    @ResponseBody
    @GetMapping(value={"/getProgress"})
    public ResponseData<NewCompanyGuideProgress> getProgress(Byte step) {
        CompanyBaseInfoModel company = UserUtils.getCurrentCompanyFromDataCenter();
        AreaModel area = this.areaProvideService.getAreaById(company.getAreaId());
        return ResponseData.success((Object)this.newCompanyGuideProgressService.getByStep(company.getCid(), area.getAreaId(), step));
    }

    @ResponseBody
    @PostMapping(value={"/confirmTips"})
    public ResponseData confirmTips(Byte step) {
        try {
            this.newCompanyGuideProgressService.confirmTips(UserUtils.getLoginStaffCompanyId(), step, UserUtils.getLoginStaffId());
        }
        catch (Exception e) {
            return ResponseData.fail((String)e.getMessage());
        }
        return ResponseData.success();
    }

    @ResponseBody
    @RequestMapping(value={"/finishGuide"})
    public ResponseData<List<String>> finishGuide(Long tsProjectId) {
        List list = this.newCompanyGuideProgressService.finishGuide(UserUtils.getLoginStaffCompanyId(), UserUtils.getLoginStaffId(), tsProjectId);
        if (!list.isEmpty()) {
            return ResponseData.fail((Object)list);
        }
        this.reformItemBasicCommandService.genKeyFactorReformNewCompany(UserUtils.getLoginStaffCompanyId().toString());
        return ResponseData.success();
    }

    @ResponseBody
    @GetMapping(value={"/testReGenRisk"})
    public ResponseData<String> testReGenRisk(String cids) {
        try {
            if (StringUtils.isBlank((CharSequence)cids)) {
                return ResponseData.success();
            }
            this.newCompanyGuideProgressService.testConvert2normalCompany(cids);
            this.reformItemBasicNewService.autoGenKeyFactorReform(cids);
            return ResponseData.success();
        }
        catch (Exception e) {
            return ResponseData.fail((String)e.getMessage());
        }
    }

    @ResponseBody
    @GetMapping(value={"/convert2normalCompany"})
    public ResponseData<String> convert2normalCompany() {
        Long cid = UserUtils.getLoginStaffCompanyId();
        this.newCompanyGuideProgressService.convert2normalCompany(Collections.singletonList(cid));
        return ResponseData.success();
    }

    @Log(title="\u4f01\u4e1a\u5f15\u5bfc-\u83b7\u53d6\u5339\u914d\u7684\u9879\u76ee\u5217\u8868", type=2)
    @ResponseBody
    @GetMapping(value={"/matchingTsProjectList"})
    public ResponseData<Object> matchingTsProjectList() {
        List warnList = this.newCompanyGuideProgressService.verifyItem(UserUtils.getLoginStaffCompanyId());
        if (CollectionUtils.isNotEmpty((Collection)warnList)) {
            return ResponseData.fail((Object)warnList);
        }
        return ResponseData.success((Object)this.newCompanyGuideProgressService.matchingTsProjectList(UserUtils.getLoginStaffCompanyId()));
    }

    @GetMapping(value={"reportLackMaterialPage"})
    public String reportLackMaterialPage() {
        return "/newCompanyGuide/itemsPage/reportList";
    }

    @GetMapping(value={"/lackMaterialList"})
    @ResponseBody
    public LayUiResponseResult<LackMaterialVo> getSimpleLackMaterialList(JqGridParam pageParam, NewCompanyGuideLackMaterialModel searchParam) {
        if (searchParam == null) {
            searchParam = new NewCompanyGuideLackMaterialModel();
        }
        Long cid = UserUtils.getLoginStaffCompanyId();
        searchParam.setCid(cid);
        PageInfo lackPage = this.newCompanyGuideLackMaterialService.getSimpleLackMaterialList(pageParam, searchParam);
        return LayUiResponseResult.success((PageInfo)lackPage);
    }

    @GetMapping(value={"/lackMaterialDetail"})
    @ResponseBody
    public LayUiResponseResult<LackMaterialVo> getLackMaterialDetail(LackMaterialVo searchParam) {
        if (searchParam == null) {
            searchParam = new LackMaterialVo();
        }
        Long cid = UserUtils.getLoginStaffCompanyId();
        searchParam.setCid(cid);
        LackMaterialVo lackDetail = this.newCompanyGuideLackMaterialService.getLackMaterialDetail(searchParam);
        return LayUiResponseResult.success((Object)lackDetail);
    }

    @PostMapping(value={"/submitLackMaterial"})
    @ResponseBody
    public LayUiResponseResult<Object> submitLackMaterial(@RequestBody NewCompanyGuideLackMaterialModel lackModel) {
        if (lackModel == null) {
            lackModel = new NewCompanyGuideLackMaterialModel();
        }
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        lackModel.setCid(cid);
        lackModel.setCreateBy(loginStaffId);
        lackModel.setUpdateBy(loginStaffId);
        this.newCompanyGuideLackMaterialService.submitLackMaterial(lackModel);
        return LayUiResponseResult.success();
    }

    @GetMapping(value={"/lackMaterialAuditRecord"})
    @ResponseBody
    public LayUiResponseResult<NewCompanyGuideLackMaterialHistoryVo> getLackMaterialAuditRecord(JqGridParam pageParam, NewCompanyGuideLackMaterialHistoryModel searchParam) {
        if (searchParam == null) {
            searchParam = new NewCompanyGuideLackMaterialHistoryModel();
        }
        PageInfo recordPage = this.newCompanyGuideLackMaterialService.getLackMaterialAuditRecord(pageParam, searchParam);
        return LayUiResponseResult.success((PageInfo)recordPage);
    }
}

