/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.micro;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.modules.health.micro.param.MicroCompanyCertStaffDetailParam;
import cn.smarthse.modules.health.micro.param.MicroCompanyDeclareParam;
import cn.smarthse.modules.health.micro.param.MicroCompanyThirdOrganizationParam;
import cn.smarthse.modules.health.micro.param.MicroCompanyTsProjectSimpleParam;
import cn.smarthse.modules.health.micro.param.MicrocomPreSmartContentParam;
import cn.smarthse.modules.health.micro.param.MicrocomPreSmartDocParam;
import cn.smarthse.modules.health.micro.param.MicrocomPreSmartPlanParam;
import cn.smarthse.modules.health.micro.param.MicrocomProcessGuideParam;
import cn.smarthse.modules.health.micro.service.IMicroCompanyThirdOrganizationService;
import cn.smarthse.modules.health.micro.service.IMicrocomPreSmartContentService;
import cn.smarthse.modules.health.micro.service.IMicrocomPreSmartDocService;
import cn.smarthse.modules.health.micro.service.IMicrocomPreSmartPlanService;
import cn.smarthse.modules.health.micro.vo.MicroCompanyCertStaffDetailVo;
import cn.smarthse.modules.health.micro.vo.MicroCompanyDeclareVo;
import cn.smarthse.modules.health.micro.vo.MicroCompanyThirdOrganizationVo;
import cn.smarthse.modules.health.micro.vo.MicroCompanyTsProjectSimpleVo;
import cn.smarthse.modules.health.micro.vo.MicrocomPreSmartContentVo;
import cn.smarthse.modules.health.micro.vo.MicrocomPreSmartDocVo;
import cn.smarthse.modules.health.micro.vo.MicrocomPreSmartPlanVo;
import cn.smarthse.modules.health.micro.vo.MicrocomProcessGuideVo;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/microCompany"})
public class MicroCompanyController
extends ControllerSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MicroCompanyController.class);
    @DubboReference(check=false)
    private IMicroCompanyThirdOrganizationService microOrgService;
    @DubboReference(check=false)
    private IMicrocomPreSmartDocService microSmartService;
    @DubboReference(check=false)
    IMicrocomPreSmartPlanService microcomPreSmartPlanService;
    @DubboReference(check=false)
    IMicrocomPreSmartContentService microcomPreSmartContentService;

    @GetMapping(value={"/preSmartDoc"})
    public String preSmartDoc(ModelMap model) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        model.put((Object)"cid", (Object)cid);
        return "/views/intelligentPreviewManagement/intelligentPreviewIndex";
    }

    @GetMapping(value={"/orgInfoPage"})
    @ResponseBody
    public ResponseData<JqGridData<MicroCompanyThirdOrganizationVo>> thirdOrganizationPage(JqGridParam pageParam, MicroCompanyThirdOrganizationParam orgParam) {
        if (orgParam == null) {
            orgParam = new MicroCompanyThirdOrganizationParam();
        }
        if (orgParam.getCid() == null) {
            orgParam.setCid(UserUtils.getLoginStaffCompanyId());
        }
        PageInfo microOrgPage = this.microOrgService.getMicroCompanyThirdOrganizationPage(pageParam, orgParam);
        JqGridData newCompanyInfoData = new JqGridData(microOrgPage, pageParam);
        return ResponseData.success((Object)newCompanyInfoData);
    }

    @GetMapping(value={"/preTip"})
    @ResponseBody
    public ResponseData<MicrocomPreSmartPlanVo> preSmartPlanTip(MicrocomPreSmartPlanParam planParam) {
        if (planParam == null) {
            planParam = new MicrocomPreSmartPlanParam();
        }
        if (planParam.getCid() == null) {
            planParam.setCid(UserUtils.getLoginStaffCompanyId());
        }
        MicrocomPreSmartPlanVo preTip = this.microcomPreSmartPlanService.preSmartPlanTip(planParam);
        return ResponseData.success((Object)preTip);
    }

    @GetMapping(value={"/preSmartPlan"})
    @ResponseBody
    public ResponseData<JqGridData<MicrocomPreSmartPlanVo>> microcomPreSmartPlanPage(JqGridParam pageParam, MicrocomPreSmartPlanParam planParam) {
        if (planParam == null) {
            planParam = new MicrocomPreSmartPlanParam();
        }
        if (planParam.getCid() == null) {
            planParam.setCid(UserUtils.getLoginStaffCompanyId());
        }
        PageInfo planPage = this.microcomPreSmartPlanService.getMicrocomPreSmartPlanPage(pageParam, planParam);
        return ResponseData.success((Object)new JqGridData(planPage, pageParam));
    }

    @GetMapping(value={"/preSmartContent"})
    @ResponseBody
    public ResponseData<List<MicrocomPreSmartContentVo>> microcomPreSmartContentList(MicrocomPreSmartContentParam contentParam) {
        if (contentParam == null) {
            contentParam = new MicrocomPreSmartContentParam();
        }
        if (contentParam.getCid() == null) {
            contentParam.setCid(UserUtils.getLoginStaffCompanyId());
        }
        List contentList = this.microcomPreSmartContentService.getMicrocomPreSmartContentList(contentParam);
        return ResponseData.success((Object)contentList);
    }

    @GetMapping(value={"/preSmartDocList"})
    @ResponseBody
    public ResponseData<List<MicrocomPreSmartDocVo>> preSmartDocList(MicrocomPreSmartDocParam docParam) {
        if (docParam == null) {
            docParam = new MicrocomPreSmartDocParam();
        }
        if (docParam.getCid() == null) {
            docParam.setCid(UserUtils.getLoginStaffCompanyId());
        }
        List docList = this.microSmartService.getMicrocomPreSmartDocList(docParam);
        return ResponseData.success((Object)docList);
    }

    @GetMapping(value={"/processGuideData"})
    @ResponseBody
    public ResponseData<MicrocomProcessGuideVo> processGuideData(MicrocomProcessGuideParam guideParam) {
        if (guideParam == null) {
            guideParam = new MicrocomProcessGuideParam();
        }
        if (guideParam.getCid() == null) {
            guideParam.setCid(UserUtils.getLoginStaffCompanyId());
        }
        MicrocomProcessGuideVo processGuideData = this.microSmartService.getProcessGuideData(guideParam);
        return ResponseData.success((Object)processGuideData);
    }

    @GetMapping(value={"/declareList"})
    @ResponseBody
    @Deprecated
    public ResponseData<List<MicroCompanyDeclareVo>> declareList(MicroCompanyDeclareParam dParam) {
        if (dParam == null) {
            dParam = new MicroCompanyDeclareParam();
        }
        if (dParam.getCid() == null) {
            dParam.setCid(UserUtils.getLoginStaffCompanyId());
        }
        List declareList = this.microSmartService.getMicroCompanyDeclareList(dParam);
        return ResponseData.success((Object)declareList);
    }

    @GetMapping(value={"/certStaffDetailList"})
    @ResponseBody
    @Deprecated
    public ResponseData<List<MicroCompanyCertStaffDetailVo>> certStaffDetailList(MicroCompanyCertStaffDetailParam certParam) {
        if (certParam == null) {
            certParam = new MicroCompanyCertStaffDetailParam();
        }
        if (certParam.getCid() == null) {
            certParam.setCid(UserUtils.getLoginStaffCompanyId());
        }
        List certList = this.microSmartService.getMicroCompanyCertStaffDetailList(certParam);
        return ResponseData.success((Object)certList);
    }

    @GetMapping(value={"/generateCert"})
    @ResponseBody
    @Deprecated
    public ResponseData<String> generateCert(MicroCompanyCertStaffDetailParam certParam) {
        if (certParam == null) {
            certParam = new MicroCompanyCertStaffDetailParam();
        }
        if (certParam.getCid() == null) {
            certParam.setCid(UserUtils.getLoginStaffCompanyId());
        }
        if (certParam.getCreateBy() == null) {
            certParam.setCreateBy(UserUtils.getLoginStaffCompanyId());
        }
        if (certParam.getUpdateBy() == null) {
            certParam.setUpdateBy(UserUtils.getLoginStaffCompanyId());
        }
        certParam.setGenerateNumber(Integer.valueOf(1));
        this.microSmartService.generatePreSmartCertStaffDetailInfo(certParam);
        return ResponseData.success((String)"\u5b8c\u6210");
    }

    @GetMapping(value={"/generate"})
    @ResponseBody
    @Deprecated
    public ResponseData<String> generate(MicrocomPreSmartDocParam param) {
        this.microSmartService.generatePreSmartInfo(param);
        return ResponseData.success((String)"\u5b8c\u6210");
    }

    @GetMapping(value={"/tsProjectSimpleList"})
    @ResponseBody
    @Deprecated
    public ResponseData<List<MicroCompanyTsProjectSimpleVo>> tsProjectSimpleList(MicroCompanyTsProjectSimpleParam tsParam) {
        if (tsParam == null) {
            tsParam = new MicroCompanyTsProjectSimpleParam();
        }
        if (tsParam.getCid() == null) {
            tsParam.setCid(UserUtils.getLoginStaffCompanyId());
        }
        List certList = this.microSmartService.getMicroCompanyTsProjectSimpleList(tsParam);
        return ResponseData.success((Object)certList);
    }

    @GetMapping(value={"/generateTs"})
    @ResponseBody
    @Deprecated
    public ResponseData<String> generatePreSmartTsProjectSimpleInfo(MicroCompanyTsProjectSimpleParam tsParam) {
        if (tsParam == null) {
            tsParam = new MicroCompanyTsProjectSimpleParam();
        }
        if (tsParam.getCid() == null) {
            tsParam.setCid(UserUtils.getLoginStaffCompanyId());
        }
        if (tsParam.getCreateBy() == null) {
            tsParam.setCreateBy(UserUtils.getLoginStaffCompanyId());
        }
        if (tsParam.getUpdateBy() == null) {
            tsParam.setUpdateBy(UserUtils.getLoginStaffCompanyId());
        }
        tsParam.setGenerateNumber(Integer.valueOf(1));
        this.microSmartService.generatePreSmartTsProjectSimpleInfo(tsParam);
        return ResponseData.success((String)"\u5b8c\u6210");
    }

    @GetMapping(value={"/generateCheck"})
    @ResponseBody
    public ResponseData<String> generateCheck(Integer month, Long cid) {
        if (month == null) {
            month = DateUtils.getMonth((Date)new Date());
        }
        if (cid == null) {
            cid = UserUtils.getLoginStaffCompanyId();
        }
        return ResponseData.success((String)"\u9884\u667a\u5355-\u68c0\u6d4b\u5de5\u4f5c\u8be6\u60c5\u5b89\u6392,\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7");
    }

    @GetMapping(value={"/generateCheckOver"})
    @ResponseBody
    public ResponseData<String> generateCheckOver(Integer month, Long cid) {
        if (month == null) {
            month = DateUtils.getMonth((Date)new Date());
        }
        if (cid == null) {
            cid = UserUtils.getLoginStaffCompanyId();
        }
        return ResponseData.success((String)"\u9884\u667a\u5355-\u68c0\u6d4b\u8d85\u6807\u5de5\u4f5c\u8be6\u60c5\u5b89\u6392,\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7");
    }

    @GetMapping(value={"/generatePhy"})
    @ResponseBody
    public ResponseData<String> generatePhy(Integer month, Long cid) {
        if (month == null) {
            month = DateUtils.getMonth((Date)new Date());
        }
        if (cid == null) {
            cid = UserUtils.getLoginStaffCompanyId();
        }
        return ResponseData.success((String)"\u9884\u667a\u5355-\u4f53\u68c0\u7ed3\u679c\u5f02\u5e38\u8be6\u60c5\u5b89\u6392,\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7");
    }
}

