/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.litearchive.simple;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.mapper.JsonMapper;
import cn.smarthse.modules.health.entity.litearchive.LiteArchive;
import cn.smarthse.modules.health.enums.thirdtime.TsProjectPhraseEnum;
import cn.smarthse.modules.health.enums.thirdtime.TsProjectTypeEnum;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveService;
import cn.smarthse.modules.health.service.litearchive.simple.ILiteArchiveSimpleService;
import cn.smarthse.modules.health.vo.litearchive.TsLiteArchiveVo;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/liteArchive/simple"})
public class LiteArchiveSimpleController
extends ControllerSupport {
    @DubboReference
    private ILiteArchiveService liteArchiveService;
    @DubboReference
    private ILiteArchiveSimpleService liteArchiveSimpleService;

    @RequestMapping(value={"/index"}, method={RequestMethod.GET})
    public String index(Integer archiveType, Model model) {
        Long companyId = UserUtils.getLoginStaffCompanyId();
        if (archiveType.equals(1)) {
            model.addAttribute("tsprojecttype", (Object)JsonMapper.toJsonString((Object)TsProjectTypeEnum.getAllValues()));
            List tsprojectPhrase = TsProjectPhraseEnum.getAllValues(t -> t.getCode() != 4);
            model.addAttribute("tsprojectPhrase", (Object)JsonMapper.toJsonString((Object)tsprojectPhrase));
            Long complianceCompany = this.liteArchiveService.isComplianceCompany(companyId);
            boolean isComplianceCompany = complianceCompany != null;
            model.addAttribute("iscompliance", (Object)isComplianceCompany);
            return "views/keyFactorManagement/liteArchive/simple/tsindex";
        }
        if (archiveType.equals(6)) {
            return "views/keyFactorManagement/liteArchive/liteArchiveDetailPersonal";
        }
        model.addAttribute("archiveType", (Object)archiveType);
        model.addAttribute("title", (Object)this.getArchiveTitleByType(archiveType));
        if (archiveType.equals(5)) {
            LiteArchive doc5 = this.liteArchiveService.getFirstArchive5ByCid(companyId, UserUtils.getLoginStaffId());
            return "forward:/liteArchive/detail?id=" + doc5.getId();
        }
        return "views/keyFactorManagement/liteArchive/liteArchiveIndex";
    }

    @RequestMapping(value={"/tslistdata"})
    @ResponseBody
    public JqGridData<TsLiteArchiveVo> tslistdata(JqGridParam jqGridParam, String kw, Boolean finish, Boolean iscompliance) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        PageInfo pageInfo = this.liteArchiveSimpleService.getTsLiteArchivePage(jqGridParam, kw, cid, finish, iscompliance);
        return new JqGridData(pageInfo, jqGridParam);
    }

    private String getArchiveTitleByType(Integer archiveType) {
        switch (archiveType) {
            case 1: {
                return "\u5efa\u8bbe\u9879\u76ee\u804c\u4e1a\u536b\u751f\u201c\u4e09\u540c\u65f6\u201d\u6863\u6848";
            }
            case 2: {
                return "\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u6863\u6848";
            }
            case 3: {
                return "\u804c\u4e1a\u536b\u751f\u5ba3\u4f20\u57f9\u8bad\u6863\u6848";
            }
            case 4: {
                return "\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u76d1\u6d4b\u4e0e\u68c0\u6d4b\u8bc4\u4ef7\u6863\u6848";
            }
            case 5: {
                return "\u7528\u4eba\u5355\u4f4d\u804c\u4e1a\u5065\u5eb7\u76d1\u62a4\u7ba1\u7406\u6863\u6848";
            }
            case 6: {
                return "\u52b3\u52a8\u8005\u4e2a\u4eba\u804c\u4e1a\u5065\u5eb7\u76d1\u62a4\u6863\u6848";
            }
        }
        return "";
    }
}

