/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.litearchive;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.compliance.service.IBusinessDataUpdateRefreshService;
import cn.smarthse.modules.health.entity.archive.lite.LiteArcTsFormVo;
import cn.smarthse.modules.health.entity.work.thirdtime.LiteArchiveTsLink;
import cn.smarthse.modules.health.entity.work.thirdtime.TsProjectSimple;
import cn.smarthse.modules.health.newcompliance.service.INewBusinessDataUpdateRefreshService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.service.work.thirdtime.ILiteArchiveTsLinkService;
import cn.smarthse.modules.health.service.work.thirdtime.simple.ITsProjectSimpleService;
import cn.smarthse.modules.health.vo.litearchive.TsLiteArchiveVo;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/lite/tsarchive"})
public class LiteArchiveTsController
extends ControllerSupport {
    @DubboReference
    private ILiteArchiveTsLinkService liteArchiveTsLinkService;
    @DubboReference
    private ITsProjectSimpleService tsProjectSimpleService;
    @DubboReference
    private ILiteArchiveService liteArchiveService;
    @DubboReference
    private IReformItemBasicService reformItemBasicService;
    @DubboReference(check=false)
    private IBusinessDataUpdateRefreshService businessDataUpdateRefreshService;
    @Autowired
    private INewBusinessDataUpdateRefreshService newBusinessDataUpdateRefreshService;

    @RequestMapping(value={"addpage"})
    public String addpage(Long achiveId, ModelMap m) {
        TsLiteArchiveVo tsLiteArchiveVo = this.liteArchiveTsLinkService.getTsLiteArchiveVoByArchiveId(achiveId);
        m.put((Object)"vo", (Object)tsLiteArchiveVo);
        return "views/keyFactorManagement/liteArchive/ts/add";
    }

    @RequestMapping(value={"selectevaluate"})
    public String selectevaluate() {
        return "views/keyFactorManagement/liteArchive/ts/selectevaluate";
    }

    @RequestMapping(value={"save"})
    @ResponseBody
    @RepeatUrlFormData
    @Log(title="\u5171\u4eab\u4f53\u7cfb\u5c71\u540c\u65f6\u6863\u6848-\u6dfb\u52a0\u9879\u76ee", type=20)
    public ResponseData<String> saveTsArc(LiteArcTsFormVo formVo) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        formVo.setCid(cid);
        ResponseData data = new ResponseData();
        try {
            if (StringUtils.isNotBlank((CharSequence)formVo.getEvaluateIds()) && StringUtils.isNotBlank((CharSequence)formVo.getProjectName())) {
                data.setContent("\u4fdd\u5b58\u6210\u529f");
            } else {
                data.setContent("\u53c2\u6570\u9519\u8bef");
            }
        }
        catch (Exception e) {
            data.setContent("\u4fdd\u5b58\u5931\u8d25");
        }
        return data;
    }

    @RequestMapping(value={"del"})
    @Log(title="\u5171\u4eab\u4f53\u7cfb\u5c71\u540c\u65f6\u6863\u6848-\u5220\u9664", type=22)
    @RepeatUrlFormData
    @ResponseBody
    public ResponseData<String> del(Long archiveId) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        ResponseData resultData = new ResponseData();
        try {
            LiteArchiveTsLink tsLinkByArchiveId = this.liteArchiveTsLinkService.getTsLinkByArchiveId(archiveId);
            Long tsId = tsLinkByArchiveId.getTsId();
            TsProjectSimple ts = new TsProjectSimple();
            ts.setId(tsId);
            this.tsProjectSimpleService.delTsProject(ts, loginStaffId);
            this.liteArchiveTsLinkService.delArchiveTsLink(archiveId, loginStaffId);
            resultData.setContent("\u5220\u9664\u6210\u529f");
            return resultData;
        }
        catch (Exception e) {
            this.logger.error("\u5220\u9664\u51fa\u9519\uff1a" + e.getMessage());
            resultData.setState(ResponseStateEnum.fail);
            resultData.setContent(e.getMessage());
            return resultData;
        }
    }
}

