/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.litearchive;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.FilesTypeEnum;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.common.util.Java2WordGeneratorTemp;
import cn.smarthse.common.util.ServletsUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.compliance.enums.ComplianceCodeEnum;
import cn.smarthse.modules.health.compliance.service.IBusinessDataUpdateRefreshService;
import cn.smarthse.modules.health.entity.base.staff.vo.HarmWorkStaffInfoVo;
import cn.smarthse.modules.health.entity.base.staff.vo.StaffDocInfoVo;
import cn.smarthse.modules.health.entity.litearchive.CheckResultImportVo;
import cn.smarthse.modules.health.entity.litearchive.LiteArchive;
import cn.smarthse.modules.health.entity.litearchive.LiteArchiveFilePersonal;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalCheckSearchVo;
import cn.smarthse.modules.health.entity.work.check.vo.doc.Doc6Table4_2;
import cn.smarthse.modules.health.entity.work.reform.param.RiskListSearch;
import cn.smarthse.modules.health.entity.work.reform.vo.RiskListItemDataVo;
import cn.smarthse.modules.health.enums.archive.PersonalHarmFactorArchiveDataMapKeyEnum;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.enums.staff.StaffInfoImportStateEnum;
import cn.smarthse.modules.health.param.ArchiveSearchParam;
import cn.smarthse.modules.health.service.base.IBusinessNoService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveFilePersonalService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveService;
import cn.smarthse.modules.health.service.work.check.checkV3221.IPhcPhysicalCheckV3221Service;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.uploader.FileResourceEnum;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.AppConfigHolder;
import cn.smarthse.web.util.SysFileUtil;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/liteArchive"})
public class LiteArchivePersonalController
extends ControllerSupport {
    @DubboReference
    private ILiteArchiveFilePersonalService liteArchiveFilePersonalService;
    @DubboReference
    IBusinessNoService businessNoService;
    @DubboReference(timeout=5000000)
    private ISysFileProvideService sysFileProvideService;
    @DubboReference
    IStaffInfoService staffInfoService;
    @DubboReference
    private ILiteArchiveService liteArchiveService;
    @DubboReference(check=false)
    private IBusinessDataUpdateRefreshService refreshService;
    @DubboReference
    private IReformItemBasicService reformItemBasicService;
    @DubboReference(timeout=600000, check=false)
    private IPhcPhysicalCheckV3221Service phcPhysicalCheckV3221Service;

    @RequestMapping(value={"/personalData"})
    @ResponseBody
    public JqGridData<LiteArchiveFilePersonal> personalData(JqGridParam jqGridParam, ArchiveSearchParam param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        PageInfo pageInfo = this.liteArchiveFilePersonalService.queryDetail(jqGridParam, param);
        return new JqGridData(pageInfo, jqGridParam);
    }

    @RequestMapping(value={"/personalDetail"})
    public String detail(Long id, Model model, Boolean iscompliance) {
        LiteArchiveFilePersonal liteArchive = (LiteArchiveFilePersonal)this.liteArchiveFilePersonalService.getById(id);
        model.addAttribute("title", (Object)(liteArchive.getStaffName() + "\u7684\u4e2a\u4eba\u804c\u4e1a\u5065\u5eb7\u76d1\u62a4\u6863\u6848"));
        model.addAttribute("id", (Object)id);
        model.addAttribute("liteArchivePersonal", (Object)liteArchive);
        boolean archiveEditSec = UserUtils.hasPermissionCode("recordFile.6.edit");
        model.addAttribute("archiveEditSec", (Object)archiveEditSec);
        LiteArchive la = new LiteArchive();
        la.setArchiveType(Integer.valueOf(6));
        la.setId(liteArchive.getId());
        model.addAttribute("iscompliance", (Object)iscompliance);
        model.addAttribute("liteArchive", (Object)la);
        return "views/keyFactorManagement/liteArchive/liteArchiveDetail";
    }

    @ResponseBody
    @RequestMapping(value={"getDocStaffIds"})
    public ResponseData<String> getDocStaffIds(HttpSession session, ModelMap m) {
        ResponseData data = new ResponseData();
        String staffIds = this.getDocStaffIdsToStr();
        data.setResult((Object)staffIds);
        return data;
    }

    private String getDocStaffIdsToStr() {
        Long cid = UserUtils.getLoginStaffCompanyId();
        StringBuilder staffIds = new StringBuilder();
        int year = DateUtil.getYear();
        List list = this.liteArchiveFilePersonalService.getArchiveStaffIdsByCid(cid);
        if (list != null) {
            for (Long mem : list) {
                staffIds.append(",").append(mem);
            }
        }
        return staffIds.toString();
    }

    @RequestMapping(value={"/checkResultList"})
    public String personalHistoryPage(Model model) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        model.addAttribute("cid", (Object)cid);
        return "views/keyFactorManagement/liteArchive/personal/checkResultPage";
    }

    @RequestMapping(value={"/goToView"})
    @ResponseBody
    public ResponseData<String> goToView(ModelMap m) {
        try {
            PhcPhysicalCheckSearchVo searchVo = new PhcPhysicalCheckSearchVo();
            this.settingValueForSearchVo(searchVo);
            searchVo.setBodyCheckType(Byte.valueOf((byte)2));
            Long checkCount = this.phcPhysicalCheckV3221Service.getCountBySearchVo(searchVo);
            Object targetUrl = null;
            if (checkCount == null || checkCount == 0L) {
                RiskListSearch search = new RiskListSearch();
                search.setCid(UserUtils.getLoginStaffCompanyId());
                search.setSearchSource(Integer.valueOf(10));
                JqGridParam param = new JqGridParam();
                PageInfo pageInfo = this.reformItemBasicService.getRiskListDataPage(param, search, Boolean.valueOf(true), Integer.valueOf(0));
                Long searchId = ((RiskListItemDataVo)pageInfo.getList().get(0)).getId();
                targetUrl = "/riskResolution/riskInfo?id=" + searchId;
            } else {
                targetUrl = "/work/newCheck/toIndex";
            }
            return ResponseData.success((String)targetUrl);
        }
        catch (Exception ex) {
            return ResponseData.fail((String)("\u8bf7\u6c42\u5904\u7406\u53d1\u751f\u5f02\u5e38\uff1a" + ex.getMessage()));
        }
    }

    private void settingValueForSearchVo(PhcPhysicalCheckSearchVo searchVo) {
        Company company = UserUtils.getCurrentCompany();
        if (company != null) {
            searchVo.setCid(company.getId());
            searchVo.setUnifiedSocialCc(company.getUnifiedSocialCc());
            searchVo.setCompanyName(company.getName());
        }
    }

    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"addPersonalArchive"}, method={RequestMethod.POST})
    public ResponseData<String> addPersonalArchive(String staffIds) throws Exception {
        this.logger.info("\u6dfb\u52a0\u4e2a\u4eba\u6863\u6848");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        if (StringUtils.isNotEmpty((String)staffIds)) {
            List staffInfoIdList = StringUtils.parseToLongList((String)staffIds);
            this.liteArchiveFilePersonalService.addPersonalArchiveByCid(staffInfoIdList, cid, staffId, null);
            return ResponseData.success((String)"\u65b0\u589e\u6210\u529f");
        }
        return ResponseData.success((String)"\u65e0\u6570\u636e");
    }

    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"updatePersonalArchive"}, method={RequestMethod.POST})
    public ResponseData<String> updatePersonalArchive(Long archiveId) throws Exception {
        this.logger.info("\u66f4\u65b0\u4e2a\u4eba\u6863\u6848");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        this.liteArchiveFilePersonalService.updatePersionArchive(new LiteArchiveFilePersonal().setId(archiveId).setUpdateBy(staffId).setUpdateDate(new Date()));
        try {
            this.reformItemBasicService.changeStatusByCidAndGenerationSource(cid, ReformGenerationSourceEnum.ARCHIVES.getValue(), Byte.valueOf((byte)3), staffId, null);
        }
        catch (Exception e) {
            this.logger.info("\u6863\u6848\u81ea\u52a8\u9a8c\u6536\u5931\u8d25\uff0c\u62a5\u9519\u65b9\u6cd5\uff1acn.smarthse.web.controller.litearchive.LiteArchivePersonalController.updatePersonalArchive");
            e.printStackTrace();
        }
        return ResponseData.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @Log(title="\u4e2a\u4eba\u6863\u6848\u5220\u9664", type=22)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"delPersonalDoc"}, method={RequestMethod.POST})
    public ResponseData<String> delPersonalDoc(String archiveIds) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData r = new ResponseData();
        if (archiveIds != null) {
            List arcs = StringUtils.parseToLongList((String)archiveIds);
            for (Long id : arcs) {
                LiteArchiveFilePersonal arc = new LiteArchiveFilePersonal();
                arc.setId(id);
                this.liteArchiveFilePersonalService.delete((Object)arc, staffid);
            }
        } else {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u53c2\u6570\u9519\u8bef");
            return r;
        }
        HashMap<CallSite, String> params = new HashMap<CallSite, String>();
        params.put((CallSite)((Object)(ComplianceCodeEnum.CODE14.getCode() + ":archiveTypeStr")), "6");
        this.refreshService.addBusinessDataUpdateMsg(cid, params, new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE14});
        return r;
    }

    @Log(title="\u4e2a\u4eba\u6863\u6848\u6279\u91cf\u66f4\u65b0", type=21)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"updatePersonalDoc"}, method={RequestMethod.POST})
    public ResponseData<String> updatePersonalDoc(String archiveIds) {
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData r = new ResponseData();
        if (!StringUtils.isNotEmpty((String)archiveIds)) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u53c2\u6570\u9519\u8bef");
            return r;
        }
        this.liteArchiveFilePersonalService.updatePersonalArchive(archiveIds, staffid);
        return r;
    }

    @Log(title="\u4e2a\u4eba\u6863\u6848\u6279\u91cf\u767b\u8bb0", type=21)
    @ResponseBody
    @PostMapping(value={"/batchUpdatePersonalRegister"})
    public ResponseData<String> batchUpdatePersonalRegister(String archiveIds, String storageLocation) {
        Long operateId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        if (StringUtils.isEmpty((CharSequence)archiveIds)) {
            return ResponseData.fail((String)"\u672a\u52fe\u9009\u4eba\u5458");
        }
        if (StringUtils.isEmpty((CharSequence)storageLocation)) {
            return ResponseData.fail((String)"\u5b58\u653e\u4f4d\u5b50\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Integer i = this.liteArchiveFilePersonalService.batchUpdatePersonalRegister(StringUtils.parseToLongList((String)archiveIds), cid, storageLocation, operateId, null);
        HashMap<CallSite, String> params = new HashMap<CallSite, String>();
        params.put((CallSite)((Object)(ComplianceCodeEnum.CODE14.getCode() + ":archiveTypeStr")), "6");
        this.refreshService.addBusinessDataUpdateMsg(cid, params, new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE14});
        return ResponseData.success((String)"\u6210\u529f");
    }

    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"fileUpPersonal"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_fileUp(Long id, Long[] fileId2) {
        this.logger.info("ajax-\u5236\u5ea6\u9884\u6848\u300b\u7ba1\u7406\u5236\u5ea6\u300b\u4e0a\u4f20\u9644\u4ef6");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData r = new ResponseData();
        if (id == null || fileId2 == null) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u53c2\u6570\u9519\u8bef");
            return r;
        }
        Boolean bl = this.liteArchiveFilePersonalService.addFile(id, fileId2, cid, staffid, false);
        return r;
    }

    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"fileUpPersonalNow"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_fileUpNow(Long id, Long[] fileId2) {
        this.logger.info("ajax-\u5236\u5ea6\u9884\u6848\u300b\u7ba1\u7406\u5236\u5ea6\u300b\u4e0a\u4f20\u9644\u4ef6");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData r = new ResponseData();
        if (id == null || fileId2 == null) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u53c2\u6570\u9519\u8bef");
            return r;
        }
        Boolean bl = this.liteArchiveFilePersonalService.addFile(id, fileId2, cid, staffid, true);
        return r;
    }

    private void addHarmWorkStaffToArchive(Long cid, Long staffId) throws Exception {
        List staffs = this.staffInfoService.getHarmWorkStaffInfosNotInArchive(cid);
        for (HarmWorkStaffInfoVo staff : staffs) {
            LiteArchiveFilePersonal arc = new LiteArchiveFilePersonal();
            arc.setCid(cid);
            arc.setStaffId(staff.getStaffId());
            arc.setStaffName(staff.getRealName());
            arc.setCreateBy(staffId);
            this.liteArchiveFilePersonalService.addPersionArchive(arc);
        }
    }

    @Log(title="\u4e2a\u4eba\u6863\u6848\u5220\u9664\u9644\u4ef6", type=22)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"delPersonalfile"}, method={RequestMethod.POST})
    public ResponseData<String> delPersonalfile(Long id, Long fileId) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData r = new ResponseData();
        if (id == null || fileId == null) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u53c2\u6570\u9519\u8bef");
            return r;
        }
        Boolean bl = this.liteArchiveFilePersonalService.delFile(id, fileId, cid, staffid);
        return r;
    }

    private String generatorPersonalArchive(Long staffId, Long cid) throws Exception {
        Map dataMap = this.liteArchiveFilePersonalService.getPersonalDocMap(cid, staffId);
        String docNo = this.businessNoService.getDocNo(cid, "doc6", null);
        dataMap.put(PersonalHarmFactorArchiveDataMapKeyEnum.docNo.name(), docNo);
        String targetFileNameFormat = FilesTypeEnum.phc.getTargetFilenameFormat();
        String[] targetDirs = FilesTypeEnum.phc.getDirs();
        StaffDocInfoVo staffVo = (StaffDocInfoVo)dataMap.get(PersonalHarmFactorArchiveDataMapKeyEnum.staffInfo.name());
        String destFileDir = String.format("\u52b3\u52a8\u8005\u4e2a\u4eba\u804c\u4e1a\u5065\u5eb7\u76d1\u62a4\u6863\u6848\uff08%s%s\uff09", staffVo.getRealName() == null ? "" : staffVo.getRealName(), staffVo.getDocNumber() == null ? "" : staffVo.getDocNumber());
        String name = (staffVo.getRealName() == null ? "" : staffVo.getRealName()) + (staffVo.getDocNumber() == null ? "" : staffVo.getDocNumber());
        String destFileName = "\u52b3\u52a8\u8005\u4e2a\u4eba\u804c\u4e1a\u5065\u5eb7\u76d1\u62a4\u6863\u6848(" + staffVo.getRealName() + ").doc";
        String datadir = AppConfigHolder.getConfig("ossclient.ossdir");
        String ossPath = cid + "/archive";
        String targetDir = datadir + "/" + ossPath;
        String destFilePath = targetDir + "/" + destFileDir + "/";
        dataMap.put("archive_doc__filename", destFileDir);
        File file = Java2WordGeneratorTemp.createDoc((Map)dataMap, (String)"doc6phc/phcFile.ftl", (String)(destFilePath + destFileName));
        SysFileModel sysFile = this.uploadFile(file, ossPath, "\u52b3\u52a8\u8005\u4e2a\u4eba\u804c\u4e1a\u5065\u5eb7\u76d1\u62a4\u6863\u6848\uff08" + staffVo.getRealName() + ").doc", "doc");
        String fileIds = sysFile.getId().toString() + ",";
        List testProveBookHistory = (List)dataMap.get(PersonalHarmFactorArchiveDataMapKeyEnum.testProveBookHistory.name());
        if (testProveBookHistory != null) {
            for (Doc6Table4_2 d : testProveBookHistory) {
                if (d.getCerts() == null) continue;
                for (SysFileModel sf : d.getCerts()) {
                    fileIds = fileIds + sf.getId() + ",";
                }
            }
        }
        return fileIds;
    }

    private SysFileModel uploadFile(File obj, String ossPath, String fileName, String ext) throws IOException {
        SysFileModel file = new SysFileModel();
        Long cid = UserUtils.getLoginStaffCompanyId();
        String oss = this.ossClientBean.OSSPutObject(String.valueOf(UUID.randomUUID()) + ".doc", obj, ossPath, fileName, "" + FileUtils.checksumCRC32((File)obj));
        file.setFileName(fileName);
        file.setCid(cid);
        file.setResource(Integer.valueOf(FileResourceEnum.companyHealth_07.getValue()));
        file.setFileSize("" + FileUtils.sizeOf((File)obj));
        file.setFileExt(ext);
        file.setFileHash("" + FileUtils.checksumCRC32((File)obj));
        file.setOssUrl(oss);
        file.setDescription("\u6863\u6848\u6587\u4ef6");
        file = this.sysFileProvideService.addSysFile(file, Long.valueOf(0L));
        return file;
    }

    @RequestMapping(value={"/imporCheckResultData"})
    @ResponseBody
    public ResponseData<String> imporCheckResultData(Long fileId, Integer year) {
        ResponseData res = new ResponseData();
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        String ossfile = SysFileUtil.getContextPathFileUrlByfid(fileId);
        List importData = this.liteArchiveFilePersonalService.getCheckResultData(ossfile, loginStaffId, cid);
        if (importData == null || importData.size() < 1) {
            res.setResult((Object)"\u4e0a\u4f20\u7684\u6587\u4ef6\u4e2d\u6ca1\u6709\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
            res.setState(ResponseStateEnum.warning);
            return res;
        }
        ArrayList<String> errorList = new ArrayList<String>();
        for (CheckResultImportVo vo : importData) {
            if (vo.getDataState().byteValue() != StaffInfoImportStateEnum.error.getValue()) continue;
            errorList.add(vo.getErrorReason());
        }
        if (errorList != null && errorList.size() > 0) {
            res.setResult((Object)((Object)errorList).toString());
            res.setState(ResponseStateEnum.warning);
            return res;
        }
        try {
            this.liteArchiveFilePersonalService.importCheckResultData(importData, year, cid, loginStaffId, fileId);
            res.setResult((Object)"\u5bfc\u5165\u6210\u529f");
            res.setState(ResponseStateEnum.success);
        }
        catch (Exception e) {
            res.setResult((Object)("\u5bfc\u5165\u5931\u8d25" + String.valueOf(e)));
            res.setState(ResponseStateEnum.fail);
        }
        return res;
    }

    @ResponseBody
    @RequestMapping(value={"exportCheckResult"}, method={RequestMethod.POST})
    public void exportWorkRoleInfo(HttpServletResponse response) throws Exception {
        Long cid = UserUtils.getLoginStaffCompanyId();
        List list = this.liteArchiveFilePersonalService.getFilePersonalList(cid);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u5de5\u4f5c\u573a\u6240\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u68c0\u6d4b\u7ed3\u679c\u5bfc\u5165" + dateFormat.format(new Date()) + ".xls";
        String[] colums = new String[]{"\u59d3\u540d|name", "\u6863\u6848\u53f7|docNo", "\u5c97\u4f4d|workName", "\u68c0\u6d4b\u65f6\u95f4|checkTime", "\u68c0\u6d4b\u673a\u6784|checkOrg", "\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u540d\u79f0|harmName", "\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u68c0\u6d4b\u7ed3\u679c|result", "\u4fdd\u62a4\u63aa\u65bd|protect", "\u5907\u6ce8|remark"};
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("GBK"), "ISO8859_1"));
        response.setContentType("application/octet-stream; charset=GBK");
        ExportExcel listexcel = new ExportExcel();
        listexcel.simpleExportAutoWidthAndHeight("\u5de5\u4f5c\u573a\u6240\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u68c0\u6d4b\u7ed3\u679c\u5bfc\u5165", colums, list, Integer.valueOf(20000), (OutputStream)response.getOutputStream());
    }

    @GetMapping(value={"/getStaffDocInfo"})
    @ResponseBody
    public ResponseData<StaffDocInfoVo> getStaffDocInfo(Long staffId) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        HashMap<Long, List<Long>> cidAndStaffIdListMap = new HashMap<Long, List<Long>>();
        cidAndStaffIdListMap.put(cid, Collections.singletonList(staffId));
        Map map = this.staffInfoService.getStaffDocInfoVoMap(cidAndStaffIdListMap);
        Map docInfoVoMap = (Map)map.get(cid);
        if (docInfoVoMap != null && docInfoVoMap.get(staffId) != null) {
            StaffDocInfoVo vo = (StaffDocInfoVo)docInfoVoMap.get(staffId);
            if (vo.getFaceId() != null) {
                SysFileModel file = this.sysFileProvideService.getFileById(vo.getFaceId());
                vo.setFaceFile(file);
            }
            return ResponseData.success((Object)vo);
        }
        return ResponseData.fail((String)"\u6ca1\u627e\u5230\u6570\u636e");
    }

    @Log(title="\u4e2a\u4eba\u4fe1\u606f\u6587\u4ef6\u4e0b\u8f7d", type=25)
    @RequestMapping(value={"downloadStaffDocInfo"})
    public void downloadStaffDocInfo(Long staffId, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Long cid = UserUtils.getLoginStaffCompanyId();
        OutputStream os = null;
        InputStream inputStream = null;
        File file = null;
        try {
            int length;
            file = this.liteArchiveFilePersonalService.getStaffDocInfoFile(cid, staffId);
            ServletsUtil.setFileDownloadHeader((HttpServletResponse)response, (String)file.getName(), (HttpServletRequest)request);
            inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);
            os = response.getOutputStream();
            byte[] b = new byte[2048];
            while ((length = inputStream.read(b)) > 0) {
                os.write(b, 0, length);
            }
        }
        catch (Exception e) {
            this.logger.error("\u4e2a\u4eba\u4fe1\u606f\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38\uff1a", (Throwable)e);
            throw e;
        }
        finally {
            if (file != null) {
                file.delete();
            }
            if (inputStream != null) {
                inputStream.close();
            }
            if (os != null) {
                os.flush();
                os.close();
            }
        }
    }

    @GetMapping(value={"/handDirtyData"})
    @ResponseBody
    public ResponseData<String> handDirtyData(String cids) {
        return ResponseData.success((String)this.liteArchiveFilePersonalService.handDirtyData(cids));
    }
}

