/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.litearchive;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.IDCardUtil;
import cn.smarthse.common.util.ZipCompressorUtil;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.entity.litearchive.LiteArchive;
import cn.smarthse.modules.health.entity.litearchive.LiteArchiveFileItem;
import cn.smarthse.modules.health.entity.litearchive.LiteArchiveFileItemChild;
import cn.smarthse.modules.health.entity.litearchive.LiteArchiveFileName;
import cn.smarthse.modules.health.entity.work.certificate.CertificateFiles;
import cn.smarthse.modules.health.entity.work.check.vo.PhcDieaserUnprocessParam;
import cn.smarthse.modules.health.entity.work.check.vo.PhcOccupationalDiseaserParam;
import cn.smarthse.modules.health.entity.work.train.TrainPaperFile;
import cn.smarthse.modules.health.entity.work.train.TrainPlan;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.model.litearchive.ArchiveFileItemUpdateParam;
import cn.smarthse.modules.health.pojo.HealthCheckArchiveStaffGroup;
import cn.smarthse.modules.health.pojo.HealthCheckArchiveStaffInfo;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveFileItemChildService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveFileItemService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveFileNameService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveFilePersonalService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateStaffDetailService;
import cn.smarthse.modules.health.service.work.check.IPhcOccupationalDiseaserService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckDataResultService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.service.work.train.ITrainPaperFileService;
import cn.smarthse.modules.health.service.work.train.ITrainPlanService;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrgQualificationService;
import cn.smarthse.modules.health.thirdOrganization.util.StringUtil;
import cn.smarthse.util.common.StringUtils;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.DocUtil;
import cn.smarthse.web.util.SysFileUtil;
import cn.smarthse.web.util.UserUtils;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/liteArchive/itemChild"})
public class LiteArchiveFileItemChildController
extends ControllerSupport {
    @DubboReference
    private ILiteArchiveFileItemChildService liteArchiveFileItemChildService;
    @DubboReference
    private ILiteArchiveFileItemService archiveFileItemService;
    @DubboReference(timeout=5000000)
    private ISysFileProvideService sysFileProvideService;
    @DubboReference
    private ILiteArchiveFileNameService liteArchiveFileNameService;
    @DubboReference
    private IPhcPhysicalCheckService phcPhysicalCheckService;
    @DubboReference
    private ILiteArchiveFileItemService liteArchiveFileItemService;
    @DubboReference
    private IStaffInfoService staffInfoService;
    @DubboReference
    private IPhcOccupationalDiseaserService phcOccupationalDiseaserService;
    @DubboReference
    private IPhcPhysicalCheckDataResultService phcPhysicalCheckDataResultService;
    @DubboReference
    private ILiteArchiveService liteArchiveService;
    @DubboReference
    private ICertificateStaffDetailService certificateStaffDetailService;
    @DubboReference
    private ITrainPlanService trainPlanService;
    @DubboReference
    private ITrainPaperFileService trainPaperFileService;
    @DubboReference
    private IThirdOrgQualificationService thirdOrgQualificationService;
    @DubboReference
    private ILiteArchiveFilePersonalService liteArchiveFilePersonalService;
    @DubboReference
    private IReformItemBasicService reformItemBasicService;

    @Log(title="\u804c\u4e1a\u536b\u751f\u6863\u6848\u5217\u8868", type=2)
    @RequestMapping(value={"itemChildListPage"})
    public String liteArchiveListPage(ModelMap m, Long itemId, Long fileNameId, Long liteArchiveId) {
        m.put((Object)"fileNameId", (Object)fileNameId);
        m.put((Object)"liteArchiveId", (Object)liteArchiveId);
        if (itemId == null) {
            Long loginStaffId = UserUtils.getLoginStaffId();
            ArchiveFileItemUpdateParam param = new ArchiveFileItemUpdateParam();
            param.setFileNameId(fileNameId);
            param.setArchiveId(liteArchiveId);
            param.setStaffId(loginStaffId);
            itemId = this.archiveFileItemService.updateArchiveFiles(param);
        }
        m.put((Object)"itemId", (Object)itemId);
        return "views/keyFactorManagement/liteArchive/itemChildListPage";
    }

    @RequestMapping(value={"/childrenData"})
    @ResponseBody
    public JqGridData<LiteArchiveFileItemChild> childrenData(Long itemId, JqGridParam jqGridParam) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        this.liteArchiveFileItemChildService.addLatelyYearData(itemId, staffid, cid);
        PageInfo pageInfo = this.liteArchiveFileItemChildService.queryDetail(jqGridParam, itemId);
        return new JqGridData(pageInfo, jqGridParam);
    }

    @RequestMapping(value={"/updateArchiveFiles"})
    @ResponseBody
    public ResponseData<Long> updateArchiveFiles(LiteArchiveFileItemChild child) {
        LiteArchive db;
        Long loginStaffId = UserUtils.getLoginStaffId();
        child.setUploadStaffId("" + loginStaffId);
        child.setUpdateBy(loginStaffId);
        this.liteArchiveFileItemChildService.updateArchiveFiles(child);
        ResponseData data = new ResponseData();
        LiteArchiveFileItemChild cdb = (LiteArchiveFileItemChild)this.liteArchiveFileItemChildService.getById(child.getId());
        LiteArchiveFileItem liteArchiveFileItem = (LiteArchiveFileItem)this.liteArchiveFileItemService.getById(cdb.getItemId());
        if (cdb.getYear().equals(DateUtils.getYear()) && (Long.valueOf(602L).equals(liteArchiveFileItem.getFileNameId()) || Long.valueOf(503L).equals(liteArchiveFileItem.getFileNameId()))) {
            liteArchiveFileItem.setFileIds(cdb.getFileIds());
            this.liteArchiveFileItemService.update((Object)liteArchiveFileItem, loginStaffId);
        }
        if (liteArchiveFileItem.getLiteArchiveId() != null && (db = (LiteArchive)this.liteArchiveService.getById(liteArchiveFileItem.getLiteArchiveId())) != null) {
            if (!Integer.valueOf(5).equals(db.getArchiveType())) {
                return data;
            }
            HashMap<Long, Boolean> hasFileMap = new HashMap<Long, Boolean>();
            List items = this.liteArchiveFileItemService.getDoc5ListByLiteArchiveId(liteArchiveFileItem.getLiteArchiveId(), Integer.valueOf(DateUtils.getThisYear()));
            for (LiteArchiveFileItem item : items) {
                hasFileMap.put(item.getId(), false);
                String fileIds = item.getFileIds();
                if (Long.valueOf(501L).equals(item.getFileNameId())) {
                    LiteArchiveFileItemChild child501 = this.liteArchiveFileItemChildService.getFileItemChildrenByItemIdAndYear(item.getId(), Integer.valueOf(DateUtils.getThisYear()), loginStaffId);
                    fileIds = child501.getFileIds();
                } else if (Long.valueOf(503L).equals(item.getFileNameId())) {
                    LiteArchiveFileItemChild child503 = this.liteArchiveFileItemChildService.getFileItemChildrenByItemIdAndYear(item.getId(), Integer.valueOf(DateUtils.getThisYear()), loginStaffId);
                    fileIds = child503.getFileIds();
                }
                if (!StringUtils.isNotEmpty((String)fileIds) || Arrays.stream(fileIds.split(",")).filter(s -> StringUtils.isNotEmpty((String)s) && !"null".equals(s.toLowerCase())).collect(Collectors.toList()).size() <= 0) continue;
                hasFileMap.put(item.getId(), true);
            }
            LiteArchive liteArchive = new LiteArchive();
            liteArchive.setId(liteArchiveFileItem.getLiteArchiveId());
            liteArchive.setStatus(Integer.valueOf(1));
            if (hasFileMap.values().contains(true)) {
                if (hasFileMap.values().contains(false)) {
                    liteArchive.setStatus(Integer.valueOf(2));
                } else {
                    liteArchive.setStatus(Integer.valueOf(3));
                }
            }
            this.liteArchiveService.update((Object)liteArchive, loginStaffId);
        }
        return data;
    }

    @RequestMapping(value={"fileUp"}, method={RequestMethod.GET})
    public String fileUp(Long id, Model model) {
        model.addAttribute("id", (Object)id);
        return "views/keyFactorManagement/liteArchive/dialog_fileUp";
    }

    @ResponseBody
    @RequestMapping(value={"delfile"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_delFile(Long id, Long fileId) {
        LiteArchiveFileItem liteArchiveFileItem;
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData r = new ResponseData();
        this.liteArchiveFileItemChildService.deleteArchiveFiles(id, fileId, staffid);
        LiteArchiveFileItemChild child = (LiteArchiveFileItemChild)this.liteArchiveFileItemChildService.getById(id);
        if (child != null && child.getItemId() != null && (liteArchiveFileItem = (LiteArchiveFileItem)this.liteArchiveFileItemService.getById(child.getItemId())) != null) {
            LiteArchive db;
            liteArchiveFileItem.setUploadDate(new Date());
            liteArchiveFileItem.setUploadStaffId(staffid);
            if (child.getYear().equals(DateUtils.getYear()) && (Long.valueOf(602L).equals(liteArchiveFileItem.getFileNameId()) || Long.valueOf(503L).equals(liteArchiveFileItem.getFileNameId()))) {
                liteArchiveFileItem.setFileIds(child.getFileIds());
            }
            this.liteArchiveFileItemService.update((Object)liteArchiveFileItem, staffid);
            if (liteArchiveFileItem.getLiteArchiveId() != null && (db = (LiteArchive)this.liteArchiveService.getById(liteArchiveFileItem.getLiteArchiveId())) != null) {
                if (!Integer.valueOf(5).equals(db.getArchiveType())) {
                    return r;
                }
                HashMap<Long, Boolean> hasFileMap = new HashMap<Long, Boolean>();
                List items = this.liteArchiveFileItemService.getDoc5ListByLiteArchiveId(liteArchiveFileItem.getLiteArchiveId(), Integer.valueOf(DateUtils.getThisYear()));
                for (LiteArchiveFileItem item : items) {
                    hasFileMap.put(item.getId(), false);
                    String fileIds = item.getFileIds();
                    if (Long.valueOf(501L).equals(item.getFileNameId())) {
                        LiteArchiveFileItemChild child501 = this.liteArchiveFileItemChildService.getFileItemChildrenByItemIdAndYear(item.getId(), Integer.valueOf(DateUtils.getThisYear()), staffid);
                        fileIds = child501.getFileIds();
                    } else if (Long.valueOf(503L).equals(item.getFileNameId())) {
                        LiteArchiveFileItemChild child503 = this.liteArchiveFileItemChildService.getFileItemChildrenByItemIdAndYear(item.getId(), Integer.valueOf(DateUtils.getThisYear()), staffid);
                        fileIds = child503.getFileIds();
                    }
                    if (!StringUtils.isNotEmpty((String)fileIds) || Arrays.stream(fileIds.split(",")).filter(s -> StringUtils.isNotEmpty((String)s) && !"null".equals(s.toLowerCase())).collect(Collectors.toList()).size() <= 0) continue;
                    hasFileMap.put(item.getId(), true);
                }
                LiteArchive liteArchive = new LiteArchive();
                liteArchive.setId(liteArchiveFileItem.getLiteArchiveId());
                liteArchive.setStatus(Integer.valueOf(1));
                if (hasFileMap.values().contains(true)) {
                    if (hasFileMap.values().contains(false)) {
                        liteArchive.setStatus(Integer.valueOf(2));
                    } else {
                        liteArchive.setStatus(Integer.valueOf(3));
                    }
                }
                this.liteArchiveService.update((Object)liteArchive, staffid);
            }
        }
        return r;
    }

    @ResponseBody
    @RequestMapping(value={"childFilesDownload"})
    public void childFilesDownload(Model model, Long id, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        LiteArchiveFileItemChild child = (LiteArchiveFileItemChild)this.liteArchiveFileItemChildService.getById(id);
        child.getItemId();
        LiteArchiveFileItem fileItem = (LiteArchiveFileItem)this.archiveFileItemService.getById(child.getItemId());
        String fileName = ((LiteArchiveFileName)this.liteArchiveFileNameService.getById(fileItem.getFileNameId())).getFileName();
        fileName = URLEncoder.encode(String.format(fileName + dateFormat.format(new Date()) + ".zip", LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE)), "UTF-8").replaceAll("\\+", "%20");
        response.setContentType("application/x-download");
        Object fileIds = "0";
        if (StringUtils.isNotEmpty((String)child.getFileIds())) {
            fileIds = (String)fileIds + "," + child.getFileIds();
        }
        if (StringUtils.isNotEmpty((String)child.getReferFileIds())) {
            fileIds = (String)fileIds + "," + child.getReferFileIds();
        }
        if (StringUtils.isNotEmpty((String)(fileIds = Arrays.stream(((String)fileIds).split(",")).filter(s -> !"0".equals(s)).distinct().collect(Collectors.joining(","))))) {
            List sfiles = this.sysFileProvideService.getListByIds((String)fileIds);
            ArrayList<File> files = new ArrayList<File>();
            for (SysFileModel sfm : sfiles) {
                File file = SysFileUtil.getFileByfid((long)sfm.getId(), "liteDoc");
                files.add(file);
            }
            if (files.size() == 1) {
                String name = URLEncoder.encode(String.format(((File)files.get(0)).getName(), LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE)), "UTF-8").replaceAll("\\+", "%20");
                response.setHeader("Content-disposition", "attachment; filename=" + name);
                FileCopyUtils.copy((InputStream)new FileInputStream((File)files.get(0)), (OutputStream)response.getOutputStream());
            } else {
                response.setHeader("Content-disposition", "attachment; filename=" + fileName);
                ZipCompressorUtil.getDownZipFile(files, (String)"", (OutputStream)response.getOutputStream());
            }
        }
    }

    @ResponseBody
    @RequestMapping(value={"itemsFilesDownload"})
    public void itemsFilesDownload(Model model, Long itemId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (itemId == null) {
            return;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        LiteArchiveFileItem fileItem = (LiteArchiveFileItem)this.archiveFileItemService.getById(itemId);
        String fileName = ((LiteArchiveFileName)this.liteArchiveFileNameService.getById(fileItem.getFileNameId())).getFileName();
        fileName = URLEncoder.encode(String.format(fileName + dateFormat.format(new Date()) + ".zip", LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE)), "UTF-8").replaceAll("\\+", "%20");
        response.setContentType("application/x-download");
        ResponseData r = new ResponseData();
        File doc503File = null;
        if (Long.valueOf(507L).equals(fileItem.getFileNameId())) {
            String filePath = request.getSession().getServletContext().getRealPath("/") + "template" + File.separator + "liteDoc5" + File.separator + "\u804c\u4e1a\u75c5\u5371\u5bb3\u4e8b\u6545\u62a5\u544a\u4e0e\u5904\u7406\u8bb0\u5f55\u8868.docx";
            response.setHeader("Content-disposition", "attachment; filename=" + new String("\u804c\u4e1a\u75c5\u5371\u5bb3\u4e8b\u6545\u62a5\u544a\u4e0e\u5904\u7406\u8bb0\u5f55\u8868.docx".getBytes("gbk"), "iso8859-1"));
            FileCopyUtils.copy((InputStream)new FileInputStream(new File(filePath)), (OutputStream)response.getOutputStream());
            return;
        }
        if (Long.valueOf(301L).equals(fileItem.getFileNameId())) {
            String filePath = request.getSession().getServletContext().getRealPath("/") + "template" + File.separator + "liteDoc3" + File.separator + "\u804c\u4e1a\u536b\u751f\u57f9\u8bad\u8ba1\u5212.docx";
            response.setHeader("Content-disposition", "attachment; filename=" + new String("\u804c\u4e1a\u536b\u751f\u57f9\u8bad\u8ba1\u5212.docx".getBytes("gbk"), "iso8859-1"));
            FileCopyUtils.copy((InputStream)new FileInputStream(new File(filePath)), (OutputStream)response.getOutputStream());
            return;
        }
        if (Long.valueOf(303L).equals(fileItem.getFileNameId())) {
            String filePath = request.getSession().getServletContext().getRealPath("/") + "template" + File.separator + "liteDoc3" + File.separator + "\u5e74\u5ea6\u804c\u4e1a\u536b\u751f\u5ba3\u4f20\u57f9\u8bad\u4e00\u89c8\u8868.docx";
            response.setHeader("Content-disposition", "attachment; filename=" + new String("\u5e74\u5ea6\u804c\u4e1a\u536b\u751f\u5ba3\u4f20\u57f9\u8bad\u4e00\u89c8\u8868.docx".getBytes("gbk"), "iso8859-1"));
            FileCopyUtils.copy((InputStream)new FileInputStream(new File(filePath)), (OutputStream)response.getOutputStream());
            return;
        }
        if (Long.valueOf(304L).equals(fileItem.getFileNameId())) {
            String filePath = request.getSession().getServletContext().getRealPath("/") + "template" + File.separator + "liteDoc3" + File.separator + "\u5e74\u5ea6\u804c\u4e1a\u536b\u751f\u57f9\u8bad\u5de5\u4f5c\u603b\u7ed3.docx";
            response.setHeader("Content-disposition", "attachment; filename=" + new String("\u5e74\u5ea6\u804c\u4e1a\u536b\u751f\u57f9\u8bad\u5de5\u4f5c\u603b\u7ed3.docx".getBytes("gbk"), "iso8859-1"));
            FileCopyUtils.copy((InputStream)new FileInputStream(new File(filePath)), (OutputStream)response.getOutputStream());
            return;
        }
        Object fileIds = "0";
        if (Long.valueOf(501L).equals(fileItem.getFileNameId())) {
            Long cid = UserUtils.getLoginStaffCompanyId();
            int year = LocalDateTime.now().getYear();
            List thirdOrgIds = this.phcPhysicalCheckService.getThirdOrgIdByYear(cid, year);
            String qualificationFileIds = this.thirdOrgQualificationService.getHealthCheckQualificationFileIdsByOrgIds(thirdOrgIds);
            fileIds = (String)fileIds + "," + qualificationFileIds;
        } else if (StringUtils.isNotEmpty((String)fileItem.getReferFileIds())) {
            fileIds = (String)fileIds + "," + fileItem.getReferFileIds();
        }
        fileIds = Arrays.stream(((String)fileIds).split(",")).filter(s -> !"0".equals(s)).distinct().collect(Collectors.joining(","));
        if (StringUtils.isNotEmpty((String)fileIds)) {
            List sfiles = this.sysFileProvideService.getListByIds((String)fileIds);
            ArrayList<File> files = new ArrayList<File>();
            for (SysFileModel sfm : sfiles) {
                File file = SysFileUtil.getFileByfid((long)sfm.getId(), "liteDoc");
                files.add(file);
            }
            if (files.size() == 1) {
                String name = URLEncoder.encode(String.format(((File)files.get(0)).getName(), LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE)), "UTF-8").replaceAll("\\+", "%20");
                response.setHeader("Content-disposition", "attachment; filename=" + name);
                FileCopyUtils.copy((InputStream)new FileInputStream((File)files.get(0)), (OutputStream)response.getOutputStream());
            } else {
                response.setHeader("Content-disposition", "attachment; filename=" + fileName);
                ZipCompressorUtil.getDownZipFile(files, (String)"", (OutputStream)response.getOutputStream());
            }
        } else if (fileItem.getFileNameId() != null && (fileItem.getFileNameId() >= 301L && fileItem.getFileNameId() <= 304L || fileItem.getFileNameId() >= 501L && fileItem.getFileNameId() <= 507L)) {
            String noDataFileName = "";
            String liteDir = "";
            if (fileItem.getFileNameId() >= 301L && fileItem.getFileNameId() <= 304L) {
                liteDir = "liteDoc3";
                if (Long.valueOf(301L).equals(fileItem.getFileNameId())) {
                    noDataFileName = "\u52b3\u52a8\u8005\u804c\u4e1a\u536b\u751f\u57f9\u8bad\u8ba1\u5212.docx";
                }
                if (Long.valueOf(303L).equals(fileItem.getFileNameId())) {
                    noDataFileName = "\u5e74\u5ea6\u804c\u4e1a\u536b\u751f\u5ba3\u4f20\u57f9\u8bad\u4e00\u89c8\u8868.docx";
                }
                if (Long.valueOf(304L).equals(fileItem.getFileNameId())) {
                    noDataFileName = "\u5e74\u5ea6\u804c\u4e1a\u536b\u751f\u57f9\u8bad\u5de5\u4f5c\u603b\u7ed3.docx";
                }
            } else if (fileItem.getFileNameId() >= 501L && fileItem.getFileNameId() <= 507L) {
                liteDir = "liteDoc5";
                if (Long.valueOf(502L).equals(fileItem.getFileNameId())) {
                    noDataFileName = "\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5\u7ed3\u679c\u6c47\u603b\u8868.docx";
                } else if (Long.valueOf(503L).equals(fileItem.getFileNameId())) {
                    List list = this.liteArchiveFilePersonalService.getArchive503BaseInfoByCid(UserUtils.getLoginStaffCompanyId());
                    DocUtil docUtil = new DocUtil();
                    HashMap<String, List> dataMap = new HashMap<String, List>();
                    dataMap.put("dataList", list);
                    doc503File = docUtil.createDocFile(dataMap, "\u804c\u4e1a\u5065\u5eb7\u76d1\u62a4\u6863\u6848\u6c47\u603b\u8868.ftl", "/templates/liteDoc5/", "\u804c\u4e1a\u5065\u5eb7\u76d1\u62a4\u6863\u6848\u6c47\u603b\u8868" + dateFormat.format(new Date()));
                    noDataFileName = "\u804c\u4e1a\u5065\u5eb7\u76d1\u62a4\u6863\u6848\u6c47\u603b\u8868.docx";
                } else if (Long.valueOf(504L).equals(fileItem.getFileNameId())) {
                    noDataFileName = "\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5\u5f02\u5e38\u7ed3\u679c\u767b\u8bb0\u8868.docx";
                } else if (Long.valueOf(505L).equals(fileItem.getFileNameId())) {
                    noDataFileName = "\u7591\u4f3c\u804c\u4e1a\u75c5\u60a3\u8005\u4e00\u89c8\u8868.docx";
                } else if (Long.valueOf(506L).equals(fileItem.getFileNameId())) {
                    noDataFileName = "\u804c\u4e1a\u75c5\u548c\u7591\u4f3c\u804c\u4e1a\u75c5\u4eba\u62a5\u544a.docx";
                }
            }
            String filePath = request.getSession().getServletContext().getRealPath("/") + "template" + File.separator + liteDir + File.separator + noDataFileName;
            response.setHeader("Content-disposition", "attachment; filename=" + new String(noDataFileName.getBytes("gbk"), "iso8859-1"));
            if (Long.valueOf(503L).equals(fileItem.getFileNameId())) {
                FileCopyUtils.copy((InputStream)new FileInputStream(doc503File), (OutputStream)response.getOutputStream());
            } else {
                FileCopyUtils.copy((InputStream)new FileInputStream(new File(filePath)), (OutputStream)response.getOutputStream());
            }
        }
    }

    @ResponseBody
    @RequestMapping(value={"itemsFilesTemplateDownload"})
    public void itemsFilesTemplateDownload(Model model, Long fileNameId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType("application/x-download");
        this.logger.info("\u8c03\u7528\u4e0b\u8f7d");
        ResponseData r = new ResponseData();
        if (Long.valueOf(507L).equals(fileNameId)) {
            String filePath = request.getSession().getServletContext().getRealPath("/") + "template" + File.separator + "liteDoc5" + File.separator + "\u804c\u4e1a\u75c5\u5371\u5bb3\u4e8b\u6545\u62a5\u544a\u4e0e\u5904\u7406\u8bb0\u5f55\u8868.docx";
            response.setHeader("Content-disposition", "attachment; filename=" + new String("\u804c\u4e1a\u75c5\u5371\u5bb3\u4e8b\u6545\u62a5\u544a\u4e0e\u5904\u7406\u8bb0\u5f55\u8868.docx".getBytes("gbk"), "iso8859-1"));
            FileCopyUtils.copy((InputStream)new FileInputStream(new File(filePath)), (OutputStream)response.getOutputStream());
            return;
        }
        if (Long.valueOf(301L).equals(fileNameId)) {
            String filePath = request.getSession().getServletContext().getRealPath("/") + "template" + File.separator + "liteDoc3" + File.separator + "\u804c\u4e1a\u536b\u751f\u57f9\u8bad\u8ba1\u5212.docx";
            response.setHeader("Content-disposition", "attachment; filename=" + new String("\u804c\u4e1a\u536b\u751f\u57f9\u8bad\u8ba1\u5212.docx".getBytes("gbk"), "iso8859-1"));
            FileCopyUtils.copy((InputStream)new FileInputStream(new File(filePath)), (OutputStream)response.getOutputStream());
            return;
        }
        if (Long.valueOf(304L).equals(fileNameId)) {
            String filePath = request.getSession().getServletContext().getRealPath("/") + "template" + File.separator + "liteDoc3" + File.separator + "\u5e74\u5ea6\u804c\u4e1a\u536b\u751f\u57f9\u8bad\u5de5\u4f5c\u603b\u7ed3.docx";
            response.setHeader("Content-disposition", "attachment; filename=" + new String("\u5e74\u5ea6\u804c\u4e1a\u536b\u751f\u57f9\u8bad\u5de5\u4f5c\u603b\u7ed3.docx".getBytes("gbk"), "iso8859-1"));
            FileCopyUtils.copy((InputStream)new FileInputStream(new File(filePath)), (OutputStream)response.getOutputStream());
            return;
        }
        String noDataFileName = "";
        String liteDir = "";
        if (fileNameId >= 301L && fileNameId <= 304L) {
            liteDir = "liteDoc3";
            if (Long.valueOf(302L).equals(fileNameId)) {
                noDataFileName = "\u7528\u4eba\u5355\u4f4d\u8d1f\u8d23\u4eba\u3001\u7ba1\u7406\u4eba\u5458\u804c\u4e1a\u536b\u751f\u57f9\u8bad\u8bc1\u660e.docx";
            } else if (Long.valueOf(303L).equals(fileNameId)) {
                noDataFileName = "\u52b3\u52a8\u8005\u804c\u4e1a\u536b\u751f\u5ba3\u4f20\u57f9\u8bad\u5217\u8868.docx";
            }
        } else if (fileNameId >= 501L && fileNameId <= 507L) {
            liteDir = "liteDoc5";
            if (Long.valueOf(502L).equals(fileNameId)) {
                noDataFileName = "\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5\u7ed3\u679c\u6c47\u603b\u8868.docx";
            } else if (Long.valueOf(503L).equals(fileNameId)) {
                noDataFileName = "\u804c\u4e1a\u5065\u5eb7\u76d1\u62a4\u6863\u6848\u6c47\u603b\u8868.docx";
            } else if (Long.valueOf(504L).equals(fileNameId)) {
                noDataFileName = "\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5\u5f02\u5e38\u7ed3\u679c\u767b\u8bb0\u8868.docx";
            } else if (Long.valueOf(505L).equals(fileNameId)) {
                noDataFileName = "\u7591\u4f3c\u804c\u4e1a\u75c5\u60a3\u8005\u4e00\u89c8\u8868.docx";
            } else if (Long.valueOf(506L).equals(fileNameId)) {
                noDataFileName = "\u804c\u4e1a\u75c5\u548c\u7591\u4f3c\u804c\u4e1a\u75c5\u4eba\u62a5\u544a.docx";
            }
        }
        if (StringUtils.isNotEmpty((String)noDataFileName)) {
            String filePath = request.getSession().getServletContext().getRealPath("/") + "template" + File.separator + liteDir + File.separator + noDataFileName;
            response.setHeader("Content-disposition", "attachment; filename=" + new String(noDataFileName.getBytes("gbk"), "iso8859-1"));
            FileCopyUtils.copy((InputStream)new FileInputStream(new File(filePath)), (OutputStream)response.getOutputStream());
        }
    }

    @RequestMapping(value={"getDoc5_501"})
    @ResponseBody
    public ResponseData<String> getDoc5_501(HttpServletRequest request, HttpServletResponse response, Long childId) throws Exception {
        ResponseData r = new ResponseData();
        Long cid = UserUtils.getLoginStaffCompanyId();
        List fileIds = this.phcPhysicalCheckService.getInstitutionalQualificationFileIdsByCidAndYear(cid, Long.valueOf(DateUtils.getThisYear()));
        LiteArchiveFileItemChild child = new LiteArchiveFileItemChild();
        child.setId(childId);
        if (fileIds == null || fileIds.size() == 0) {
            child.setReferFileIds("");
        } else {
            child.setReferFileIds(fileIds.stream().map(s -> String.valueOf(s)).collect(Collectors.joining(",")));
        }
        Long staffid = UserUtils.getLoginStaffId();
        child.setUploadStaffId("" + staffid);
        child.setUpdateBy(staffid);
        this.liteArchiveFileItemChildService.updateArchiveFiles(child);
        r.setResult((Object)"true");
        return r;
    }

    @RequestMapping(value={"getDoc5_501_V314"})
    @ResponseBody
    public ResponseData<String> getDoc5_501_V314(HttpServletRequest request, HttpServletResponse response, Long itemId, Long fileNameId, Long liteArchiveId) throws Exception {
        ResponseData r = new ResponseData();
        Long loginStaffId = UserUtils.getLoginStaffId();
        if (itemId == null) {
            ArchiveFileItemUpdateParam param = new ArchiveFileItemUpdateParam();
            param.setFileNameId(fileNameId);
            param.setArchiveId(liteArchiveId);
            param.setStaffId(loginStaffId);
            itemId = this.archiveFileItemService.updateArchiveFiles(param);
        }
        Long cid = UserUtils.getLoginStaffCompanyId();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        DocUtil docUtil = new DocUtil();
        HashMap dataMap = new HashMap();
        List fileIds = this.phcPhysicalCheckService.getInstitutionalQualificationFileIdsByCidAndYear(cid, Long.valueOf(DateUtils.getThisYear()));
        LiteArchiveFileItem liteArchiveFileItem = new LiteArchiveFileItem();
        if (fileIds == null || fileIds.size() == 0) {
            liteArchiveFileItem.setReferFileIds("");
        } else {
            liteArchiveFileItem.setReferFileIds(fileIds.stream().map(s -> String.valueOf(s)).collect(Collectors.joining(",")));
        }
        liteArchiveFileItem.setId(itemId);
        liteArchiveFileItem.setUploadStaffId(loginStaffId);
        liteArchiveFileItem.setUploadDate(new Date());
        LiteArchiveFileItem oldData = (LiteArchiveFileItem)this.liteArchiveFileItemService.getById(itemId);
        liteArchiveFileItem.setFileIds(oldData.getFileIds());
        List<Object> oldRefileIds = new ArrayList();
        if (StringUtils.isNotEmpty((String)oldData.getReferFileIds())) {
            oldRefileIds = Arrays.stream(oldData.getReferFileIds().split(",")).collect(Collectors.toList());
        }
        if (oldRefileIds.size() > 0 && StringUtils.isNotEmpty((String)liteArchiveFileItem.getFileIds())) {
            for (String oldRfileId : oldRefileIds) {
                if (!oldData.getFileIds().contains(oldRfileId)) continue;
                liteArchiveFileItem.setFileIds(liteArchiveFileItem.getFileIds().replace(oldRfileId, ""));
            }
        }
        if (StringUtils.isNotEmpty((String)liteArchiveFileItem.getFileIds())) {
            liteArchiveFileItem.setFileIds(liteArchiveFileItem.getFileIds() + "," + liteArchiveFileItem.getReferFileIds());
        } else {
            liteArchiveFileItem.setFileIds(liteArchiveFileItem.getReferFileIds());
        }
        this.liteArchiveFileItemService.update((Object)liteArchiveFileItem, loginStaffId);
        r.setResult((Object)("" + fileNameId));
        return r;
    }

    @RequestMapping(value={"getDoc5_502"})
    @ResponseBody
    public ResponseData<String> getDoc5_502(HttpServletRequest request, HttpServletResponse response, Long itemId, Long fileNameId, Long liteArchiveId) throws Exception {
        ResponseData r = new ResponseData();
        Long loginStaffId = UserUtils.getLoginStaffId();
        if (itemId == null) {
            ArchiveFileItemUpdateParam param = new ArchiveFileItemUpdateParam();
            param.setFileNameId(fileNameId);
            param.setArchiveId(liteArchiveId);
            param.setStaffId(loginStaffId);
            itemId = this.archiveFileItemService.updateArchiveFiles(param);
        }
        Long cid = UserUtils.getLoginStaffCompanyId();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        DocUtil docUtil = new DocUtil();
        HashMap<String, List> dataMap = new HashMap<String, List>();
        List list = this.phcPhysicalCheckService.queryHealthArchiveVo(cid, null);
        if (list == null || list.size() == 0) {
            return r;
        }
        dataMap.put("dataList", list);
        File file = docUtil.createDocFile(dataMap, "\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5\u7ed3\u679c\u6c47\u603b\u8868.ftl", "/templates/liteDoc5/", "\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5\u7ed3\u679c\u6c47\u603b\u8868" + dateFormat.format(new Date()));
        SysFileModel sysFile = this.uploadOss(file, cid + "/archive/" + itemId, "\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5\u7ed3\u679c\u6c47\u603b\u8868" + dateFormat.format(new Date()) + ".doc", "doc");
        LiteArchiveFileItem liteArchiveFileItem = new LiteArchiveFileItem();
        liteArchiveFileItem.setId(itemId);
        liteArchiveFileItem.setReferFileIds("" + sysFile.getId());
        liteArchiveFileItem.setUploadStaffId(loginStaffId);
        liteArchiveFileItem.setUploadDate(new Date());
        LiteArchiveFileItem oldData = (LiteArchiveFileItem)this.liteArchiveFileItemService.getById(itemId);
        liteArchiveFileItem.setFileIds(oldData.getFileIds());
        List<Object> oldRefileIds = new ArrayList();
        if (StringUtils.isNotEmpty((String)oldData.getReferFileIds())) {
            oldRefileIds = Arrays.stream(oldData.getReferFileIds().split(",")).collect(Collectors.toList());
        }
        if (oldRefileIds.size() > 0 && StringUtils.isNotEmpty((String)liteArchiveFileItem.getFileIds())) {
            for (String oldRfileId : oldRefileIds) {
                if (!oldData.getFileIds().contains(oldRfileId)) continue;
                liteArchiveFileItem.setFileIds(liteArchiveFileItem.getFileIds().replace(oldRfileId, ""));
            }
        }
        if (StringUtils.isNotEmpty((String)liteArchiveFileItem.getFileIds())) {
            liteArchiveFileItem.setFileIds(liteArchiveFileItem.getFileIds() + "," + liteArchiveFileItem.getReferFileIds());
        } else {
            liteArchiveFileItem.setFileIds(liteArchiveFileItem.getReferFileIds());
        }
        this.liteArchiveFileItemService.update((Object)liteArchiveFileItem, loginStaffId);
        r.setResult((Object)("" + fileNameId));
        try {
            this.reformItemBasicService.changeStatusByCidAndGenerationSource(cid, ReformGenerationSourceEnum.ARCHIVES.getValue(), Byte.valueOf((byte)3), loginStaffId, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("\u6863\u6848\u81ea\u52a8\u9a8c\u6536\u5931\u8d25\uff0c\u62a5\u9519\u65b9\u6cd5\uff1acn.smarthse.web.controller.litearchive.LiteArchiveFileItemChildController.getDoc5_502");
        }
        return r;
    }

    @RequestMapping(value={"getDoc5_503"})
    @ResponseBody
    public ResponseData<String> getDoc5_503(HttpServletRequest request, HttpServletResponse response, Long childId) throws Exception {
        ResponseData r = new ResponseData();
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        DocUtil docUtil = new DocUtil();
        HashMap<String, List> dataMap = new HashMap<String, List>();
        List staffInfoArchiveVos = this.staffInfoService.getStaffInfoArchiveVoByStaffIds(Integer.valueOf(DateUtils.getThisYear()), cid);
        if (staffInfoArchiveVos == null || staffInfoArchiveVos.size() == 0) {
            return r;
        }
        dataMap.put("dataList", staffInfoArchiveVos);
        File file = docUtil.createDocFile(dataMap, "\u804c\u4e1a\u5065\u5eb7\u76d1\u62a4\u6863\u6848\u6c47\u603b\u8868.ftl", "/templates/liteDoc5/", "\u804c\u4e1a\u5065\u5eb7\u76d1\u62a4\u6863\u6848\u6c47\u603b\u8868" + dateFormat.format(new Date()));
        SysFileModel sysFile = this.uploadOss(file, cid + "/archive/" + childId, "\u804c\u4e1a\u5065\u5eb7\u76d1\u62a4\u6863\u6848\u6c47\u603b\u8868" + dateFormat.format(new Date()) + ".doc", "doc");
        LiteArchiveFileItemChild child = new LiteArchiveFileItemChild();
        child.setId(childId);
        child.setReferFileIds("" + sysFile.getId());
        Long staffid = UserUtils.getLoginStaffId();
        child.setUploadStaffId("" + staffid);
        child.setUpdateBy(staffid);
        this.liteArchiveFileItemChildService.updateArchiveFiles(child);
        r.setResult((Object)"true");
        return r;
    }

    @RequestMapping(value={"getDoc5_503_V314"})
    @ResponseBody
    public ResponseData<String> getDoc5_503_V314(HttpServletRequest request, HttpServletResponse response, Long itemId, Long fileNameId, Long liteArchiveId) throws Exception {
        ResponseData r = new ResponseData();
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        if (itemId == null) {
            ArchiveFileItemUpdateParam param = new ArchiveFileItemUpdateParam();
            param.setFileNameId(fileNameId);
            param.setArchiveId(liteArchiveId);
            param.setStaffId(loginStaffId);
            itemId = this.archiveFileItemService.updateArchiveFiles(param);
        }
        LiteArchiveFileItem liteArchiveFileItem = new LiteArchiveFileItem();
        liteArchiveFileItem.setId(itemId);
        liteArchiveFileItem.setUploadStaffId(loginStaffId);
        liteArchiveFileItem.setUploadDate(new Date());
        this.liteArchiveFileItemService.update((Object)liteArchiveFileItem, loginStaffId);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        DocUtil docUtil = new DocUtil();
        HashMap<String, List> dataMap = new HashMap<String, List>();
        List staffInfoArchiveVos = this.staffInfoService.getStaffInfoArchiveVoByStaffIds(Integer.valueOf(DateUtils.getThisYear()), cid);
        if (staffInfoArchiveVos == null || staffInfoArchiveVos.size() == 0) {
            return r;
        }
        Long staffid = UserUtils.getLoginStaffId();
        LiteArchiveFileItemChild childThisYear = this.liteArchiveFileItemChildService.addLatelyYearData(itemId, staffid, cid);
        dataMap.put("dataList", staffInfoArchiveVos);
        File file = docUtil.createDocFile(dataMap, "\u804c\u4e1a\u5065\u5eb7\u76d1\u62a4\u6863\u6848\u6c47\u603b\u8868.ftl", "/templates/liteDoc5/", "\u804c\u4e1a\u5065\u5eb7\u76d1\u62a4\u6863\u6848\u6c47\u603b\u8868" + dateFormat.format(new Date()));
        SysFileModel sysFile = this.uploadOss(file, cid + "/archive/" + childThisYear.getId(), "\u804c\u4e1a\u5065\u5eb7\u76d1\u62a4\u6863\u6848\u6c47\u603b\u8868" + dateFormat.format(new Date()) + ".doc", "doc");
        LiteArchiveFileItemChild child = new LiteArchiveFileItemChild();
        child.setId(childThisYear.getId());
        child.setReferFileIds("" + sysFile.getId());
        child.setUploadStaffId("" + staffid);
        child.setUpdateBy(staffid);
        LiteArchiveFileItemChild oldData = (LiteArchiveFileItemChild)this.liteArchiveFileItemChildService.getById(childThisYear.getId());
        child.setFileIds(oldData.getFileIds());
        List<Object> oldRefileIds = new ArrayList();
        if (StringUtils.isNotEmpty((String)oldData.getReferFileIds())) {
            oldRefileIds = Arrays.stream(oldData.getReferFileIds().split(",")).collect(Collectors.toList());
        }
        if (oldRefileIds.size() > 0 && StringUtils.isNotEmpty((String)child.getFileIds())) {
            for (String oldRfileId : oldRefileIds) {
                if (!oldData.getFileIds().contains(oldRfileId)) continue;
                child.setFileIds(child.getFileIds().replace(oldRfileId, ""));
            }
        }
        if (StringUtils.isNotEmpty((String)child.getFileIds())) {
            child.setFileIds(child.getFileIds() + "," + child.getReferFileIds());
        } else {
            child.setFileIds(child.getReferFileIds());
        }
        this.liteArchiveFileItemChildService.updateArchiveFiles(child);
        this.updateArchiveFiles(child);
        r.setResult((Object)("" + fileNameId));
        return r;
    }

    @RequestMapping(value={"getDoc5_504"})
    @ResponseBody
    public ResponseData<String> getDoc5_504(HttpServletRequest request, HttpServletResponse response, Long itemId, Long fileNameId, Long liteArchiveId) throws Exception {
        ResponseData r = new ResponseData();
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        if (itemId == null) {
            ArchiveFileItemUpdateParam param = new ArchiveFileItemUpdateParam();
            param.setFileNameId(fileNameId);
            param.setArchiveId(liteArchiveId);
            param.setStaffId(loginStaffId);
            itemId = this.archiveFileItemService.updateArchiveFiles(param);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        DocUtil docUtil = new DocUtil();
        HashMap<String, List> dataMap = new HashMap<String, List>();
        List list = this.phcPhysicalCheckService.queryHealthCheckArchiveStaffInfoGroup(cid);
        if (list != null && list.size() > 0) {
            for (HealthCheckArchiveStaffGroup group : list) {
                if (group.getList() == null || group.getList().size() <= 0) continue;
                for (HealthCheckArchiveStaffInfo si : group.getList()) {
                    if (!StringUtils.isNotEmpty((String)si.getIcCard())) continue;
                    si.setAge(Integer.valueOf(IDCardUtil.getAge((String)si.getIcCard())));
                }
            }
            dataMap.put("dataList", list);
            File file = docUtil.createDocFile(dataMap, "\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5\u5f02\u5e38\u7ed3\u679c\u767b\u8bb0\u8868.ftl", "/templates/liteDoc5/", "\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5\u5f02\u5e38\u7ed3\u679c\u767b\u8bb0\u8868" + dateFormat.format(new Date()));
            SysFileModel sysFile = this.uploadOss(file, cid + "/archive/" + itemId, "\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5\u5f02\u5e38\u7ed3\u679c\u767b\u8bb0\u8868" + dateFormat.format(new Date()) + ".doc", "doc");
            LiteArchiveFileItem liteArchiveFileItem = new LiteArchiveFileItem();
            liteArchiveFileItem.setId(itemId);
            liteArchiveFileItem.setReferFileIds("" + sysFile.getId());
            liteArchiveFileItem.setUploadStaffId(loginStaffId);
            liteArchiveFileItem.setUploadDate(new Date());
            LiteArchiveFileItem oldData = (LiteArchiveFileItem)this.liteArchiveFileItemService.getById(itemId);
            liteArchiveFileItem.setFileIds(oldData.getFileIds());
            List<Object> oldRefileIds = new ArrayList();
            if (StringUtils.isNotEmpty((String)oldData.getReferFileIds())) {
                oldRefileIds = Arrays.stream(oldData.getReferFileIds().split(",")).collect(Collectors.toList());
            }
            if (oldRefileIds.size() > 0 && StringUtils.isNotEmpty((String)liteArchiveFileItem.getFileIds())) {
                for (String oldRfileId : oldRefileIds) {
                    if (!oldData.getFileIds().contains(oldRfileId)) continue;
                    liteArchiveFileItem.setFileIds(liteArchiveFileItem.getFileIds().replace(oldRfileId, ""));
                }
            }
            if (StringUtils.isNotEmpty((String)liteArchiveFileItem.getFileIds())) {
                liteArchiveFileItem.setFileIds(liteArchiveFileItem.getFileIds() + "," + liteArchiveFileItem.getReferFileIds());
            } else {
                liteArchiveFileItem.setFileIds(liteArchiveFileItem.getReferFileIds());
            }
            this.liteArchiveFileItemService.update((Object)liteArchiveFileItem, loginStaffId);
        }
        r.setResult((Object)("" + fileNameId));
        try {
            this.reformItemBasicService.changeStatusByCidAndGenerationSource(cid, ReformGenerationSourceEnum.ARCHIVES.getValue(), Byte.valueOf((byte)3), loginStaffId, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("\u6863\u6848\u81ea\u52a8\u9a8c\u6536\u5931\u8d25\uff0c\u62a5\u9519\u65b9\u6cd5\uff1acn.smarthse.web.controller.litearchive.LiteArchiveFileItemChildController.getDoc5_504");
        }
        return r;
    }

    @RequestMapping(value={"getDoc5_505"})
    @ResponseBody
    public ResponseData<String> getDoc5_505(HttpServletRequest request, HttpServletResponse response, Long itemId, Long fileNameId, Long liteArchiveId) throws Exception {
        List list2;
        ResponseData r = new ResponseData();
        Long loginStaffId = UserUtils.getLoginStaffId();
        if (itemId == null) {
            ArchiveFileItemUpdateParam param = new ArchiveFileItemUpdateParam();
            param.setFileNameId(fileNameId);
            param.setArchiveId(liteArchiveId);
            param.setStaffId(loginStaffId);
            itemId = this.archiveFileItemService.updateArchiveFiles(param);
        }
        Long cid = UserUtils.getLoginStaffCompanyId();
        PhcOccupationalDiseaserParam param = new PhcOccupationalDiseaserParam();
        param.setCid(cid);
        List list1 = this.phcOccupationalDiseaserService.getSuperviseDataList(param);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        DocUtil docUtil = new DocUtil();
        ArrayList<CallSite> fileIds = new ArrayList<CallSite>();
        if (list1 != null && list1.size() > 0) {
            HashMap<String, List> dataMap = new HashMap<String, List>();
            dataMap.put("dataList", list1);
            File file = docUtil.createDocFile(dataMap, "\u804c\u4e1a\u75c5\u60a3\u8005\u4e00\u89c8\u8868.ftl", "/templates/liteDoc5/", "\u804c\u4e1a\u75c5\u60a3\u8005\u4e00\u89c8\u8868" + dateFormat.format(new Date()));
            SysFileModel sysFile = this.uploadOss(file, cid + "/archive/" + itemId, "\u804c\u4e1a\u75c5\u60a3\u8005\u4e00\u89c8\u8868" + dateFormat.format(new Date()) + ".doc", "doc");
            fileIds.add((CallSite)((Object)("" + sysFile.getId())));
        }
        if ((list2 = this.phcPhysicalCheckDataResultService.getPatientDataByCid(cid)) != null && list2.size() > 0) {
            HashMap<String, List> dataMap = new HashMap<String, List>();
            dataMap.put("dataList", list2);
            File file = docUtil.createDocFile(dataMap, "\u7591\u4f3c\u804c\u4e1a\u75c5\u60a3\u8005\u4e00\u89c8\u8868.ftl", "/templates/liteDoc5/", "\u7591\u4f3c\u804c\u4e1a\u75c5\u60a3\u8005\u4e00\u89c8\u8868" + dateFormat.format(new Date()));
            SysFileModel sysFile = this.uploadOss(file, cid + "/archive/" + itemId, "\u7591\u4f3c\u804c\u4e1a\u75c5\u60a3\u8005\u4e00\u89c8\u8868" + dateFormat.format(new Date()) + ".doc", "doc");
            fileIds.add((CallSite)((Object)("" + sysFile.getId())));
        }
        if (fileIds.size() > 0) {
            LiteArchiveFileItem liteArchiveFileItem = new LiteArchiveFileItem();
            liteArchiveFileItem.setId(itemId);
            liteArchiveFileItem.setReferFileIds(String.join((CharSequence)",", fileIds));
            liteArchiveFileItem.setUploadStaffId(loginStaffId);
            liteArchiveFileItem.setUploadDate(new Date());
            LiteArchiveFileItem oldData = (LiteArchiveFileItem)this.liteArchiveFileItemService.getById(itemId);
            liteArchiveFileItem.setFileIds(oldData.getFileIds());
            List<Object> oldRefileIds = new ArrayList();
            if (StringUtils.isNotEmpty((String)oldData.getReferFileIds())) {
                oldRefileIds = Arrays.stream(oldData.getReferFileIds().split(",")).collect(Collectors.toList());
            }
            if (oldRefileIds.size() > 0 && StringUtils.isNotEmpty((String)liteArchiveFileItem.getFileIds())) {
                for (String oldRfileId : oldRefileIds) {
                    if (!oldData.getFileIds().contains(oldRfileId)) continue;
                    liteArchiveFileItem.setFileIds(liteArchiveFileItem.getFileIds().replace(oldRfileId, ""));
                }
            }
            if (StringUtils.isNotEmpty((String)liteArchiveFileItem.getFileIds())) {
                liteArchiveFileItem.setFileIds(liteArchiveFileItem.getFileIds() + "," + liteArchiveFileItem.getReferFileIds());
            } else {
                liteArchiveFileItem.setFileIds(liteArchiveFileItem.getReferFileIds());
            }
            this.liteArchiveFileItemService.update((Object)liteArchiveFileItem, loginStaffId);
        }
        r.setResult((Object)("" + fileNameId));
        return r;
    }

    @RequestMapping(value={"getDoc5_506"})
    @ResponseBody
    public ResponseData<String> getDoc5_506(HttpServletRequest request, HttpServletResponse response, Long itemId, Long fileNameId, Long liteArchiveId) throws Exception {
        ResponseData r = new ResponseData();
        Long loginStaffId = UserUtils.getLoginStaffId();
        if (itemId == null) {
            ArchiveFileItemUpdateParam param = new ArchiveFileItemUpdateParam();
            param.setFileNameId(fileNameId);
            param.setArchiveId(liteArchiveId);
            param.setStaffId(loginStaffId);
            itemId = this.archiveFileItemService.updateArchiveFiles(param);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Long cid = UserUtils.getLoginStaffCompanyId();
        DocUtil docUtil = new DocUtil();
        List list2 = this.phcPhysicalCheckDataResultService.getPatientDataByCid(cid);
        ArrayList<PhcDieaserUnprocessParam> newList = new ArrayList<PhcDieaserUnprocessParam>();
        HashMap map = new HashMap();
        for (PhcDieaserUnprocessParam pup : list2) {
            if (map.get(pup.getCheckBeginTime().getTime() + "->" + pup.getThirdOrg()) == null) {
                map.put((CallSite)((Object)(pup.getCheckBeginTime().getTime() + "->" + pup.getThirdOrg())), new ArrayList());
            }
            ((List)map.get(pup.getCheckBeginTime().getTime() + "->" + pup.getThirdOrg())).add(pup);
        }
        for (String str : map.keySet()) {
            String[] strs = str.split("->");
            PhcDieaserUnprocessParam pdup = new PhcDieaserUnprocessParam();
            pdup.setCheckBeginTime(new Date(Long.valueOf(strs[0])));
            pdup.setThirdOrg("null".equals(strs[1]) ? "" : strs[1]);
            pdup.setStaffCount(Integer.valueOf(((List)map.get(str)).size()));
            newList.add(pdup);
        }
        if (newList != null && newList.size() > 0) {
            HashMap<String, ArrayList<PhcDieaserUnprocessParam>> dataMap = new HashMap<String, ArrayList<PhcDieaserUnprocessParam>>();
            dataMap.put("dataList", newList);
            File file = docUtil.createDocFile(dataMap, "\u804c\u4e1a\u75c5\u548c\u7591\u4f3c\u804c\u4e1a\u75c5\u4eba\u62a5\u544a.ftl", "/templates/liteDoc5/", "\u804c\u4e1a\u75c5\u548c\u7591\u4f3c\u804c\u4e1a\u75c5\u4eba\u62a5\u544a" + dateFormat.format(new Date()));
            SysFileModel sysFile = this.uploadOss(file, cid + "/archive/" + itemId, "\u804c\u4e1a\u75c5\u548c\u7591\u4f3c\u804c\u4e1a\u75c5\u4eba\u62a5\u544a" + dateFormat.format(new Date()) + ".doc", "doc");
            LiteArchiveFileItem liteArchiveFileItem = new LiteArchiveFileItem();
            liteArchiveFileItem.setId(itemId);
            liteArchiveFileItem.setReferFileIds("" + sysFile.getId());
            liteArchiveFileItem.setUploadStaffId(loginStaffId);
            liteArchiveFileItem.setUploadDate(new Date());
            LiteArchiveFileItem oldData = (LiteArchiveFileItem)this.liteArchiveFileItemService.getById(itemId);
            liteArchiveFileItem.setFileIds(oldData.getFileIds());
            List<Object> oldRefileIds = new ArrayList();
            if (StringUtils.isNotEmpty((String)oldData.getReferFileIds())) {
                oldRefileIds = Arrays.stream(oldData.getReferFileIds().split(",")).collect(Collectors.toList());
            }
            if (oldRefileIds.size() > 0 && StringUtils.isNotEmpty((String)liteArchiveFileItem.getFileIds())) {
                for (String oldRfileId : oldRefileIds) {
                    if (!oldData.getFileIds().contains(oldRfileId)) continue;
                    liteArchiveFileItem.setFileIds(liteArchiveFileItem.getFileIds().replace(oldRfileId, ""));
                }
            }
            if (StringUtils.isNotEmpty((String)liteArchiveFileItem.getFileIds())) {
                liteArchiveFileItem.setFileIds(liteArchiveFileItem.getFileIds() + "," + liteArchiveFileItem.getReferFileIds());
            } else {
                liteArchiveFileItem.setFileIds(liteArchiveFileItem.getReferFileIds());
            }
            this.liteArchiveFileItemService.update((Object)liteArchiveFileItem, loginStaffId);
        }
        r.setResult((Object)("" + fileNameId));
        return r;
    }

    @RequestMapping(value={"getDoc5_507"})
    @ResponseBody
    public ResponseData<String> getDoc5_507(HttpServletRequest request, HttpServletResponse response, Long itemId, Long fileNameId, Long liteArchiveId) throws Exception {
        ResponseData r = new ResponseData();
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        if (itemId == null) {
            ArchiveFileItemUpdateParam param = new ArchiveFileItemUpdateParam();
            param.setFileNameId(fileNameId);
            param.setArchiveId(liteArchiveId);
            param.setStaffId(loginStaffId);
            itemId = this.archiveFileItemService.updateArchiveFiles(param);
        }
        r.setResult((Object)("" + fileNameId));
        return r;
    }

    @RequestMapping(value={"getDoc3_301"})
    @ResponseBody
    public ResponseData<String> getDoc3_301(HttpServletRequest request, HttpServletResponse response, Long itemId, Long fileNameId, Long liteArchiveId) throws Exception {
        LiteArchiveFileItem liteArchiveFileItem;
        ResponseData r = new ResponseData();
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        if (itemId == null) {
            ArchiveFileItemUpdateParam param = new ArchiveFileItemUpdateParam();
            param.setFileNameId(fileNameId);
            param.setArchiveId(liteArchiveId);
            param.setStaffId(loginStaffId);
            itemId = this.archiveFileItemService.updateArchiveFiles(param);
        }
        if (!StringUtil.isEmpty((String)(liteArchiveFileItem = this.archiveFileItemService.getByArchiveAndFileName(liteArchiveId, fileNameId)).getFileIds())) {
            liteArchiveFileItem.setDataState(Integer.valueOf(1));
        } else {
            liteArchiveFileItem.setDataState(Integer.valueOf(0));
        }
        this.liteArchiveFileItemService.updateByPrimaryKey((Object)liteArchiveFileItem, loginStaffId);
        r.setResult((Object)("" + fileNameId));
        return r;
    }

    @RequestMapping(value={"getDoc3_302"})
    @ResponseBody
    public ResponseData<String> getDoc3_302(HttpServletRequest request, HttpServletResponse response, Long itemId, Long fileNameId, Long liteArchiveId) throws Exception {
        ResponseData r = new ResponseData();
        Long loginStaffId = UserUtils.getLoginStaffId();
        if (itemId == null) {
            ArchiveFileItemUpdateParam param = new ArchiveFileItemUpdateParam();
            param.setFileNameId(fileNameId);
            param.setArchiveId(liteArchiveId);
            param.setStaffId(loginStaffId);
            itemId = this.archiveFileItemService.updateArchiveFiles(param);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Long cid = UserUtils.getLoginStaffCompanyId();
        DocUtil docUtil = new DocUtil();
        LiteArchive liteArchive = (LiteArchive)this.liteArchiveService.getById(liteArchiveId);
        List newList = this.certificateStaffDetailService.getListNoIncludeNoWorkedByCidAndNameIdsAndYear(cid, "0,12,13", null);
        if (newList != null && newList.size() > 0) {
            ArrayList<Long> files = new ArrayList<Long>();
            HashMap<String, List> dataMap = new HashMap<String, List>();
            dataMap.put("dataList", newList);
            File file = docUtil.createDocFile(dataMap, "\u7528\u4eba\u5355\u4f4d\u8d1f\u8d23\u4eba\u3001\u7ba1\u7406\u4eba\u5458\u804c\u4e1a\u536b\u751f\u57f9\u8bad\u8bc1\u660e.ftl", "/templates/liteDoc3/", "\u7528\u4eba\u5355\u4f4d\u8d1f\u8d23\u4eba\u3001\u7ba1\u7406\u4eba\u5458\u804c\u4e1a\u536b\u751f\u57f9\u8bad\u8bc1\u660e" + dateFormat.format(new Date()));
            SysFileModel sysFile = this.uploadOss(file, cid + "/archive/" + itemId, "\u7528\u4eba\u5355\u4f4d\u8d1f\u8d23\u4eba\u3001\u7ba1\u7406\u4eba\u5458\u804c\u4e1a\u536b\u751f\u57f9\u8bad\u8bc1\u660e" + dateFormat.format(new Date()) + ".doc", "doc");
            files.add(sysFile.getId());
            newList.forEach(s -> {
                if (s.getFiles() != null) {
                    files.addAll(s.getFiles().stream().mapToLong(CertificateFiles::getFileId).boxed().collect(Collectors.toList()));
                }
            });
            LiteArchiveFileItem liteArchiveFileItem = new LiteArchiveFileItem();
            liteArchiveFileItem.setId(itemId);
            liteArchiveFileItem.setReferFileIds(files.stream().map(s -> "" + s).collect(Collectors.joining(",")));
            liteArchiveFileItem.setUploadStaffId(loginStaffId);
            liteArchiveFileItem.setUploadDate(new Date());
            LiteArchiveFileItem oldData = (LiteArchiveFileItem)this.liteArchiveFileItemService.getById(itemId);
            liteArchiveFileItem.setFileIds(oldData.getFileIds());
            List<Object> oldRefileIds = new ArrayList();
            if (StringUtils.isNotEmpty((String)oldData.getReferFileIds())) {
                oldRefileIds = Arrays.stream(oldData.getReferFileIds().split(",")).collect(Collectors.toList());
            }
            if (oldRefileIds.size() > 0 && StringUtils.isNotEmpty((String)liteArchiveFileItem.getFileIds())) {
                for (String oldRfileId : oldRefileIds) {
                    if (!oldData.getFileIds().contains(oldRfileId)) continue;
                    liteArchiveFileItem.setFileIds(liteArchiveFileItem.getFileIds().replace(oldRfileId, ""));
                }
            }
            if (StringUtils.isNotEmpty((String)liteArchiveFileItem.getFileIds())) {
                liteArchiveFileItem.setFileIds(liteArchiveFileItem.getFileIds() + "," + liteArchiveFileItem.getReferFileIds());
            } else {
                liteArchiveFileItem.setFileIds(liteArchiveFileItem.getReferFileIds());
            }
            Long certId = this.liteArchiveService.checkCertStaffValidDataByYear(liteArchive.getTitle(), liteArchive.getCid());
            if (certId != null) {
                liteArchiveFileItem.setDataState(Integer.valueOf(1));
            } else {
                liteArchiveFileItem.setDataState(Integer.valueOf(0));
            }
            this.liteArchiveFileItemService.update((Object)liteArchiveFileItem, loginStaffId);
        }
        r.setResult((Object)("" + fileNameId));
        return r;
    }

    @RequestMapping(value={"getDoc3_303"})
    @ResponseBody
    public ResponseData<String> getDoc3_303(HttpServletRequest request, HttpServletResponse response, Long itemId, Long fileNameId, Long liteArchiveId) throws Exception {
        ResponseData r = new ResponseData();
        Long loginStaffId = UserUtils.getLoginStaffId();
        if (itemId == null) {
            ArchiveFileItemUpdateParam param = new ArchiveFileItemUpdateParam();
            param.setFileNameId(fileNameId);
            param.setArchiveId(liteArchiveId);
            param.setStaffId(loginStaffId);
            itemId = this.archiveFileItemService.updateArchiveFiles(param);
        }
        Long cid = UserUtils.getLoginStaffCompanyId();
        String filePath = request.getSession().getServletContext().getRealPath("/") + "template" + File.separator + "liteArchive" + File.separator + "doc3" + File.separator;
        String zipDir = filePath + "zip";
        FileUtils.forceMkdir((File)new File(zipDir));
        LiteArchive la = (LiteArchive)this.liteArchiveService.getById(liteArchiveId);
        Integer year = Integer.valueOf(la.getTitle().replace("\u5e74", "").replace("\u4ee5\u524d", ""));
        boolean isBefore = false;
        if (la.getTitle().contains("\u5e74\u4ee5\u524d")) {
            isBefore = true;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String tfileName = zipDir + File.separator + String.valueOf(isBefore ? la.getTitle() : year) + "\u5e74\u5ea6\u804c\u4e1a\u536b\u751f\u5ba3\u4f20\u57f9\u8bad" + dateFormat.format(new Date()) + ".zip";
        File tfile = new File(tfileName);
        if (!tfile.exists()) {
            tfile.createNewFile();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("year", year);
        params.put("cid", cid);
        params.put("type", "1");
        params.put("yearFlag", isBefore ? "before" : null);
        List dataList = this.trainPlanService.listOfOccTrainPlan(params);
        r.setResult((Object)("" + fileNameId));
        if (dataList == null || dataList.size() == 0) {
            return r;
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("companyName", UserUtils.getCurrentCompany().getName());
        dataMap.put("year", String.valueOf(isBefore ? la.getTitle() : year) + " ");
        HashMap filesMap = new HashMap();
        DocUtil docUtil = new DocUtil();
        for (int i = 1; i <= dataList.size(); ++i) {
            String dirName = i + "-" + String.valueOf(isBefore ? la.getTitle() : year) + ((TrainPlan)dataList.get(i - 1)).getName();
            filesMap.put((CallSite)((Object)dirName), new ArrayList());
            dataMap.put("data", dataList.get(i - 1));
            File file = docUtil.createDocFile(dataMap, "\u5e74\u5ea6\u804c\u4e1a\u536b\u751f\u5ba3\u4f20\u57f9\u8bad\u4e00\u89c8\u8868.ftl", "/templates/liteDoc3/", "\u5e74\u5ea6\u804c\u4e1a\u536b\u751f\u5ba3\u4f20\u57f9\u8bad\u4e00\u89c8\u8868");
            File destFile = new File(file.getParent() + File.separator + dirName + File.separator + String.valueOf(isBefore ? la.getTitle() : year) + "\u5e74\u5ea6\u804c\u4e1a\u536b\u751f\u5ba3\u4f20\u57f9\u8bad\u4e00\u89c8\u8868" + dateFormat.format(new Date()) + ".doc");
            FileUtils.copyFile((File)file, (File)destFile);
            ((List)filesMap.get(dirName)).add(destFile);
            List tfiles = this.trainPaperFileService.getByTidAndType(((TrainPlan)dataList.get(i - 1)).getId(), null);
            ((TrainPlan)dataList.get(i - 1)).setOtherFiles(tfiles);
            for (TrainPaperFile trainPaperFile : tfiles) {
                try {
                    File file1 = SysFileUtil.getFileByfid((long)trainPaperFile.getFileId(), "doc3");
                    if (file1 == null) continue;
                    ((List)filesMap.get(dirName)).add(file1);
                }
                catch (Exception exception) {}
            }
        }
        FileOutputStream fos = new FileOutputStream(tfile);
        ZipCompressorUtil.getDownZipFile(filesMap, (OutputStream)fos);
        SysFileModel sysFile = this.uploadOss(tfile, cid + "/archive/" + itemId, tfile.getName(), "zip");
        filesMap.values().forEach(s -> s.forEach(file -> file.deleteOnExit()));
        LiteArchiveFileItem liteArchiveFileItem = new LiteArchiveFileItem();
        liteArchiveFileItem.setId(itemId);
        liteArchiveFileItem.setReferFileIds("" + sysFile.getId());
        liteArchiveFileItem.setUploadStaffId(loginStaffId);
        liteArchiveFileItem.setUploadDate(new Date());
        LiteArchiveFileItem oldData = (LiteArchiveFileItem)this.liteArchiveFileItemService.getById(itemId);
        liteArchiveFileItem.setFileIds(oldData.getFileIds());
        List<Object> oldRefileIds = new ArrayList();
        if (StringUtils.isNotEmpty((String)oldData.getReferFileIds())) {
            oldRefileIds = Arrays.stream(oldData.getReferFileIds().split(",")).collect(Collectors.toList());
        }
        if (oldRefileIds.size() > 0 && StringUtils.isNotEmpty((String)liteArchiveFileItem.getFileIds())) {
            for (String oldRfileId : oldRefileIds) {
                if (!oldData.getFileIds().contains(oldRfileId)) continue;
                liteArchiveFileItem.setFileIds(liteArchiveFileItem.getFileIds().replace(oldRfileId, ""));
            }
        }
        if (StringUtils.isNotEmpty((String)liteArchiveFileItem.getFileIds())) {
            liteArchiveFileItem.setFileIds(liteArchiveFileItem.getFileIds() + "," + liteArchiveFileItem.getReferFileIds());
        } else {
            liteArchiveFileItem.setFileIds(liteArchiveFileItem.getReferFileIds());
        }
        LiteArchiveFileItem archiveFileItem = this.archiveFileItemService.getByArchiveAndFileName(liteArchiveId, fileNameId);
        this.liteArchiveFileItemService.update((Object)liteArchiveFileItem, loginStaffId);
        return r;
    }

    @RequestMapping(value={"getDoc3_304"})
    @ResponseBody
    public ResponseData<String> getDoc3_304(HttpServletRequest request, HttpServletResponse response, Long itemId, Long fileNameId, Long liteArchiveId) throws Exception {
        ResponseData r = new ResponseData();
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        if (itemId == null) {
            ArchiveFileItemUpdateParam param = new ArchiveFileItemUpdateParam();
            param.setFileNameId(fileNameId);
            param.setArchiveId(liteArchiveId);
            param.setStaffId(loginStaffId);
            itemId = this.archiveFileItemService.updateArchiveFiles(param);
        }
        this.liteArchiveService.updateStatus(liteArchiveId);
        r.setResult((Object)("" + fileNameId));
        return r;
    }

    @ResponseBody
    @RequestMapping(value={"abnormalResults"})
    public void abnormalResults(HttpServletResponse response) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Object fileName = "\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5\u5f02\u5e38\u7ed3\u679c\u767b\u8bb0\u8868";
        fileName = (String)fileName + dateFormat.format(new Date());
        fileName = (String)fileName + ".zip";
        response.setContentType("application/x-download");
        response.setHeader("Content-disposition", "attachment; filename=" + new String(((String)fileName).getBytes("gbk"), "iso8859-1"));
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        ArrayList<abnormalResultVo> datas = new ArrayList<abnormalResultVo>();
        HashMap<String, ArrayList<abnormalResultVo>> dataMap = new HashMap<String, ArrayList<abnormalResultVo>>();
        abnormalResultVo vo = new abnormalResultVo();
        vo.setName("\u5927\u72d7");
        vo.setAge(18);
        vo.setGender("\u7537");
        vo.setPost("\u6b66\u5f53\u638c\u95e8");
        vo.setFactor("\u8475\u82b1\u5b9d\u5178");
        vo.setAdvice("\u5efa\u8bae\u81ea\u5bab");
        vo.setIllness("\u4f53\u865a");
        vo.setSituation("\u662f");
        datas.add(vo);
        abnormalResultVo vo1 = new abnormalResultVo();
        vo1.setName("\u4e8c\u72d7");
        vo1.setAge(18);
        vo1.setGender("\u7537");
        vo1.setPost("\u5149\u660e\u9876");
        vo1.setFactor("\u4e7e\u5764\u5927\u632a\u79fb");
        vo1.setAdvice("\u5403\u5e2d");
        vo1.setIllness("\u4f53\u865a");
        vo1.setSituation("\u662f");
        datas.add(vo1);
        dataMap.put("dataList", datas);
        ArrayList<File> files = new ArrayList<File>();
        DocUtil docUtil = new DocUtil();
        File file = docUtil.createDocFile(dataMap, "\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5\u5f02\u5e38\u7ed3\u679c\u767b\u8bb0\u8868.ftl", "/templates/liteDoc5/", "\u7591\u4f3c\u804c\u4e1a\u75c5\u60a3\u8005\u4e00\u89c8\u8868" + dateFormat.format(new Date()));
        files.add(file);
        ZipCompressorUtil.getDownZipFile(files, (String)"", (OutputStream)response.getOutputStream());
    }

    @ResponseBody
    @RequestMapping(value={"downMoreFile"})
    public void downMoreFile(Model model, String fileIds, Long fileNameId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (StringUtils.isBlank((CharSequence)fileIds)) {
            return;
        }
        if (StringUtils.isNotEmpty((String)fileIds)) {
            List sfiles = this.sysFileProvideService.getListByIds(fileIds);
            ArrayList<File> files = new ArrayList<File>();
            if (CollectionUtils.isNotEmpty((Collection)sfiles)) {
                for (SysFileModel sfm : sfiles) {
                    File file = SysFileUtil.getFileByfid((long)sfm.getId(), "downloadfilesdir");
                    if (file == null) continue;
                    files.add(file);
                }
            }
            if (CollectionUtils.isEmpty(files)) {
                response.setCharacterEncoding("utf-8");
                response.setHeader("Content-Type", "text/html;charset=utf-8");
                response.getWriter().write("\u9644\u4ef6\u4e22\u5931\uff0c\u9644\u4ef6\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u6863\u6848");
                return;
            }
            if (files.size() == 1 && fileNameId != 406L) {
                response.setHeader("Content-disposition", "attachment; filename=" + new String(((File)files.get(0)).getName().getBytes("gbk"), "iso8859-1"));
                FileCopyUtils.copy((InputStream)new FileInputStream((File)files.get(0)), (OutputStream)response.getOutputStream());
            } else {
                LiteArchiveFileName archiveFileName = (LiteArchiveFileName)this.liteArchiveFileNameService.getById(fileNameId);
                Object fileName = archiveFileName.getFileName();
                fileName = (String)fileName + ".zip";
                response.setHeader("Content-disposition", "attachment; filename=" + new String(((String)fileName).getBytes("gbk"), "iso8859-1"));
                ZipCompressorUtil.getDownZipFile(files, (String)"", (OutputStream)response.getOutputStream());
            }
        }
    }

    public class abnormalResultVo
    implements Serializable {
        String name;
        String gender;
        Integer age;
        String post;
        String factor;
        String illness;
        String advice;
        String situation;

        @Generated
        public abnormalResultVo() {
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getGender() {
            return this.gender;
        }

        @Generated
        public Integer getAge() {
            return this.age;
        }

        @Generated
        public String getPost() {
            return this.post;
        }

        @Generated
        public String getFactor() {
            return this.factor;
        }

        @Generated
        public String getIllness() {
            return this.illness;
        }

        @Generated
        public String getAdvice() {
            return this.advice;
        }

        @Generated
        public String getSituation() {
            return this.situation;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setGender(String gender) {
            this.gender = gender;
        }

        @Generated
        public void setAge(Integer age) {
            this.age = age;
        }

        @Generated
        public void setPost(String post) {
            this.post = post;
        }

        @Generated
        public void setFactor(String factor) {
            this.factor = factor;
        }

        @Generated
        public void setIllness(String illness) {
            this.illness = illness;
        }

        @Generated
        public void setAdvice(String advice) {
            this.advice = advice;
        }

        @Generated
        public void setSituation(String situation) {
            this.situation = situation;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof abnormalResultVo)) {
                return false;
            }
            abnormalResultVo other = (abnormalResultVo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$age = this.getAge();
            Integer other$age = other.getAge();
            if (this$age == null ? other$age != null : !((Object)this$age).equals(other$age)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$gender = this.getGender();
            String other$gender = other.getGender();
            if (this$gender == null ? other$gender != null : !this$gender.equals(other$gender)) {
                return false;
            }
            String this$post = this.getPost();
            String other$post = other.getPost();
            if (this$post == null ? other$post != null : !this$post.equals(other$post)) {
                return false;
            }
            String this$factor = this.getFactor();
            String other$factor = other.getFactor();
            if (this$factor == null ? other$factor != null : !this$factor.equals(other$factor)) {
                return false;
            }
            String this$illness = this.getIllness();
            String other$illness = other.getIllness();
            if (this$illness == null ? other$illness != null : !this$illness.equals(other$illness)) {
                return false;
            }
            String this$advice = this.getAdvice();
            String other$advice = other.getAdvice();
            if (this$advice == null ? other$advice != null : !this$advice.equals(other$advice)) {
                return false;
            }
            String this$situation = this.getSituation();
            String other$situation = other.getSituation();
            return !(this$situation == null ? other$situation != null : !this$situation.equals(other$situation));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof abnormalResultVo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $age = this.getAge();
            result = result * 59 + ($age == null ? 43 : ((Object)$age).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $gender = this.getGender();
            result = result * 59 + ($gender == null ? 43 : $gender.hashCode());
            String $post = this.getPost();
            result = result * 59 + ($post == null ? 43 : $post.hashCode());
            String $factor = this.getFactor();
            result = result * 59 + ($factor == null ? 43 : $factor.hashCode());
            String $illness = this.getIllness();
            result = result * 59 + ($illness == null ? 43 : $illness.hashCode());
            String $advice = this.getAdvice();
            result = result * 59 + ($advice == null ? 43 : $advice.hashCode());
            String $situation = this.getSituation();
            result = result * 59 + ($situation == null ? 43 : $situation.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LiteArchiveFileItemChildController.abnormalResultVo(name=" + this.getName() + ", gender=" + this.getGender() + ", age=" + this.getAge() + ", post=" + this.getPost() + ", factor=" + this.getFactor() + ", illness=" + this.getIllness() + ", advice=" + this.getAdvice() + ", situation=" + this.getSituation() + ")";
        }
    }
}

