/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.litearchive;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.mapper.JsonMapper;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.health.compliance.enums.ComplianceCodeEnum;
import cn.smarthse.modules.health.compliance.service.IBusinessDataUpdateRefreshService;
import cn.smarthse.modules.health.entity.litearchive.LiteArchive;
import cn.smarthse.modules.health.entity.litearchive.LiteArchiveFileItem;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.entity.work.reform.param.RiskListSearch;
import cn.smarthse.modules.health.entity.work.shield.ProtectEquipIssueRecord;
import cn.smarthse.modules.health.enums.archive.ArchiveType;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.enums.thirdtime.TsProjectPhraseEnum;
import cn.smarthse.modules.health.enums.thirdtime.TsProjectTypeEnum;
import cn.smarthse.modules.health.model.litearchive.ArchiveFileItemUpdateParam;
import cn.smarthse.modules.health.pojo.Archive4ExtraModel;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveFileItemService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveFilePersonalService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.service.work.shield.IProtectEquipIssueRecordDetailService;
import cn.smarthse.modules.health.vo.litearchive.LiteArchiveFileDetailVo;
import cn.smarthse.modules.health.vo.litearchive.LiteArchiveVo;
import cn.smarthse.modules.health.vo.litearchive.TsLiteArchiveVo;
import cn.smarthse.modules.health.vo.litearchive.ZjArchiveCountView;
import cn.smarthse.services.hfi.api.model.list.CheckPlanList;
import cn.smarthse.services.hfi.api.model.list.CheckPlanListParam;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.invoke.CallSite;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.redisson.api.RLock;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/liteArchive"})
public class LiteArchiveController
extends ControllerSupport {
    @DubboReference
    private ILiteArchiveService liteArchiveService;
    @DubboReference
    private ILiteArchiveFilePersonalService liteArchiveFilePersonalService;
    @DubboReference
    private ILiteArchiveFileItemService archiveFileItemService;
    @DubboReference
    private ICheckPlanService hazardCheckPlanService;
    @DubboReference
    private IReformItemBasicService reformItemBasicService;
    @DubboReference
    private IProtectEquipIssueRecordDetailService protectEquipIssueRecordDetailService;
    @DubboReference(check=false)
    private IBusinessDataUpdateRefreshService refreshService;

    @Log(title="\u6863\u6848\u7ba1\u7406\u9996\u9875", type=2)
    @RequiresPermissions(value={"doc.menu"})
    @RequestMapping(method={RequestMethod.GET})
    public String page_archiveIndex(HttpServletRequest request, HttpServletResponse response, Model model) {
        this.logger.info("\u6863\u6848\u7ba1\u7406\u9996\u9875");
        model.addAttribute("archiveList", (Object)ArchiveType.values());
        return "/archive/archive-home";
    }

    @RequestMapping(value={"/index"}, method={RequestMethod.GET})
    public String index(Integer archiveType, Model model) {
        boolean iscompliance;
        Long companyId = UserUtils.getLoginStaffCompanyId();
        Long complianceCompany = this.liteArchiveService.isComplianceCompany(companyId);
        Long loginStaffId = UserUtils.getLoginStaffId();
        boolean bl = iscompliance = complianceCompany != null;
        if (archiveType.equals(1)) {
            model.addAttribute("tsprojecttype", (Object)JsonMapper.toJsonString((Object)TsProjectTypeEnum.getAllValues()));
            List tsprojectPhrase = TsProjectPhraseEnum.getAllValues(t -> t.getCode() != 4);
            model.addAttribute("tsprojectPhrase", (Object)JsonMapper.toJsonString((Object)tsprojectPhrase));
            return "views/keyFactorManagement/liteArchive/ts/tsindex";
        }
        if (archiveType.equals(6)) {
            new Thread(() -> {
                LiteArchiveController liteArchiveController = this;
                synchronized (liteArchiveController) {
                    this.liteArchiveFilePersonalService.addPersonalArchiveByCid(null, companyId, loginStaffId, null);
                }
            }).start();
            model.addAttribute("iscompliance", (Object)iscompliance);
            return "views/keyFactorManagement/liteArchive/liteArchiveDetailPersonal";
        }
        model.addAttribute("archiveType", (Object)archiveType);
        model.addAttribute("title", (Object)this.getArchiveTitleByType(archiveType));
        model.addAttribute("compliance", (Object)iscompliance);
        if (archiveType.equals(5)) {
            LiteArchive doc5 = this.liteArchiveService.getFirstArchive5ByCid(companyId, UserUtils.getLoginStaffId());
            return "forward:/liteArchive/detail?id=" + doc5.getId() + "&iscompliance=" + iscompliance;
        }
        return "views/keyFactorManagement/liteArchive/liteArchiveIndex";
    }

    @RequestMapping(value={"/data.json"})
    @ResponseBody
    public JqGridData<LiteArchiveVo> data(JqGridParam jqGridParam, Integer archiveType, boolean iscompliance) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        PageInfo pageInfo = this.liteArchiveService.queryVoPage(jqGridParam, cid, archiveType, iscompliance);
        return new JqGridData(pageInfo, jqGridParam);
    }

    @RequestMapping(value={"/tslistdata"})
    @ResponseBody
    public JqGridData<TsLiteArchiveVo> tslistdata(JqGridParam jqGridParam, String kw) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        PageInfo pageInfo = this.liteArchiveService.pageTsLiteArchiveVo(jqGridParam, kw, cid);
        return new JqGridData(pageInfo, jqGridParam);
    }

    @RequestMapping(value={"/detail"})
    public String detail(Long id, Model model, Boolean iscompliance) {
        LiteArchive liteArchive;
        if (iscompliance == null) {
            iscompliance = false;
        }
        if ((liteArchive = (LiteArchive)this.liteArchiveService.getById(id)) == null) {
            throw new RuntimeException("\u6863\u6848\u4e0d\u5b58\u5728");
        }
        model.addAttribute("id", (Object)id);
        Long cid = UserUtils.getLoginStaffCompanyId();
        model.addAttribute("archive4ExtraModel", (Object)JSON.toJSONString((Object)new Archive4ExtraModel(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteBigDecimalAsPlain, SerializerFeature.UseSingleQuotes, SerializerFeature.WriteNullStringAsEmpty}));
        if (Integer.valueOf("1").equals(liteArchive.getArchiveType())) {
            model.addAttribute("title", (Object)liteArchive.getTitle());
        } else {
            model.addAttribute("title", (Object)this.getArchiveTitleByType(liteArchive.getArchiveType()));
        }
        model.addAttribute("liteArchive", (Object)liteArchive);
        model.addAttribute("iscompliance", (Object)iscompliance);
        if (Objects.equals(liteArchive.getArchiveType(), 2) || Objects.equals(liteArchive.getArchiveType(), 3) || Objects.equals(liteArchive.getArchiveType(), 4)) {
            String title = liteArchive.getTitle();
            model.addAttribute("archiveYear", StringUtils.isNumber((String)title) ? title + "\u5e74" : title);
        }
        model.addAttribute("archiveEditSec", (Object)UserUtils.hasPermissionCode("recordFile." + liteArchive.getArchiveType() + ".edit"));
        if (Objects.equals(ArchiveType.Archive4.getType(), liteArchive.getArchiveType().byteValue())) {
            Archive4ExtraModel archive4ExtraModel = null;
            if (StringUtils.isNotBlank((CharSequence)liteArchive.getExtraJson())) {
                archive4ExtraModel = (Archive4ExtraModel)JSON.parseObject((String)liteArchive.getExtraJson(), Archive4ExtraModel.class);
            }
            if (archive4ExtraModel == null) {
                ProtectEquipIssueRecord protectEquipIssueRecordData;
                archive4ExtraModel = new Archive4ExtraModel();
                int year = StringUtils.isNumber((String)liteArchive.getTitle()) ? Integer.parseInt(liteArchive.getTitle()) : 2022;
                Long getLastCheckDataId = this.getCheckPlanIdByYear2(year);
                archive4ExtraModel.setCheckId(getLastCheckDataId);
                if (Objects.isNull(getLastCheckDataId)) {
                    ReformItemBasic isFinished = this.getRiskResolutionCheckPlanIsFinished();
                    archive4ExtraModel.setRiskId(isFinished.getId());
                    if (Objects.nonNull(isFinished)) {
                        Byte status = isFinished.getStatus();
                        archive4ExtraModel.setReformStatus(status);
                        if (status != null && (status == 3 || status == 4 || status == 5)) {
                            archive4ExtraModel.setReformFinish(true);
                        }
                    }
                }
                ProtectEquipIssueRecord param = new ProtectEquipIssueRecord();
                param.setCid(cid);
                param.setBeginTime(DateUtils.getYearFirstTime((int)year));
                List protectEquipIssueRecordDatas = this.protectEquipIssueRecordDetailService.getDataTypeForArchive(param);
                if (CollectionUtils.isNotEmpty((Collection)protectEquipIssueRecordDatas) && (protectEquipIssueRecordData = (ProtectEquipIssueRecord)protectEquipIssueRecordDatas.get(0)) != null) {
                    archive4ExtraModel.setEquipIssueId(protectEquipIssueRecordData.getId());
                }
            }
            model.addAttribute("archive4ExtraModel", (Object)JSON.toJSONString((Object)archive4ExtraModel, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteBigDecimalAsPlain, SerializerFeature.UseSingleQuotes, SerializerFeature.WriteNullStringAsEmpty}));
        }
        if (Objects.equals(ArchiveType.Archive3.getType(), liteArchive.getArchiveType().byteValue())) {
            // empty if block
        }
        if (Objects.equals(ArchiveType.Archive1.getType(), liteArchive.getArchiveType().byteValue())) {
            List<Long> fileNameIdList = Arrays.asList(104L, 105L, 106L, 107L, 109L, 110L, 102L);
            ArchiveFileItemUpdateParam param = new ArchiveFileItemUpdateParam();
            param.setArchiveId(liteArchive.getId());
            this.archiveFileItemService.judgeAndUpdateArchiveFilteItemDataState(param, fileNameIdList);
        }
        if (Objects.equals(ArchiveType.Archive5.getType(), liteArchive.getArchiveType().byteValue())) {
            String info;
            ZjArchiveCountView view = new ZjArchiveCountView();
            String year = "" + DateUtil.getYear();
            Map map = this.liteArchiveService.getDoc5FileIdsStatus(view, cid, Boolean.valueOf(false));
            if (!map.keySet().isEmpty()) {
                info = this.getComleteStatus(map);
                model.addAttribute("info", (Object)info);
                model.addAttribute("doc5", (Object)true);
            }
            if (iscompliance.booleanValue() && !(map = this.liteArchiveService.getDoc5FileIdsStatus(view, cid, Boolean.valueOf(true))).keySet().isEmpty()) {
                info = this.getComleteStatus(map);
                model.addAttribute("complianceCompleteStatus", (Object)info);
                model.addAttribute("doc5", (Object)true);
            }
        }
        return "views/keyFactorManagement/liteArchive/liteArchiveDetail";
    }

    private String getComleteStatus(Map<String, Integer> map) {
        Integer finsihNum = map.get("finsihNum");
        Integer totalNum = map.get("totalNum");
        Object info = "";
        info = finsihNum == 0 ? "\u3010\u672a\u5b8c\u5584 0/" + totalNum + "\u3011" : (finsihNum < totalNum ? "\u3010\u672a\u5b8c\u5584 " + finsihNum + "/" + totalNum + "\u3011" : "\u3010\u5df2\u5b8c\u5584\u3011");
        return info;
    }

    public ReformItemBasic getRiskResolutionCheckPlanIsFinished() {
        JqGridParam jparam = new JqGridParam();
        jparam.setRows(1);
        jparam.setPage(1);
        RiskListSearch search = new RiskListSearch();
        search.setCid(UserUtils.getLoginStaffCompanyId());
        search.setSearchSource(Integer.valueOf(14));
        return this.reformItemBasicService.getRiskListDataToArchive(jparam, search, Boolean.valueOf(false));
    }

    public Long getCheckPlanIdByYear(Integer checkYear) {
        PageInfo list;
        List rst;
        JqGridParam jparam = new JqGridParam();
        jparam.setRows(Integer.MAX_VALUE);
        jparam.setPage(1);
        CheckPlanListParam hc = new CheckPlanListParam();
        hc.setCid(UserUtils.getLoginStaffCompanyId());
        hc.setCheckTypes(Arrays.asList(2, 3, 4));
        if (Objects.nonNull(checkYear)) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(DateUtils.getYearFirstTime((int)checkYear));
            cal.add(1, -3);
            hc.setCheckDateBegin(cal.getTime());
            hc.setCheckDateEnd(DateUtils.getYearLastTime((int)checkYear));
        }
        return CollUtil.isNotEmpty((Collection)(rst = (list = this.hazardCheckPlanService.getCheckPlanPage(jparam, hc, Boolean.valueOf(false))).getList())) && rst.size() > 0 ? rst.stream().max(Comparator.comparing(CheckPlanList::getCheckBeginTime)).get().getId() : null;
    }

    public Long getCheckPlanIdByYear2(Integer checkYear) {
        CheckPlanListParam hc = new CheckPlanListParam();
        hc.setCid(UserUtils.getLoginStaffCompanyId());
        hc.setCheckTypes(Arrays.asList(2, 3, 4));
        if (Objects.nonNull(checkYear)) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(DateUtils.getYearFirstTime((int)checkYear));
            cal.add(1, -3);
            hc.setCheckDateBegin(cal.getTime());
            hc.setCheckDateEnd(DateUtils.getYearLastTime((int)checkYear));
        }
        return this.hazardCheckPlanService.getCheckPlanIdBySearch(hc);
    }

    @RequestMapping(value={"/detailData.json"})
    @ResponseBody
    public JqGridData<LiteArchiveFileDetailVo> detailData(Long id, Long staffId, JqGridParam jqGridParam, Boolean iscompliance) {
        if (iscompliance == null) {
            iscompliance = false;
        }
        jqGridParam.setCid(UserUtils.getLoginStaffCompanyId());
        PageInfo pageInfo = this.archiveFileItemService.queryDetail(jqGridParam, id, staffId, iscompliance);
        return new JqGridData(pageInfo, jqGridParam);
    }

    @RequestMapping(value={"/detailDataList"})
    @ResponseBody
    public ResponseData<List<LiteArchiveFileDetailVo>> detailDataList(Long id) {
        ResponseData responseDatas = new ResponseData();
        List list = this.archiveFileItemService.queryDetailList(id);
        responseDatas.setResult((Object)list);
        return responseDatas;
    }

    @RequestMapping(value={"/updateArchiveFiles"})
    @ResponseBody
    public ResponseData<Long> updateArchiveFiles(ArchiveFileItemUpdateParam param) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        param.setStaffId(loginStaffId);
        Long itemId = this.archiveFileItemService.updateArchiveFiles(param);
        List<Long> fileNameIdList = Arrays.asList(104L, 105L, 106L, 107L, 109L, 110L, 102L);
        boolean archive1 = fileNameIdList.contains(param.getFileNameId());
        if (archive1) {
            this.archiveFileItemService.judgeAndUpdateArchiveFilteItemDataState(param, fileNameIdList);
        }
        ResponseData data = new ResponseData();
        data.setResult((Object)itemId);
        try {
            Long cid = UserUtils.getLoginStaffCompanyId();
            this.reformItemBasicService.changeStatusByCidAndGenerationSource(cid, ReformGenerationSourceEnum.ARCHIVES.getValue(), Byte.valueOf((byte)3), loginStaffId, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("\u6863\u6848\u81ea\u52a8\u9a8c\u6536\u5931\u8d25\uff0c\u62a5\u9519\u65b9\u6cd5\uff1acn.smarthse.web.controller.litearchive.LiteArchiveController.updateArchiveFiles");
        }
        return data;
    }

    @RequestMapping(value={"/updateStorageLocation"})
    @ResponseBody
    public ResponseData<String> updateStorageLocation(LiteArchiveFileItem item) {
        ResponseData data = new ResponseData();
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        this.archiveFileItemService.updateStorageLocation(item, loginStaffId);
        HashMap<CallSite, String> params = new HashMap<CallSite, String>();
        if (item.getFileNameId() != null && item.getFileNameId().equals(605L)) {
            params.put((CallSite)((Object)(ComplianceCodeEnum.CODE14.getCode() + ":archiveTypeStr")), "6");
            this.refreshService.addBusinessDataUpdateMsg(cid, params, new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE14});
        } else {
            LiteArchive archive;
            LiteArchiveFileItem dbItemData;
            Long liteArchiveId = item.getLiteArchiveId();
            if (liteArchiveId == null && (dbItemData = (LiteArchiveFileItem)this.archiveFileItemService.getById(item.getId())) != null) {
                liteArchiveId = dbItemData.getLiteArchiveId();
            }
            if ((archive = (LiteArchive)this.liteArchiveService.getById(liteArchiveId)) != null) {
                params.put((CallSite)((Object)(ComplianceCodeEnum.CODE14.getCode() + ":archiveTypeStr")), String.valueOf(archive.getArchiveType()));
                this.refreshService.addBusinessDataUpdateMsg(cid, params, new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE14});
            }
        }
        data.setResult((Object)"\u4fdd\u5b58\u6210\u529f");
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/updateCreateFile"})
    @ResponseBody
    public ResponseData<String> updateCreateFile(Long liteArchiveId) throws InterruptedException {
        LiteArchive liteArchive = new LiteArchive();
        liteArchive.setId(liteArchiveId);
        liteArchive.setProcStatus(Integer.valueOf(1));
        Long loginStaffId = UserUtils.getLoginStaffId();
        RLock lock = this.redissonClient.getLock("liteArchive:updateCreateFile:" + liteArchiveId);
        if (lock.tryLock(0L, 60L, TimeUnit.SECONDS)) {
            this.liteArchiveService.update((Object)liteArchive, loginStaffId);
            try {
                this.archiveFileItemService.autoRefreshCreateFileItems(liteArchiveId);
                Long cid = UserUtils.getLoginStaffCompanyId();
                this.reformItemBasicService.changeStatusByCidAndGenerationSource(cid, ReformGenerationSourceEnum.ARCHIVES.getValue(), Byte.valueOf((byte)3), loginStaffId, null);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.info("\u6863\u6848\u81ea\u52a8\u9a8c\u6536\u5931\u8d25\uff0c\u62a5\u9519\u65b9\u6cd5\uff1acn.smarthse.web.controller.litearchive.LiteArchiveController.updateCreateFile");
                ResponseData responseData = new ResponseData("\u6863\u6848\u66f4\u65b0\u5931\u8d25\uff01");
                return responseData;
            }
            finally {
                liteArchive.setProcStatus(Integer.valueOf(0));
                this.liteArchiveService.update((Object)liteArchive, UserUtils.getLoginStaffId());
                lock.unlock();
            }
        } else {
            return new ResponseData("\u6863\u6848\u6b63\u5728\u66f4\u65b0\u4e2d...\u8bf7\u7a0d\u540e\uff01");
        }
        return new ResponseData("\u8be5\u6863\u6848\u5df2\u66f4\u65b0\uff01");
    }

    private String getArchiveTitleByType(Integer archiveType) {
        switch (archiveType) {
            case 1: {
                return "\u5efa\u8bbe\u9879\u76ee\u804c\u4e1a\u536b\u751f\u201c\u4e09\u540c\u65f6\u201d\u6863\u6848";
            }
            case 2: {
                return "\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u6863\u6848";
            }
            case 3: {
                return "\u804c\u4e1a\u536b\u751f\u5ba3\u4f20\u57f9\u8bad\u6863\u6848";
            }
            case 4: {
                return "\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u76d1\u6d4b\u4e0e\u68c0\u6d4b\u8bc4\u4ef7\u6863\u6848";
            }
            case 5: {
                return "\u7528\u4eba\u5355\u4f4d\u804c\u4e1a\u5065\u5eb7\u76d1\u62a4\u7ba1\u7406\u6863\u6848";
            }
            case 6: {
                return "\u52b3\u52a8\u8005\u4e2a\u4eba\u804c\u4e1a\u5065\u5eb7\u76d1\u62a4\u6863\u6848";
            }
        }
        return "";
    }

    @RequestMapping(value={"/mergeData"})
    @ResponseBody
    public ResponseData<String> mergeData(Long id, JqGridParam jqGridParam) {
        ResponseData data = new ResponseData();
        this.archiveFileItemService.mergeData();
        return data;
    }

    @RequestMapping(value={"/mergeYearData"})
    @ResponseBody
    public ResponseData<String> mergeYearData(Long id, JqGridParam jqGridParam) {
        ResponseData data = new ResponseData();
        this.archiveFileItemService.mergeYearData();
        return data;
    }
}

