/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.information;

import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrgInfo;
import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrgInfoDic;
import cn.smarthse.modules.health.thirdOrganization.model.org.OrgQueryParamModel;
import cn.smarthse.modules.health.thirdOrganization.model.org.SuperviseOrgListVo;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrgInfoDicService;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrgInfoService;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrganizationService;
import com.github.pagehelper.PageInfo;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/thirdOrgInfo"})
public class ThirdOrgController {
    @DubboReference
    private IThirdOrganizationService thirdOrganizationService;
    @DubboReference
    private IThirdOrgInfoService thirdOrgInfoService;
    @DubboReference
    private IThirdOrgInfoDicService orgInfoDicService;

    @RequestMapping(value={"/index"})
    public String index() {
        return "information/org/index";
    }

    @RequestMapping(value={"org.json"})
    @ResponseBody
    public PageInfo<SuperviseOrgListVo> org(OrgQueryParamModel param) {
        param.setLoginUserAreaId(Long.valueOf(0L));
        param.setIsEnable(Boolean.valueOf(true));
        param.setIsValid(Boolean.valueOf(true));
        param.setTestData(Boolean.valueOf(false));
        param.setBusinessStatus(Byte.valueOf((byte)1));
        return this.thirdOrganizationService.queryPageAndServiceRange(param);
    }

    @RequestMapping(value={"detail"})
    public String detail(ModelMap m, Long id) {
        OrgQueryParamModel param = new OrgQueryParamModel();
        param.setLoginUserAreaId(Long.valueOf(0L));
        param.setIsEnable(Boolean.valueOf(true));
        param.setIsValid(Boolean.valueOf(true));
        param.setTestData(Boolean.valueOf(false));
        param.setPage(Integer.valueOf(1));
        param.setRows(Integer.valueOf(1));
        LinkedList<Long> ids = new LinkedList<Long>();
        ids.add(id);
        param.setOrgIds(ids);
        PageInfo page = this.thirdOrganizationService.queryPageAndServiceRange(param);
        SuperviseOrgListVo vo = (SuperviseOrgListVo)page.getList().get(0);
        m.addAttribute("org", (Object)vo);
        m.addAttribute("typeNames", (Object)this.getTypeNames(vo));
        m.addAttribute("isExam", (Object)(vo.getOrgTypes() != null && vo.getOrgTypes().contains("2") ? 1 : 0));
        m.addAttribute("isDetection", (Object)(vo.getOrgTypes() != null && vo.getOrgTypes().contains("1") ? 1 : 0));
        m.addAttribute("isDiagnose", (Object)(vo.getOrgTypes() != null && (vo.getOrgTypes().contains("4") || vo.getOrgTypes().contains("8")) ? 1 : 0));
        this.setDicInfoMsg(m, vo);
        return "information/org/detail";
    }

    private void setDicInfoMsg(ModelMap m, SuperviseOrgListVo vo) {
        if (vo.getOrgTypes() == null) {
            return;
        }
        List all = this.orgInfoDicService.getAll();
        HashMap<Long, ThirdOrgInfoDic> map = new HashMap<Long, ThirdOrgInfoDic>();
        for (ThirdOrgInfoDic dic : all) {
            map.put(dic.getId(), dic);
        }
        List list = this.thirdOrgInfoService.getByOrg(vo.getId());
        if (vo.getOrgTypes().contains("1")) {
            StringBuilder serviceRange = new StringBuilder();
            StringBuilder serveRange = new StringBuilder();
            for (ThirdOrgInfo orgInfo : list) {
                ThirdOrgInfoDic dic = (ThirdOrgInfoDic)map.get(orgInfo.getInfoDicId());
                if (dic == null) continue;
                Integer type = dic.getType();
                if (type.equals(101) || type.equals(102)) {
                    serviceRange.append(dic.getName());
                    serviceRange.append(" ");
                }
                if (!type.equals(200)) continue;
                serveRange.append(dic.getName());
                String value = orgInfo.getValue();
                if ("1".equals(value)) {
                    serveRange.append("\uff08\u4e0d\u542b\u653e\u5c04\uff09");
                }
                if ("2".equals(value)) {
                    serveRange.append("\uff08\u542b\u653e\u5c04\uff09");
                }
                if (!"3".equals(value)) continue;
                serveRange.append("\uff08\u4ec5\u9650\u653e\u5c04\uff09");
            }
            m.addAttribute("serviceRange", (Object)serviceRange.toString());
            m.addAttribute("serveRange", (Object)serveRange.toString());
        }
    }

    private String getTypeNames(SuperviseOrgListVo vo) {
        StringBuilder sb = new StringBuilder();
        String orgTypes = vo.getOrgTypes();
        if (orgTypes == null) {
            return "";
        }
        if (orgTypes.contains("1")) {
            sb.append("\u6280\u672f\u670d\u52a1\u673a\u6784");
        }
        if (orgTypes.contains("2")) {
            sb.append(" \u4f53\u68c0\u673a\u6784");
        }
        if (orgTypes.contains("4") || orgTypes.contains("8")) {
            sb.append(" \u8bca\u65ad\u9274\u5b9a\u673a\u6784");
        }
        return sb.toString();
    }
}

