/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.information;

import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.entity.information.BigText;
import cn.smarthse.modules.health.entity.information.Information;
import cn.smarthse.modules.health.pojo.information.InformationQueryParam;
import cn.smarthse.modules.health.service.information.IBigTextService;
import cn.smarthse.modules.health.service.information.IInformationService;
import com.github.pagehelper.PageInfo;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/information"})
public class InformationController {
    @DubboReference
    private IInformationService informationService;
    @DubboReference(timeout=5000000)
    private ISysFileProvideService fileProvideService;
    @DubboReference
    private IBigTextService textService;
    private List<Long> infoIds = new LinkedList<Long>();

    @RequestMapping(value={"/index"})
    public String index() {
        return "information/index";
    }

    @RequestMapping(value={"information.json"})
    @ResponseBody
    public PageInfo<Information> informationList(InformationQueryParam param) {
        param.setStatus(Integer.valueOf(3));
        PageInfo page = this.informationService.page(param);
        this.infoIds.clear();
        this.infoIds.addAll(this.informationService.getQueryAllIds(param));
        this.setImgUrl(page.getList());
        return page;
    }

    @RequestMapping(value={"detail"})
    public String detail(ModelMap m, Long id) {
        Information info = (Information)this.informationService.getById(id);
        this.informationService.addClickNum(id, 1);
        BigText text = (BigText)this.textService.getById(info.getTextId());
        m.addAttribute("info", (Object)info);
        m.addAttribute("text", (Object)text);
        String preId = this.getPreId(id);
        String nextId = this.getNextId(id);
        if (!preId.isEmpty()) {
            Information pre = (Information)this.informationService.getById(Long.valueOf(Long.parseLong(preId)));
            m.addAttribute("pre", (Object)pre);
        }
        if (!nextId.isEmpty()) {
            Information next = (Information)this.informationService.getById(Long.valueOf(Long.parseLong(nextId)));
            m.addAttribute("next", (Object)next);
        }
        m.addAttribute("preId", (Object)preId);
        m.addAttribute("nextId", (Object)nextId);
        return "information/detail";
    }

    private String getNextId(Long id) {
        for (int i = 0; i < this.infoIds.size(); ++i) {
            if (!this.infoIds.get(i).equals(id) || i >= this.infoIds.size() - 1) continue;
            return String.valueOf(this.infoIds.get(i + 1));
        }
        return "";
    }

    private String getPreId(Long id) {
        for (int i = 0; i < this.infoIds.size(); ++i) {
            if (!this.infoIds.get(i).equals(id) || i <= 0) continue;
            return String.valueOf(this.infoIds.get(i - 1));
        }
        return "";
    }

    private void setImgUrl(List<Information> list) {
        List imgIds = list.stream().map(Information::getSurfaceImgId).collect(Collectors.toList());
        if (imgIds.isEmpty()) {
            return;
        }
        List files = this.fileProvideService.getListByIds(imgIds);
        if (files == null) {
            return;
        }
        HashMap<Long, String> idToUrlMap = new HashMap<Long, String>();
        for (SysFileModel file : files) {
            idToUrlMap.put(file.getId(), file.getFullOssurl());
        }
        for (Information information : list) {
            information.setSurfaceImgUrl((String)idToUrlMap.get(information.getSurfaceImgId()));
        }
    }
}

