/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.home;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.health.company.model.CompanyPopupReminder;
import cn.smarthse.modules.health.company.model.vo.CompanyPopupVo;
import cn.smarthse.modules.health.company.service.ICompanyPopupReminderService;
import cn.smarthse.modules.health.compliance.enums.ComplianceInfoStatusEnum;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyInfoService;
import cn.smarthse.modules.health.entity.work.reform.param.RiskListSearch;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyInfo;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyInfoService;
import cn.smarthse.modules.health.service.work.reform.ICompanyRiskProspectService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.vo.work.keyFactory.HealthManagementArchiveVo;
import cn.smarthse.modules.health.vo.work.keyFactory.KeyFactoryStateVo;
import cn.smarthse.modules.health.vo.work.keyFactory.ThreeTimeDetailVo;
import cn.smarthse.modules.health.vo.work.reform.RiskLevelVo;
import cn.smarthse.modules.health.vo.work.reform.RiskTypeVo;
import cn.smarthse.township.manage.model.vo.company.CompanyTownShipIndexVo;
import cn.smarthse.township.manage.provider.company.IPatrolToCompanyProviderService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/visualHomePage"})
public class VisualHomePageController
extends ControllerSupport {
    @DubboReference
    private IReformItemBasicService reformItemBasicService;
    @DubboReference
    private IPatrolToCompanyProviderService patrolToCompanyProviderService;
    @DubboReference
    private ICompanyPopupReminderService companyPopupReminderService;
    @Autowired
    private IComplianceCompanyInfoService complianceCompanyInfoService;
    @Autowired
    private INewComplianceCompanyInfoService newComplianceCompanyInfoService;
    @DubboReference(version="1.0.0")
    private ICompanyRiskProspectService companyRiskProspectService;

    @GetMapping(value={"/townshipAssistanceData"})
    @ResponseBody
    public ResponseData<CompanyTownShipIndexVo> getTownshipAssistanceData() {
        CompanyTownShipIndexVo town = this.patrolToCompanyProviderService.getTownshipAssistanceData(UserUtils.getLoginStaffCompanyId());
        return new ResponseData((Object)town);
    }

    @GetMapping(value={"/keyFactorPortrait"})
    @ResponseBody
    public ResponseData<List<KeyFactoryStateVo>> getKeyFactorPortraitDataList() {
        List keyList = this.reformItemBasicService.getKeyFactorPortraitDataListNew(UserUtils.getLoginStaffCompanyId());
        return new ResponseData((Object)keyList);
    }

    @GetMapping(value={"/threeTimeDetail"})
    @ResponseBody
    public ResponseData<ThreeTimeDetailVo> getThreeTimeProjDetails() {
        ThreeTimeDetailVo tsDetail = this.reformItemBasicService.getThreeTimeProjDetails(UserUtils.getLoginStaffCompanyId());
        return new ResponseData((Object)tsDetail);
    }

    @GetMapping(value={"/healthArchives"})
    @ResponseBody
    public ResponseData<List<HealthManagementArchiveVo>> getHealthManagementArchivesData() {
        List archiveList = this.reformItemBasicService.getHealthManagementArchivesData(UserUtils.getLoginStaffCompanyId());
        return new ResponseData((Object)archiveList);
    }

    @GetMapping(value={"/riskLevelListData"})
    @ResponseBody
    public ResponseData<List<RiskLevelVo>> getRiskLevelListData() {
        List levelList = this.reformItemBasicService.getRiskLevelListData(UserUtils.getLoginStaffCompanyId());
        return new ResponseData((Object)levelList);
    }

    @GetMapping(value={"/riskTypeListData"})
    @ResponseBody
    public ResponseData<List<RiskTypeVo>> getRiskTypeListData() {
        List typeList = this.reformItemBasicService.getRiskTypeListDataNew(UserUtils.getLoginStaffCompanyId());
        return new ResponseData((Object)typeList);
    }

    @GetMapping(value={"/shouldShowPopup"})
    @ResponseBody
    public ResponseData<Boolean> shouldShowPopup() {
        return ResponseData.success((Object)this.companyPopupReminderService.shouldShowPopup(UserUtils.getLoginStaffCompanyId()));
    }

    @PostMapping(value={"/updateReminderTime"})
    @ResponseBody
    public ResponseData<Boolean> updateReminderTime(@RequestBody CompanyPopupReminder entity) {
        entity.setCid(UserUtils.getLoginStaffCompanyId());
        this.companyPopupReminderService.updateReminderTime(entity);
        return ResponseData.success();
    }

    @ResponseBody
    @GetMapping(value={"/getCompanyPopup"})
    public ResponseData<CompanyPopupVo> getCompanyPopup() {
        Long cid = UserUtils.getLoginStaffCompanyId();
        CompanyPopupVo vo = new CompanyPopupVo();
        List categoryList = this.companyPopupReminderService.getCategoryInfoByCid(cid);
        if (categoryList == null || CollectionUtils.isEmpty((Collection)categoryList)) {
            vo.setCategoryDisplay(Boolean.valueOf(false));
        } else {
            vo.setCategoryDisplay(Boolean.valueOf(true));
            vo.setCategoryDetails(categoryList);
        }
        JqGridParam param = new JqGridParam();
        param.setRows(Integer.MAX_VALUE);
        RiskListSearch search = new RiskListSearch();
        search.setPushDate("2025\u5e74");
        search.setSearchStatus(Byte.valueOf((byte)7));
        search.setCid(cid);
        PageInfo page = this.reformItemBasicService.getRiskListDataPage(param, search, Boolean.valueOf(true), Integer.valueOf(6));
        if (page == null || page.getList() == null) {
            vo.setRiskDisplay(Boolean.valueOf(false));
        } else {
            List reformList = page.getList();
            vo.setRiskDisplay(Boolean.valueOf(true));
            vo.setRiskDetails(reformList);
        }
        NewComplianceCompanyInfo compliance = this.newComplianceCompanyInfoService.getLastByCid(cid);
        if (compliance == null || Objects.equals(ComplianceInfoStatusEnum.COMPLIANT.getKey(), compliance.getStatus())) {
            vo.setComplianceDisplay(Boolean.valueOf(false));
        } else {
            vo.setComplianceDisplay(Boolean.valueOf(true));
            vo.setCompliance(compliance);
        }
        try {
            List companyTips = this.companyRiskProspectService.getCompanyTips(cid, Integer.valueOf(3));
            if (companyTips == null || companyTips.isEmpty()) {
                vo.setCompanyTipsDisplay(Boolean.valueOf(false));
            } else {
                vo.setCompanyTipsDisplay(Boolean.valueOf(true));
                vo.setCompanyTips(companyTips);
            }
        }
        catch (RuntimeException e) {
            this.logger.error(e.getMessage());
            return ResponseData.fail((String)"\u524d\u77bb\u6570\u636e\u83b7\u53d6\u5931\u8d25");
        }
        return ResponseData.success((Object)vo);
    }
}

