/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.home;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.MD5Utils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.model.system.riskFactors.HarmFactor;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.modules.health.onlineMonitoring.entity.device.OnlineMonitorDeviceFactor;
import cn.smarthse.modules.health.onlineMonitoring.service.device.IOnlineMonitorDeviceFactorService;
import cn.smarthse.modules.health.onlineMonitoring.service.device.IOnlineMonitorWarningService;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineDevice;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineDeviceAlarm;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineDeviceAlarmLog;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineDeviceSceneConfig;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineMonitoringBigDataCountVo;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineMonitoringDataVo;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineMonitoringOverDataVo;
import cn.smarthse.modules.health.supervise.enums.onlinedevice.DataTypeEnum;
import cn.smarthse.modules.health.supervise.model.OnlineDeviceParam;
import cn.smarthse.modules.health.supervise.model.home.v3223.onlineMonitoring.MonitorCompanyVo;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IOnlineDeviceAlarmLogService;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IOnlineDeviceAlarmService;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IOnlineDeviceSceneConfigService;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IOnlineDeviceService;
import cn.smarthse.modules.health.supervise.vo.onlineMonitoring.OnlineDeviceAlaramSearchVo;
import cn.smarthse.modules.health.supervise.vo.onlineMonitoring.OnlineMonitoringSearchVo;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/onlineMonitor"})
public class OnlineMonitoringController
extends ControllerSupport {
    @DubboReference
    private IOnlineDeviceService onlineDeviceService;
    @DubboReference
    private IOnlineDeviceAlarmService alarmService;
    @DubboReference
    private IOnlineDeviceAlarmLogService alarmLogService;
    @DubboReference(timeout=5000000)
    private ISysFileProvideService fileProvideService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService areaService;
    @DubboReference
    IOnlineDeviceSceneConfigService configService;
    @DubboReference(version="1.0.0")
    private IHarmFactorService harmFactorService;
    @DubboReference
    private IOnlineMonitorDeviceFactorService onlineMonitorDeviceFactorService;
    @DubboReference(check=false)
    private IOnlineMonitorWarningService onlineMonitorWarningService;

    @RequestMapping(value={"/view"}, method={RequestMethod.GET})
    public String deviceView(Model model, String type, OnlineDeviceParam param) {
        List cameras;
        OnlineDevice device;
        List deviceList;
        if (type != null) {
            List collect;
            Long companyId = UserUtils.getLoginStaffCompanyId();
            deviceList = this.onlineDeviceService.getDeviceListInfoByCid(companyId);
            if (type.equals("camera")) {
                collect = deviceList.stream().filter(item -> StringUtils.contains((CharSequence)item.getType(), (CharSequence)"3")).collect(Collectors.toList());
                param.setId(((OnlineDevice)collect.get(0)).getId());
            }
            if (type.equals("device")) {
                collect = deviceList.stream().filter(item -> !"3".equalsIgnoreCase(item.getType()) && !"4".equalsIgnoreCase(item.getType())).collect(Collectors.toList());
                OnlineDevice device2 = (OnlineDevice)collect.get(0);
                param.setId(device2.getId());
                if ("1".equalsIgnoreCase(device2.getType())) {
                    param.setDataType(device2.getDataType());
                    param.setFactorId(device2.getFactorId());
                }
            }
        }
        if (!Objects.isNull((device = this.onlineDeviceService.getDeviceInfoByParam(param)).getVideoAddress())) {
            device.setLiveAddress(this.concatLive(device));
        }
        deviceList = this.onlineDeviceService.getDeviceListInfoByCid(device.getCid());
        for (OnlineDevice item2 : deviceList) {
            boolean flag;
            if (!item2.getType().equals("1") || !(flag = this.onlineDeviceService.hasExitTwo(item2.getId()))) continue;
            HarmFactor harmFactor = this.harmFactorService.getThisById(item2.getFactorId());
            String deviceName = item2.getDataType().equals(DataTypeEnum.TOTAL_DUST.getCode()) ? harmFactor.getNameCh() + "-" + DataTypeEnum.TOTAL_DUST.getContent() : harmFactor.getNameCh() + "-" + DataTypeEnum.EXHALE_DUST.getContent();
            item2.setDeviceName(deviceName);
        }
        model.addAttribute("deviceList", (Object)deviceList);
        model.addAttribute("data", (Object)device);
        Company currentCompany = UserUtils.getCurrentCompany();
        model.addAttribute("company", (Object)currentCompany);
        String fullName = this.areaService.getFullName(currentCompany.getAreaId(), "");
        model.addAttribute("areaFullName", (Object)fullName);
        OnlineDeviceSceneConfig config = this.configService.getDeviceByDeviceId(param.getId());
        model.addAttribute("config", (Object)config);
        model.addAttribute("deviceIdStr", (Object)param.getId());
        model.addAttribute("deviceIdStr", (Object)param.getId());
        List list = this.onlineDeviceService.getDeviceListInfoByCid(device.getCid());
        List collect = list.stream().filter(item -> "3".equalsIgnoreCase(item.getType())).collect(Collectors.toList());
        for (Object onlineDevice : collect) {
            onlineDevice.setLiveAddress(this.concatLive((OnlineDevice)onlineDevice));
        }
        model.addAttribute("cameras", collect);
        if ("3".equalsIgnoreCase(device.getType())) {
            List devices = this.onlineDeviceService.getDevicesByCamera(param.getId());
            for (OnlineDevice onlineDevice : devices) {
                onlineDevice.setMonitorData(deviceList.stream().filter(s -> s.getId().equals(onlineDevice.getId())).findFirst().orElse(new OnlineDevice()).getMonitorData());
            }
            model.addAttribute("devices", (Object)devices);
            return "home/onlineMonitoring/deviceinfoCameraV310New";
        }
        HarmFactor harmFactor = this.harmFactorService.getThisById(device.getFactorId());
        if (!Objects.isNull(harmFactor)) {
            boolean flag;
            Object factorName = harmFactor.getNameCh();
            if (device.getType().equals((byte)1) && (flag = this.onlineDeviceService.hasExitTwo(param.getId()))) {
                model.addAttribute("dataType", (Object)device.getDataType());
                factorName = device.getDataType().equals(DataTypeEnum.TOTAL_DUST.getCode()) ? harmFactor.getNameCh() + "-" + DataTypeEnum.TOTAL_DUST.getContent() : harmFactor.getNameCh() + "-" + DataTypeEnum.EXHALE_DUST.getContent();
            }
            model.addAttribute("factorName", factorName);
        }
        if (CollectionUtils.isNotEmpty((Collection)(cameras = this.onlineDeviceService.getCamerasByDevice(param.getId())))) {
            model.addAttribute("camera", cameras.get(0));
        }
        return "home/onlineMonitoring/deviceInfoV310New";
    }

    @GetMapping(value={"/monitorDetails"})
    @ResponseBody
    public ResponseData<MonitorCompanyVo> getMonitorDetails() {
        Long cid = UserUtils.getLoginStaffCompanyId();
        MonitorCompanyVo result = this.onlineMonitorWarningService.getMonitorDetails(cid);
        return new ResponseData(ResponseStateEnum.success, null, (Object)result);
    }

    @RequestMapping(value={"/putTimePoint"})
    @ResponseBody
    public ResponseData<String> putTimePoint(String timePoint) {
        this.onlineMonitorWarningService.putTimePoint(timePoint);
        return new ResponseData(ResponseStateEnum.success);
    }

    private String concatLive(OnlineDevice device) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dataStr = sdf.format(new Date());
        String signCheck = MD5Utils.getMD5String((String)("appId=" + device.getAppId() + "&appSecret=" + device.getAppSecret() + "&deviceNo=" + device.getDeviceNo() + "&online=1&requestTime=" + dataStr));
        String liveAdreess = device.getVideoAddress() + "?appId=" + device.getAppId() + "&sign=" + signCheck + "&deviceNo=" + device.getDeviceNo() + "&online=1&requestTime=" + dataStr;
        return liveAdreess;
    }

    @RequestMapping(value={"/companyView"}, method={RequestMethod.GET})
    public String companyView(Model model) {
        Long companyId = UserUtils.getLoginStaffCompanyId();
        List deviceList = this.onlineDeviceService.getDeviceListInfoByCid(companyId);
        OnlineDevice device = new OnlineDevice();
        if (deviceList != null && deviceList.size() > 0) {
            device = (OnlineDevice)deviceList.get(0);
        }
        model.addAttribute("deviceList", (Object)deviceList);
        model.addAttribute("data", (Object)device);
        model.addAttribute("deviceIdStr", (Object)device.getId());
        if ("3".equalsIgnoreCase(device.getType())) {
            List devices = this.onlineDeviceService.getDevicesByCamera(device.getId());
            for (OnlineDevice onlineDevice : devices) {
                onlineDevice.setMonitorData(deviceList.stream().filter(s -> s.getId().equals(onlineDevice.getId())).findFirst().orElse(new OnlineDevice()).getMonitorData());
            }
            model.addAttribute("devices", (Object)devices);
            return "home/onlineMonitoring/deviceinfoCameraV310New";
        }
        List cameras = this.onlineDeviceService.getCamerasByDevice(device.getId());
        model.addAttribute("cameras", (Object)cameras);
        return "home/onlineMonitoring/deviceInfoV310New";
    }

    @RequestMapping(value={"/getDeviceAlarmInfo"})
    public String getDeviceAlarmInfo(Model model, OnlineDeviceAlaramSearchVo searchVo) {
        List collectVoList = this.alarmService.collectAlarmData(searchVo);
        model.addAttribute("collectVoList", (Object)collectVoList);
        return "home/onlineMonitoring/deviceInfoAlarmInfo";
    }

    @RequestMapping(value={"/showPic"})
    public String showPic(Model model, Long alarmId) {
        OnlineDeviceAlarm alarm = (OnlineDeviceAlarm)this.alarmService.getById(alarmId);
        if (alarm != null && StringUtils.isNotBlank((CharSequence)alarm.getPhotoIds())) {
            List sysFileModelList = this.fileProvideService.getListByIds(alarm.getPhotoIds());
            model.addAttribute("sysFileModelList", (Object)sysFileModelList);
        }
        return "home/onlineMonitoring/showPic";
    }

    @RequestMapping(value={"/getDeviceEnentInfo"})
    public String getDeviceEnentInfo(Model model, OnlineDeviceAlaramSearchVo searchVo) {
        List collectVoList = this.alarmService.collectAlarmData(searchVo);
        model.addAttribute("collectVoList", (Object)collectVoList);
        return "home/onlineMonitoring/deviceInfoEventInfo";
    }

    @RequestMapping(value={"/viewOld"}, method={RequestMethod.GET})
    public String viewOld(Model model, Long id, OnlineDeviceAlaramSearchVo searchVo) {
        OnlineDevice device = (OnlineDevice)this.onlineDeviceService.getById(id);
        List deviceList = this.onlineDeviceService.getDeviceListInfoByCid(device.getCid());
        model.addAttribute("deviceList", (Object)deviceList);
        model.addAttribute("data", (Object)device);
        List collectVoList = this.alarmService.collectAlarmData(searchVo);
        model.addAttribute("collectVoList", (Object)collectVoList);
        return "/home/onlineMonitoring/deviceInfo";
    }

    @RequestMapping(value={"/getDeviceMonitoringData"})
    @ResponseBody
    public List<OnlineMonitoringDataVo> getDeviceMonitoringData(OnlineMonitoringSearchVo vo) {
        if (vo.getBeginMonitorDate() == null) {
            Date date = new Date();
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.add(5, -2);
            vo.setBeginMonitorDate(cal.getTime());
            vo.setEndMonitorDate(date);
        }
        List list = this.onlineDeviceService.getDeviceDate(vo);
        return list;
    }

    @Log(title="\u7f16\u8f91\u5728\u7ebf\u76d1\u6d4b\u8bbe\u5907\u4fe1\u606f", type=21)
    @ResponseBody
    @RequestMapping(value={"/saveDeviceInfo"}, method={RequestMethod.POST})
    public ResponseData<OnlineDevice> saveKeyWorkViewSet(OnlineDevice info) {
        ResponseData data = new ResponseData();
        Long staffid = UserUtils.getLoginStaffId();
        this.onlineDeviceService.update((Object)info, staffid);
        data.setResult((Object)info);
        data.setContent("\u7f16\u8f91\u6210\u529f");
        return data;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"editDevice"})
    public String onlineMonitoring(ModelMap m, Long id) {
        OnlineDevice info = (OnlineDevice)this.onlineDeviceService.getById(id);
        m.put((Object)"data", (Object)info);
        return "/home/onlineMonitoring/deviceEdit";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"editThreshold"})
    public String editThreshold(ModelMap m, OnlineDeviceParam param) {
        OnlineMonitorDeviceFactor info = this.onlineMonitorDeviceFactorService.getWarnInfoByParam(param);
        HarmFactor factor = this.harmFactorService.getThisById(param.getFactorId());
        m.put((Object)"info", (Object)info);
        m.put((Object)"factor", (Object)factor);
        return "/home/onlineMonitoring/thresholdEdit";
    }

    @PostMapping(value={"/saveWarning"})
    @ResponseBody
    public ResponseData saveWarning(OnlineMonitorDeviceFactor info) {
        ResponseData data = new ResponseData();
        this.onlineMonitorDeviceFactorService.update((Object)info);
        data.setResult((Object)info);
        data.setContent("\u4fee\u6539\u6210\u529f");
        return data;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"editInstallation"})
    public String editInstallation(ModelMap m, Long id) {
        OnlineDevice info = (OnlineDevice)this.onlineDeviceService.getById(id);
        m.put((Object)"data", (Object)info);
        return "/home/onlineMonitoring/installationEdit";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"editPosition"})
    public String editPosition(ModelMap m, Long id) {
        OnlineDevice info = (OnlineDevice)this.onlineDeviceService.getById(id);
        m.put((Object)"data", (Object)info);
        return "/home/onlineMonitoring/positionEdit";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"deviceInfoAlarmLogInfo"})
    public String deviceInfoAlarmLogInfo(ModelMap m, Long alarmId) {
        Long deviceId;
        List camerasByDeviceList;
        m.put((Object)"alarmId", (Object)alarmId);
        OnlineDeviceAlarm deviceAlarm = (OnlineDeviceAlarm)this.alarmService.getById(alarmId);
        if (deviceAlarm != null && CollectionUtils.isNotEmpty((Collection)(camerasByDeviceList = this.onlineDeviceService.getCamerasByDevice(deviceId = deviceAlarm.getDeviceId())))) {
            m.put((Object)"hasCamera", (Object)true);
        }
        return "home/onlineMonitoring/deviceInfoAlarmLogInfo";
    }

    @Log(title="\u5728\u7ebf\u76d1\u6d4b-\u8be6\u60c5-\u62a5\u8b66\u65e5\u5fd7-\u62a5\u8b66\u60c5\u51b5", type=2)
    @RequestMapping(value={"/viewInfoAlarmLogListData"})
    @ResponseBody
    public JqGridData<OnlineDeviceAlarmLog> viewInfoAlarmLogListData(JqGridParam param, Long alarmId) {
        PageInfo alarmLogPageInfo = this.alarmLogService.pageAlarmLogDataByAlaramId(param, alarmId);
        JqGridData data = new JqGridData(alarmLogPageInfo, param);
        return data;
    }

    @RequestMapping(value={"/editSceneConfig"})
    public String editSceneConfig(Long id, OnlineDeviceSceneConfig config, String person, Model model) {
        if (config == null && id == null) {
            model.addAttribute("msg", (Object)"\u4f20\u5165\u503c\u4e3a\u7a7a");
            return "home/onlineMonitoring/deviceInfoV310New";
        }
        config.setAlarmPrompt(Long.valueOf(1L));
        String[] split = person.split(",");
        if (split.length == 1) {
            if (split[0].equals("1")) {
                config.setSmsAlartRecipient(Integer.valueOf(1));
            }
            if (split[0].equals("2")) {
                config.setSmsAlartRecipient(Integer.valueOf(2));
            }
        }
        if (split.length == 2) {
            config.setSmsAlartRecipient(Integer.valueOf(3));
        }
        config.setDeviceId(id);
        OnlineDeviceSceneConfig device = this.configService.getDeviceByDeviceId(id);
        if (device != null) {
            config.setId(device.getId());
            this.configService.update((Object)config);
        } else {
            this.configService.add((Object)config);
        }
        model.addAttribute("msg", (Object)"\u4fee\u6539\u6210\u529f");
        return "home/onlineMonitoring/deviceInfoV310New";
    }

    @GetMapping(value={"/getSceneConfig"})
    @ResponseBody
    public Map<String, Object> getSceneConfig(Long deviceId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        OnlineDeviceSceneConfig config = this.configService.getDeviceByDeviceId(deviceId);
        map.put("config", config);
        return map;
    }

    @RequestMapping(value={"/getDeviceOverDateCount"})
    @ResponseBody
    public List<OnlineMonitoringOverDataVo> getDeviceOverDateCount(OnlineMonitoringSearchVo vo) {
        List list = this.onlineDeviceService.getDeviceOverDateCountV317(vo);
        return list;
    }

    @RequestMapping(value={"/getDeviceBigMoreDateCount"})
    @ResponseBody
    public List<OnlineMonitoringBigDataCountVo> getDeviceBigMoreDateCount(OnlineMonitoringSearchVo vo) {
        List list = this.onlineDeviceService.getDeviceBigMoreDateCountV317(vo);
        return list;
    }
}

