/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.home;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.sys.SysUser;
import cn.smarthse.modules.health.enums.sysParam.SysParamGroupEnum;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.sys.ISysParamService;
import cn.smarthse.modules.health.service.sys.ISysUserService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/home"})
public class MyStaffInfoController
extends ControllerSupport {
    @DubboReference
    private IStaffInfoService staffInfoService;
    @DubboReference
    private ISysParamService sysParamService;
    @DubboReference
    private ISysUserService sysUserService;

    @RequestMapping(value={"/mystaffinfo/{isThirdParty}"}, method={RequestMethod.GET, RequestMethod.POST})
    public String page_userStaffInfo(HttpServletRequest request, HttpServletResponse response, Model model, @PathVariable String isThirdParty) {
        this.logger.info("\u6211\u7684\u4e2a\u4eba\u4fe1\u606f\u9875");
        model.addAttribute("isThirdParty", (Object)isThirdParty);
        return "/home/mystaffinfo-list";
    }

    @RequestMapping(value={"/myInfo"}, method={RequestMethod.GET})
    public String myInfo(HttpServletRequest request, HttpServletResponse response, Model model) {
        this.logger.info("\u6211\u7684\u4e2a\u4eba\u4fe1\u606f\u9875");
        Long staffId = UserUtils.getLoginStaffId();
        StaffInfo staffInfo = this.staffInfoService.getStaffInfoDetailById(staffId);
        model.addAttribute("educationParam", (Object)this.sysParamService.getListByGroup(SysParamGroupEnum.educ_background));
        model.addAttribute("staffInfo", (Object)staffInfo);
        return "/home/mystaffinfo";
    }

    @Log(title="\u5173\u8054\u5458\u5de5", type=21)
    @ResponseBody
    @RequestMapping(value={"/mystaffinfo/relate"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_userRelateStaff(Long relateStaffId) {
        this.logger.info("\u5173\u8054\u73b0\u6709\u5458\u5de5");
        Long staffId = UserUtils.getLoginStaffId();
        List relateUserList = this.sysUserService.getUserListByStaff(relateStaffId);
        if (relateUserList.size() > 0) {
            return new ResponseData(ResponseStateEnum.fail, "\u8be5\u5458\u5de5\u5df2\u88ab\u5173\u8054\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9!");
        }
        SysUser loginUser = UserUtils.getCurrentUser();
        String relateStaffName = this.staffInfoService.getStaffNameByStaffId(relateStaffId);
        loginUser.setStaffId(relateStaffId);
        loginUser.setFullname(relateStaffName);
        this.sysUserService.update((Object)loginUser, staffId);
        UserUtils.updateCurrentUser(loginUser);
        StaffInfo staff = this.staffInfoService.getStaffInfoDetailById(relateStaffId);
        UserUtils.updateLoginStaffStaff(staff);
        return new ResponseData();
    }

    @RequestMapping(value={"/mystaffinfo/add"}, method={RequestMethod.GET})
    public String page_userStaffInfo_add(HttpServletRequest request, HttpServletResponse response, Model model) {
        this.logger.info("\u65b0\u589e\u5458\u5de5\u4fe1\u606f\u8fdb\u884c\u5173\u8054");
        Long staffId = UserUtils.getLoginStaffId();
        if (staffId != null) {
            StaffInfo staffInfo = this.staffInfoService.getStaffInfoDetailById(staffId);
            model.addAttribute("staffInfo", (Object)staffInfo);
            return "/home/mystaffinfo-edit";
        }
        model.addAttribute("educationParam", (Object)this.sysParamService.getListByGroup(SysParamGroupEnum.educ_background));
        return "/home/mystaffinfo";
    }

    @Log(title="\u65b0\u589e\u4e2a\u4eba\u5458\u5de5\u4fe1\u606f", type=20)
    @ResponseBody
    @RequestMapping(value={"/mystaffinfo"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_userStaffInfoForm(StaffInfo staffInfoForm) {
        this.logger.info("\u65b0\u589e\u4e2a\u4eba\u5458\u5de5\u4fe1\u606f");
        Long userId = UserUtils.getCurrentUser().getId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        SysUser loginUser = this.sysUserService.updateUserFromStaffInfoForm(userId, cid, staffInfoForm);
        UserUtils.updateCurrentUser(loginUser);
        StaffInfo staff = this.staffInfoService.getStaffInfoDetailById(loginUser.getStaffId());
        UserUtils.updateLoginStaffStaff(staff);
        return new ResponseData();
    }
}

