/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.gj;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrgAuditLog;
import cn.smarthse.fwgj.model.param.GjOrgCustomerQueryParam;
import cn.smarthse.fwgj.model.param.company.CompanyCustomerSearchParam;
import cn.smarthse.fwgj.model.param.company.GjOrjSearchParam;
import cn.smarthse.fwgj.model.param.third.GjOrgCustomerAddParam;
import cn.smarthse.fwgj.model.vo.check.CheckVo;
import cn.smarthse.fwgj.model.vo.check.ReformListVo;
import cn.smarthse.fwgj.model.vo.company.CompanyCustomerHistoryListVo;
import cn.smarthse.fwgj.model.vo.company.CompanyCustomerStatisticVo;
import cn.smarthse.fwgj.model.vo.company.CompanyGjOrjListVo;
import cn.smarthse.fwgj.model.vo.third.CheckRecordVo;
import cn.smarthse.fwgj.model.vo.third.GjOrgCustomerVo;
import cn.smarthse.fwgj.provider.company.IThirdGjCheckProviderToCompany;
import cn.smarthse.fwgj.provider.company.IThirdGjOrgCustomerProviderToCompany;
import cn.smarthse.fwgj.provider.third.IThirdGjCheckProviderService;
import cn.smarthse.fwgj.provider.third.IThirdGjOrgProviderService;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.entity.work.reform.param.RiskListSearch;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicNewService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.vo.litearchive.ZjArchiveCountView;
import cn.smarthse.modules.health.vo.work.reform.RiskReformGjListVo;
import cn.smarthse.modules.health.vo.work.reform.RiskReformGjSearch;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"gj/customer"})
@Validated
public class GjOrgCustomerController
extends ControllerSupport {
    @DubboReference
    private IThirdGjOrgCustomerProviderToCompany orgCustomerProviderService;
    @DubboReference
    private IThirdGjCheckProviderToCompany checkToCompanyProviderService;
    @DubboReference
    private IThirdGjOrgProviderService gjOrgProviderService;
    @DubboReference
    private IThirdGjCheckProviderService checkProviderService;
    @DubboReference
    private IReformItemBasicService reformItemBasicService;
    @DubboReference
    private IReformItemBasicNewService reformItemBasicNewService;
    @DubboReference
    private ILiteArchiveService liteArchiveService;

    @GetMapping(value={"serverList.html", "serverList", ""})
    public String check(ModelMap m) {
        m.put((Object)"customerId", (Object)UserUtils.getCurCustomerId());
        return "views/serviceButlerManagement/serverList";
    }

    @GetMapping(value={"checkList", "checkList.html"})
    public String checkDetailPageRoute(ModelMap m) {
        return "views/serviceButlerManagement/checkList";
    }

    @GetMapping(value={"riskReport", "riskReport.html"})
    public String riskReportPageRoute(ModelMap m) {
        return "views/serviceButlerManagement/riskReport";
    }

    @GetMapping(value={"riskInfo", "riskInfo.html"})
    public String riskInfoPageRoute(ModelMap m, RiskListSearch search) {
        m.put((Object)"search", (Object)search);
        m.put((Object)"hasReformEdit", (Object)UserUtils.hasPermissionCode("reformItem.edit"));
        ReformItemBasic reform = (ReformItemBasic)this.reformItemBasicService.getById(search.getId());
        List generationSourceValueList = this.reformItemBasicService.getGenerationSourceValue();
        if (!generationSourceValueList.contains(reform.getGenerationSource())) {
            reform.setGenerationSourceStr("\u5176\u4ed6");
        }
        m.put((Object)"reform", (Object)reform);
        if (Objects.equals(reform.getGenerationSource().intValue(), 18)) {
            Long cid = UserUtils.getLoginStaffCompanyId();
            int thisYear = cn.smarthse.util.common.date.DateUtils.getYear();
            ZjArchiveCountView view = (ZjArchiveCountView)this.liteArchiveService.getArchiveData(cid).get(thisYear);
            m.put((Object)"archive", (Object)view);
        }
        return "work/riskResolution/riskInfo";
    }

    @GetMapping(value={"gjOrgCustomer.html"})
    public String gjOrgCustomer(ModelMap m, Long customerId) {
        m.put((Object)"customerId", (Object)customerId);
        return "views/serviceButlerManagement/gjOrgCustomer";
    }

    @GetMapping(value={"viewCancelOrgCustomerRoute.html"})
    public String viewCancelOrgCustomerRoute(ModelMap m, Long customerId, String reason) {
        m.put((Object)"customerId", (Object)customerId);
        m.put((Object)"reason", (Object)reason);
        return "views/serviceButlerManagement/serverTerminate";
    }

    @GetMapping(value={"serverTerminate.html"})
    public String cancelOrgCustomerRoute(ModelMap m, Long customerId, String reason) {
        m.put((Object)"customerId", (Object)customerId);
        m.put((Object)"reason", (Object)reason);
        return "views/serviceButlerManagement/serverTerminate";
    }

    @GetMapping(value={"serverContinue.html"})
    public String gjOrgCustomer2(ModelMap m, Long orgId) {
        m.put((Object)"orgId", (Object)orgId);
        return "views/serviceButlerManagement/serverContinue";
    }

    @GetMapping(value={"serverHistoryList.html"})
    public String serverHistoryListRoute(ModelMap m, Long customerId) {
        m.put((Object)"customerId", (Object)customerId);
        return "views/serviceButlerManagement/serverHistoryList";
    }

    @ResponseBody
    @GetMapping(value={"getCompanyCustomerStatistic"})
    public ResponseData<CompanyCustomerStatisticVo> getCompanyCustomerStatistic() {
        Long customerId = UserUtils.getCurCustomerId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        return ResponseData.success((Object)this.orgCustomerProviderService.getCompanyCustomerStatistic(customerId, cid));
    }

    @ResponseBody
    @GetMapping(value={"getCustomerUnsignMsg"})
    public ResponseData<String> getCustomerUnsignMsg() {
        return ResponseData.success((String)this.orgCustomerProviderService.getCustomerUnsignMsg(UserUtils.getCurCustomerId()));
    }

    @ResponseBody
    @GetMapping(value={"getCustomerCheckedList"})
    public JqGridData<CheckRecordVo> getCustomerCheckedList(Long customerId, Date beginTime, Date endTime) {
        return this.checkToCompanyProviderService.listCheckInfoForCompany(UserUtils.getLoginStaffCompanyId(), customerId, beginTime, endTime);
    }

    @ResponseBody
    @GetMapping(value={"getCustomerReformList"})
    public ResponseData<JqGridData<RiskReformGjListVo>> getCustomerReformList(RiskReformGjSearch param) {
        param.setCid(UserUtils.getLoginStaffCompanyId());
        JqGridData gjReformListData = this.checkProviderService.getGjReformListData(param);
        List list = gjReformListData.getRows();
        for (RiskReformGjListVo item : list) {
            if (item == null) continue;
            Date findTime = item.getFindTime();
            Byte status = item.getStatus();
            Date acceptanceDate = item.getAcceptanceDate();
            if (findTime == null) continue;
            try {
                Date begin = DateUtils.parseDate((String)"2024-01-01", (String[])new String[]{"yyyy-MM-dd"});
                Date end = DateUtils.parseDate((String)"2024-03-01", (String[])new String[]{"yyyy-MM-dd"});
                if (DateUtils.getYear((Date)findTime) == 2024 && status != null && (status == 3 || status == 4) && acceptanceDate != null && DateUtils.compareDate((Date)acceptanceDate, (Date)begin) >= 0L && DateUtils.compareDate((Date)acceptanceDate, (Date)end) <= 0L) {
                    item.setFindTimeStr("\u65e0\u9700\u63a8\u9001");
                    continue;
                }
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                item.setFindTimeStr(format.format(findTime));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return ResponseData.success((Object)gjReformListData);
    }

    @ResponseBody
    @GetMapping(value={"getCheckSummaryInfoForCompany"})
    public ResponseData<CheckVo> getCheckSummaryInfoForCompany(Long checkInfoId) {
        return ResponseData.success((Object)this.checkToCompanyProviderService.getCheckSummaryInfoForCompany(checkInfoId));
    }

    @ResponseBody
    @GetMapping(value={"getCheckReformList"})
    public List<ReformListVo> getCheckReformList(Long checkInfoId) {
        return this.checkToCompanyProviderService.getCheckReformList(checkInfoId);
    }

    @ResponseBody
    @GetMapping(value={"listOrjByCompanyAreaId"})
    public JqGridData<CompanyGjOrjListVo> listOrjByCompanyAreaId(GjOrjSearchParam param) {
        param.setCid(UserUtils.getLoginStaffCompanyId());
        param.setAreaId(UserUtils.getCurrentCompany().getAreaId());
        return this.gjOrgProviderService.listOrjByCompanyAreaId(param);
    }

    @ResponseBody
    @GetMapping(value={"listCustomerHistoryForCompany"})
    public JqGridData<CompanyCustomerHistoryListVo> listCustomerHistoryForCompany(CompanyCustomerSearchParam param) {
        param.setCid(UserUtils.getLoginStaffCompanyId());
        return this.orgCustomerProviderService.listCustomerHistoryForCompany(param);
    }

    @ResponseBody
    @GetMapping(value={"getGjOrgCustomer"})
    public ResponseData<GjOrgCustomerVo> getGjOrgCustomer(Long gjOrgCustomerId) {
        return ResponseData.success((Object)this.orgCustomerProviderService.getGjOrgCustomer(gjOrgCustomerId, UserUtils.getLoginStaffCompanyId()));
    }

    @ResponseBody
    @GetMapping(value={"getLastGjOrgCustomer"})
    public ResponseData<GjOrgCustomerVo> getLastGjOrgCustomer(Long orgId) {
        return ResponseData.success((Object)this.orgCustomerProviderService.getLastGjOrgCustomer(orgId, UserUtils.getLoginStaffCompanyId()));
    }

    @ResponseBody
    @GetMapping(value={"getGjOrgCustomerListData"})
    public JqGridData<CompanyCustomerHistoryListVo> getGjOrgCustomerListData(GjOrgCustomerQueryParam param) {
        param.setCid(UserUtils.getLoginStaffCompanyId());
        return this.orgCustomerProviderService.getGjOrgCustomerListData(param);
    }

    @ResponseBody
    @GetMapping(value={"getGjOrgAuditLogList"})
    public ResponseData<List<ThirdGjOrgAuditLog>> getGjOrgAuditLogList(Long gjOrgCustomerId, Integer type) {
        return ResponseData.success((Object)this.orgCustomerProviderService.getGjOrgAuditLogList(gjOrgCustomerId, type));
    }

    @ResponseBody
    @GetMapping(value={"cancelGjOrgCustomer"})
    public ResponseData<String> cancelGjOrgCustomer(Long gjOrgCustomerId, String cancelReason) {
        this.logger.info("\u7ba1\u5bb6\uff1a\u673a\u6784-\u4f01\u4e1a\u7b7e\u7ea6 \u89e3\u7ea6\u63d0\u4ea4\uff1a{}-{}", (Object)gjOrgCustomerId, (Object)cancelReason);
        if (!this.orgCustomerProviderService.checkPermission(gjOrgCustomerId, UserUtils.getLoginStaffCompanyId())) {
            ResponseData.fail((String)"\u975e\u6cd5\u64cd\u4f5c\uff01");
        }
        this.orgCustomerProviderService.cancelGjOrgCustomer(gjOrgCustomerId, cancelReason, UserUtils.getCurrentCompany().getName());
        return ResponseData.success((String)"");
    }

    @ResponseBody
    @PostMapping(value={"addContinueGjOrgCustomer"})
    public ResponseData<Long> addContinueGjOrgCustomer(GjOrgCustomerAddParam param) {
        this.logger.info("\u7eed\u7ea6\uff1a\u673a\u6784-\u4f01\u4e1a\u7eed\u7ea6 \u6dfb\u52a0\uff1a{}", (Object)param);
        param.setUserId(UserUtils.getCurrentUserId());
        param.setCid(UserUtils.getLoginStaffCompanyId());
        return ResponseData.success((Object)this.orgCustomerProviderService.addGjOrgCustomer(param));
    }

    @Generated
    public GjOrgCustomerController() {
    }
}

